[Goto Home](/docs/index.html)

# 🔒 GET `/rewards/meetme`

## Request Query

- **limit** - default `10`; set the number of items to return on each page
- **page** - default `1`; set the page for which to return the items

## Description

- Gives the list of all meetme rewards as per pagination
- Also adds location based query
- Don't return those rewards which are expired 2 days ago
- Also populate reward hashes for that user

## Response Body

```json
{
  "rewards": [
    {
      "_id": "69007c68ed57fd48466ed0ea",
      "title": "Starbucks",
      "description": "Get one free on any latte, when you check in with vibe",
      "total": 10,
      "remaining": 10,
      "location": {
        "type": "Point",
        "coordinates": [
          -34.566,
          12.455
        ]
      },
      "locationString": "Central Park, Rock-port, UK",
      "isMeetme": true,
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/69007c68ed57fd48466ed0ea/1761639525912-6152251467462092-starbucks.webp",
      "createdAt": "2025-10-28T08:18:50.603Z",
      "updatedAt": "2025-10-28T08:18:50.603Z",
      "hash?": "6900c24af70a9e7c1ebb4922",
      "isConsumed?": true
    }
  ],
  "count": 1
}
```

# 🔒 GET `/rewards/profile`

## Request Query

- **limit** - default `10`; set the number of items to return on each page
- **page** - default `1`; set the page for which to return the items

## Description

- Gives the list of all won profile rewards as per pagination
- Also adds location based query
- Only return latest 6 profile rewards which are won
- Also populate reward hashes for that user

## Response Body

```json
{
  "rewardHashes": [
    {
      "_id": "6912985c25dffea922a788c1",
      "user": "68ac3f6dd7f5a437029aa88f",
      "reward": {
        "_id": "69007c68ed57fd48466ed0ea",
        "title": "Starbucks",
        "description": "Get one free on any latte, when you check in with vibe",
        "total": 500,
        "remaining": 490,
        "location": {
          "type": "Point",
          "coordinates": [
            -34.566,
            12.455
          ]
        },
        "locationString": "Central Park, Rock-port, UK",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/69007c68ed57fd48466ed0ea/1761639525912-6152251467462092-starbucks.webp",
        "createdAt": "2025-10-28T08:18:50.603Z",
        "updatedAt": "2025-11-06T13:32:46.455Z"
      },
      "score": "6912963572e3471532c0bd67",
      "at": "2025-11-11T01:58:52.000Z"
    }
  ],
  "count": 1,
  "rewardCoins": [
    {
      "type": "unlocked"
    },
    {
      "type": "pending"
    },
    {
      "type": "locked"
    },
    {
      "type": "locked"
    },
    {
      "type": "locked"
    },
    {
      "type": "locked"
    },
    {
      "type": "locked"
    }
  ]
}
```

# 🔒 POST `/rewards/:id/generate-hash`

## Description

- Generate QR Hash
- Reward must be a meet me reward
- Only work for meetme reward
- If hash already exist for that user and reward, then return that hash data
- Reward must be active

## Response Body

```json
{
  "hash": "6900c24af70a9e7c1ebb4922"
}
```

# 🔒 POST `/rewards/opened-view-all`

## Description

- Its just for updating vibe score
- Update `open-view-all-rewards` action of vibe social score of that user and send socket notification with event `score-updated`

# Links

[Goto Home](/docs/index.html)
