"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/meetme', validations_1.default.getMeetmeRewards, auth_1.default.authorizeUser, controllers_1.default.getMeetmeRewards);
router.get('/profile', auth_1.default.authorizeUser, controllers_1.default.getProfileRewards);
router.post('/:id/generate-hash', validations_1.default.postGenerateRewardHash, auth_1.default.authorizeUser, controllers_1.default.postGenerateRewardHash);
router.post('/opened-view-all', auth_1.default.authorizeUser, controllers_1.default.postOpenedViewAll);
module.exports = router;
