"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const services_1 = __importDefault(require("../../utils/services"));
function getScores(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            let { limit = '10', page = '1' } = req.query;
            limit = +limit;
            page = +page;
            const skip = (page - 1) * limit;
            const query = { user: user._id };
            const scores = yield models_1.Score
                .find(query, { 'mindfulness.journal': 0 })
                .sort({ createdAt: -1 })
                .skip(skip)
                .limit(limit);
            const count = yield models_1.Score.countDocuments(query);
            return res.json({ scores, count });
        }
        catch (error) {
            console.error(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function getTodayScore(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            const score = yield services_1.default.getOrCreateTodayScore(user._id);
            if (!score) {
                return res.status(500).json({ message: 'server error' });
            }
            if (score.mindfulness.journal) {
                score.mindfulness.journal = undefined;
            }
            return res.json({ score });
        }
        catch (error) {
            console.error(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function postScoreJournal(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const message = req.body.message;
            const user = res.locals.user;
            const score = yield services_1.default.getOrCreateTodayScore(user._id);
            if (!score) {
                return res.status(500).json({ message: 'server error' });
            }
            if (score.mindfulness.journal) {
                return res.status(409).json({ message: 'journal for today already exist' });
            }
            score.mindfulness.journal = { message, at: new Date() };
            yield score.save();
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    const score = yield services_1.default.getOrCreateTodayScore(user._id);
                    if (!score) {
                        return;
                    }
                    const action = score.mindfulness.actions.find(e => e.type === 'journalism');
                    if (!action || action.completed) {
                        return;
                    }
                    action.value = 1;
                    action.completed = true;
                    yield services_1.default.updateScore(score);
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.status(201).json({ message: 'journal added successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const scoreControllers = {
    getScores,
    getTodayScore,
    postScoreJournal
};
exports.default = scoreControllers;
