"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Score = void 0;
const mongoose_1 = require("mongoose");
const constants_1 = __importDefault(require("../../utils/constants"));
const SocialActionSchema = new mongoose_1.Schema({
    label: {
        type: String,
        required: true
    },
    subLabel: {
        type: String,
        required: true
    },
    type: {
        type: String,
        enum: constants_1.default.socialConnectednessActions.map(e => e.type),
        required: true
    },
    value: {
        type: Number,
        default: 0
    },
    completed: Boolean,
    count: Number
}, { versionKey: false, _id: false });
const SocialSchema = new mongoose_1.Schema({
    score: {
        type: Number,
        default: 0
    },
    day: {
        type: String,
        enum: constants_1.default.days,
        required: true,
    },
    actions: {
        type: [SocialActionSchema],
        default: [],
    }
}, { versionKey: false, _id: false });
const MindfulnessActionSchema = new mongoose_1.Schema({
    label: {
        type: String,
        required: true
    },
    type: {
        type: String,
        enum: constants_1.default.mindfulnessActions.map(e => e.type),
        required: true
    },
    value: {
        type: Number,
        default: 0
    },
    completed: Boolean,
    count: Number,
    startAt: Number
}, { versionKey: false, _id: false });
const JournalSchema = new mongoose_1.Schema({
    message: {
        type: String,
        required: true
    },
    at: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
const MindfulnessSchema = new mongoose_1.Schema({
    score: {
        type: Number,
        default: 0
    },
    actions: {
        type: [MindfulnessActionSchema],
        default: [],
    },
    journal: JournalSchema
}, { versionKey: false, _id: false });
const WeeklyScoreSchema = new mongoose_1.Schema({
    score: {
        type: Number,
        required: true
    },
    date: {
        type: Date,
        required: true
    },
    day: {
        type: String,
        enum: constants_1.default.days,
        required: true
    },
    reference: {
        type: mongoose_1.Types.ObjectId,
        required: true,
        ref: 'Score'
    }
}, { versionKey: false, _id: false });
const ScoreSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    date: {
        type: Date,
        default: () => {
            const now = new Date();
            const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
            return today;
        }
    },
    appUsageSeconds: {
        type: Number,
        default: 0
    },
    doomScrollUsageSeconds: {
        type: Number,
        default: 0
    },
    social: {
        type: SocialSchema,
        default: () => {
            const now = new Date();
            const day = constants_1.default.days[now.getDay()];
            const actions = structuredClone(constants_1.default.socialConnectednessActions.filter(e => e.days.flat().includes(day)));
            return { score: 0, day, actions };
        }
    },
    mindfulness: {
        type: MindfulnessSchema,
        default: () => {
            const actions = structuredClone(constants_1.default.mindfulnessActions);
            return { score: 0, actions };
        }
    },
    totalScore: {
        type: Number,
        default: 0
    },
    weeklyScores: {
        type: [WeeklyScoreSchema],
        default: []
    },
    hash: {
        type: mongoose_1.Types.ObjectId,
        ref: 'RewardHash'
    },
    reelsSeen: {
        type: Number,
        default: 10
    }
}, { versionKey: false, timestamps: true });
exports.Score = (0, mongoose_1.model)('Score', ScoreSchema, 'scores');
