[Goto Home](/docs/index.html)

# 🔒 GET `/scores`

## Description

- Returns the list of scores of that user as per pagination

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items

## Response Body

```json
{
  "scores": [
    {
      "_id": "690f107ffe517e702e09bc70",
      "user": "68ac3f6dd7f5a437029aa88f",
      "date": "2025-11-07T18:30:00.000Z",
      "appUsageSeconds": 0,
      "doomScrollUsageSeconds": 0,
      "totalScore": 0,
      "reelsSeen": 3,
      "weeklyScores": [
        {
          "score": 0,
          "date": "2025-11-06T18:30:00.000Z",
          "day": "friday",
          "reference": "690d5066ee14c660d9f00307"
        },
        {
          "score": 0,
          "date": "2025-11-06T00:00:00.000Z",
          "day": "thursday",
          "reference": "690c3ce4871928c92affcaa9"
        },
        {
          "score": 0,
          "date": "2025-11-05T00:00:00.000Z",
          "day": "wednesday",
          "reference": "690ad91403f1f732ef28ea8e"
        }
      ],
      "social": {
        "score": 0,
        "day": "saturday",
        "actions": [
          {
            "label": "Reply mindfully to a comment in the home feed",
            "subLabel": "Cultivate empathy by responding with kindness and understanding different perspectives",
            "type": "mindful-comment-reply",
            "value": 0
          },
          {
            "label": "Send a DM to a friend",
            "subLabel": "Strengthen real connection and presence through one-to-one mindful conversation",
            "type": "send-dm-message",
            "value": 0
          }
        ]
      },
      "mindfulness": {
        "score": 0,
        "actions": [
          {
            "label": "Watch a Focus video (1 min)",
            "type": "focus-video",
            "value": 0,
            "startAt": 8
          },
          {
            "label": "Watch a Mindfulness video (1 min)",
            "type": "mindfulness-video",
            "value": 0,
            "startAt": 15
          },
          {
            "label": "Watch a Reflection video (1 min)",
            "type": "reflection-video",
            "value": 0,
            "startAt": 20
          },
          {
            "label": "Write in Your Journal",
            "type": "journalism",
            "value": 0,
            "startAt": 20
          }
        ]
      },
      "createdAt": "2025-11-08T09:42:23.254Z",
      "updatedAt": "2025-11-08T09:42:23.254Z"
    }
  ],
  "count": 1
}
```

# 🔒 GET `/scores/today`

## Description

- Returns the today's score details of that user
- If score for that day, does not exist, it will create it for that day

## Response Body

```json
{
  "score": {
    "user": "68ac3f6dd7f5a437029aa88f",
    "date": "2025-11-07T18:30:00.000Z",
    "appUsageSeconds": 0,
    "doomScrollUsageSeconds": 0,
    "totalScore": 0,
    "reelsSeen": 3,
    "weeklyScores": [
      {
        "score": 0,
        "date": "2025-11-06T18:30:00.000Z",
        "day": "friday",
        "reference": "690d5066ee14c660d9f00307"
      },
      {
        "score": 0,
        "date": "2025-11-06T00:00:00.000Z",
        "day": "thursday",
        "reference": "690c3ce4871928c92affcaa9"
      },
      {
        "score": 0,
        "date": "2025-11-05T00:00:00.000Z",
        "day": "wednesday",
        "reference": "690ad91403f1f732ef28ea8e"
      }
    ],
    "_id": "690f107ffe517e702e09bc70",
    "social": {
      "score": 0,
      "day": "saturday",
      "actions": [
        {
          "label": "Leave 3 mindful comments",
          "subLabel": "Practice mindful comments — each word can uplift someone's day, including yours",
          "type": "mindful-comments",
          "value": 1,
          "completed": true,
          "count": 3  // only available in 'mindful-comments' type
        },
        {
          "label": "Send a DM to a friend",
          "subLabel": "Strengthen real connection and presence through one-to-one mindful conversation",
          "type": "send-dm-message",
          "value": 0
        }
      ]
    },
    "mindfulness": {
      "score": 0,
      "actions": [
        {
          "label": "Watch a Focus video (1 min)",
          "type": "focus-video",
          "value": 1,
          "startAt": 8,
          "completed": true
        },
        {
          "label": "Watch a Mindfulness video (1 min)",
          "type": "mindfulness-video",
          "value": 0,
          "startAt": 15
        },
        {
          "label": "Watch a Reflection video (1 min)",
          "type": "reflection-video",
          "value": 0,
          "startAt": 20
        },
        {
          "label": "Write in Your Journal",
          "type": "journalism",
          "value": 0,
          "startAt": 20
        }
      ]
    },
    "createdAt": "2025-11-08T09:42:23.254Z",
    "updatedAt": "2025-11-08T09:42:23.254Z"
  }
}
```

# 🔒 POST `/scores/journal`

## Description

- Creates a new journal entry
- If journal for today already exists, then reject with status `409`
- Update `journalism` action of vibe mindfulness score and send socket notification with event `score-updated`

## Request Body

```json
{
  "message": "Today, I feel very good" // range: 10-1000
}
```

# Links

[Goto Home](/docs/index.html)