"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Share = void 0;
const mongoose_1 = require("mongoose");
const ShareSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    chats: {
        type: [mongoose_1.Types.ObjectId],
        default: undefined
    },
    count: {
        type: Number,
        default: 1,
    },
    reel: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Reel',
        required: true,
    },
    at: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
exports.Share = (0, mongoose_1.model)('Share', ShareSchema, 'shares');
