"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function postShare(req, res, next) {
    try {
        const { errors } = (0, super_easy_validator_1.validate)({ reel: 'mongoid' }, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    postShare
};
exports.default = validations;
