"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = void 0;
const mongoose_1 = require("mongoose");
const types_1 = require("../../utils/types");
const StatusSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    categories: {
        type: [String],
        required: true,
    },
    schedule: {
        type: String,
        enum: ['now', 'later'],
        required: true,
    },
    startDateType: {
        type: String,
        enum: ['today', 'tomorrow', 'custom'],
        required: true,
    },
    startDate: {
        type: String,
        required: true,
    },
    startTime: {
        type: String,
        required: true,
    },
    title: String,
    startedAt: {
        type: Date,
        required: true
    },
    visibleAt: {
        type: Date,
        required: true
    },
    endedAt: {
        type: Date,
        required: true
    },
    location: types_1.LocationSchema,
    locationString: String,
}, { versionKey: false, timestamps: true });
StatusSchema.index({ location: '2dsphere' });
exports.Status = (0, mongoose_1.model)('Status', StatusSchema, 'statuses');
