"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getStatuses, auth_1.default.authorizeUser, controllers_1.default.getStatuses);
router.get('/search', validations_1.default.getStatusesAndEvents, auth_1.default.authorizeUser, controllers_1.default.getStatusesAndEvents);
router.post('/', validations_1.default.postStatus, auth_1.default.authorizeUser, controllers_1.default.postStatus);
router.patch('/', validations_1.default.patchStatus, auth_1.default.authorizeUser, controllers_1.default.patchStatus);
router.delete('/', auth_1.default.authorizeUser, controllers_1.default.deleteStatus);
module.exports = router;
