"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const models_2 = require("../reels/models");
const models_3 = require("../comments/models");
const services_1 = __importDefault(require("../../utils/services"));
function postSuperLike(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            const reelId = req.params.reelId;
            const lastDay = new Date();
            lastDay.setHours(lastDay.getHours() - 24);
            const count = yield models_1.SuperLike.countDocuments({
                user: user._id,
                at: { $gt: lastDay }
            });
            if (count >= 1) {
                return res.status(403).json({ message: 'Super like can\'t be given more than once in a day' });
            }
            const reel = yield models_2.Reel.findById(reelId).populate('user');
            if (!reel) {
                return res.status(404).json({ message: 'reel not found' });
            }
            const reelUser = reel.user;
            let superLike = yield models_1.SuperLike.findOne({
                user: user._id,
                reel: reel._id,
            });
            if (superLike) {
                return res.status(200).json({ message: 'already super-liked' });
            }
            superLike = (yield models_1.SuperLike.create({ user: user._id, reel: reel._id }));
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    const count = yield models_1.SuperLike.countDocuments({ reel: reel._id });
                    reel.superLikes = count;
                    yield reel.save();
                    yield models_3.Comment.updateMany({ user: user._id, reel: reel._id }, { $set: { superLike: superLike._id } });
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    const score = yield services_1.default.getOrCreateTodayScore(user._id);
                    if (!score) {
                        return;
                    }
                    const action = score.social.actions.find(e => e.type === 'create-super-like');
                    if (!action || action.completed) {
                        return;
                    }
                    action.value = 1;
                    action.completed = true;
                    yield services_1.default.updateScore(score);
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            if (`${reelUser._id}` !== `${user._id}`) {
                yield services_1.default.notifyUser({
                    title: 'Your vibe got a super like',
                    description: `💖 ${user.username} super liked your vibe`,
                    event: 'reel-super-liked',
                    user: reelUser,
                    from: user._id,
                    reel: reel._id,
                    superLike: superLike._id
                });
            }
            return res.status(201).json({ message: 'super-liked successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function deleteSuperLike(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            const reelId = req.params.reelId;
            const reel = yield models_2.Reel.findById(reelId);
            if (!reel) {
                return res.status(404).json({ message: 'reel not found' });
            }
            const superLike = yield models_1.SuperLike.findOne({
                user: user._id,
                reel: reel._id
            });
            if (!superLike) {
                return res.status(200).json({ message: 'already un-liked' });
            }
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield superLike.deleteOne();
                    const count = yield models_1.SuperLike.countDocuments({ reel: reel._id });
                    reel.superLikes = count;
                    yield reel.save();
                    yield models_3.Comment.updateMany({ user: user._id, reel: reel._id }, { $unset: { superLike: '' } });
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.status(201).json({ message: 'un-liked successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postSuperLike,
    deleteSuperLike
};
exports.default = controllers;
