"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const models_2 = require("../reels/models");
const services_1 = __importDefault(require("../../utils/services"));
function postUsage(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { reel: reelId, seconds } = req.body;
            const user = res.locals.user;
            let reel;
            if (reelId) {
                reel = yield models_2.Reel.findById(reelId);
                if (!reel) {
                    return res.status(404).json({ message: 'reel not found' });
                }
            }
            yield models_1.Usage.create({
                user: user._id,
                reel: reelId,
                seconds
            });
            (() => __awaiter(this, void 0, void 0, function* () {
                var _a;
                try {
                    const score = yield services_1.default.getOrCreateTodayScore(user._id);
                    if (!score) {
                        return;
                    }
                    const now = new Date();
                    const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
                    const result = yield models_1.Usage.aggregate([
                        {
                            $match: {
                                user: user._id,
                                at: { $gte: today },
                                reel: reelId ? reel._id : { $exists: false }
                            }
                        },
                        {
                            $group: {
                                _id: null,
                                seconds: { $sum: { $toDouble: '$seconds' } }
                            }
                        }
                    ]);
                    const seconds = ((_a = result[0]) === null || _a === void 0 ? void 0 : _a.seconds) || 0;
                    if (reelId) {
                        score.doomScrollUsageSeconds = seconds;
                    }
                    else {
                        score.appUsageSeconds = seconds;
                    }
                    yield score.save();
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.status(201).json({ message: 'usage added successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postUsage
};
exports.default = controllers;
