[Goto Home](/docs/index.html)

# 🔐 GET `/admin/users`

## Description

- Returns users list as per pagination

## Request Query

- `limit` - optional, natural number, default `"10"`, determines the number of items to be shown in each page
- `page` - optional, natural number, default `"1"`, determines the page number
- `search` - optional, string, searches from `name`, `email`, `phone`, `_id` (`_id` only works for each match)
- `emailVerified` - optional, string, boolean, exact match for `emailVerified`
- `phoneVerified` - optional, string, boolean, exact match for `phoneVerified`
- `terminated` - optional, string, boolean, exact match for `terminated`
- `2fa` - optional, string, boolean, exact match for `twoFactorAuthentication`
- `verified` - optional, string, boolean, exact match for `verified`

## Response Body

```json
{
  "users": [
    {
      "_id": "687a21a4d059b54cbd556352",
      "name": "John Doe",
      "dob": "1998-01-23",
      "email": "john.doe@example.com",
      "auth": {
        "emailVerified": true,
        "phoneVerified": true,
        "twoFactorAuthentication": true
      },
      "createdAt": "2025-07-18T10:27:48.297Z",
      "updatedAt": "2025-07-18T10:51:05.724Z",
      "phone": "+1 1234567899",
      "photo": "https://vibe.r2.ap-south-1.amazonaws.com/users/687a21a4d059b54cbd556352/1752835263638-4811266187365434-forest_2364458.png",
      "verified": true
    }
  ],
  "count": 1
}
```

# 🔐 GET `/admin/users/:id`

## Description

- Returns the user details

## Response Body

```json
{
  "user": {
    "_id": "687a21a4d059b54cbd556352",
    "name": "John Wick",
    "dob": "1998-01-23",
    "email": "john.doe@example.com",
    "auth": {
      "emailVerified": true,
      "phoneVerified": true,
      "twoFactorAuthentication": true
    },
    "createdAt": "2025-07-18T10:27:48.297Z",
    "updatedAt": "2025-07-19T07:19:15.196Z",
    "phone": "+1 1234567899",
    "photo": "https://vibe-business.r2.ap-south-1.amazonaws.com/users/687a21a4d059b54cbd556352/1752835263638-4811266187365434-forest_2364458.png",
    "verified": true
  }
}
```

# 🔐 PATCH `/admin/users/:id`

## Description

- Update the users details

## Request Body

```js
{
  verified?: boolean
}
```

# 🔐 DELETE `/admin/users/:id`

## Description

- Toggles the `terminate` field of user
- Send email notification to that user
- Logout all devices of that user

## Request Body

```json
{
  "terminated": true
}
```

# Links

[Goto Home](/docs/index.html)
