"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("../models");
const helpers_1 = __importDefault(require("../../../utils/helpers"));
const mongoose_1 = require("mongoose");
const services_1 = __importDefault(require("../../../utils/services"));
function getUsers(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let { limit = '10', page = '1', search, emailVerified, phoneVerified, terminated, '2fa': tfa, verified } = req.query;
            limit = +limit;
            page = +page;
            const skip = (page - 1) * limit;
            const query = { $and: [] };
            if (search) {
                const $or = [{ name: RegExp(search, 'i') }, { email: RegExp(search, 'i') }, { phone: RegExp(search, 'i') }];
                query.$and.push({ $or });
                if (mongoose_1.Types.ObjectId.isValid(search)) {
                    $or.push({ _id: new mongoose_1.Types.ObjectId(search) });
                }
            }
            if (emailVerified) {
                if (emailVerified === 'false') {
                    query.$and.push({
                        $or: [{ 'auth.emailVerified': false }, { 'auth.emailVerified': { $exists: false } }]
                    });
                }
                else {
                    query.$and.push({ 'auth.emailVerified': true });
                }
            }
            if (phoneVerified) {
                if (phoneVerified === 'false') {
                    query.$and.push({
                        $or: [{ 'auth.phoneVerified': false }, { 'auth.phoneVerified': { $exists: false } }]
                    });
                }
                else {
                    query.$and.push({ 'auth.phoneVerified': true });
                }
            }
            if (terminated) {
                if (terminated === 'false') {
                    query.$and.push({
                        $or: [{ terminated: false }, { terminated: { $exists: false } }]
                    });
                }
                else {
                    query.$and.push({ terminated: true });
                }
            }
            if (tfa) {
                if (tfa === 'false') {
                    query.$and.push({
                        $or: [{ 'auth.twoFactorAuthentication': false }, { 'auth.twoFactorAuthentication': { $exists: false } }]
                    });
                }
                else {
                    query.$and.push({ 'auth.twoFactorAuthentication': true });
                }
            }
            if (verified) {
                if (verified === 'false') {
                    query.$and.push({
                        $or: [{ verified: false }, { verified: { $exists: false } }]
                    });
                }
                else {
                    query.$and.push({ verified: true });
                }
            }
            const users = yield models_1.User.find(query, {
                name: 1,
                username: 1,
                dob: 1,
                email: 1,
                phone: 1,
                auth: {
                    emailVerified: 1,
                    phoneVerified: 1
                },
                photo: 1,
                terminated: 1,
                verified: 1,
                createdAt: 1,
                updatedAt: 1
            }).sort({ createdAt: -1 }).skip(skip).limit(limit);
            const count = yield models_1.User.countDocuments(query);
            return res.json({ users, count });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function getUser(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { id } = req.params;
            const user = yield models_1.User.findById(id, {
                name: 1,
                username: 1,
                bio: 1,
                url: 1,
                school: 1,
                courses: 1,
                dob: 1,
                email: 1,
                phone: 1,
                auth: {
                    twoFactorAuthentication: 1,
                    emailVerified: 1,
                    phoneVerified: 1
                },
                photo: 1,
                terminated: 1,
                verified: 1,
                purposes: 1,
                studies: 1,
                categories: 1,
                createdAt: 1,
                updatedAt: 1
            });
            if (!user) {
                return res.status(404).json({ message: 'user not found' });
            }
            return res.json({ user });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function patchUser(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { id } = req.params;
            const { verified } = req.body;
            const user = yield models_1.User.findById(id);
            if (!user) {
                return res.status(404).json({ message: 'user not found' });
            }
            user.verified = verified !== null && verified !== void 0 ? verified : user.verified;
            yield user.save();
            return res.json({ message: 'updated successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function deleteUser(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { id } = req.params;
            const user = yield models_1.User.findById(id);
            if (!user) {
                return res.status(404).json({ message: 'user not found' });
            }
            if (user.terminated) {
                user.terminated = undefined;
                yield helpers_1.default.sendOauthGmail(user.email, 'Your account has been reactivated', 'Good news!\nAfter careful review, we are pleased to inform you that your account has been reactivated.');
            }
            else {
                user.terminated = true;
                yield helpers_1.default.sendOauthGmail(user.email, 'Your account has been terminated', 'Your account has been terminated due to a violation of our Terms and Conditions and in accordance with our Privacy Policy.');
                services_1.default.socketNotifyUser({
                    userId: `${user._id}`,
                    event: 'account-terminated',
                    data: { message: 'Your account has been terminated due to a violation of our Terms and Conditions and in accordance with our Privacy Policy.' },
                });
            }
            user.auth.loggedinDevices = [];
            yield user.save();
            return res.json({
                message: `user's ${user.terminated ? 'terminated' : 'reactivated'} successfully`,
                terminated: user.terminated
            });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    getUsers,
    getUser,
    patchUser,
    deleteUser
};
exports.default = controllers;
