"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getUsers, auth_1.default.authorizeAdmin, controllers_1.default.getUsers);
router.get('/:id', validations_1.default.getUser, auth_1.default.authorizeAdmin, controllers_1.default.getUser);
router.patch('/:id', validations_1.default.patchUser, auth_1.default.authorizeAdmin, controllers_1.default.patchUser);
router.delete('/:id', validations_1.default.deleteUser, auth_1.default.authorizeAdmin, controllers_1.default.deleteUser);
module.exports = router;
