"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function getUsers(req, res, next) {
    try {
        const rules = {
            limit: 'optional|string|natural',
            page: 'optional|string|natural',
            search: 'optional|string',
            emailVerified: 'optional|string|boolean',
            phoneVerified: 'optional|string|boolean',
            terminated: 'optional|string|boolean',
            '2fa': 'optional|string|boolean',
            verified: 'optional|string|boolean',
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.query);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function getUser(req, res, next) {
    try {
        const rules = {
            id: 'mongoid'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.params);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function patchUser(req, res, next) {
    try {
        const rules = {
            id: 'mongoid',
            verified: 'optional|boolean'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, Object.assign(Object.assign({}, req.params), req.body));
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function deleteUser(req, res, next) {
    try {
        const rules = {
            id: 'mongoid'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.params);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    getUsers,
    getUser,
    patchUser,
    deleteUser
};
exports.default = validations;
