"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = exports.StudySchema = exports.PurposeSchema = exports.AuthSchema = exports.LoggedinDeviceSchema = void 0;
const mongoose_1 = require("mongoose");
const types_1 = require("../../utils/types");
exports.LoggedinDeviceSchema = new mongoose_1.Schema({
    fcmToken: String,
    platform: {
        type: String,
        enum: ['android', 'ios', 'web']
    },
    tokenHash: {
        type: String,
        required: true
    },
    lastAccessedAt: {
        type: Date,
        default: Date
    }
}, { versionKey: false, timestamps: true });
exports.AuthSchema = new mongoose_1.Schema({
    password: {
        type: String,
        required: true,
    },
    twoFactorAuthentication: Boolean,
    loggedinDevices: {
        type: [exports.LoggedinDeviceSchema],
        default: []
    },
    phoneOtp: String,
    phoneOtpExpiry: Date,
    phoneVerified: Boolean,
    lastPhoneOtpSentAt: Date,
    emailOtp: String,
    emailOtpExpiry: Date,
    emailVerified: Boolean,
    lastEmailOtpSentAt: Date,
}, { versionKey: false, _id: false });
exports.PurposeSchema = new mongoose_1.Schema({
    type: {
        type: String,
        enum: ['short-term', 'long-term'],
        required: true,
    },
    value: {
        type: [String],
        required: true,
    },
}, { versionKey: false, _id: false });
exports.StudySchema = new mongoose_1.Schema({
    type: {
        type: String,
        required: true,
    },
    value: {
        type: [String],
        required: true,
    },
}, { versionKey: false, _id: false });
const UserSchema = new mongoose_1.Schema({
    name: {
        type: String,
        trim: true,
    },
    username: {
        type: String,
        trim: true,
    },
    bio: {
        type: String,
        trim: true,
    },
    url: {
        type: String,
        trim: true,
    },
    school: {
        type: String,
        trim: true,
    },
    courses: {
        type: String,
        trim: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
        match: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i
    },
    phone: String,
    dob: {
        type: Date,
        required: true
    },
    auth: {
        type: exports.AuthSchema,
        required: true,
    },
    photo: String,
    terminated: Boolean,
    purposes: {
        type: [exports.PurposeSchema],
        default: []
    },
    studies: {
        type: [exports.StudySchema],
        default: []
    },
    categories: {
        type: [String],
        default: []
    },
    isManuallyOffline: Boolean,
    isOnline: Boolean,
    lastOnlineAt: Date,
    followers: {
        type: Number,
        default: 0,
    },
    followings: {
        type: Number,
        default: 0,
    },
    posts: {
        type: Number,
        default: 0
    },
    status: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Status'
    },
    deactivatedAt: Date,
    location: types_1.LocationSchema,
    locationString: String,
    data: mongoose_1.Schema.Types.Mixed,
    verified: Boolean
}, { versionKey: false, timestamps: true });
UserSchema.index({ location: '2dsphere' });
exports.User = (0, mongoose_1.model)('User', UserSchema, 'users');
