"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const uploaders_1 = require("../../utils/uploaders");
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getUsers, auth_1.default.authorizeUser, controllers_1.default.getUsers);
router.get('/explore', validations_1.default.getExploreUsersAndChats, auth_1.default.authorizeUser, controllers_1.default.getExploreUsersAndChats);
router.get('/meetme/online-users', validations_1.default.getMeetmeOnlineUsers, auth_1.default.authorizeUser, controllers_1.default.getMeetmeOnlineUsers);
router.get('/profile', auth_1.default.authorizeUser, controllers_1.default.getProfile);
router.get('/:id', auth_1.default.authorizeUser, controllers_1.default.getUser);
router.patch('/', validations_1.default.patchUser, auth_1.default.authorizeUser, controllers_1.default.patchUser);
router.post('/check-username', validations_1.default.postCheckUsername, auth_1.default.authorizeUser, controllers_1.default.postCheckUsername);
router.put('/photo', uploaders_1.ImageUploader.single('photo'), validations_1.default.putProfilePhoto, auth_1.default.authorizeUser, controllers_1.default.putProfilePhoto);
router.delete('/me', auth_1.default.authorizeUser, controllers_1.default.deleteUser);
module.exports = router;
