"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = __importDefault(require("../../utils/constants"));
const services_1 = __importDefault(require("../../utils/services"));
const models_1 = require("./models");
const userSchedules = {};
userSchedules['user-offline'] = (data) => __awaiter(void 0, void 0, void 0, function* () {
    const { user: userId } = data;
    const user = yield models_1.User.findById(userId);
    if (!user) {
        return;
    }
    if (user.isManuallyOffline || user.isOnline || !user.lastOnlineAt) {
        return;
    }
    const lastOnlineAt = new Date(user.lastOnlineAt);
    lastOnlineAt.setMinutes(lastOnlineAt.getMinutes() + constants_1.default.maxOnlineVisibilityInMinutes);
    if (lastOnlineAt > new Date()) {
        return;
    }
    // notify all users that this user is offline
    yield services_1.default.socketNotifyOnUserPresenceUpdated(user, 'offline');
});
exports.default = userSchedules;
