"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const models_2 = require("../reels/models");
const services_1 = __importDefault(require("../../utils/services"));
function postView(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            const reelId = req.body.reel;
            const reel = yield models_2.Reel.findById(reelId);
            if (!reel) {
                return res.status(404).json({ message: 'reel not found' });
            }
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield models_1.View.create({
                        user: user._id,
                        reel: reel._id
                    });
                    const count = yield models_1.View.countDocuments({ reel: reel._id });
                    reel.views = count;
                    yield reel.save();
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            (() => __awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c;
                try {
                    const score = yield services_1.default.getOrCreateTodayScore(user._id);
                    if (!score) {
                        return;
                    }
                    const action = score.social.actions.find(e => e.type === 'watch-vibe-dynamic');
                    if (action && !(action === null || action === void 0 ? void 0 : action.completed) && reel.dynamic) {
                        action.value = 1;
                        action.completed = true;
                    }
                    const mindfulness = score.mindfulness;
                    score.reelsSeen++;
                    const hour = new Date().getHours();
                    for (const action of mindfulness.actions) {
                        if (action.type === 'focus-video' && hour >= action.startAt && ((_a = reel.chips) === null || _a === void 0 ? void 0 : _a.includes('focus'))) {
                            action.completed = true;
                            action.value = 1;
                            score.reelsSeen = 0;
                        }
                        else if (action.type === 'mindfulness-video' && hour >= action.startAt && ((_b = reel.chips) === null || _b === void 0 ? void 0 : _b.includes('mindfulness'))) {
                            action.completed = true;
                            action.value = 1;
                            score.reelsSeen = 0;
                        }
                        else if (action.type === 'reflection-video' && hour >= action.startAt && ((_c = reel.chips) === null || _c === void 0 ? void 0 : _c.includes('reflection'))) {
                            action.completed = true;
                            action.value = 1;
                            score.reelsSeen = 0;
                        }
                    }
                    yield services_1.default.updateScore(score);
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.status(201).json({ message: 'views created successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postView
};
exports.default = controllers;
