"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const srcDir = './src';
const distDir = './dist/src';
const extensions = ['.md'];
function copyFilesWithExtensions(src, dest) {
    if (!fs_1.default.existsSync(dest))
        fs_1.default.mkdirSync(dest, { recursive: true });
    for (const file of fs_1.default.readdirSync(src)) {
        const srcPath = path_1.default.join(src, file);
        const destPath = path_1.default.join(dest, file);
        const stat = fs_1.default.statSync(srcPath);
        if (stat.isDirectory()) {
            copyFilesWithExtensions(srcPath, destPath);
        }
        else {
            const ext = path_1.default.extname(file);
            if (extensions.includes(ext)) {
                fs_1.default.copyFileSync(srcPath, destPath);
            }
        }
    }
}
copyFilesWithExtensions(srcDir, distDir);
