"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("../api/followers/models");
const models_2 = require("../api/mutual-follows/models");
const models_3 = require("../api/users/models");
function execute() {
    return __awaiter(this, void 0, void 0, function* () {
        const users = JSON.parse(JSON.stringify(yield models_3.User.find({}, { _id: 1, username: 1 }).lean()));
        const followers = JSON.parse(JSON.stringify(yield models_1.Follower.find({}, { follower: 1, following: 1 }).lean()));
        let pairs = [];
        for (let follower of followers) {
            const match = followers.find((e) => e.follower === follower.following && e.following === follower.follower);
            if (match) {
                const u1 = users.find((e) => e._id === match.follower);
                const u2 = users.find((e) => e._id === match.following);
                if (pairs.some(e => e[u1.username] && e[u2.username])) {
                    continue;
                }
                pairs.push({ [u1.username]: true, [u2.username]: true });
                console.log(u1.username, u2.username);
                yield models_2.MutualFollow.create({ users: [u1._id, u2._id] });
            }
        }
    });
}
const scriptCreateMutualFollows = {
    execute
};
exports.default = scriptCreateMutualFollows;
