"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_cron_1 = __importDefault(require("node-cron"));
const helpers_1 = __importDefault(require("./helpers"));
const services_1 = __importDefault(require("./services"));
const constants_1 = __importDefault(require("./constants"));
// delete old files every hour
node_cron_1.default.schedule('0 * * * *', () => __awaiter(void 0, void 0, void 0, function* () {
    helpers_1.default.deleteOldFiles();
}));
// removes all unverified users (created 7 days ago), runs every Monday at midnight
node_cron_1.default.schedule('0 0 * * 1', () => __awaiter(void 0, void 0, void 0, function* () {
    services_1.default.deleteOldUnverifiedUsers();
}));
// removes all notifications older than 7 days, run at every sunday midnight
node_cron_1.default.schedule('0 0 * * 0', () => __awaiter(void 0, void 0, void 0, function* () {
    services_1.default.deleteOldNotifications();
}));
// Soft delete all deactivated users older than 7 days, run every night 1AM
node_cron_1.default.schedule('0 1 * * *', () => __awaiter(void 0, void 0, void 0, function* () {
    services_1.default.deleteDeactivatedUsers();
}));
// Runs reels compression every hour
if (constants_1.default.compressionEnabled) {
    node_cron_1.default.schedule('7 * * * *', () => __awaiter(void 0, void 0, void 0, function* () {
        services_1.default.addUncompressedReelsToQueue();
    }));
}
exports.default = node_cron_1.default;
