"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocationSchema = exports.scheduleEvents = void 0;
const mongoose_1 = require("mongoose");
exports.scheduleEvents = ['user-offline'];
exports.LocationSchema = new mongoose_1.Schema({
    type: {
        type: String,
        enum: ['Point'],
        required: true
    },
    coordinates: {
        type: [Number],
        required: true,
        validate: {
            validator: (value) => {
                const [lng, lat] = value;
                return (lat >= -90 && lat <= 90 &&
                    lng >= -180 && lng <= 180);
            },
            message: 'Invalid coordinates: latitude must be between -90 and 90, longitude between -180 and 180'
        }
    },
}, { versionKey: false, _id: false });
