"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileUploader = exports.PdfUploader = exports.ImageUploaderMemory = exports.ImageUploader = void 0;
const multer_1 = __importDefault(require("multer"));
exports.ImageUploader = (0, multer_1.default)({
    fileFilter: (req, file, cb) => {
        if (file.mimetype.startsWith('image/')) {
            return cb(null, true);
        }
        return cb(new Error('File type is invalid'));
    },
    limits: {
        fieldSize: 10 * 1024 * 1024,
    },
    storage: multer_1.default.diskStorage({
        destination: './uploads',
        filename: (req, file, cb) => {
            const suffix = Date.now() + '-' + `${Math.random()}`.substring(2);
            return cb(null, suffix + '-' + file.originalname);
        },
    }),
});
exports.ImageUploaderMemory = (0, multer_1.default)({
    fileFilter: (req, file, cb) => {
        if (file.mimetype.startsWith('image/')) {
            return cb(null, true);
        }
        return cb(new Error('File type is invalid'));
    },
    limits: {
        fileSize: 10 * 1024 * 1024,
    },
    storage: multer_1.default.memoryStorage(),
});
exports.PdfUploader = (0, multer_1.default)({
    fileFilter: (req, file, cb) => {
        if (file.mimetype.startsWith('application/pdf')) {
            return cb(null, true);
        }
        return cb(new Error('File type is invalid'));
    },
    limits: {
        fieldSize: 10 * 1024 * 1024,
    },
    storage: multer_1.default.diskStorage({
        destination: './uploads',
        filename: (req, file, cb) => {
            const suffix = Date.now() + '-' + `${Math.random()}`.substring(2);
            return cb(null, suffix + '-' + file.originalname);
        },
    }),
});
exports.FileUploader = (0, multer_1.default)({
    fileFilter: (req, file, cb) => {
        return cb(null, true);
    },
    limits: {
        fieldSize: 10 * 1024 * 1024,
    },
    storage: multer_1.default.diskStorage({
        destination: './uploads',
        filename: (req, file, cb) => {
            const suffix = Date.now() + '-' + `${Math.random()}`.substring(2);
            return cb(null, suffix + '-' + file.originalname);
        },
    }),
});
