# PART I: One time setup in AWS Console

## 1. Create Lambda Function

- Go to AWS Console → Lambda → Create Function
- Enter function name
- Pic runtime as node.js 24
- Create Function

- Copy-Paste this code:

```js
export const handler = async (event) => {
  const { endpoint, payload } = event

  try {
    const res = await fetch('https://jsonplaceholder.typicode.com/posts', {
      method: 'POST',
      body: JSON.stringify({
        title: 'Testing',
        body: 'This is just for testing',
        userId: 1,
      }),
      headers: {
        'Content-type': 'application/json; charset=UTF-8',
      },
    })
    const json = await res.json()
    console.log('DONE:', json)

    return {
      status: "OK",
      responseStatus: res.status,
    }
  } catch (err) {
    console.error("Error calling API:", err)
    throw err
  }
}
```

or this

```js
export const handler = async (payload) => {
  const { id, event, data } = payload

  try {
    const res = await fetch('https://dev-vibeapp.thetunagroup.com/api/misc/scheduler', {
      method: 'POST',
      body: JSON.stringify({id, event, data}),
      headers: { 'Content-type': 'application/json; charset=UTF-8' },
    })
    const json = await res.json()
    console.log('DONE:', json)
    return {
      status: "OK",
      responseStatus: res.status,
    }
  } catch (err) {
    console.error("Error calling API:", err)
    throw err
  }
}
```

- Deploy the code
- Copy the ARN into env file as `AWS_EVENTBRIDGE_LAMBDA_ARN`

## 2. Create IAM User with Access & Secret Keys

- Goto IAM Dashboard → Users → Create user
- Enter user name → Next
- Attach Policies Directly → Next
- Add the following policies:
	- AmazonEventBridgeFullAccess
  - AWSLambda_FullAccess
  - AWSLambdaRole
- Next → Create User
- Open that user again
- Create Access key → Choose Application running outside AWS → Next → Create Access Key
- Copy the access key and secret key into env file as `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`
- Click Done

## 3. Create IAM Role for Scheduler

- Goto IAM Dashboard → Roles → Create Role
- Choose Custom Trust Policy
- Copy-Paste this code

```json
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": { "Service": "scheduler.amazonaws.com" },
      "Action": "sts:AssumeRole"
    }
  ]
}
```

- Next → Attach Permission Policies:
- Add these permissions:
  - AWSLambdaRole
  - AWSLambda_FullAccess
- Next → Enter name → Create Role
- Copy its ARN and paste it into `AWS_EVENTBRIDGE_ROLE_ARN`
- Make sure your env also has `AWS_REGION` and both eventbridge and lambda should be from region

## Part 2: Node.js Setup

- Install npm package

```sh
npm install @aws-sdk/client-scheduler
```

- `.env` file

```sh
AWS_ACCESS_KEY_ID='AKIA2MXU6HPVMX5EMQYG'
AWS_SECRET_ACCESS_KEY='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'
AWS_REGION='us-east-1'
AWS_EVENTBRIDGE_ROLE_ARN='arn:aws:iam::714551999466:role/vibe-eventbridge-scheduler'
AWS_EVENTBRIDGE_LAMBDA_ARN='arn:aws:lambda:us-east-1:714551999466:function:vibe-lambda-eventbridge2'
```

- Codebase

```ts
import { SchedulerClient, CreateScheduleCommand, DeleteScheduleCommand } from "@aws-sdk/client-scheduler"

const schedulerClient = new SchedulerClient({
	region: process.env.AWS_REGION,
	credentials: {
    accessKeyId: process.env.AWS_ACCESS_KEY_ID!,
    secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY!,
  }
})

async function createEventBridgeSchedule(name: string, at: Date, payload: any) {
	const toSchedulerTime = (date: Date) => {
		const d = new Date(date)
		return (
			d.getUTCFullYear() +
			"-" +
			String(d.getUTCMonth() + 1).padStart(2, "0") +
			"-" +
			String(d.getUTCDate()).padStart(2, "0") +
			"T" +
			String(d.getUTCHours()).padStart(2, "0") +
			":" +
			String(d.getUTCMinutes()).padStart(2, "0") +
			":" +
			String(d.getUTCSeconds()).padStart(2, "0")
		)
	}
	const command = new CreateScheduleCommand({
		Name: name,
		ScheduleExpression: `at(${toSchedulerTime(at)})`,
		FlexibleTimeWindow: { Mode: 'OFF' },
		ActionAfterCompletion: autoDelete ? 'DELETE' : undefined,
		Target: {
			Arn: process.env.AWS_EVENTBRIDGE_LAMBDA_ARN,
			RoleArn: process.env.AWS_EVENTBRIDGE_ROLE_ARN,
			// Input: JSON.stringify({
			// 	endpoint: "https://example.com/api/schedule",
			// 	payload: { userId: 101, message: 'hello future' }
			// })
			Input: JSON.stringify(payload)
		}
	})
	const resp = await config.schedulerClient.send(command)
	console.log('Created one-time schedule:', resp)
	/*
		{
			ScheduleArn: 'arn:aws:scheduler:us-east-1:714551999466:schedule/default/job-1764211389590',
			'$metadata': {
				httpStatusCode: 200,
				requestId: '0b204e80-49ba-44b1-b117-06bb6b9d2a79',
				extendedRequestId: undefined,
				cfId: undefined,
				attempts: 1,
				totalRetryDelay: 0
			}
		}
	*/
	return resp
}

async function deleteEventBridgeSchedule(name: string) {
	const command = new DeleteScheduleCommand({ Name: name })
	const resp = await config.schedulerClient.send(command)
	console.log('Deleted one-time schedule:', resp)
	/*
		{
			'$metadata': {
				httpStatusCode: 200,
				requestId: 'e2fed789-a449-48b9-bcf6-61476e20b26d',
				extendedRequestId: undefined,
				cfId: undefined,
				attempts: 1,
				totalRetryDelay: 0
			}
		}
	*/
	return resp
}

// createEventBridgeSchedule('job-123', new Date('2025-11-27T08:31:00+05:30'), {message: 'hello world'})

// deleteEventBridgeSchedule('job-1764211389590')
```