# Important Notes

- The response structure is generally in this format for all the error cases:

```js
{
  message: 'error message'
}
```

- In case if any api docs don't have the response body, then always assume it to be in this format:

```js
{
  message: 'success message'
}
```

- The OTP for phone/email is always `1234` in dev environment

- In case if user account is terminated, then it returns a field `terminated: true` in request body with status code `403`

- In case of user email is not verified, then it returns a field `verificationRequired: true` in request body with status code `403`

- Username follows the following regex:

```js
/^[^\W_](?!.*?[._]{2})[\w.]{3,20}[^\W_]$/
```

- Socket ID in request body follows this regex:

```js
/^[A-Za-z0-9\-_]{16,25}$/
```

- The APIs are following usual http status codes:

```log
200 - Success (Used in GET and PATCH API)
201 - Created Successfully (Generally used in POST API)
204 - Deleted Successfully (In this case, body would be missing)
400 - Data Validation Failed
401 - Authorization failed (Always assume you need to login again in this case)
403 - Permission denied
404 - Not found
405 - Route not implemented
409 - Already exist
410 - Gone, mostly used when things expired (i.e. links, otp, etc)
429 - Too many requests (rate limit)
500 - Server error
```

- In secure APIs, The auth token is provided in header in the following way:

```js
{
  Authorization: 'Bearer <token>'
}
```

- For every notification event, unless mentioned specifically, always assume its a firebase push notification as well as it will be saved in database

- The emoji 🌍 means the API is global and don't require any token
- The emoji 🔒 means the API is secure and requires users token
- The emoji 🔐 means the API is secure and requires admin token

- The base domain for dev environment is `https://dev-vibeapp.thetunagroup.com`
- The base path for all users API is `/api`
- The base path for all admin API is `/api/admin`
- The base path for docs is always `/docs`

# Links

## Postman Links

- [Postman App Collection](/docs/app-collections.json) [Use Right Click -> Save link as... to download it]
- [Postman Admin Collections](/docs/admin-collections.json) [Use Right Click -> Save link as... to download it]
- [Postman Environment](/docs/environments.json) [Use Right Click -> Save link as... to download it]

## User API Doc Links

- [Auth Module](/docs/auth.html)
- [User Module](/docs/users.html)
- [Contact Module](/docs/contacts.html)
- [Follower Module](/docs/followers.html)
- [Status Module](/docs/statuses.html)
- [Connection Module](/docs/connections.html)
- [Reel Module](/docs/reels.html)
- [Like Module](/docs/likes.html)
- [Super Like Module](/docs/super-likes.html)
- [Share Module](/docs/shares.html)
- [View Module](/docs/views.html)
- [Comment Module](/docs/comments.html)
- [Favorite Module](/docs/favorites.html)
- [Notification Module](/docs/notifications.html)
- [Blocked Users Module](/docs/blockings.html)
- [Chat Module](/docs/chats.html)
- [Message Module](/docs/messages.html)
- [Request Module](/docs/requests.html)
- [Event Module](/docs/events.html)
- [Contact Us Module](/docs/contact-us.html)
- [Reports Module](/docs/reports.html)
- [Search](/docs/search.html)
- [Rewards Module](/docs/rewards.html)
- [Reward Hashes Module](/docs/reward-hashes.html)
- [Score Module](/docs/scores.html)
- [Misc Module](/docs/misc.html)
- [Usage Module](/docs/usages.html)

## Admin API Doc Links

- [Auth Module](/docs/admin-auth.html)
- [Admin Module](/docs/admin.html)
- [User Module](/docs/admin-users.html)
- [Reel Module](/docs/admin-reels.html)
- [Rewards Module](/docs/admin-rewards.html)

## Miscellaneous Doc Links

- [Cron Jobs](/docs/cron-jobs.html)
- [Models](/docs/models.html)
- [Notification Events](/docs/notification-events.html)
- [Socket Events](/docs/socket-events.html)
- [Schedule Events](/docs/schedule-events.html)
- [Socket Client](/docs/socket.html)
