[Goto Home](/docs/index.html)

# Database Models

## 1. User - `users`

```ts
interface IUser {
  _id: Types.ObjectId
  name?: string
  username?: string  // /^[^\W_](?!.*?[._]{2})[\w.]{3,20}[^\W_]$/
  bio?: string
  url?: string
  school?: string
  courses?: string
  email: string       // /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i
  phone?: string
  dob: Date
  auth: IAuth
  photo?: string
  terminated?: boolean
  purposes: IPurpose[]
  studies: IStudy[]
  categories: string[]
  isManuallyOffline?: boolean
  isOnline?: boolean
  lastOnlineAt?: Date
  followers: number
  followings: number
  posts: number
  status?: Types.ObjectId('statuses')
  deactivatedAt?: Date
  location: {
    type: 'Point',
    coordinates: [number, number]  // [longitude, latitude]
  }
  locationString: string
  data?: Record<string, any>
  verified?: boolean
  createdAt: Date
  updatedAt: Date
}

interface IAuth {
  password: string
  twoFactorAuthentication?: boolean
  loggedinDevices: ILoggedinDevice[]

  phoneOtp?: string
  phoneOtpExpiry?: Date
  phoneVerified?: boolean
  lastPhoneOtpSentAt?: Date

  emailOtp?: string
  emailOtpExpiry?: Date
  emailVerified?: boolean
  lastEmailOtpSentAt?: Date
}

interface ILoggedinDevice {
  _id: Types.ObjectId
  tokenHash: string
  fcmToken?: string
  platform?: 'android' | 'ios' | 'web'
  lastAccessedAt: Date
  createdAt: Date
  updatedAt: Date
}

interface IPurpose {
  type: 'short-term' | 'long-term'
  value: string[]
}

interface IStudy {
  type: string
  value: string[]
}
```

## 2. Admin - `admins`

```ts
interface IAdmin {
  _id: Types.ObjectId
  name: string
  email: string
  phone?: string
  auth: IAuth
  createdAt: Date
  updatedAt: Date
}
```

## 3. Contact - `contacts`

```ts
interface IContact {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  contacts: Record<string, any>[]
  createdAt: Date
  updatedAt: Date
}
```

## 4. Follower - `followers`

```ts
interface IFollower {
  _id: Types.ObjectId
  follower: Types.ObjectId('users')
  following: Types.ObjectId('users')
  at: Date
}
```

## 5. Status - `statuses`

```ts
interface IStatus {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  categories: string[]
  title: string
  schedule: 'now' | 'later'
  startDateType: 'today' | 'tomorrow' | 'custom'
  startDate: string  // YYYY-MM-DD
  startTime: string  // 11:45 PM
  startedAt: Date
  visibleAt: Date
  endedAt: Date
  location: {
    type: 'Point',
    coordinates: [number, number]  // [longitude, latitude]
  }
  locationString: string
  createdAt: Date
  updatedAt: Date
}
```

## 6. Connection - `connections`

```ts
interface IConnection {
  _id: Types.ObjectId
  from: Types.ObjectId('users')
  to: Types.ObjectId('users')
  statusDetail: Types.ObjectId('statuses')
  status: 'pending' | 'accepted'
  acceptedAt?: Date
  chat?: Types.ObjectId('chats')
  createdAt: Date
}
```

## 7. Reel - `reels`

```ts
interface IReel {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  chat?: Types.ObjectId('chats')
  message?: Types.ObjectId('messages')
  metaData?: IReelMetaData
  event?: Types.ObjectId('events')
  description?: string
  tag?: string
  subTag?: string
  cover?: string
  video?: string
  dynamic?: DynamicReelFlat[]
  compressionResult: IReelCompressionResult
  vectorIndex: number[]
  chips?: ('focus' | 'mindfulness' | 'reflection')[]
  hashtags: string[]
  photos?: string[]
  song?: string
  isAnonymous?: boolean
  views: number
  likes: number
  superLikes: number
  shares: number
  comments: number
  reports: number
  favorites: number
  createdAt: Date
  updatedAt: Date
}

// this is how its stored in db
interface DynamicReelFlat {
  parent?: string
  _id?: string
  label?: string
  cover?: string
  video: string
  question?: string
}

// this structure is used when backend interacts with frontend
interface DynamicReelNested {
  _id?: string
  label?: string
  cover?: string
  video: string
  question?: string
  children?: DynamicReelNested[]
}

interface IReelCompressionResult {
  isCompleted?: boolean
  errors?: Record<string, string>
}

interface IReelMetaData {
  comments?: string
  vectorMetaData?: number[]
  isPositive?: boolean
  isNegative?: boolean
  awarenessExercise?: ('mindful-breathing' | 'noticing-sound' | 'body-awareness' | 'focus-on-object' | 'cloud-watching' | 'mindful-walking' | 'gratitude-anchor')[]
  groundingExercise?: ('54321-technique' | 'body-scan' | 'box-breathing' | 'object-focus' | 'name-label-emotions' | 'mindful-walk-scroll' | 'name-surroundings')[]
  isProductivity?: boolean
  isMeditation?: boolean
}
```

## 8. Comment - `comments`

```ts
interface IComment {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reel: Types.ObjectId('reels')
  parent?: Types.ObjectId('comments')
  data: ICommentData[]
  superLike?: Types.ObjectId('super-likes')
  likes: number
  isKind?: boolean
  isThankyou?: boolean
  isNegative?: boolean
  createdAt: Date
  updatedAt: Date
}

// either user or text will be there but not both
interface ICommentData {
  user?: Types.ObjectId('users')
  text?: string
}
```

## 9. Like - `likes`

```ts
interface ILike {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reel?: Types.ObjectId('reels')
  comment?: Types.ObjectId('comments')
  at: Date
}
```

## 10. Super Like - `super-likes`

```ts
interface ISuperLike {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reel: Types.ObjectId('reels')
  at: Date
}
```

## 11. Share - `shares`

```ts
interface IShare {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reel: Types.ObjectId('reels')
  chats: Types.ObjectId('chats')[]
  count: number
  at: Date
}
```

## 12. View - `views`

```ts
interface IView {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reel: Types.ObjectId('reels')
  at: Date
}
```

## 13. Favorite - `favorites`

```ts
interface IFavorite {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reel: Types.ObjectId('reels')
  at: Date
}
```

## 14. Blocked Users - `blockings`

```ts
interface IBlocking {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  blockedBy: Types.ObjectId('users')
  at: Date
}
```

## 15. Notifications - `notifications`

```ts
interface INotification {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  title: string
  description: string
  data?: object
  event: NotificationEvent
  from?: Types.ObjectId('users')
  comment?: Types.ObjectId('comments')
  connection?: Types.ObjectId('connections')
  follower?: Types.ObjectId('followers')
  like?: Types.ObjectId('likes')
  superLike?: Types.ObjectId('super-likes')
  reel?: Types.ObjectId('reels')
  status?: Types.ObjectId('statuses')
  request?: Types.ObjectId('requests')
  chat?: Types.ObjectId('chats')
  meetMeEvent?: Types.ObjectId('events')
  rewardHash?: Types.ObjectId('reward-hashes')
  read?: boolean
  dismissed?: boolean
  at: Date
}
```

> **NOTE:** for list of all `NotificationEvent`, visit [/docs/notification-events.html](/docs/notification-events.html)

## 16. Chats - `chats`

```ts
interface IChat {
  _id: Types.ObjectId
  creator: Types.ObjectId('users')
  user?: Types.ObjectId('users')
  isGroup?: Boolean
  meetMe?: Types.ObjectId('connections')
  event?: Types.ObjectId('events')
  lastMessage?: Types.ObjectId('messages')
  name?: string
  category?: string
  photo?: string
  blocked?: boolean
  participants: IChatParticipant[]
  allowPublicPost?: boolean
  tags: IChatTag[]
  restricted?: boolean
  createdAt: Date
  updatedAt: Date
}

interface IChatParticipant {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  isAdmin?: boolean
  status?: 'accepted' | 'rejected'
  lastReadAt: Date
}

interface IChatTag {
  tag: string
  label: string
}
```

## 17. Messages - `messages`

```ts
interface IMessage {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  chat: Types.ObjectId('chats')
  reel?: Types.ObjectId('reels')
  content?: string
  tag?: string
  files?: IMessageFile[]
  at: Date
}

interface IMessageFile {
  _id: Types.ObjectId
  url: string
  cover?: string
  meta?: any
}
```

## 18. Requests - `requests`

```ts
interface IRequest {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  chat: Types.ObjectId('chats')
  status: ('pending') | 'accepted' | 'rejected'
  createdAt: Date
  acceptedAt?: Date
  rejectedAt?: Date
}
```

## 19. Events - `events`

```ts
interface IEvent {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  title: string
  description: string
  date: string  // YYYY-MM-DD
  time: string  // 11:45 PM
  location: {
    type: 'Point',
    coordinates: [number, number]  // [longitude, latitude]
  }
  locationString: string
  chat: Types.ObjectId('chats')
  category: string
  cover?: string
  startedAt: Date
  endedAt: Date
  createdAt: Date
  updatedAt: Date
}
```

## 20. Contact Us - `contact-us`

```ts
interface IContactUs {
  _id: Types.ObjectId
  user?: Types.ObjectId('users')
  name: string
  email: string
  phone?: string
  message?: string
  createdAt: Date
  updatedAt: Date
}
```

## 21. Reports - `reports`

```ts
interface IReport {
  _id: Types.ObjectId
  reportedBy: Types.ObjectId('users')
  user: Types.ObjectId('users')
  reel: Types.ObjectId('reels')
  category: string
  message?: string
  createdAt: Date
  updatedAt: Date
}
```

## 22. Rewards - `rewards`

```ts
interface IReward {
  _id: Types.ObjectId
  title: string
  description: string
  cover: string
  total: number
  remaining: number
  coupon?: string
  isMeetme?: boolean
  location?: ILocation
  locationString?: string
  expiredAt?: Date
  createdAt: Date
  updatedAt: Date
}
```

## 23. Reward Hashes - `reward-hashes`

```ts
interface IRewardHash {
  _id: Types.ObjectId
  user: Types.ObjectId('users')
  reward?: Types.ObjectId('rewards')
  hash: string
  isConsumed?: boolean
  isMeetme?: Boolean
  score?: Types.ObjectId('scores')
  at: Date
}
```

## 24. Scores - `scores`

```ts
interface IScore {
  _id: Types.ObjectId
  user: Types.ObjectId
  date: Date
  appUsageSeconds: number
  doomScrollUsageSeconds: number
  social: ISocial
  mindfulness: IMindfulness
  totalScore: number
  weeklyScores: IWeeklyScore[]
  hash?: Types.ObjectId
  reelsSeenCount: number
  createdAt: Date
  updatedAt: Date
}

interface IWeeklyScore {
  score: number
  date: Date
  day: typeof constants.days[number]
  reference: Types.ObjectId('scores')
}

interface ISocial {
  score: number
  day: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'
  actions: ISocialAction[]
}

interface ISocialAction {
  label: string
  subLabel: string
  type: 'add-new-friend' | 'create-super-like' | 'create-meetme-request' | 'open-view-all-events' | 'join-group-chat' | 'watch-vibe-dynamic' | 'search-with-meetme-category-filter' | 'open-view-all-rewards' | 'mindful-comment-reply' | 'send-dm-message' | 'mindful-comments' | 'create-meetme-status'
  value: number
  completed?: boolean
  count?: number
}

const socialConnectednessActions = [
  {
    type: 'open-view-all-rewards',
    label: 'Click on View All in the Rewards Near Me',
    subLabel: 'Encourage real-world explorations with your surroundings',
    days: ['monday']
  },
  {
    type: 'create-meetme-status',
    label: 'Add a "Meet Me" Status',
    subLabel: 'Show you\'re open to new connections',
    days: ['monday', 'sunday']
  },
  {
    type: 'add-new-friend',
    label: 'Add one new friend',
    subLabel: 'Expand your circle with presence — connection begins with mindful curiosity',
    days: ['tuesday']
  },
  {
    type: 'create-super-like',
    label: 'Super-like a Vibe video in the home feed',
    subLabel: 'Pause to notice what truly inspires you and express appreciation with intention to the creator',
    days: ['tuesday', 'thursday']
  },
  {
    type: 'create-meetme-request',
    label: 'Send a "Meet Me" request to someone new',
    subLabel: 'Step outside your comfort zone and open space for genuine connection',
    days: ['wednesday']
  },
  {
    type: 'open-view-all-events',
    label: 'Click on View All in the Events Near Me',
    subLabel: 'Discover new experiences and build meaningful connections offline',
    days: ['wednesday']
  },
  {
    type: 'join-group-chat',
    label: 'Join a new community in the Explore page',
    subLabel: 'Expand your perspective, nurture belonging, and deepen meaningful connection',
    days: ['thursday']
  },
  {
    type: 'watch-vibe-dynamic',
    label: 'Watch a Vibe Dynamic video',
    subLabel: 'Engage your mind and interact with creative Vibes',
    days: ['friday']
  },
  {
    type: 'search-with-meetme-category-filter',
    label: 'Filter Meet Me requests by category (e.g., "Coffee")',
    subLabel: 'Align connections with your interests, reduce overwhelm, and support mindful, safe meetups',
    days: ['friday']
  },
  {
    type: 'mindful-comment-reply',
    label: 'Reply mindfully to a comment in the home feed',
    subLabel: 'Cultivate empathy by responding with kindness and understanding different perspectives',
    days: ['saturday']
  },
  {
    type: 'send-dm-message',
    label: 'Send a DM to a friend',
    subLabel: 'Strengthen real connection and presence through one-to-one mindful conversation',
    days: ['saturday']
  },
  {
    type: 'mindful-comments',
    label: 'Leave 3 mindful comments',
    subLabel: 'Practice mindful comments — each word can uplift someone\'s day, including yours',
    days: ['sunday']
  }
]

interface IMindfulness {
  score: number
  actions: IMindfulnessAction[]
  journal?: IJournal
}

interface IMindfulnessAction {
  label: string
  type: 'focus-video' | 'mindfulness-video' | 'reflection-video' | 'journalism'
  value: number
  completed?: boolean
  count?: number
  startAt?: number
}

const mindfulnessActions = [
  { type: 'focus-video', label: 'Watch a Focus video (1 min)', startAt: 8 },
  { type: 'mindfulness-video', label: 'Watch a Mindfulness video (1 min)', startAt: 15 },
  { type: 'reflection-video', label: 'Watch a Reflection video (1 min)', startAt: 20 },
  { type: 'journalism', label: 'Write in Your Journal', startAt: 20 },
]

interface IJournal {
  message: string
  at: Date
}
```

## 25. Misc - `misc`

```ts
interface IMisc {
  _id: Types.ObjectId
  version: IMiscVersionPlatform
}

interface IMiscVersionPlatform {
  android: IMiscVersion
  ios: IMiscVersion
}

interface IMiscVersion {
  latestVersionString: string
  latestVersionCode: number
  minimumVersionString: string
  minimumVersionCode: number
}
```

## 26. Usage - `usages`

```ts
interface IUsage {
  _id: Types.ObjectId
  user: Types.ObjectId
  reel?: Types.ObjectId
  seconds: number
  at: Date
}
```

## 27. MutualFollow - `mutual-follows`

```ts
interface IMutualFollow {
  _id: Types.ObjectId
  users: [Types.ObjectId('users'), Types.ObjectId('users')]
  at: Date
}
```

## 27. Deletion - `deletions`

```ts
interface IDeletion {
  _id: Types.ObjectId
  user: Types.ObjectId
  collections: 'users' | 'reels'
  data: Record<string, any>
  at: Date
}
```

# Links

[Goto Home](/docs/index.html)