[Goto Home](/docs/index.html)

# Notification Events

## 1. `comment-created`

- When a new comment is placed on any reel
- Notify to the reel creator if reel creator and comment creator are different person
- Notify to the parent comment creator if parent comment creator and this comment creator are different person
- Optional fields: `from`, `comment`, `reel`

## 2. `comment-updated`

- When a comment is updated
- Notify to the reel creator if reel creator and comment creator are different person
- Notify to the parent comment creator if parent comment creator and this comment creator are different person
- Optional fields: `from`, `comment`, `reel`

## 3. `connection-request`

- When a meet me connection request received
- Notify the person to which connection is sent
- Optional fields: `from`, `connection`

## 4. `connection-accepted`

- When a meet me connection request is accepted
- Notify the person which requested the connection
- Optional fields: `from`, `connection`

## 5. `user-followed`

- When a user is followed
- Notify the user which has been followed
- Optional fields: `from`, `follower`

## 6. `reel-liked`

- When a reel is liked
- Notify the reel creator if both are different person
- Optional fields: `from`, `reel`, `like`

## 7. `comment-liked`

- When a comment is liked
- Notify the comment creator if both are different person
- Optional fields: `from`, `reel`, `comment`, `like`

## 8. `reel-shared`

- When a reel is shared
- Notify the reel creator if both are different person
- Optional fields: `from`, `reel`

## 9. `reel-super-liked`

- When a reel gets super liked
- Notify the reel creator if both are different person
- Optional fields: `from`, `reel`, `superLike`

## 10. `message-received` ⚡️

- When a new message is received
- This is only fcm notification and it won't get saved in database

```json
{
  "title": "New message from John Doe",
  "body": "Hi, how are you ?",
  "data": {
    "event": "message-received",
    "message": {
      "_id": "68c15d2bf57d9ada6cf9b3cb",
      "user": {
        "_id": "34c15d2bf57d9ada6cf9bb24",
        "username": "john.doe",
        "name": "John Doe",
        "photo": "url",
      },
      "isGroup": false,
      "chat": "34c15d2bf57d9ada6cf9bb24",
      "reel?": "34c15d2bf57d9ada6cf9bb24",
      "content": "Hi, how are you ?",
      "files": [
        {
          "url": "https://example.com/image.jpg"
        }
      ],
      "at": "2025-09-11T10:23:00Z",
    }
  }
}
```

## 11. `chat-join-request`

- When a user send chat join request to restricted chat group
- Notify all the chat admins
- Optional fields: `from`, `chat`, `request`

## 12. `chat-request-accepted`

- When a chat admin accepts chat join request in a restricted chat group
- Notify the user
- Optional fields: `from`, `chat`, `request`

## 13. `chat-admin-access-granted`

- When a regular chat participant got admin access in any chat group by some other admin participant
- Notify the user who got admin access
- Optional fields: `from`, `chat`

## 14. `chat-admin-access-removed`

- When a regular chat participant got his admin access removed in any chat group by some other admin participant
- Notify the user whose admin access got removed
- Optional fields: `from`, `chat`

## 15. `chat-access-removed`

- When a chat participant removed from a chat group by some other admin participant
- Notify the user whose chat access got removed
- Optional fields: `from`, `chat`

## 16. `chat-joined`

- When users joined to a chat by any admin directly
- Notify all those user
- Optional fields: `from`, `chat`

## 17. `event-access-granted`

- When users got access granted to an event by any admin
- Notify that user
- Optional fields: `from`, `chat`, `meetMeEvent`

## 18. `event-access-rejected`

- When users got access rejected to an event by any admin
- Notify that user
- Optional fields: `from`, `chat`, `meetMeEvent`

## 19. `event-joined`

- When users joined to an event chat
- Notify all the chat admins
- Optional fields: `from`, `chat`, `meetMeEvent`

## 20. `reward-unlocked`

- When a profile reward is unlocked for the user
- Notify that user
- Optional fields: `rewardHash`

## 21. `group-chat-created`

- When a group chat is created and the user is a member of that chat
- Notify all participants
- Optional fields: `from`, `chat`

# Important Note

All fcm notifications payload (when saved in db) are of this form:

```ts
interface Payload {
  title: string
  description: string
  data: {
    notification: string
    event: NotificationEvent
  }
}
```

Here is the sample example:

```json
{
  "title": "Your reel got a new like",
  "body": "A user raj.example has liked your reel",
  "data": {
    "notification": "68c15d2bf57d9ada6cf9b3cb",
    "event": "reel-liked"
  }
}
```

# Links

[Goto Home](/docs/index.html)