[Goto Home](/docs/index.html)

# 🔒 GET `/statuses/search` for Meet Me

## Description

- Returns the matching user statuses and events nearby
- Don't return the current user status

## Request Query

- **limit** - default `5`, set the number of items to return on each page
- **search** - required field; apply search filter for user based on its name, username & status title and for events - title and description; Minimum character required is `3`

## Response Body

```json
{
  "users": [
    {
      "_id": "688c51572b675be4b88339d1",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-01T05:32:07.075Z",
      "updatedAt": "2025-10-22T05:47:40.556Z",
      "name": "John Doe",
      "username": "john.doe",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
      "bio": "I am a workaholic",
      "status": {
        "_id": "68f86ffc6fd2628adeee4534",
        "user": "688c51572b675be4b88339d1",
        "category": "exam",
        "schedule": "later",
        "startDateType": "today",
        "startDate": "2025-10-22",
        "startTime": "09:59 PM",
        "title": "Hi let's connect for exam preparation",
        "startedAt": "2025-10-22T16:29:00.000Z",
        "visibleAt": "2025-10-22T04:29:00.000Z",
        "endedAt": "2025-10-22T17:29:00.000Z",
        "location": {
          "type": "Point",
          "coordinates": [
            -34.566,
            12.455
          ]
        },
        "locationString": "Central Park, Rock-port, UK",
        "createdAt": "2025-10-22T05:47:40.146Z",
        "updatedAt": "2025-10-22T05:47:40.146Z"
      },
      "connection": {
        "_id": "689c346d05d06cb919e301e9",
        "from": "688c51572b675be4b88339d1",
        "to": "68914287e4c3076d9436523c",
        "status": "accepted",
        "createdAt": "2025-08-13T06:45:01.000Z",
        "acceptedAt": "2025-08-13T06:46:49.541Z"
      }
    }
  ],
  "events": [
    {
      "_id": "68eca782eab58ae34d040489",
      "user": "68c7f963d4ec4fd41b3e804b",
      "title": "Let's Plant Many Trees",
      "description": "Lets meet at this sunday, plant many trees and make our nature healthy",
      "date": "2025-11-12",
      "time": "11:00 AM",
      "location": {
        "type": "Point",
        "coordinates": [
          -71.0948037,
          42.360092
        ]
      },
      "locationString": "77 Massachusetts Ave, Cambridge, MA 02139, United States",
      "chat": {
        "_id": "68eca782eab58ae34d040487",
        "creator": "68c7f963d4ec4fd41b3e804b",
        "isGroup": true,
        "name": "Let's Plant Many Trees",
        "allowPublicPost": true,
        "areYouAdmin": false,
        "tags": [],
        "participants": [
          {
            "user": "68c7f963d4ec4fd41b3e804b",
            "isAdmin": true,
            "_id": "68eca782eab58ae34d040488",
            "lastReadAt": "2025-10-13T07:17:22.000Z"
          },
          {
            "user": "68ac3f6dd7f5a437029aa88f",
            "_id": "68ef6dd1b774b6019cf94617",
            "lastReadAt": "2025-10-21T08:34:27.073Z"
          }
        ],
        "event": "68eca782eab58ae34d040489",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68eca782eab58ae34d040487/1760339841971-1786227063776834-tree.png",
        "createdAt": "2025-10-13T07:17:25.793Z",
        "updatedAt": "2025-10-21T08:34:27.074Z",
        "lastMessage": "68f35a006ce2864d871fbba9",
        "participantsCount": 2,
        "isJoined": false
      },
      "category": "Plants",
      "startedAt": "2025-11-12T05:30:00.000Z",
      "endedAt": "2025-11-12T10:30:00.000Z",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68eca782eab58ae34d040487/1760339841971-1786227063776834-tree.png",
      "createdAt": "2025-10-13T07:17:26.118Z",
      "updatedAt": "2025-10-13T07:17:26.118Z",
      "joined": false
    }
  ]
}
```

# 🔒 GET `/users/explore` for Explore Search

## Description

- Returns the matching users and group chats
- Don't return the current user

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **search** - required field; apply search filter for user based on its name and username and for chats name; Minimum character required is `3`

## Response Body

```json
{
  "users": [
    {
      "_id": "68ac3f6dd7f5a437029aa88f",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-25T10:48:13.368Z",
      "updatedAt": "2025-10-14T09:16:01.065Z",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1758007790332-16697659211217097-1758007788161-f05c235e-a4de-4519-8615-ed9802295e9d.jpeg.jpg",
      "name": "Jass Singh",
      "username": "bat_ma_n",
      "bio": "New Bio +1"
    }
  ],
  "chats": [
    {
      "_id": "68ee530a808e28d0b11beec9",
      "isGroup": true,
      "name": "Pool Party",
      "allowPublicPost": true,
      "areYouAdmin": false,
      "participants": [
        {
          "user": "68914287e4c3076d9436523c",
          "isAdmin": true,
          "_id": "68ee530a808e28d0b11beeca",
          "lastReadAt": "2025-10-24T11:23:59.609Z"
        },
        {
          "user": "688c51572b675be4b88339d1",
          "_id": "68f8b97793ecb98e6261a6eb",
          "lastReadAt": "2025-10-22T11:23:18.751Z"
        }
      ],
      "event": "68ee530a808e28d0b11beecb",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68ee530a808e28d0b11beec9/1760449289304-22034956871186895-tree.png",
      "createdAt": "2025-10-14T13:41:32.673Z",
      "updatedAt": "2025-10-24T11:23:59.610Z",
      "restricted": true,
      "request": {
        "_id": "68fb2194ebd831054c0411cc",
        "user": "689b1fca132cd7d169e76e2d",
        "chat": "68ee530a808e28d0b11beec9",
        "status": "pending",
        "createdAt": "2025-10-24T06:49:56.000Z"
      },
      "participantsCount": 2,
      "isJoined": false
    }
  ]
}
```

# Links

[Goto Home](/docs/index.html)