[Goto Home](/docs/index.html)

# Socket Events for Listening

## 1. `user-online`

- When one of the user in his chat list becomes online
- Triggered at 2 places:
  - When the user modifies its isManuallyOffline field from PATCH /users/profile API
  - When the user creates a socket connection with the server

```json
{
  "event": "user-online",
  "data": {
    "user": {
      "_id": "68ac3f6dd7f5a437029aa88f",
      "name": "ScannerScannerScanne",
      "username": "bat_ma_n",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1760618979709-3310522348281584-1760618978233-543e7038-2cf6-46b9-ac0d-9af0cb741d6b.jpeg.jpg"
    },
    "chats": [
      "68c90eb8d4ec4fd41b3e8bb5",
      "68d637d114789cc4f67a4582",
      "68c91d441f5f189aa2c53780",
      "68eca782eab58ae34d040487",
      "6911fcc4b338e45e74dd0aaa",
      "68d144ba72f149b17a22391a"
    ],
    "chat": "68d637d114789cc4f67a4582"
  }
}
```

## 2. `user-offline`

- When one of the user in his chat list becomes offline
- Triggered when the user modifies its isManuallyOffline field from PATCH /users/profile API

```json
{
  "event": "user-offline",
  "data": {
    "user": {
      "_id": "68ac3f6dd7f5a437029aa88f",
      "name": "ScannerScannerScanne",
      "username": "bat_ma_n",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1760618979709-3310522348281584-1760618978233-543e7038-2cf6-46b9-ac0d-9af0cb741d6b.jpeg.jpg"
    },
    "chats": [
      "68c90eb8d4ec4fd41b3e8bb5",
      "68d637d114789cc4f67a4582",
      "68c91d441f5f189aa2c53780",
      "68eca782eab58ae34d040487",
      "6911fcc4b338e45e74dd0aaa",
      "68d144ba72f149b17a22391a"
    ],
    "chat": "68d637d114789cc4f67a4582"
  }
}
```

## 3. `typing-started`

- When a user in one of his chats started typing
- User must belong to that chat

```json
{
  "event": "typing-started",
  "data": {
    "user": {
      "_id": "68b5931b4d5c718924c59a40",
      "name": "Raj Kr",
      "username": "raj.example",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
    },
    "chat": "24f83d46d7f5a437029aa4c3"
  }
}
```

## 4. `typing-stopped`

- When a user in one of his chats stopped typing
- User must belong to that chat

```json
{
  "event": "typing-stopped",
  "data": {
    "user": {
      "_id": "68b5931b4d5c718924c59a40",
      "name": "Raj Kr",
      "username": "raj.example",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
    },
    "chat": "24f83d46d7f5a437029aa4c3"
  }
}
```

## 5. `messages-read`

- When a user in one of his chats read messages

```json
{
  "event": "messages-read",
  "data": {
    "user": {
      "_id": "68b5931b4d5c718924c59a40",
      "name": "Raj Kr",
      "username": "raj.example",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
    },
    "chat": "68beebca57ab80b6986794df",
    "lastReadAt": "2025-09-12T15:36:43.453Z",
    "lastMessage": {
      "_id": "68bef611862efa05c5a15438",
      "user": "68b5931b4d5c718924c59a40",
      "chat": "68beebca57ab80b6986794df",
      "content": "Hi There",
      "at": "2025-09-08T15:28:17.000Z"
    }
  }
}
```

## 6. `message-received`

- When a user got a new message

```json
{
  "event": "messages-received",
  "data": {
    "message": {
      "_id": "68c7df06d34e93befb486cda",
      "user": {
        "_id": "68b5931b4d5c718924c59a40",
        "name": "Raj Kr",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png",
        "username": "raj.example"
      },
      "chat": "68bee79857ab80b69867946b",
      "reel?": "68bee79857ab80b69867946b",
      "content": "Hi John, All good ?",
      "at": "2025-09-15T09:40:22.000Z"
    }
  }
}
```

## 7. `message-sent`

- When a message has been sent

```json
{
  "event": "messages-sent",
  "data": {
    "message": {
      "_id": "68c7df06d34e93befb486cda",
      "user": {
        "_id": "68b5931b4d5c718924c59a40",
        "name": "Raj Kr",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png",
        "username": "raj.example"
      },
      "chat": "68bee79857ab80b69867946b",
      "content": "Hi John, All good ?",
      "at": "2025-09-15T09:40:22.000Z"
    }
  }
}
```

## 8. `chat-created`

- When a user got new chat

```json
{
  "event": "chat-created",
  "data": {
    "chat": "68c7ed083834f8071f38346b"
  }
}
```

## 9. `account-terminated`

- When a user account is terminated

```json
{
  "event": "account-terminated",
  "data": {
    "message": "Your account has been terminated due to a violation of our Terms and Conditions and in accordance with our Privacy Policy."
  }
}
```

## 10. `chat-joined`

- When a user joined a chat
- If user is joined by an admin, then his data would also appear 

```json
{
  "event": "chat-joined",
  "data": {
    "chat": "c2b131b4d5c7189924c59721",
    "admin?": {
      "_id": "68b5931b4d5c718924c59a40",
      "name": "Raj Kr",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png",
      "username": "raj.example"
    },
  }
}
```

## 11. `chat-participant-removed`

- When a user leave a chat group either by himself or by admin

```json
{
  "event": "chat-participant-removed",
  "data": {
    "chat": "c2b131b4d5c7189924c59721",
    "user": "24f83d46d7f5a437029aa4c3",
  }
}
```

## 12. `chat-deleted`

- When a admin deletes the chat
- Notify all other users
- Notify current user's other devices as well

```json
{
  "event": "chat-deleted",
  "data": {
    "chat": "c2b131b4d5c7189924c59721",
    "user": "24f83d46d7f5a437029aa6cb",
    "event?": "24f83d46d7f5a437029aa4c3",
  }
}
```

## 13. `reward-consumed`

- When a user consumes a reward
- Notify all users

```json
{
  "event": "reward-consumed",
  "data": {
    "reward": "c2b131b4d5c7189924c59721",
    "isExpired": true,
    "remaining": 0,
    "isConsumedByYou": true
  }
}
```

## 14. `score-updated`

- When a user score is updated

```json
{
  "event": "score-updated",
  "data": {
    "date": "2025-11-07T18:30:00.000Z",
    "reelsSeen": 3,
    "totalScore": 1,
    "social": {
      "score": 0.5,
      "day": "saturday",
      "actions": [
        {
          "label": "Reply mindfully to a comment in the home feed",
          "subLabel": "Cultivate empathy by responding with kindness and understanding different perspectives",
          "type": "mindful-comment-reply",
          "value": 1,
          "completed": true
        },
        {
          "label": "Send a DM to a friend",
          "subLabel": "Strengthen real connection and presence through one-to-one mindful conversation",
          "type": "send-dm-message",
          "value": 0
        }
      ]
    },
    "mindfulness": {
      "score": 0,
      "actions": [
        {
          "label": "Watch a Focus video (1 min)",
          "type": "focus-video",
          "value": 0,
          "startAt": 8
        },
        {
          "label": "Watch a Mindfulness video (1 min)",
          "type": "mindfulness-video",
          "value": 0,
          "startAt": 15
        },
        {
          "label": "Watch a Reflection video (1 min)",
          "type": "reflection-video",
          "value": 0,
          "startAt": 20
        },
        {
          "label": "Write in Your Journal",
          "type": "journalism",
          "value": 0,
          "startAt": 20
        }
      ]
    }
  }
}
```

# Socket Events for Emitting

## 1. `typing-started`

- When a user in one of his chats started typing

```json
{
  "event": "typing-started",
  "data": {
    "chat": "24f83d46d7f5a437029aa4c3"
  }
}
```

## 2. `typing-stopped`

- When a user in one of his chats stopped typing

```json
{
  "event": "typing-stopped",
  "data": {
    "chat": "24f83d46d7f5a437029aa4c3"
  }
}
```

## 3. `messages-read`

- When a user in one of his chats read messages

```json
{
  "event": "messages-read",
  "data": {
    "chat": "68beebca57ab80b6986794df"
  }
}
```

# Socket Error Events

> **NOTE:** These are just for debugging and logging purposes. Also in all these cases, the payload would be of this form:

```ts
interface Payload {
  event: SocketErrorEvent
  data: {
    message: string
  }
}
```

Here is a payload example:

```json
{
  "event": "verification-required",
  "data": {
    "message": "Please verify your email first"
  }
}
```

Here are the list of all `SocketErrorEvent`:

## 1. `authorization-failed`

- Emitted at the time of connection when token is invalid

## 2. `verification-required`

- Emitted at the time of connection if user account is not verified

## 3. `account-terminated`

- Emitted at the time of connection if user account is terminated

## 4. `server-error`

- Emitted any time of creating connection or emitting socket event, if there is any server error

## 5. `validation-failed`

- When the event payload in socket has invalid data

## 6. `not-found`

- When the given resource is not found

## 7. `permission-denied`

- When the user don't have proper permission to perform that specific action

# Links

[Goto Home](/docs/index.html)