'use strict';

var middlewareHostHeader = require('@aws-sdk/middleware-host-header');
var middlewareLogger = require('@aws-sdk/middleware-logger');
var middlewareRecursionDetection = require('@aws-sdk/middleware-recursion-detection');
var middlewareUserAgent = require('@aws-sdk/middleware-user-agent');
var configResolver = require('@smithy/config-resolver');
var core = require('@smithy/core');
var schema = require('@smithy/core/schema');
var middlewareContentLength = require('@smithy/middleware-content-length');
var middlewareEndpoint = require('@smithy/middleware-endpoint');
var middlewareRetry = require('@smithy/middleware-retry');
var smithyClient = require('@smithy/smithy-client');
var httpAuthSchemeProvider = require('./auth/httpAuthSchemeProvider');
var runtimeConfig = require('./runtimeConfig');
var regionConfigResolver = require('@aws-sdk/region-config-resolver');
var protocolHttp = require('@smithy/protocol-http');

const resolveClientEndpointParameters = (options) => {
    return Object.assign(options, {
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        defaultSigningName: "scheduler",
    });
};
const commonParams = {
    UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
    Endpoint: { type: "builtInParams", name: "endpoint" },
    Region: { type: "builtInParams", name: "region" },
    UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
};

const getHttpAuthExtensionConfiguration = (runtimeConfig) => {
    const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
    let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
    let _credentials = runtimeConfig.credentials;
    return {
        setHttpAuthScheme(httpAuthScheme) {
            const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
            if (index === -1) {
                _httpAuthSchemes.push(httpAuthScheme);
            }
            else {
                _httpAuthSchemes.splice(index, 1, httpAuthScheme);
            }
        },
        httpAuthSchemes() {
            return _httpAuthSchemes;
        },
        setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
            _httpAuthSchemeProvider = httpAuthSchemeProvider;
        },
        httpAuthSchemeProvider() {
            return _httpAuthSchemeProvider;
        },
        setCredentials(credentials) {
            _credentials = credentials;
        },
        credentials() {
            return _credentials;
        },
    };
};
const resolveHttpAuthRuntimeConfig = (config) => {
    return {
        httpAuthSchemes: config.httpAuthSchemes(),
        httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
        credentials: config.credentials(),
    };
};

const resolveRuntimeExtensions = (runtimeConfig, extensions) => {
    const extensionConfiguration = Object.assign(regionConfigResolver.getAwsRegionExtensionConfiguration(runtimeConfig), smithyClient.getDefaultExtensionConfiguration(runtimeConfig), protocolHttp.getHttpHandlerExtensionConfiguration(runtimeConfig), getHttpAuthExtensionConfiguration(runtimeConfig));
    extensions.forEach((extension) => extension.configure(extensionConfiguration));
    return Object.assign(runtimeConfig, regionConfigResolver.resolveAwsRegionExtensionConfiguration(extensionConfiguration), smithyClient.resolveDefaultRuntimeConfig(extensionConfiguration), protocolHttp.resolveHttpHandlerRuntimeConfig(extensionConfiguration), resolveHttpAuthRuntimeConfig(extensionConfiguration));
};

class SchedulerClient extends smithyClient.Client {
    config;
    constructor(...[configuration]) {
        const _config_0 = runtimeConfig.getRuntimeConfig(configuration || {});
        super(_config_0);
        this.initConfig = _config_0;
        const _config_1 = resolveClientEndpointParameters(_config_0);
        const _config_2 = middlewareUserAgent.resolveUserAgentConfig(_config_1);
        const _config_3 = middlewareRetry.resolveRetryConfig(_config_2);
        const _config_4 = configResolver.resolveRegionConfig(_config_3);
        const _config_5 = middlewareHostHeader.resolveHostHeaderConfig(_config_4);
        const _config_6 = middlewareEndpoint.resolveEndpointConfig(_config_5);
        const _config_7 = httpAuthSchemeProvider.resolveHttpAuthSchemeConfig(_config_6);
        const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
        this.config = _config_8;
        this.middlewareStack.use(schema.getSchemaSerdePlugin(this.config));
        this.middlewareStack.use(middlewareUserAgent.getUserAgentPlugin(this.config));
        this.middlewareStack.use(middlewareRetry.getRetryPlugin(this.config));
        this.middlewareStack.use(middlewareContentLength.getContentLengthPlugin(this.config));
        this.middlewareStack.use(middlewareHostHeader.getHostHeaderPlugin(this.config));
        this.middlewareStack.use(middlewareLogger.getLoggerPlugin(this.config));
        this.middlewareStack.use(middlewareRecursionDetection.getRecursionDetectionPlugin(this.config));
        this.middlewareStack.use(core.getHttpAuthSchemeEndpointRuleSetPlugin(this.config, {
            httpAuthSchemeParametersProvider: httpAuthSchemeProvider.defaultSchedulerHttpAuthSchemeParametersProvider,
            identityProviderConfigProvider: async (config) => new core.DefaultIdentityProviderConfig({
                "aws.auth#sigv4": config.credentials,
            }),
        }));
        this.middlewareStack.use(core.getHttpSigningPlugin(this.config));
    }
    destroy() {
        super.destroy();
    }
}

let SchedulerServiceException$1 = class SchedulerServiceException extends smithyClient.ServiceException {
    constructor(options) {
        super(options);
        Object.setPrototypeOf(this, SchedulerServiceException.prototype);
    }
};

let InternalServerException$1 = class InternalServerException extends SchedulerServiceException$1 {
    name = "InternalServerException";
    $fault = "server";
    Message;
    constructor(opts) {
        super({
            name: "InternalServerException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, InternalServerException.prototype);
        this.Message = opts.Message;
    }
};
let ResourceNotFoundException$1 = class ResourceNotFoundException extends SchedulerServiceException$1 {
    name = "ResourceNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
        this.Message = opts.Message;
    }
};
let ThrottlingException$1 = class ThrottlingException extends SchedulerServiceException$1 {
    name = "ThrottlingException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ThrottlingException.prototype);
        this.Message = opts.Message;
    }
};
let ValidationException$1 = class ValidationException extends SchedulerServiceException$1 {
    name = "ValidationException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ValidationException.prototype);
        this.Message = opts.Message;
    }
};
let ConflictException$1 = class ConflictException extends SchedulerServiceException$1 {
    name = "ConflictException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Message = opts.Message;
    }
};
let ServiceQuotaExceededException$1 = class ServiceQuotaExceededException extends SchedulerServiceException$1 {
    name = "ServiceQuotaExceededException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ServiceQuotaExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceQuotaExceededException.prototype);
        this.Message = opts.Message;
    }
};

const _A = "Arn";
const _AAC = "ActionAfterCompletion";
const _API = "AssignPublicIp";
const _AVC = "AwsVpcConfiguration";
const _CD = "CreationDate";
const _CE = "ConflictException";
const _CPS = "CapacityProviderStrategy";
const _CPSI = "CapacityProviderStrategyItem";
const _CS = "CreateSchedule";
const _CSG = "CreateScheduleGroup";
const _CSGI = "CreateScheduleGroupInput";
const _CSGO = "CreateScheduleGroupOutput";
const _CSI = "CreateScheduleInput";
const _CSO = "CreateScheduleOutput";
const _CT = "ClientToken";
const _D = "Description";
const _DLC = "DeadLetterConfig";
const _DS = "DeleteSchedule";
const _DSG = "DeleteScheduleGroup";
const _DSGI = "DeleteScheduleGroupInput";
const _DSGO = "DeleteScheduleGroupOutput";
const _DSI = "DeleteScheduleInput";
const _DSO = "DeleteScheduleOutput";
const _DT = "DetailType";
const _EBP = "EventBridgeParameters";
const _ED = "EndDate";
const _EEC = "EnableExecuteCommand";
const _EECSMT = "EnableECSManagedTags";
const _EP = "EcsParameters";
const _FTW = "FlexibleTimeWindow";
const _G = "Group";
const _GN = "GroupName";
const _GS = "GetSchedule";
const _GSG = "GetScheduleGroup";
const _GSGI = "GetScheduleGroupInput";
const _GSGO = "GetScheduleGroupOutput";
const _GSI = "GetScheduleInput";
const _GSO = "GetScheduleOutput";
const _I = "Input";
const _ISE = "InternalServerException";
const _K = "Key";
const _KKA = "KmsKeyArn";
const _KP = "KinesisParameters";
const _LMD = "LastModificationDate";
const _LS = "ListSchedules";
const _LSG = "ListScheduleGroups";
const _LSGI = "ListScheduleGroupsInput";
const _LSGO = "ListScheduleGroupsOutput";
const _LSI = "ListSchedulesInput";
const _LSO = "ListSchedulesOutput";
const _LT = "LaunchType";
const _LTFR = "ListTagsForResource";
const _LTFRI = "ListTagsForResourceInput";
const _LTFRO = "ListTagsForResourceOutput";
const _M = "Message";
const _MEAIS = "MaximumEventAgeInSeconds";
const _MGI = "MessageGroupId";
const _MR = "MaxResults";
const _MRA = "MaximumRetryAttempts";
const _MWIM = "MaximumWindowInMinutes";
const _Mo = "Mode";
const _N = "Name";
const _NC = "NetworkConfiguration";
const _NP = "NamePrefix";
const _NT = "NextToken";
const _PC = "PlacementConstraints";
const _PCl = "PlacementConstraint";
const _PK = "PartitionKey";
const _PPL = "PipelineParameterList";
const _PS = "PlacementStrategy";
const _PSl = "PlacementStrategies";
const _PT = "PropagateTags";
const _PV = "PlatformVersion";
const _RA = "ResourceArn";
const _RAo = "RoleArn";
const _RI = "ReferenceId";
const _RNFE = "ResourceNotFoundException";
const _RP = "RetryPolicy";
const _S = "Subnets";
const _SA = "ScheduleArn";
const _SD = "StartDate";
const _SE = "ScheduleExpression";
const _SET = "ScheduleExpressionTimezone";
const _SG = "SecurityGroups";
const _SGA = "ScheduleGroupArn";
const _SGL = "ScheduleGroupList";
const _SGS = "ScheduleGroupSummary";
const _SGc = "ScheduleGroups";
const _SGch = "ScheduleGroup";
const _SL = "ScheduleList";
const _SMPP = "SageMakerPipelineParameter";
const _SMPPL = "SageMakerPipelineParameterList";
const _SMPPa = "SageMakerPipelineParameters";
const _SP = "SqsParameters";
const _SQEE = "ServiceQuotaExceededException";
const _SS = "ScheduleSummary";
const _Sc = "Schedules";
const _So = "Source";
const _St = "State";
const _T = "Tags";
const _TC = "TaskCount";
const _TDA = "TaskDefinitionArn";
const _TE = "ThrottlingException";
const _TK = "TagKeys";
const _TL = "TagList";
const _TR = "TagResource";
const _TRI = "TagResourceInput";
const _TRO = "TagResourceOutput";
const _TS = "TargetSummary";
const _Ta = "Target";
const _Tag = "Tag";
const _UR = "UntagResource";
const _URI = "UntagResourceInput";
const _URO = "UntagResourceOutput";
const _US = "UpdateSchedule";
const _USI = "UpdateScheduleInput";
const _USO = "UpdateScheduleOutput";
const _V = "Value";
const _VE = "ValidationException";
const _aC = "awsvpcConfiguration";
const _b = "base";
const _c = "client";
const _cP = "capacityProvider";
const _cT = "clientToken";
const _e = "error";
const _ex = "expression";
const _f = "field";
const _gN = "groupName";
const _h = "http";
const _hE = "httpError";
const _hQ = "httpQuery";
const _iT = "idempotencyToken";
const _s = "server";
const _sm = "smithy.ts.sdk.synthetic.com.amazonaws.scheduler";
const _t = "type";
const _w = "weight";
const n0 = "com.amazonaws.scheduler";
var AwsVpcConfiguration = [3, n0, _AVC, 0, [_S, _SG, _API], [64 | 0, 64 | 0, 0]];
var CapacityProviderStrategyItem = [3, n0, _CPSI, 0, [_cP, _w, _b], [0, 1, 1]];
var ConflictException = [
    -3,
    n0,
    _CE,
    {
        [_e]: _c,
        [_hE]: 409,
    },
    [_M],
    [0],
];
schema.TypeRegistry.for(n0).registerError(ConflictException, ConflictException$1);
var CreateScheduleGroupInput = [
    3,
    n0,
    _CSGI,
    0,
    [_N, _T, _CT],
    [[0, 1], () => TagList, [0, 4]],
];
var CreateScheduleGroupOutput = [3, n0, _CSGO, 0, [_SGA], [0]];
var CreateScheduleInput = [
    3,
    n0,
    _CSI,
    0,
    [_N, _GN, _SE, _SD, _ED, _D, _SET, _St, _KKA, _Ta, _FTW, _CT, _AAC],
    [[0, 1], 0, 0, 4, 4, 0, 0, 0, 0, () => Target, () => FlexibleTimeWindow, [0, 4], 0],
];
var CreateScheduleOutput = [3, n0, _CSO, 0, [_SA], [0]];
var DeadLetterConfig = [3, n0, _DLC, 0, [_A], [0]];
var DeleteScheduleGroupInput = [
    3,
    n0,
    _DSGI,
    0,
    [_N, _CT],
    [
        [0, 1],
        [
            0,
            {
                [_iT]: 1,
                [_hQ]: _cT,
            },
        ],
    ],
];
var DeleteScheduleGroupOutput = [3, n0, _DSGO, 0, [], []];
var DeleteScheduleInput = [
    3,
    n0,
    _DSI,
    0,
    [_N, _GN, _CT],
    [
        [0, 1],
        [
            0,
            {
                [_hQ]: _gN,
            },
        ],
        [
            0,
            {
                [_iT]: 1,
                [_hQ]: _cT,
            },
        ],
    ],
];
var DeleteScheduleOutput = [3, n0, _DSO, 0, [], []];
var EcsParameters = [
    3,
    n0,
    _EP,
    0,
    [_TDA, _TC, _LT, _NC, _PV, _G, _CPS, _EECSMT, _EEC, _PC, _PS, _PT, _RI, _T],
    [
        0,
        1,
        0,
        () => NetworkConfiguration,
        0,
        0,
        () => CapacityProviderStrategy,
        2,
        2,
        () => PlacementConstraints,
        () => PlacementStrategies,
        0,
        0,
        [1, n0, _T, 0, 128 | 0],
    ],
];
var EventBridgeParameters = [3, n0, _EBP, 0, [_DT, _So], [0, 0]];
var FlexibleTimeWindow = [3, n0, _FTW, 0, [_Mo, _MWIM], [0, 1]];
var GetScheduleGroupInput = [3, n0, _GSGI, 0, [_N], [[0, 1]]];
var GetScheduleGroupOutput = [3, n0, _GSGO, 0, [_A, _N, _St, _CD, _LMD], [0, 0, 0, 4, 4]];
var GetScheduleInput = [
    3,
    n0,
    _GSI,
    0,
    [_N, _GN],
    [
        [0, 1],
        [
            0,
            {
                [_hQ]: _gN,
            },
        ],
    ],
];
var GetScheduleOutput = [
    3,
    n0,
    _GSO,
    0,
    [_A, _GN, _N, _SE, _SD, _ED, _D, _SET, _St, _CD, _LMD, _KKA, _Ta, _FTW, _AAC],
    [0, 0, 0, 0, 4, 4, 0, 0, 0, 4, 4, 0, () => Target, () => FlexibleTimeWindow, 0],
];
var InternalServerException = [
    -3,
    n0,
    _ISE,
    {
        [_e]: _s,
        [_hE]: 500,
    },
    [_M],
    [0],
];
schema.TypeRegistry.for(n0).registerError(InternalServerException, InternalServerException$1);
var KinesisParameters = [3, n0, _KP, 0, [_PK], [0]];
var ListScheduleGroupsInput = [
    3,
    n0,
    _LSGI,
    0,
    [_NP, _NT, _MR],
    [
        [
            0,
            {
                [_hQ]: _NP,
            },
        ],
        [
            0,
            {
                [_hQ]: _NT,
            },
        ],
        [
            1,
            {
                [_hQ]: _MR,
            },
        ],
    ],
];
var ListScheduleGroupsOutput = [
    3,
    n0,
    _LSGO,
    0,
    [_NT, _SGc],
    [0, () => ScheduleGroupList],
];
var ListSchedulesInput = [
    3,
    n0,
    _LSI,
    0,
    [_GN, _NP, _St, _NT, _MR],
    [
        [
            0,
            {
                [_hQ]: _SGch,
            },
        ],
        [
            0,
            {
                [_hQ]: _NP,
            },
        ],
        [
            0,
            {
                [_hQ]: _St,
            },
        ],
        [
            0,
            {
                [_hQ]: _NT,
            },
        ],
        [
            1,
            {
                [_hQ]: _MR,
            },
        ],
    ],
];
var ListSchedulesOutput = [3, n0, _LSO, 0, [_NT, _Sc], [0, () => ScheduleList]];
var ListTagsForResourceInput = [3, n0, _LTFRI, 0, [_RA], [[0, 1]]];
var ListTagsForResourceOutput = [3, n0, _LTFRO, 0, [_T], [() => TagList]];
var NetworkConfiguration = [3, n0, _NC, 0, [_aC], [() => AwsVpcConfiguration]];
var PlacementConstraint = [3, n0, _PCl, 0, [_t, _ex], [0, 0]];
var PlacementStrategy = [3, n0, _PS, 0, [_t, _f], [0, 0]];
var ResourceNotFoundException = [
    -3,
    n0,
    _RNFE,
    {
        [_e]: _c,
        [_hE]: 404,
    },
    [_M],
    [0],
];
schema.TypeRegistry.for(n0).registerError(ResourceNotFoundException, ResourceNotFoundException$1);
var RetryPolicy = [3, n0, _RP, 0, [_MEAIS, _MRA], [1, 1]];
var SageMakerPipelineParameter = [3, n0, _SMPP, 0, [_N, _V], [0, 0]];
var SageMakerPipelineParameters = [
    3,
    n0,
    _SMPPa,
    0,
    [_PPL],
    [() => SageMakerPipelineParameterList],
];
var ScheduleGroupSummary = [3, n0, _SGS, 0, [_A, _N, _St, _CD, _LMD], [0, 0, 0, 4, 4]];
var ScheduleSummary = [
    3,
    n0,
    _SS,
    0,
    [_A, _N, _GN, _St, _CD, _LMD, _Ta],
    [0, 0, 0, 0, 4, 4, () => TargetSummary],
];
var ServiceQuotaExceededException = [
    -3,
    n0,
    _SQEE,
    {
        [_e]: _c,
        [_hE]: 402,
    },
    [_M],
    [0],
];
schema.TypeRegistry.for(n0).registerError(ServiceQuotaExceededException, ServiceQuotaExceededException$1);
var SqsParameters = [3, n0, _SP, 0, [_MGI], [0]];
var Tag = [3, n0, _Tag, 0, [_K, _V], [0, 0]];
var TagResourceInput = [3, n0, _TRI, 0, [_RA, _T], [[0, 1], () => TagList]];
var TagResourceOutput = [3, n0, _TRO, 0, [], []];
var Target = [
    3,
    n0,
    _Ta,
    0,
    [_A, _RAo, _DLC, _RP, _I, _EP, _EBP, _KP, _SMPPa, _SP],
    [
        0,
        0,
        () => DeadLetterConfig,
        () => RetryPolicy,
        0,
        () => EcsParameters,
        () => EventBridgeParameters,
        () => KinesisParameters,
        () => SageMakerPipelineParameters,
        () => SqsParameters,
    ],
];
var TargetSummary = [3, n0, _TS, 0, [_A], [0]];
var ThrottlingException = [
    -3,
    n0,
    _TE,
    {
        [_e]: _c,
        [_hE]: 429,
    },
    [_M],
    [0],
];
schema.TypeRegistry.for(n0).registerError(ThrottlingException, ThrottlingException$1);
var UntagResourceInput = [
    3,
    n0,
    _URI,
    0,
    [_RA, _TK],
    [
        [0, 1],
        [
            64 | 0,
            {
                [_hQ]: _TK,
            },
        ],
    ],
];
var UntagResourceOutput = [3, n0, _URO, 0, [], []];
var UpdateScheduleInput = [
    3,
    n0,
    _USI,
    0,
    [_N, _GN, _SE, _SD, _ED, _D, _SET, _St, _KKA, _Ta, _FTW, _CT, _AAC],
    [[0, 1], 0, 0, 4, 4, 0, 0, 0, 0, () => Target, () => FlexibleTimeWindow, [0, 4], 0],
];
var UpdateScheduleOutput = [3, n0, _USO, 0, [_SA], [0]];
var ValidationException = [
    -3,
    n0,
    _VE,
    {
        [_e]: _c,
        [_hE]: 400,
    },
    [_M],
    [0],
];
schema.TypeRegistry.for(n0).registerError(ValidationException, ValidationException$1);
var SchedulerServiceException = [-3, _sm, "SchedulerServiceException", 0, [], []];
schema.TypeRegistry.for(_sm).registerError(SchedulerServiceException, SchedulerServiceException$1);
var CapacityProviderStrategy = [1, n0, _CPS, 0, () => CapacityProviderStrategyItem];
var PlacementConstraints = [1, n0, _PC, 0, () => PlacementConstraint];
var PlacementStrategies = [1, n0, _PSl, 0, () => PlacementStrategy];
var SageMakerPipelineParameterList = [1, n0, _SMPPL, 0, () => SageMakerPipelineParameter];
var ScheduleGroupList = [1, n0, _SGL, 0, () => ScheduleGroupSummary];
var ScheduleList = [1, n0, _SL, 0, () => ScheduleSummary];
var TagList = [1, n0, _TL, 0, () => Tag];
var CreateSchedule = [
    9,
    n0,
    _CS,
    {
        [_h]: ["POST", "/schedules/{Name}", 200],
    },
    () => CreateScheduleInput,
    () => CreateScheduleOutput,
];
var CreateScheduleGroup = [
    9,
    n0,
    _CSG,
    {
        [_h]: ["POST", "/schedule-groups/{Name}", 200],
    },
    () => CreateScheduleGroupInput,
    () => CreateScheduleGroupOutput,
];
var DeleteSchedule = [
    9,
    n0,
    _DS,
    {
        [_h]: ["DELETE", "/schedules/{Name}", 200],
    },
    () => DeleteScheduleInput,
    () => DeleteScheduleOutput,
];
var DeleteScheduleGroup = [
    9,
    n0,
    _DSG,
    {
        [_h]: ["DELETE", "/schedule-groups/{Name}", 200],
    },
    () => DeleteScheduleGroupInput,
    () => DeleteScheduleGroupOutput,
];
var GetSchedule = [
    9,
    n0,
    _GS,
    {
        [_h]: ["GET", "/schedules/{Name}", 200],
    },
    () => GetScheduleInput,
    () => GetScheduleOutput,
];
var GetScheduleGroup = [
    9,
    n0,
    _GSG,
    {
        [_h]: ["GET", "/schedule-groups/{Name}", 200],
    },
    () => GetScheduleGroupInput,
    () => GetScheduleGroupOutput,
];
var ListScheduleGroups = [
    9,
    n0,
    _LSG,
    {
        [_h]: ["GET", "/schedule-groups", 200],
    },
    () => ListScheduleGroupsInput,
    () => ListScheduleGroupsOutput,
];
var ListSchedules = [
    9,
    n0,
    _LS,
    {
        [_h]: ["GET", "/schedules", 200],
    },
    () => ListSchedulesInput,
    () => ListSchedulesOutput,
];
var ListTagsForResource = [
    9,
    n0,
    _LTFR,
    {
        [_h]: ["GET", "/tags/{ResourceArn}", 200],
    },
    () => ListTagsForResourceInput,
    () => ListTagsForResourceOutput,
];
var TagResource = [
    9,
    n0,
    _TR,
    {
        [_h]: ["POST", "/tags/{ResourceArn}", 200],
    },
    () => TagResourceInput,
    () => TagResourceOutput,
];
var UntagResource = [
    9,
    n0,
    _UR,
    {
        [_h]: ["DELETE", "/tags/{ResourceArn}", 200],
    },
    () => UntagResourceInput,
    () => UntagResourceOutput,
];
var UpdateSchedule = [
    9,
    n0,
    _US,
    {
        [_h]: ["PUT", "/schedules/{Name}", 200],
    },
    () => UpdateScheduleInput,
    () => UpdateScheduleOutput,
];

class CreateScheduleCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "CreateSchedule", {})
    .n("SchedulerClient", "CreateScheduleCommand")
    .sc(CreateSchedule)
    .build() {
}

class CreateScheduleGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "CreateScheduleGroup", {})
    .n("SchedulerClient", "CreateScheduleGroupCommand")
    .sc(CreateScheduleGroup)
    .build() {
}

class DeleteScheduleCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "DeleteSchedule", {})
    .n("SchedulerClient", "DeleteScheduleCommand")
    .sc(DeleteSchedule)
    .build() {
}

class DeleteScheduleGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "DeleteScheduleGroup", {})
    .n("SchedulerClient", "DeleteScheduleGroupCommand")
    .sc(DeleteScheduleGroup)
    .build() {
}

class GetScheduleCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "GetSchedule", {})
    .n("SchedulerClient", "GetScheduleCommand")
    .sc(GetSchedule)
    .build() {
}

class GetScheduleGroupCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "GetScheduleGroup", {})
    .n("SchedulerClient", "GetScheduleGroupCommand")
    .sc(GetScheduleGroup)
    .build() {
}

class ListScheduleGroupsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "ListScheduleGroups", {})
    .n("SchedulerClient", "ListScheduleGroupsCommand")
    .sc(ListScheduleGroups)
    .build() {
}

class ListSchedulesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "ListSchedules", {})
    .n("SchedulerClient", "ListSchedulesCommand")
    .sc(ListSchedules)
    .build() {
}

class ListTagsForResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "ListTagsForResource", {})
    .n("SchedulerClient", "ListTagsForResourceCommand")
    .sc(ListTagsForResource)
    .build() {
}

class TagResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "TagResource", {})
    .n("SchedulerClient", "TagResourceCommand")
    .sc(TagResource)
    .build() {
}

class UntagResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "UntagResource", {})
    .n("SchedulerClient", "UntagResourceCommand")
    .sc(UntagResource)
    .build() {
}

class UpdateScheduleCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AWSChronosService", "UpdateSchedule", {})
    .n("SchedulerClient", "UpdateScheduleCommand")
    .sc(UpdateSchedule)
    .build() {
}

const commands = {
    CreateScheduleCommand,
    CreateScheduleGroupCommand,
    DeleteScheduleCommand,
    DeleteScheduleGroupCommand,
    GetScheduleCommand,
    GetScheduleGroupCommand,
    ListScheduleGroupsCommand,
    ListSchedulesCommand,
    ListTagsForResourceCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateScheduleCommand,
};
class Scheduler extends SchedulerClient {
}
smithyClient.createAggregatedClient(commands, Scheduler);

const paginateListScheduleGroups = core.createPaginator(SchedulerClient, ListScheduleGroupsCommand, "NextToken", "NextToken", "MaxResults");

const paginateListSchedules = core.createPaginator(SchedulerClient, ListSchedulesCommand, "NextToken", "NextToken", "MaxResults");

const ActionAfterCompletion = {
    DELETE: "DELETE",
    NONE: "NONE",
};
const AssignPublicIp = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
};
const FlexibleTimeWindowMode = {
    FLEXIBLE: "FLEXIBLE",
    OFF: "OFF",
};
const ScheduleState = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
};
const LaunchType = {
    EC2: "EC2",
    EXTERNAL: "EXTERNAL",
    FARGATE: "FARGATE",
};
const PlacementConstraintType = {
    DISTINCT_INSTANCE: "distinctInstance",
    MEMBER_OF: "memberOf",
};
const PlacementStrategyType = {
    BINPACK: "binpack",
    RANDOM: "random",
    SPREAD: "spread",
};
const PropagateTags = {
    TASK_DEFINITION: "TASK_DEFINITION",
};
const ScheduleGroupState = {
    ACTIVE: "ACTIVE",
    DELETING: "DELETING",
};

Object.defineProperty(exports, "$Command", {
    enumerable: true,
    get: function () { return smithyClient.Command; }
});
Object.defineProperty(exports, "__Client", {
    enumerable: true,
    get: function () { return smithyClient.Client; }
});
exports.ActionAfterCompletion = ActionAfterCompletion;
exports.AssignPublicIp = AssignPublicIp;
exports.ConflictException = ConflictException$1;
exports.CreateScheduleCommand = CreateScheduleCommand;
exports.CreateScheduleGroupCommand = CreateScheduleGroupCommand;
exports.DeleteScheduleCommand = DeleteScheduleCommand;
exports.DeleteScheduleGroupCommand = DeleteScheduleGroupCommand;
exports.FlexibleTimeWindowMode = FlexibleTimeWindowMode;
exports.GetScheduleCommand = GetScheduleCommand;
exports.GetScheduleGroupCommand = GetScheduleGroupCommand;
exports.InternalServerException = InternalServerException$1;
exports.LaunchType = LaunchType;
exports.ListScheduleGroupsCommand = ListScheduleGroupsCommand;
exports.ListSchedulesCommand = ListSchedulesCommand;
exports.ListTagsForResourceCommand = ListTagsForResourceCommand;
exports.PlacementConstraintType = PlacementConstraintType;
exports.PlacementStrategyType = PlacementStrategyType;
exports.PropagateTags = PropagateTags;
exports.ResourceNotFoundException = ResourceNotFoundException$1;
exports.ScheduleGroupState = ScheduleGroupState;
exports.ScheduleState = ScheduleState;
exports.Scheduler = Scheduler;
exports.SchedulerClient = SchedulerClient;
exports.SchedulerServiceException = SchedulerServiceException$1;
exports.ServiceQuotaExceededException = ServiceQuotaExceededException$1;
exports.TagResourceCommand = TagResourceCommand;
exports.ThrottlingException = ThrottlingException$1;
exports.UntagResourceCommand = UntagResourceCommand;
exports.UpdateScheduleCommand = UpdateScheduleCommand;
exports.ValidationException = ValidationException$1;
exports.paginateListScheduleGroups = paginateListScheduleGroups;
exports.paginateListSchedules = paginateListSchedules;
