import { createAggregatedClient } from "@smithy/smithy-client";
import { CreateScheduleCommand, } from "./commands/CreateScheduleCommand";
import { CreateScheduleGroupCommand, } from "./commands/CreateScheduleGroupCommand";
import { DeleteScheduleCommand, } from "./commands/DeleteScheduleCommand";
import { DeleteScheduleGroupCommand, } from "./commands/DeleteScheduleGroupCommand";
import { GetScheduleCommand } from "./commands/GetScheduleCommand";
import { GetScheduleGroupCommand, } from "./commands/GetScheduleGroupCommand";
import { ListScheduleGroupsCommand, } from "./commands/ListScheduleGroupsCommand";
import { ListSchedulesCommand, } from "./commands/ListSchedulesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateScheduleCommand, } from "./commands/UpdateScheduleCommand";
import { SchedulerClient } from "./SchedulerClient";
const commands = {
    CreateScheduleCommand,
    CreateScheduleGroupCommand,
    DeleteScheduleCommand,
    DeleteScheduleGroupCommand,
    GetScheduleCommand,
    GetScheduleGroupCommand,
    ListScheduleGroupsCommand,
    ListSchedulesCommand,
    ListTagsForResourceCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateScheduleCommand,
};
export class Scheduler extends SchedulerClient {
}
createAggregatedClient(commands, Scheduler);
