import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { DeleteScheduleGroupInput, DeleteScheduleGroupOutput } from "../models/models_0";
import { SchedulerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../SchedulerClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteScheduleGroupCommand}.
 */
export interface DeleteScheduleGroupCommandInput extends DeleteScheduleGroupInput {
}
/**
 * @public
 *
 * The output of {@link DeleteScheduleGroupCommand}.
 */
export interface DeleteScheduleGroupCommandOutput extends DeleteScheduleGroupOutput, __MetadataBearer {
}
declare const DeleteScheduleGroupCommand_base: {
    new (input: DeleteScheduleGroupCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteScheduleGroupCommandInput, DeleteScheduleGroupCommandOutput, SchedulerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteScheduleGroupCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteScheduleGroupCommandInput, DeleteScheduleGroupCommandOutput, SchedulerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all schedules associated with the group.
 *          When you delete a group, it remains in a <code>DELETING</code> state until all of its associated schedules are deleted.
 *          Schedules associated with the group that are set to run while the schedule group is in the process of being deleted might continue to invoke their targets
 *          until the schedule group and its associated schedules are deleted.</p>
 *          <note>
 *             <p>
 *             This operation is eventually consistent.
 *          </p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SchedulerClient, DeleteScheduleGroupCommand } from "@aws-sdk/client-scheduler"; // ES Modules import
 * // const { SchedulerClient, DeleteScheduleGroupCommand } = require("@aws-sdk/client-scheduler"); // CommonJS import
 * // import type { SchedulerClientConfig } from "@aws-sdk/client-scheduler";
 * const config = {}; // type is SchedulerClientConfig
 * const client = new SchedulerClient(config);
 * const input = { // DeleteScheduleGroupInput
 *   Name: "STRING_VALUE", // required
 *   ClientToken: "STRING_VALUE",
 * };
 * const command = new DeleteScheduleGroupCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteScheduleGroupCommandInput - {@link DeleteScheduleGroupCommandInput}
 * @returns {@link DeleteScheduleGroupCommandOutput}
 * @see {@link DeleteScheduleGroupCommandInput} for command's `input` shape.
 * @see {@link DeleteScheduleGroupCommandOutput} for command's `response` shape.
 * @see {@link SchedulerClientResolvedConfig | config} for SchedulerClient's `config` shape.
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>Updating or deleting the resource can cause an inconsistent state.</p>
 *
 * @throws {@link InternalServerException} (server fault)
 *  <p>Unexpected error encountered while processing the request.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The request references a resource which does not exist.</p>
 *
 * @throws {@link ThrottlingException} (client fault)
 *  <p>The request was denied due to request throttling.</p>
 *
 * @throws {@link ValidationException} (client fault)
 *  <p>The input fails to satisfy the constraints specified by an AWS service.</p>
 *
 * @throws {@link SchedulerServiceException}
 * <p>Base exception class for all service exceptions from Scheduler service.</p>
 *
 *
 * @public
 */
export declare class DeleteScheduleGroupCommand extends DeleteScheduleGroupCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteScheduleGroupInput;
            output: {};
        };
        sdk: {
            input: DeleteScheduleGroupCommandInput;
            output: DeleteScheduleGroupCommandOutput;
        };
    };
}
