import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import {
  CreateScheduleCommandInput,
  CreateScheduleCommandOutput,
} from "./commands/CreateScheduleCommand";
import {
  CreateScheduleGroupCommandInput,
  CreateScheduleGroupCommandOutput,
} from "./commands/CreateScheduleGroupCommand";
import {
  DeleteScheduleCommandInput,
  DeleteScheduleCommandOutput,
} from "./commands/DeleteScheduleCommand";
import {
  DeleteScheduleGroupCommandInput,
  DeleteScheduleGroupCommandOutput,
} from "./commands/DeleteScheduleGroupCommand";
import {
  GetScheduleCommandInput,
  GetScheduleCommandOutput,
} from "./commands/GetScheduleCommand";
import {
  GetScheduleGroupCommandInput,
  GetScheduleGroupCommandOutput,
} from "./commands/GetScheduleGroupCommand";
import {
  ListScheduleGroupsCommandInput,
  ListScheduleGroupsCommandOutput,
} from "./commands/ListScheduleGroupsCommand";
import {
  ListSchedulesCommandInput,
  ListSchedulesCommandOutput,
} from "./commands/ListSchedulesCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateScheduleCommandInput,
  UpdateScheduleCommandOutput,
} from "./commands/UpdateScheduleCommand";
import { SchedulerClient } from "./SchedulerClient";
export interface Scheduler {
  createSchedule(
    args: CreateScheduleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateScheduleCommandOutput>;
  createSchedule(
    args: CreateScheduleCommandInput,
    cb: (err: any, data?: CreateScheduleCommandOutput) => void
  ): void;
  createSchedule(
    args: CreateScheduleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateScheduleCommandOutput) => void
  ): void;
  createScheduleGroup(
    args: CreateScheduleGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateScheduleGroupCommandOutput>;
  createScheduleGroup(
    args: CreateScheduleGroupCommandInput,
    cb: (err: any, data?: CreateScheduleGroupCommandOutput) => void
  ): void;
  createScheduleGroup(
    args: CreateScheduleGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateScheduleGroupCommandOutput) => void
  ): void;
  deleteSchedule(
    args: DeleteScheduleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteScheduleCommandOutput>;
  deleteSchedule(
    args: DeleteScheduleCommandInput,
    cb: (err: any, data?: DeleteScheduleCommandOutput) => void
  ): void;
  deleteSchedule(
    args: DeleteScheduleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteScheduleCommandOutput) => void
  ): void;
  deleteScheduleGroup(
    args: DeleteScheduleGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteScheduleGroupCommandOutput>;
  deleteScheduleGroup(
    args: DeleteScheduleGroupCommandInput,
    cb: (err: any, data?: DeleteScheduleGroupCommandOutput) => void
  ): void;
  deleteScheduleGroup(
    args: DeleteScheduleGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteScheduleGroupCommandOutput) => void
  ): void;
  getSchedule(
    args: GetScheduleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetScheduleCommandOutput>;
  getSchedule(
    args: GetScheduleCommandInput,
    cb: (err: any, data?: GetScheduleCommandOutput) => void
  ): void;
  getSchedule(
    args: GetScheduleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetScheduleCommandOutput) => void
  ): void;
  getScheduleGroup(
    args: GetScheduleGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetScheduleGroupCommandOutput>;
  getScheduleGroup(
    args: GetScheduleGroupCommandInput,
    cb: (err: any, data?: GetScheduleGroupCommandOutput) => void
  ): void;
  getScheduleGroup(
    args: GetScheduleGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetScheduleGroupCommandOutput) => void
  ): void;
  listScheduleGroups(): Promise<ListScheduleGroupsCommandOutput>;
  listScheduleGroups(
    args: ListScheduleGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListScheduleGroupsCommandOutput>;
  listScheduleGroups(
    args: ListScheduleGroupsCommandInput,
    cb: (err: any, data?: ListScheduleGroupsCommandOutput) => void
  ): void;
  listScheduleGroups(
    args: ListScheduleGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListScheduleGroupsCommandOutput) => void
  ): void;
  listSchedules(): Promise<ListSchedulesCommandOutput>;
  listSchedules(
    args: ListSchedulesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListSchedulesCommandOutput>;
  listSchedules(
    args: ListSchedulesCommandInput,
    cb: (err: any, data?: ListSchedulesCommandOutput) => void
  ): void;
  listSchedules(
    args: ListSchedulesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListSchedulesCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TagResourceCommandOutput>;
  tagResource(
    args: TagResourceCommandInput,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UntagResourceCommandOutput>;
  untagResource(
    args: UntagResourceCommandInput,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  updateSchedule(
    args: UpdateScheduleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateScheduleCommandOutput>;
  updateSchedule(
    args: UpdateScheduleCommandInput,
    cb: (err: any, data?: UpdateScheduleCommandOutput) => void
  ): void;
  updateSchedule(
    args: UpdateScheduleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateScheduleCommandOutput) => void
  ): void;
}
export declare class Scheduler extends SchedulerClient implements Scheduler {}
