import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { SchedulerClientResolvedConfig } from "../SchedulerClient";
export interface SchedulerHttpAuthSchemeParameters
  extends HttpAuthSchemeParameters {
  region?: string;
}
export interface SchedulerHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    SchedulerClientResolvedConfig,
    HandlerExecutionContext,
    SchedulerHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultSchedulerHttpAuthSchemeParametersProvider: (
  config: SchedulerClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<SchedulerHttpAuthSchemeParameters>;
export interface SchedulerHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<SchedulerHttpAuthSchemeParameters> {}
export declare const defaultSchedulerHttpAuthSchemeProvider: SchedulerHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: SchedulerHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: SchedulerHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
