import {
  ActionAfterCompletion,
  AssignPublicIp,
  FlexibleTimeWindowMode,
  LaunchType,
  PlacementConstraintType,
  PlacementStrategyType,
  PropagateTags,
  ScheduleGroupState,
  ScheduleState,
} from "./enums";
export interface ListTagsForResourceInput {
  ResourceArn: string | undefined;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface ListTagsForResourceOutput {
  Tags?: Tag[] | undefined;
}
export interface FlexibleTimeWindow {
  Mode: FlexibleTimeWindowMode | undefined;
  MaximumWindowInMinutes?: number | undefined;
}
export interface DeadLetterConfig {
  Arn?: string | undefined;
}
export interface CapacityProviderStrategyItem {
  capacityProvider: string | undefined;
  weight?: number | undefined;
  base?: number | undefined;
}
export interface AwsVpcConfiguration {
  Subnets: string[] | undefined;
  SecurityGroups?: string[] | undefined;
  AssignPublicIp?: AssignPublicIp | undefined;
}
export interface NetworkConfiguration {
  awsvpcConfiguration?: AwsVpcConfiguration | undefined;
}
export interface PlacementConstraint {
  type?: PlacementConstraintType | undefined;
  expression?: string | undefined;
}
export interface PlacementStrategy {
  type?: PlacementStrategyType | undefined;
  field?: string | undefined;
}
export interface EcsParameters {
  TaskDefinitionArn: string | undefined;
  TaskCount?: number | undefined;
  LaunchType?: LaunchType | undefined;
  NetworkConfiguration?: NetworkConfiguration | undefined;
  PlatformVersion?: string | undefined;
  Group?: string | undefined;
  CapacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  EnableECSManagedTags?: boolean | undefined;
  EnableExecuteCommand?: boolean | undefined;
  PlacementConstraints?: PlacementConstraint[] | undefined;
  PlacementStrategy?: PlacementStrategy[] | undefined;
  PropagateTags?: PropagateTags | undefined;
  ReferenceId?: string | undefined;
  Tags?: Record<string, string>[] | undefined;
}
export interface EventBridgeParameters {
  DetailType: string | undefined;
  Source: string | undefined;
}
export interface KinesisParameters {
  PartitionKey: string | undefined;
}
export interface RetryPolicy {
  MaximumEventAgeInSeconds?: number | undefined;
  MaximumRetryAttempts?: number | undefined;
}
export interface SageMakerPipelineParameter {
  Name: string | undefined;
  Value: string | undefined;
}
export interface SageMakerPipelineParameters {
  PipelineParameterList?: SageMakerPipelineParameter[] | undefined;
}
export interface SqsParameters {
  MessageGroupId?: string | undefined;
}
export interface Target {
  Arn: string | undefined;
  RoleArn: string | undefined;
  DeadLetterConfig?: DeadLetterConfig | undefined;
  RetryPolicy?: RetryPolicy | undefined;
  Input?: string | undefined;
  EcsParameters?: EcsParameters | undefined;
  EventBridgeParameters?: EventBridgeParameters | undefined;
  KinesisParameters?: KinesisParameters | undefined;
  SageMakerPipelineParameters?: SageMakerPipelineParameters | undefined;
  SqsParameters?: SqsParameters | undefined;
}
export interface CreateScheduleInput {
  Name: string | undefined;
  GroupName?: string | undefined;
  ScheduleExpression: string | undefined;
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  Description?: string | undefined;
  ScheduleExpressionTimezone?: string | undefined;
  State?: ScheduleState | undefined;
  KmsKeyArn?: string | undefined;
  Target: Target | undefined;
  FlexibleTimeWindow: FlexibleTimeWindow | undefined;
  ClientToken?: string | undefined;
  ActionAfterCompletion?: ActionAfterCompletion | undefined;
}
export interface CreateScheduleOutput {
  ScheduleArn: string | undefined;
}
export interface DeleteScheduleInput {
  Name: string | undefined;
  GroupName?: string | undefined;
  ClientToken?: string | undefined;
}
export interface DeleteScheduleOutput {}
export interface GetScheduleInput {
  Name: string | undefined;
  GroupName?: string | undefined;
}
export interface GetScheduleOutput {
  Arn?: string | undefined;
  GroupName?: string | undefined;
  Name?: string | undefined;
  ScheduleExpression?: string | undefined;
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  Description?: string | undefined;
  ScheduleExpressionTimezone?: string | undefined;
  State?: ScheduleState | undefined;
  CreationDate?: Date | undefined;
  LastModificationDate?: Date | undefined;
  KmsKeyArn?: string | undefined;
  Target?: Target | undefined;
  FlexibleTimeWindow?: FlexibleTimeWindow | undefined;
  ActionAfterCompletion?: ActionAfterCompletion | undefined;
}
export interface ListSchedulesInput {
  GroupName?: string | undefined;
  NamePrefix?: string | undefined;
  State?: ScheduleState | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface TargetSummary {
  Arn: string | undefined;
}
export interface ScheduleSummary {
  Arn?: string | undefined;
  Name?: string | undefined;
  GroupName?: string | undefined;
  State?: ScheduleState | undefined;
  CreationDate?: Date | undefined;
  LastModificationDate?: Date | undefined;
  Target?: TargetSummary | undefined;
}
export interface ListSchedulesOutput {
  NextToken?: string | undefined;
  Schedules: ScheduleSummary[] | undefined;
}
export interface UpdateScheduleInput {
  Name: string | undefined;
  GroupName?: string | undefined;
  ScheduleExpression: string | undefined;
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  Description?: string | undefined;
  ScheduleExpressionTimezone?: string | undefined;
  State?: ScheduleState | undefined;
  KmsKeyArn?: string | undefined;
  Target: Target | undefined;
  FlexibleTimeWindow: FlexibleTimeWindow | undefined;
  ClientToken?: string | undefined;
  ActionAfterCompletion?: ActionAfterCompletion | undefined;
}
export interface UpdateScheduleOutput {
  ScheduleArn: string | undefined;
}
export interface CreateScheduleGroupInput {
  Name: string | undefined;
  Tags?: Tag[] | undefined;
  ClientToken?: string | undefined;
}
export interface CreateScheduleGroupOutput {
  ScheduleGroupArn: string | undefined;
}
export interface DeleteScheduleGroupInput {
  Name: string | undefined;
  ClientToken?: string | undefined;
}
export interface DeleteScheduleGroupOutput {}
export interface GetScheduleGroupInput {
  Name: string | undefined;
}
export interface GetScheduleGroupOutput {
  Arn?: string | undefined;
  Name?: string | undefined;
  State?: ScheduleGroupState | undefined;
  CreationDate?: Date | undefined;
  LastModificationDate?: Date | undefined;
}
export interface ListScheduleGroupsInput {
  NamePrefix?: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ScheduleGroupSummary {
  Arn?: string | undefined;
  Name?: string | undefined;
  State?: ScheduleGroupState | undefined;
  CreationDate?: Date | undefined;
  LastModificationDate?: Date | undefined;
}
export interface ListScheduleGroupsOutput {
  NextToken?: string | undefined;
  ScheduleGroups: ScheduleGroupSummary[] | undefined;
}
export interface TagResourceInput {
  ResourceArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceOutput {}
export interface UntagResourceInput {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceOutput {}
