import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateSMSSandboxPhoneNumberInputFilterSensitiveLog, } from "../models/models_0";
import { de_CreateSMSSandboxPhoneNumberCommand, se_CreateSMSSandboxPhoneNumberCommand } from "../protocols/Aws_query";
export { $Command };
export class CreateSMSSandboxPhoneNumberCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "CreateSMSSandboxPhoneNumber", {})
    .n("SNSClient", "CreateSMSSandboxPhoneNumberCommand")
    .f(CreateSMSSandboxPhoneNumberInputFilterSensitiveLog, void 0)
    .ser(se_CreateSMSSandboxPhoneNumberCommand)
    .de(de_CreateSMSSandboxPhoneNumberCommand)
    .build() {
}
