import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog, } from "../models/models_0";
import { de_DeleteSMSSandboxPhoneNumberCommand, se_DeleteSMSSandboxPhoneNumberCommand } from "../protocols/Aws_query";
export { $Command };
export class DeleteSMSSandboxPhoneNumberCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "DeleteSMSSandboxPhoneNumber", {})
    .n("SNSClient", "DeleteSMSSandboxPhoneNumberCommand")
    .f(DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog, void 0)
    .ser(se_DeleteSMSSandboxPhoneNumberCommand)
    .de(de_DeleteSMSSandboxPhoneNumberCommand)
    .build() {
}
