import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetEndpointAttributesCommand, se_GetEndpointAttributesCommand } from "../protocols/Aws_query";
export { $Command };
export class GetEndpointAttributesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "GetEndpointAttributes", {})
    .n("SNSClient", "GetEndpointAttributesCommand")
    .f(void 0, void 0)
    .ser(se_GetEndpointAttributesCommand)
    .de(de_GetEndpointAttributesCommand)
    .build() {
}
