import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListOriginationNumbersResultFilterSensitiveLog, } from "../models/models_0";
import { de_ListOriginationNumbersCommand, se_ListOriginationNumbersCommand } from "../protocols/Aws_query";
export { $Command };
export class ListOriginationNumbersCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "ListOriginationNumbers", {})
    .n("SNSClient", "ListOriginationNumbersCommand")
    .f(void 0, ListOriginationNumbersResultFilterSensitiveLog)
    .ser(se_ListOriginationNumbersCommand)
    .de(de_ListOriginationNumbersCommand)
    .build() {
}
