import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListPhoneNumbersOptedOutResponseFilterSensitiveLog, } from "../models/models_0";
import { de_ListPhoneNumbersOptedOutCommand, se_ListPhoneNumbersOptedOutCommand } from "../protocols/Aws_query";
export { $Command };
export class ListPhoneNumbersOptedOutCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "ListPhoneNumbersOptedOut", {})
    .n("SNSClient", "ListPhoneNumbersOptedOutCommand")
    .f(void 0, ListPhoneNumbersOptedOutResponseFilterSensitiveLog)
    .ser(se_ListPhoneNumbersOptedOutCommand)
    .de(de_ListPhoneNumbersOptedOutCommand)
    .build() {
}
