import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_SetSubscriptionAttributesCommand, se_SetSubscriptionAttributesCommand } from "../protocols/Aws_query";
export { $Command };
export class SetSubscriptionAttributesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "SetSubscriptionAttributes", {})
    .n("SNSClient", "SetSubscriptionAttributesCommand")
    .f(void 0, void 0)
    .ser(se_SetSubscriptionAttributesCommand)
    .de(de_SetSubscriptionAttributesCommand)
    .build() {
}
