import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { VerifySMSSandboxPhoneNumberInputFilterSensitiveLog, } from "../models/models_0";
import { de_VerifySMSSandboxPhoneNumberCommand, se_VerifySMSSandboxPhoneNumberCommand } from "../protocols/Aws_query";
export { $Command };
export class VerifySMSSandboxPhoneNumberCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "VerifySMSSandboxPhoneNumber", {})
    .n("SNSClient", "VerifySMSSandboxPhoneNumberCommand")
    .f(VerifySMSSandboxPhoneNumberInputFilterSensitiveLog, void 0)
    .ser(se_VerifySMSSandboxPhoneNumberCommand)
    .de(de_VerifySMSSandboxPhoneNumberCommand)
    .build() {
}
