import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CreateTopicInput, CreateTopicResponse } from "../models/models_0";
import { ServiceInputTypes, ServiceOutputTypes, SNSClientResolvedConfig } from "../SNSClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateTopicCommand}.
 */
export interface CreateTopicCommandInput extends CreateTopicInput {
}
/**
 * @public
 *
 * The output of {@link CreateTopicCommand}.
 */
export interface CreateTopicCommandOutput extends CreateTopicResponse, __MetadataBearer {
}
declare const CreateTopicCommand_base: {
    new (input: CreateTopicCommandInput): import("@smithy/smithy-client").CommandImpl<CreateTopicCommandInput, CreateTopicCommandOutput, SNSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateTopicCommandInput): import("@smithy/smithy-client").CommandImpl<CreateTopicCommandInput, CreateTopicCommandOutput, SNSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates a topic to which notifications can be published. Users can create at most
 *             100,000 standard topics (at most 1,000 FIFO topics). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html">Creating an Amazon SNS
 *                 topic</a> in the <i>Amazon SNS Developer Guide</i>. This action is
 *             idempotent, so if the requester already owns a topic with the specified name, that
 *             topic's ARN is returned without creating a new topic.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SNSClient, CreateTopicCommand } from "@aws-sdk/client-sns"; // ES Modules import
 * // const { SNSClient, CreateTopicCommand } = require("@aws-sdk/client-sns"); // CommonJS import
 * const client = new SNSClient(config);
 * const input = { // CreateTopicInput
 *   Name: "STRING_VALUE", // required
 *   Attributes: { // TopicAttributesMap
 *     "<keys>": "STRING_VALUE",
 *   },
 *   Tags: [ // TagList
 *     { // Tag
 *       Key: "STRING_VALUE", // required
 *       Value: "STRING_VALUE", // required
 *     },
 *   ],
 *   DataProtectionPolicy: "STRING_VALUE",
 * };
 * const command = new CreateTopicCommand(input);
 * const response = await client.send(command);
 * // { // CreateTopicResponse
 * //   TopicArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param CreateTopicCommandInput - {@link CreateTopicCommandInput}
 * @returns {@link CreateTopicCommandOutput}
 * @see {@link CreateTopicCommandInput} for command's `input` shape.
 * @see {@link CreateTopicCommandOutput} for command's `response` shape.
 * @see {@link SNSClientResolvedConfig | config} for SNSClient's `config` shape.
 *
 * @throws {@link AuthorizationErrorException} (client fault)
 *  <p>Indicates that the user has been denied access to the requested resource.</p>
 *
 * @throws {@link ConcurrentAccessException} (client fault)
 *  <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
 *             sequentially.</p>
 *
 * @throws {@link InternalErrorException} (server fault)
 *  <p>Indicates an internal service error.</p>
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>Indicates that a request parameter does not comply with the associated
 *             constraints.</p>
 *
 * @throws {@link InvalidSecurityException} (client fault)
 *  <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
 *             request using Signature Version 4.</p>
 *
 * @throws {@link StaleTagException} (client fault)
 *  <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
 *             short while and then retry the operation.</p>
 *
 * @throws {@link TagLimitExceededException} (client fault)
 *  <p>Can't add more than 50 tags to a topic.</p>
 *
 * @throws {@link TagPolicyException} (client fault)
 *  <p>The request doesn't comply with the IAM tag policy. Correct your request and then
 *             retry it.</p>
 *
 * @throws {@link TopicLimitExceededException} (client fault)
 *  <p>Indicates that the customer already owns the maximum allowed number of topics.</p>
 *
 * @throws {@link SNSServiceException}
 * <p>Base exception class for all service exceptions from SNS service.</p>
 *
 *
 * @public
 */
export declare class CreateTopicCommand extends CreateTopicCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateTopicInput;
            output: CreateTopicResponse;
        };
        sdk: {
            input: CreateTopicCommandInput;
            output: CreateTopicCommandOutput;
        };
    };
}
