import { OAuth2Client, JWT, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace compute_alpha {
    export interface Options extends GlobalOptions {
        version: 'alpha';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
        /**
         * Legacy name for parameter that has been superseded by `quotaUser`.
         */
        userIp?: string;
    }
    /**
     * Compute Engine API
     *
     * Creates and runs virtual machines on Google Cloud Platform.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const compute = google.compute('alpha');
     * ```
     */
    export class Compute {
        context: APIRequestContext;
        acceleratorTypes: Resource$Acceleratortypes;
        addresses: Resource$Addresses;
        advice: Resource$Advice;
        autoscalers: Resource$Autoscalers;
        backendBuckets: Resource$Backendbuckets;
        backendServices: Resource$Backendservices;
        crossSiteNetworks: Resource$Crosssitenetworks;
        disks: Resource$Disks;
        diskSettings: Resource$Disksettings;
        diskTypes: Resource$Disktypes;
        externalVpnGateways: Resource$Externalvpngateways;
        firewallPolicies: Resource$Firewallpolicies;
        firewalls: Resource$Firewalls;
        forwardingRules: Resource$Forwardingrules;
        futureReservations: Resource$Futurereservations;
        globalAddresses: Resource$Globaladdresses;
        globalForwardingRules: Resource$Globalforwardingrules;
        globalNetworkEndpointGroups: Resource$Globalnetworkendpointgroups;
        globalOperations: Resource$Globaloperations;
        globalOrganizationOperations: Resource$Globalorganizationoperations;
        globalPublicDelegatedPrefixes: Resource$Globalpublicdelegatedprefixes;
        healthChecks: Resource$Healthchecks;
        httpHealthChecks: Resource$Httphealthchecks;
        httpsHealthChecks: Resource$Httpshealthchecks;
        imageFamilyViews: Resource$Imagefamilyviews;
        images: Resource$Images;
        instanceGroupManagerResizeRequests: Resource$Instancegroupmanagerresizerequests;
        instanceGroupManagers: Resource$Instancegroupmanagers;
        instanceGroups: Resource$Instancegroups;
        instances: Resource$Instances;
        instanceSettings: Resource$Instancesettings;
        instanceTemplates: Resource$Instancetemplates;
        instantSnapshotGroups: Resource$Instantsnapshotgroups;
        instantSnapshots: Resource$Instantsnapshots;
        interconnectAttachmentGroups: Resource$Interconnectattachmentgroups;
        interconnectAttachments: Resource$Interconnectattachments;
        interconnectGroups: Resource$Interconnectgroups;
        interconnectLocations: Resource$Interconnectlocations;
        interconnectRemoteLocations: Resource$Interconnectremotelocations;
        interconnects: Resource$Interconnects;
        licenseCodes: Resource$Licensecodes;
        licenses: Resource$Licenses;
        machineImages: Resource$Machineimages;
        machineTypes: Resource$Machinetypes;
        networkAttachments: Resource$Networkattachments;
        networkEdgeSecurityServices: Resource$Networkedgesecurityservices;
        networkEndpointGroups: Resource$Networkendpointgroups;
        networkFirewallPolicies: Resource$Networkfirewallpolicies;
        networkProfiles: Resource$Networkprofiles;
        networks: Resource$Networks;
        nodeGroups: Resource$Nodegroups;
        nodeTemplates: Resource$Nodetemplates;
        nodeTypes: Resource$Nodetypes;
        organizationSecurityPolicies: Resource$Organizationsecuritypolicies;
        packetMirrorings: Resource$Packetmirrorings;
        previewFeatures: Resource$Previewfeatures;
        projects: Resource$Projects;
        publicAdvertisedPrefixes: Resource$Publicadvertisedprefixes;
        publicDelegatedPrefixes: Resource$Publicdelegatedprefixes;
        recoverableSnapshots: Resource$Recoverablesnapshots;
        regionAutoscalers: Resource$Regionautoscalers;
        regionBackendBuckets: Resource$Regionbackendbuckets;
        regionBackendServices: Resource$Regionbackendservices;
        regionCommitments: Resource$Regioncommitments;
        regionCompositeHealthChecks: Resource$Regioncompositehealthchecks;
        regionDisks: Resource$Regiondisks;
        regionDiskSettings: Resource$Regiondisksettings;
        regionDiskTypes: Resource$Regiondisktypes;
        regionHealthAggregationPolicies: Resource$Regionhealthaggregationpolicies;
        regionHealthChecks: Resource$Regionhealthchecks;
        regionHealthCheckServices: Resource$Regionhealthcheckservices;
        regionHealthSources: Resource$Regionhealthsources;
        regionInstanceGroupManagerResizeRequests: Resource$Regioninstancegroupmanagerresizerequests;
        regionInstanceGroupManagers: Resource$Regioninstancegroupmanagers;
        regionInstanceGroups: Resource$Regioninstancegroups;
        regionInstances: Resource$Regioninstances;
        regionInstanceTemplates: Resource$Regioninstancetemplates;
        regionInstantSnapshotGroups: Resource$Regioninstantsnapshotgroups;
        regionInstantSnapshots: Resource$Regioninstantsnapshots;
        regionMultiMigMembers: Resource$Regionmultimigmembers;
        regionMultiMigs: Resource$Regionmultimigs;
        regionNetworkEndpointGroups: Resource$Regionnetworkendpointgroups;
        regionNetworkFirewallPolicies: Resource$Regionnetworkfirewallpolicies;
        regionNotificationEndpoints: Resource$Regionnotificationendpoints;
        regionOperations: Resource$Regionoperations;
        regions: Resource$Regions;
        regionSecurityPolicies: Resource$Regionsecuritypolicies;
        regionSnapshots: Resource$Regionsnapshots;
        regionSnapshotSettings: Resource$Regionsnapshotsettings;
        regionSslCertificates: Resource$Regionsslcertificates;
        regionSslPolicies: Resource$Regionsslpolicies;
        regionTargetHttpProxies: Resource$Regiontargethttpproxies;
        regionTargetHttpsProxies: Resource$Regiontargethttpsproxies;
        regionTargetTcpProxies: Resource$Regiontargettcpproxies;
        regionUrlMaps: Resource$Regionurlmaps;
        regionZones: Resource$Regionzones;
        reliabilityRisks: Resource$Reliabilityrisks;
        reservationBlocks: Resource$Reservationblocks;
        reservations: Resource$Reservations;
        reservationSubBlocks: Resource$Reservationsubblocks;
        resourcePolicies: Resource$Resourcepolicies;
        routers: Resource$Routers;
        routes: Resource$Routes;
        securityPolicies: Resource$Securitypolicies;
        serviceAttachments: Resource$Serviceattachments;
        snapshotGroups: Resource$Snapshotgroups;
        snapshots: Resource$Snapshots;
        snapshotSettings: Resource$Snapshotsettings;
        sslCertificates: Resource$Sslcertificates;
        sslPolicies: Resource$Sslpolicies;
        storagePools: Resource$Storagepools;
        storagePoolTypes: Resource$Storagepooltypes;
        subnetworks: Resource$Subnetworks;
        targetGrpcProxies: Resource$Targetgrpcproxies;
        targetHttpProxies: Resource$Targethttpproxies;
        targetHttpsProxies: Resource$Targethttpsproxies;
        targetInstances: Resource$Targetinstances;
        targetPools: Resource$Targetpools;
        targetSslProxies: Resource$Targetsslproxies;
        targetTcpProxies: Resource$Targettcpproxies;
        targetVpnGateways: Resource$Targetvpngateways;
        urlMaps: Resource$Urlmaps;
        vpnGateways: Resource$Vpngateways;
        vpnTunnels: Resource$Vpntunnels;
        wireGroups: Resource$Wiregroups;
        zoneOperations: Resource$Zoneoperations;
        zoneQueuedResources: Resource$Zonequeuedresources;
        zones: Resource$Zones;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * A specification of the type and number of accelerator cards attached to the instance.
     */
    export interface Schema$AcceleratorConfig {
        /**
         * The number of the guest accelerator cards exposed to this instance.
         */
        acceleratorCount?: number | null;
        /**
         * Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
         */
        acceleratorType?: string | null;
    }
    /**
     * Represents an Accelerator Type resource. Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine.
     */
    export interface Schema$AcceleratorType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this accelerator type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
         */
        kind?: string | null;
        /**
         * [Output Only] Maximum number of accelerator cards allowed per instance.
         */
        maximumCardsPerInstance?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined, fully qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$AcceleratorTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AcceleratorTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$AcceleratorTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of accelerator types.
     */
    export interface Schema$AcceleratorTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AcceleratorType resources.
         */
        items?: Schema$AcceleratorType[];
        /**
         * [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AcceleratorTypesScopedList {
        /**
         * [Output Only] A list of accelerator types contained in this scope.
         */
        acceleratorTypes?: Schema$AcceleratorType[];
        /**
         * [Output Only] An informational warning that appears when the accelerator types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * An access configuration attached to an instance's network interface. Only one access config per instance is supported.
     */
    export interface Schema$AccessConfig {
        /**
         * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
         */
        externalIpv6?: string | null;
        /**
         * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
         */
        externalIpv6PrefixLength?: number | null;
        /**
         * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
         */
        kind?: string | null;
        /**
         * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
         */
        name?: string | null;
        /**
         * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
         */
        natIP?: string | null;
        /**
         * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
         */
        networkTier?: string | null;
        /**
         * [Output Only] The public DNS domain name for the instance.
         */
        publicDnsName?: string | null;
        /**
         * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
         */
        publicPtrDomainName?: string | null;
        /**
         * The resource URL for the security policy associated with this access config.
         */
        securityPolicy?: string | null;
        /**
         * Specifies whether a public DNS 'A' record should be created for the external IP address of this access configuration.
         */
        setPublicDns?: boolean | null;
        /**
         * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
         */
        setPublicPtr?: boolean | null;
        /**
         * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
         */
        type?: string | null;
    }
    /**
     * Represents an IP Address resource. Google Compute Engine has two IP Address resources: * [Global (external and internal)](https://cloud.google.com/compute/docs/reference/rest/alpha/globalAddresses) * [Regional (external and internal)](https://cloud.google.com/compute/docs/reference/rest/alpha/addresses) For more information, see Reserving a static external IP address.
     */
    export interface Schema$Address {
        /**
         * The static IP address represented by this resource.
         */
        address?: string | null;
        /**
         * The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
         */
        addressType?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The endpoint type of this address, which should be VM or NETLB. This is used for deciding which type of endpoint this address can be used after the external IPv6 address reservation.
         */
        ipv6EndpointType?: string | null;
        /**
         * The IP version that will be used by this address. Valid options are IPV4 or IPV6.
         */
        ipVersion?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#address for addresses.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this Address, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Address.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
         */
        network?: string | null;
        /**
         * This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
         */
        networkTier?: string | null;
        /**
         * The prefix length if the resource represents an IP range.
         */
        prefixLength?: number | null;
        /**
         * The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *HA VPN over Cloud Interconnect* configuration. These addresses are regional resources. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
         */
        purpose?: string | null;
        /**
         * [Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. *This field is not applicable to global addresses.*
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
         */
        status?: string | null;
        /**
         * The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The URLs of the resources that are using this address.
         */
        users?: string[] | null;
    }
    export interface Schema$AddressAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AddressesScopedList resources.
         */
        items?: {
            [key: string]: Schema$AddressesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AddressesScopedList {
        /**
         * [Output Only] A list of addresses contained in this scope.
         */
        addresses?: Schema$Address[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of addresses.
     */
    export interface Schema$AddressList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Address resources.
         */
        items?: Schema$Address[];
        /**
         * [Output Only] Type of resource. Always compute#addressList for lists of addresses.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
     */
    export interface Schema$AdvancedMachineFeatures {
        /**
         * Whether to enable nested virtualization or not (default is false).
         */
        enableNestedVirtualization?: boolean | null;
        /**
         * Whether to enable UEFI networking for instance creation.
         */
        enableUefiNetworking?: boolean | null;
        /**
         * Whether to enable the watchdog timer.
         */
        enableWatchdogTimer?: boolean | null;
        /**
         * The number of vNUMA nodes.
         */
        numaNodeCount?: number | null;
        /**
         * Type of Performance Monitoring Unit requested on instance.
         */
        performanceMonitoringUnit?: string | null;
        /**
         * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
         */
        threadsPerCore?: number | null;
        /**
         * Turbo frequency mode to use for the instance. Supported modes include: * ALL_CORE_MAX Using empty string or not setting this field will use the platform-specific default turbo mode.
         */
        turboMode?: string | null;
        /**
         * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
         */
        visibleCoreCount?: number | null;
    }
    /**
     * An alias IP range attached to an instance's network interface.
     */
    export interface Schema$AliasIpRange {
        /**
         * The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
         */
        ipCidrRange?: string | null;
        /**
         * The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
         */
        subnetworkRangeName?: string | null;
    }
    /**
     * This reservation type is specified by total resource amounts (e.g. total count of CPUs) and can account for multiple instance SKUs. In other words, one can create instances of varying shapes against this reservation.
     */
    export interface Schema$AllocationAggregateReservation {
        /**
         * [Output only] List of resources currently in use.
         */
        inUseResources?: Schema$AllocationAggregateReservationReservedResourceInfo[];
        /**
         * List of reserved resources (CPUs, memory, accelerators).
         */
        reservedResources?: Schema$AllocationAggregateReservationReservedResourceInfo[];
        /**
         * The VM family that all instances scheduled against this reservation must belong to.
         */
        vmFamily?: string | null;
        /**
         * The workload type of the instances that will target this reservation.
         */
        workloadType?: string | null;
    }
    export interface Schema$AllocationAggregateReservationReservedResourceInfo {
        /**
         * Properties of accelerator resources in this reservation.
         */
        accelerator?: Schema$AllocationAggregateReservationReservedResourceInfoAccelerator;
    }
    export interface Schema$AllocationAggregateReservationReservedResourceInfoAccelerator {
        /**
         * Number of accelerators of specified type.
         */
        acceleratorCount?: number | null;
        /**
         * Full or partial URL to accelerator type. e.g. "projects/{PROJECT\}/zones/{ZONE\}/acceleratorTypes/ct4l"
         */
        acceleratorType?: string | null;
    }
    export interface Schema$AllocationReservationSharingPolicy {
        /**
         * Sharing config for all Google Cloud services.
         */
        serviceShareType?: string | null;
    }
    /**
     * [Output Only] Contains output only fields.
     */
    export interface Schema$AllocationResourceStatus {
        /**
         * Properties of this aggregatereservation.
         */
        aggregateAllocation?: Schema$AllocationResourceStatusAggregateAllocation;
        /**
         * The number of reservation blocks associated with this reservation.
         */
        reservationBlockCount?: number | null;
        /**
         * Maintenance information for this reservation
         */
        reservationMaintenance?: Schema$GroupMaintenanceInfo;
        /**
         * Allocation Properties of this reservation.
         */
        specificSkuAllocation?: Schema$AllocationResourceStatusSpecificSKUAllocation;
    }
    /**
     * Contains Properties set for the aggregate reservation.
     */
    export interface Schema$AllocationResourceStatusAggregateAllocation {
        /**
         * Per service utilization breakdown. The Key is the Google Cloud managed service name.
         */
        utilizations?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Contains Properties set for the reservation.
     */
    export interface Schema$AllocationResourceStatusSpecificSKUAllocation {
        /**
         * ID of the instance template used to populate reservation properties.
         */
        sourceInstanceTemplateId?: string | null;
        /**
         * Per service utilization breakdown. The Key is the Google Cloud managed service name.
         */
        utilizations?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk {
        /**
         * Specifies the size of the disk in base-2 GB.
         */
        diskSizeGb?: string | null;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
         */
        interface?: string | null;
    }
    /**
     * Properties of the SKU instances being reserved. Next ID: 9
     */
    export interface Schema$AllocationSpecificSKUAllocationReservedInstanceProperties {
        /**
         * Specifies accelerator type and count.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
         */
        localSsds?: Schema$AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk[];
        /**
         * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
         */
        locationHint?: string | null;
        /**
         * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
         */
        machineType?: string | null;
        /**
         * Specifies the number of hours after reservation creation where instances using the reservation won't be scheduled for maintenance.
         */
        maintenanceFreezeDurationHours?: number | null;
        /**
         * Specifies the frequency of planned maintenance events. The accepted values are: `PERIODIC`.
         */
        maintenanceInterval?: string | null;
        /**
         * Minimum cpu platform the reservation.
         */
        minCpuPlatform?: string | null;
    }
    /**
     * This reservation type allows to pre allocate specific instance configuration.
     */
    export interface Schema$AllocationSpecificSKUReservation {
        /**
         * [Output Only] Indicates how many instances are actually usable currently.
         */
        assuredCount?: string | null;
        /**
         * Specifies the number of resources that are allocated.
         */
        count?: string | null;
        /**
         * The instance properties for the reservation.
         */
        instanceProperties?: Schema$AllocationSpecificSKUAllocationReservedInstanceProperties;
        /**
         * [Output Only] Indicates how many instances are in use.
         */
        inUseCount?: string | null;
        /**
         * Specifies the instance template to create the reservation. If you use this field, you must exclude the instanceProperties field. This field is optional, and it can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate
         */
        sourceInstanceTemplate?: string | null;
    }
    export interface Schema$AsyncReplicationStatus {
        diskPairReplicationState?: Schema$DiskPairReplicationState;
        lastReplicationDetails?: Schema$ReplicationDetails;
    }
    /**
     * An instance-attached disk resource.
     */
    export interface Schema$AttachedDisk {
        /**
         * [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
         */
        architecture?: string | null;
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean | null;
        /**
         * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
         */
        boot?: boolean | null;
        /**
         * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
         */
        deviceName?: string | null;
        /**
         * Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Note: Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group. You cannot create VMs that have disks with customer-supplied keys using the bulk insert method.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The size of the disk in GB.
         */
        diskSizeGb?: string | null;
        /**
         * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
         */
        forceAttach?: boolean | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
         */
        index?: number | null;
        /**
         * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
         */
        initializeParams?: Schema$AttachedDiskInitializeParams;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
         */
        interface?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
         */
        kind?: string | null;
        /**
         * [Output Only] Any valid publicly visible licenses.
         */
        licenses?: string[] | null;
        /**
         * [Output Only] Whether to indicate the attached disk is locked. The locked disk is not allowed to be detached from the instance, or to be used as the source of the snapshot creation, and the image creation. The instance with at least one locked attached disk is not allow to be used as source of machine image creation, instant snapshot creation, and not allowed to be deleted with --keep-disk parameter set to true for locked disks.
         */
        locked?: boolean | null;
        /**
         * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
         */
        mode?: string | null;
        /**
         * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
         */
        savedState?: string | null;
        /**
         * [Output Only] shielded vm initial state stored on disk
         */
        shieldedInstanceInitialState?: Schema$InitialStateConfig;
        /**
         * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance boot disk, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
         */
        source?: string | null;
        /**
         * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
         */
        type?: string | null;
        /**
         * [Output Only] A list of user provided licenses. It represents a list of URLs to the license resource. Unlike regular licenses, user provided licenses can be modified after the disk is created.
         */
        userLicenses?: string[] | null;
    }
    /**
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This field is persisted and returned for instanceTemplate and not returned in the context of instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     */
    export interface Schema$AttachedDiskInitializeParams {
        /**
         * The architecture of the attached disk. Valid values are arm64 or x86_64.
         */
        architecture?: string | null;
        /**
         * An optional description. Provide this property when creating the disk.
         */
        description?: string | null;
        /**
         * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
         */
        diskName?: string | null;
        /**
         * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
         */
        diskSizeGb?: string | null;
        /**
         * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
         */
        diskType?: string | null;
        /**
         * Whether this disk is using confidential compute mode.
         */
        enableConfidentialCompute?: boolean | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options. Guest OS features are applied by merging initializeParams.guestOsFeatures and disks.guestOsFeatures
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
         */
        interface?: string | null;
        /**
         * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Integer license codes indicating which licenses are attached to this disk.
         */
        licenseCodes?: string[] | null;
        /**
         * A list of publicly visible licenses. Reserved for Google's use.
         */
        licenses?: string[] | null;
        /**
         * Indicates whether or not the disk can be read/write attached to more than one instance.
         */
        multiWriter?: boolean | null;
        /**
         * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
         */
        onUpdateAction?: string | null;
        /**
         * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
         */
        provisionedIops?: string | null;
        /**
         * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must greater than or equal to 1.
         */
        provisionedThroughput?: string | null;
        /**
         * Required for each regional disk associated with the instance. Specify the URLs of the zones where the disk should be replicated to. You must provide exactly two replica zones, and one zone must be the same as the instance zone.
         */
        replicaZones?: string[] | null;
        /**
         * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id\}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
        /**
         * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
         */
        resourcePolicies?: string[] | null;
        /**
         * The source image to create this disk. When creating a new instance boot disk, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
         */
        sourceImage?: string | null;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The source instant-snapshot to create this disk. When creating a new instance boot disk, one of initializeParams.sourceSnapshot or initializeParams.sourceInstantSnapshot initializeParams.sourceImage or disks.source is required. To create a disk with a snapshot that you created, specify the snapshot name in the following format: us-central1-a/instantSnapshots/my-backup If the source instant-snapshot is deleted later, this field will not be set.
         */
        sourceInstantSnapshot?: string | null;
        /**
         * The source snapshot to create this disk. When creating a new instance boot disk, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set. Note: You cannot create VMs in bulk using a snapshot as the source. Use an image instead when you create VMs using the bulk insert method.
         */
        sourceSnapshot?: string | null;
        /**
         * The customer-supplied encryption key of the source snapshot.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
         */
        storagePool?: string | null;
    }
    /**
     * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] \}, { "log_type": "DATA_WRITE" \}, { "log_type": "ADMIN_READ" \} ] \}, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" \}, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] \} ] \} ] \} For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
     */
    export interface Schema$AuditConfig {
        /**
         * The configuration for logging of each type of permission.
         */
        auditLogConfigs?: Schema$AuditLogConfig[];
        /**
         * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
         */
        service?: string | null;
    }
    /**
     * Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] \}, { "log_type": "DATA_WRITE" \} ] \} This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
     */
    export interface Schema$AuditLogConfig {
        /**
         * Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
         */
        exemptedMembers?: string[] | null;
        /**
         * The log type that this config enables.
         */
        logType?: string | null;
    }
    /**
     * [Deprecated] The authentication settings for the backend service. The authentication settings for the backend service.
     */
    export interface Schema$AuthenticationPolicy {
        /**
         * List of authentication methods that can be used for origin authentication. Similar to peers, these will be evaluated in order the first valid one will be used to set origin identity. If none of these methods pass, the request will be rejected with authentication failed error (401). Leave the list empty if origin authentication is not required.
         */
        origins?: Schema$OriginAuthenticationMethod[];
        /**
         * List of authentication methods that can be used for peer authentication. They will be evaluated in order the first valid one will be used to set peer identity. If none of these methods pass, the request will be rejected with authentication failed error (401). Leave the list empty if peer authentication is not required.
         */
        peers?: Schema$PeerAuthenticationMethod[];
        /**
         * Define whether peer or origin identity should be used for principal. Default value is USE_PEER. If peer (or origin) identity is not available, either because peer/origin authentication is not defined, or failed, principal will be left unset. In other words, binding rule does not affect the decision to accept or reject request. This field can be set to one of the following: USE_PEER: Principal will be set to the identity from peer authentication. USE_ORIGIN: Principal will be set to the identity from origin authentication.
         */
        principalBinding?: string | null;
        /**
         * Configures the mechanism to obtain server-side security certificates and identity information.
         */
        serverTlsContext?: Schema$TlsContext;
    }
    /**
     * [Deprecated] Authorization configuration provides service-level and method-level access control for a service. control for a service.
     */
    export interface Schema$AuthorizationConfig {
        /**
         * List of RbacPolicies.
         */
        policies?: Schema$RbacPolicy[];
    }
    /**
     * Represents an Autoscaler resource. Google Compute Engine has two Autoscaler resources: * [Zonal](/compute/docs/reference/rest/alpha/autoscalers) * [Regional](/compute/docs/reference/rest/alpha/regionAutoscalers) Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances. For zonal managed instance groups resource, use the autoscaler resource. For regional managed instance groups, use the regionAutoscalers resource.
     */
    export interface Schema$Autoscaler {
        /**
         * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
         */
        autoscalingPolicy?: Schema$AutoscalingPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
         */
        recommendedSize?: number | null;
        /**
         * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
         */
        region?: string | null;
        /**
         * [Output Only] Status information of existing scaling schedules.
         */
        scalingScheduleStatus?: {
            [key: string]: Schema$ScalingScheduleStatus;
        } | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
         */
        status?: string | null;
        /**
         * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
         */
        statusDetails?: Schema$AutoscalerStatusDetails[];
        /**
         * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
         */
        target?: string | null;
        /**
         * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
         */
        zone?: string | null;
    }
    export interface Schema$AutoscalerAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AutoscalersScopedList resources.
         */
        items?: {
            [key: string]: Schema$AutoscalersScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Autoscaler resources.
     */
    export interface Schema$AutoscalerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Autoscaler resources.
         */
        items?: Schema$Autoscaler[];
        /**
         * [Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AutoscalersScopedList {
        /**
         * [Output Only] A list of autoscalers contained in this scope.
         */
        autoscalers?: Schema$Autoscaler[];
        /**
         * [Output Only] Informational warning which replaces the list of autoscalers when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AutoscalerStatusDetails {
        /**
         * The status message.
         */
        message?: string | null;
        /**
         * The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
         */
        type?: string | null;
    }
    /**
     * Cloud Autoscaler policy.
     */
    export interface Schema$AutoscalingPolicy {
        /**
         * The number of seconds that your application takes to initialize on a VM instance. This is referred to as the [initialization period](/compute/docs/autoscaler#cool_down_period). Specifying an accurate initialization period improves autoscaler decisions. For example, when scaling out, the autoscaler ignores data from VMs that are still initializing because those VMs might not yet represent normal usage of your application. The default initialization period is 60 seconds. Initialization periods might vary because of numerous factors. We recommend that you test how long your application takes to initialize. To do this, create a VM and time your application's startup process.
         */
        coolDownPeriodSec?: number | null;
        /**
         * Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
         */
        cpuUtilization?: Schema$AutoscalingPolicyCpuUtilization;
        /**
         * Configuration parameters of autoscaling based on a custom metric.
         */
        customMetricUtilizations?: Schema$AutoscalingPolicyCustomMetricUtilization[];
        /**
         * Configuration parameters of autoscaling based on load balancer.
         */
        loadBalancingUtilization?: Schema$AutoscalingPolicyLoadBalancingUtilization;
        /**
         * The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
         */
        maxNumReplicas?: number | null;
        /**
         * The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
         */
        minNumReplicas?: number | null;
        /**
         * Defines the operating mode for this policy. The following modes are available: - OFF: Disables the autoscaler but maintains its configuration. - ONLY_SCALE_OUT: Restricts the autoscaler to add VM instances only. - ON: Enables all autoscaler activities according to its policy. For more information, see "Turning off or restricting an autoscaler"
         */
        mode?: string | null;
        scaleDownControl?: Schema$AutoscalingPolicyScaleDownControl;
        scaleInControl?: Schema$AutoscalingPolicyScaleInControl;
        /**
         * Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
         */
        scalingSchedules?: {
            [key: string]: Schema$AutoscalingPolicyScalingSchedule;
        } | null;
    }
    /**
     * CPU utilization policy.
     */
    export interface Schema$AutoscalingPolicyCpuUtilization {
        /**
         * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
         */
        predictiveMethod?: string | null;
        /**
         * The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
         */
        utilizationTarget?: number | null;
    }
    /**
     * Custom utilization metric policy.
     */
    export interface Schema$AutoscalingPolicyCustomMetricUtilization {
        /**
         * A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
         */
        filter?: string | null;
        /**
         * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
         */
        metric?: string | null;
        /**
         * If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
         */
        singleInstanceAssignment?: number | null;
        /**
         * The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
         */
        utilizationTarget?: number | null;
        /**
         * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
         */
        utilizationTargetType?: string | null;
    }
    /**
     * Configuration parameters of autoscaling based on load balancing.
     */
    export interface Schema$AutoscalingPolicyLoadBalancingUtilization {
        /**
         * Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
         */
        utilizationTarget?: number | null;
    }
    /**
     * Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
     */
    export interface Schema$AutoscalingPolicyScaleDownControl {
        /**
         * Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
         */
        maxScaledDownReplicas?: Schema$FixedOrPercent;
        /**
         * How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
         */
        timeWindowSec?: number | null;
    }
    /**
     * Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
     */
    export interface Schema$AutoscalingPolicyScaleInControl {
        /**
         * Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
         */
        maxScaledInReplicas?: Schema$FixedOrPercent;
        /**
         * How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
         */
        timeWindowSec?: number | null;
    }
    /**
     * Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
     */
    export interface Schema$AutoscalingPolicyScalingSchedule {
        /**
         * A description of a scaling schedule.
         */
        description?: string | null;
        /**
         * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
         */
        disabled?: boolean | null;
        /**
         * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
         */
        durationSec?: number | null;
        /**
         * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
         */
        minRequiredReplicas?: number | null;
        /**
         * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
         */
        schedule?: string | null;
        /**
         * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
         */
        timeZone?: string | null;
    }
    /**
     * Contains the configurations necessary to generate a signature for access to private storage buckets that support Signature Version 4 for authentication. The service name for generating the authentication header will always default to 's3'.
     */
    export interface Schema$AWSV4Signature {
        /**
         * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. @InputOnly
         */
        accessKey?: string | null;
        /**
         * The identifier of an access key used for s3 bucket authentication.
         */
        accessKeyId?: string | null;
        /**
         * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
         */
        accessKeyVersion?: string | null;
        /**
         * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
         */
        originRegion?: string | null;
    }
    /**
     * Message containing information of one individual backend.
     */
    export interface Schema$Backend {
        /**
         * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
         */
        balancingMode?: string | null;
        /**
         * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
         */
        capacityScaler?: number | null;
        /**
         * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
         */
        customMetrics?: Schema$BackendCustomMetric[];
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
         */
        failover?: boolean | null;
        /**
         * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
         */
        group?: string | null;
        /**
         * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
         */
        maxConnections?: number | null;
        /**
         * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
         */
        maxConnectionsPerEndpoint?: number | null;
        /**
         * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
         */
        maxConnectionsPerInstance?: number | null;
        /**
         * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
         */
        maxRate?: number | null;
        /**
         * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
         */
        maxRatePerEndpoint?: number | null;
        /**
         * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
         */
        maxRatePerInstance?: number | null;
        /**
         * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
         */
        maxUtilization?: number | null;
        /**
         * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
         */
        preference?: string | null;
    }
    /**
     * Represents a Cloud Storage Bucket resource. This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
     */
    export interface Schema$BackendBucket {
        /**
         * Cloud Storage bucket name.
         */
        bucketName?: string | null;
        /**
         * Cloud CDN configuration for this BackendBucket.
         */
        cdnPolicy?: Schema$BackendBucketCdnPolicy;
        /**
         * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
         */
        compressionMode?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Headers that the Application Load Balancer should add to proxied responses.
         */
        customResponseHeaders?: string[] | null;
        /**
         * An optional textual description of the resource; provided by the client when the resource is created.
         */
        description?: string | null;
        /**
         * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
         */
        edgeSecurityPolicy?: string | null;
        /**
         * If true, enable Cloud CDN for this BackendBucket.
         */
        enableCdn?: boolean | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * Type of the resource.
         */
        kind?: string | null;
        /**
         * The value can only be INTERNAL_MANAGED for cross-region internal layer 7 load balancer. If loadBalancingScheme is not specified, the backend bucket can be used by classic global external load balancers, or global application external load balancers, or both.
         */
        loadBalancingScheme?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the regional backend bucket resides. This field is not applicable to global backend buckets. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] List of resources referencing that backend bucket.
         */
        usedBy?: Schema$BackendBucketUsedBy[];
    }
    /**
     * Message containing Cloud CDN configuration for a backend bucket.
     */
    export interface Schema$BackendBucketCdnPolicy {
        /**
         * Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
         */
        bypassCacheOnRequestHeaders?: Schema$BackendBucketCdnPolicyBypassCacheOnRequestHeader[];
        /**
         * The CacheKeyPolicy for this CdnPolicy.
         */
        cacheKeyPolicy?: Schema$BackendBucketCdnPolicyCacheKeyPolicy;
        /**
         * Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
         */
        cacheMode?: string | null;
        /**
         * Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
         */
        clientTtl?: number | null;
        /**
         * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-maxage). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        defaultTtl?: number | null;
        /**
         * Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        maxTtl?: number | null;
        /**
         * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
         */
        negativeCaching?: boolean | null;
        /**
         * Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
         */
        negativeCachingPolicy?: Schema$BackendBucketCdnPolicyNegativeCachingPolicy[];
        /**
         * If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
         */
        requestCoalescing?: boolean | null;
        /**
         * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-maxage) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
         */
        serveWhileStale?: number | null;
        /**
         * Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
         */
        signedUrlCacheMaxAgeSec?: string | null;
        /**
         * [Output Only] Names of the keys for signing request URLs.
         */
        signedUrlKeyNames?: string[] | null;
    }
    /**
     * Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
     */
    export interface Schema$BackendBucketCdnPolicyBypassCacheOnRequestHeader {
        /**
         * The header field name to match on when bypassing cache. Values are case-insensitive.
         */
        headerName?: string | null;
    }
    /**
     * Message containing what to include in the cache key for a request for Cloud CDN.
     */
    export interface Schema$BackendBucketCdnPolicyCacheKeyPolicy {
        /**
         * Allows HTTP request headers (by name) to be used in the cache key.
         */
        includeHttpHeaders?: string[] | null;
        /**
         * Names of query string parameters to include in cache keys. Default parameters are always included. '&' and '=' will be percent encoded and not treated as delimiters.
         */
        queryStringWhitelist?: string[] | null;
    }
    /**
     * Specify CDN TTLs for response error codes.
     */
    export interface Schema$BackendBucketCdnPolicyNegativeCachingPolicy {
        /**
         * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
         */
        code?: number | null;
        /**
         * The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        ttl?: number | null;
    }
    /**
     * Contains a list of BackendBucket resources.
     */
    export interface Schema$BackendBucketList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendBucket resources.
         */
        items?: Schema$BackendBucket[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$BackendBucketListUsable {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendBucket resources.
         */
        items?: Schema$BackendBucket[];
        /**
         * [Output Only] Type of resource. Always compute#usableBackendBucketList for lists of usable backend buckets.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$BackendBucketUsedBy {
        /**
         * [Output Only] Server-defined URL for UrlMaps referencing that BackendBucket.
         */
        reference?: string | null;
    }
    /**
     * Custom Metrics are used for CUSTOM_METRICS balancing_mode.
     */
    export interface Schema$BackendCustomMetric {
        /**
         * If true, the metric data is collected and reported to Cloud Monitoring, but is not used for load balancing.
         */
        dryRun?: boolean | null;
        /**
         * Optional parameter to define a target utilization for the Custom Metrics balancing mode. The valid range is [0.0, 1.0].
         */
        maxUtilization?: number | null;
        /**
         * Name of a custom utilization signal. The name must be 1-64 characters long and match the regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all following characters must be a dash, period, underscore, lowercase letter, or digit, except the last character, which cannot be a dash, period, or underscore. For usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED, INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
         */
        name?: string | null;
    }
    /**
     * Represents a Backend Service resource. A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly. Backend services in Google Compute Engine can be either regionally or globally scoped. * [Global](https://cloud.google.com/compute/docs/reference/rest/alpha/backendServices) * [Regional](https://cloud.google.com/compute/docs/reference/rest/alpha/regionBackendServices) For more information, see Backend Services.
     */
    export interface Schema$BackendService {
        /**
         * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        affinityCookieTtlSec?: number | null;
        /**
         * The list of backends that serve this BackendService.
         */
        backends?: Schema$Backend[];
        /**
         * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
         */
        cdnPolicy?: Schema$BackendServiceCdnPolicy;
        circuitBreakers?: Schema$CircuitBreakers;
        /**
         * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
         */
        compressionMode?: string | null;
        /**
         * connectionDraining cannot be specified with haPolicy.
         */
        connectionDraining?: Schema$ConnectionDraining;
        /**
         * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
         */
        connectionTrackingPolicy?: Schema$BackendServiceConnectionTrackingPolicy;
        /**
         * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         */
        consistentHash?: Schema$ConsistentHashLoadBalancerSettings;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
         */
        customMetrics?: Schema$BackendServiceCustomMetric[];
        /**
         * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
         */
        customRequestHeaders?: string[] | null;
        /**
         * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
         */
        customResponseHeaders?: string[] | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding feature which together with Service Extension allows customized and complex routing logic.
         */
        dynamicForwarding?: Schema$BackendServiceDynamicForwarding;
        /**
         * [Output Only] The resource URL for the edge security policy associated with this backend service.
         */
        edgeSecurityPolicy?: string | null;
        /**
         * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
         */
        enableCDN?: boolean | null;
        /**
         * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
         */
        externalManagedMigrationState?: string | null;
        /**
         * Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
         */
        externalManagedMigrationTestingPercentage?: number | null;
        /**
         * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
         */
        failoverPolicy?: Schema$BackendServiceFailoverPolicy;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
         */
        fingerprint?: string | null;
        /**
         * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
         */
        haPolicy?: Schema$BackendServiceHAPolicy;
        /**
         * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
         */
        healthChecks?: string[] | null;
        /**
         * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
         */
        iap?: Schema$BackendServiceIAP;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
         */
        ipAddressSelectionPolicy?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#backendService for backend services.
         */
        kind?: string | null;
        /**
         * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
         */
        loadBalancingScheme?: string | null;
        /**
         * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
         */
        localityLbPolicies?: Schema$BackendServiceLocalityLoadBalancingPolicyConfig[];
        /**
         * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
         */
        localityLbPolicy?: string | null;
        /**
         * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
         */
        logConfig?: Schema$BackendServiceLogConfig;
        /**
         * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
         */
        maxStreamDuration?: Schema$Duration;
        /**
         * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
         */
        metadatas?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
         */
        network?: string | null;
        /**
         * Configures traffic steering properties of internal passthrough Network Load Balancers. networkPassThroughLbTrafficPolicy cannot be specified with haPolicy.
         */
        networkPassThroughLbTrafficPolicy?: Schema$BackendServiceNetworkPassThroughLbTrafficPolicy;
        /**
         * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        outlierDetection?: Schema$OutlierDetection;
        /**
         * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
         */
        port?: number | null;
        /**
         * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
         */
        portName?: string | null;
        /**
         * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
         */
        protocol?: string | null;
        /**
         * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] The resource URL for the security policy associated with this backend service.
         */
        securityPolicy?: string | null;
        /**
         * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         */
        securitySettings?: Schema$SecuritySettings;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
         */
        serviceBindings?: string[] | null;
        /**
         * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
         */
        serviceLbPolicy?: string | null;
        /**
         * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
         */
        sessionAffinity?: string | null;
        /**
         * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
         */
        strongSessionAffinityCookie?: Schema$BackendServiceHttpCookie;
        /**
         * subsetting cannot be specified with haPolicy.
         */
        subsetting?: Schema$Subsetting;
        /**
         * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
         */
        timeoutSec?: number | null;
        /**
         * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
         */
        tlsSettings?: Schema$BackendServiceTlsSettings;
        /**
         * [Output Only] List of resources referencing given backend service.
         */
        usedBy?: Schema$BackendServiceUsedBy[];
        /**
         * The network scope of the backends that can be added to the backend service. This field can be either GLOBAL_VPC_NETWORK or REGIONAL_VPC_NETWORK. A backend service with the VPC scope set to GLOBAL_VPC_NETWORK is only allowed to have backends in global VPC networks. When the VPC scope is set to REGIONAL_VPC_NETWORK the backend service is only allowed to have backends in regional networks in the same scope as the backend service. Note: if not specified then GLOBAL_VPC_NETWORK will be used.
         */
        vpcNetworkScope?: string | null;
    }
    /**
     * Contains a list of BackendServicesScopedList.
     */
    export interface Schema$BackendServiceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendServicesScopedList resources.
         */
        items?: {
            [key: string]: Schema$BackendServicesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Message containing Cloud CDN configuration for a backend service.
     */
    export interface Schema$BackendServiceCdnPolicy {
        /**
         * Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
         */
        bypassCacheOnRequestHeaders?: Schema$BackendServiceCdnPolicyBypassCacheOnRequestHeader[];
        /**
         * The CacheKeyPolicy for this CdnPolicy.
         */
        cacheKeyPolicy?: Schema$CacheKeyPolicy;
        /**
         * Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
         */
        cacheMode?: string | null;
        /**
         * Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
         */
        clientTtl?: number | null;
        /**
         * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-maxage). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        defaultTtl?: number | null;
        /**
         * Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        maxTtl?: number | null;
        /**
         * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
         */
        negativeCaching?: boolean | null;
        /**
         * Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
         */
        negativeCachingPolicy?: Schema$BackendServiceCdnPolicyNegativeCachingPolicy[];
        /**
         * If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
         */
        requestCoalescing?: boolean | null;
        /**
         * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-maxage) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
         */
        serveWhileStale?: number | null;
        /**
         * Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
         */
        signedUrlCacheMaxAgeSec?: string | null;
        /**
         * [Output Only] Names of the keys for signing request URLs.
         */
        signedUrlKeyNames?: string[] | null;
    }
    /**
     * Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
     */
    export interface Schema$BackendServiceCdnPolicyBypassCacheOnRequestHeader {
        /**
         * The header field name to match on when bypassing cache. Values are case-insensitive.
         */
        headerName?: string | null;
    }
    /**
     * Specify CDN TTLs for response error codes.
     */
    export interface Schema$BackendServiceCdnPolicyNegativeCachingPolicy {
        /**
         * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
         */
        code?: number | null;
        /**
         * The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        ttl?: number | null;
    }
    /**
     * Connection Tracking configuration for this BackendService.
     */
    export interface Schema$BackendServiceConnectionTrackingPolicy {
        /**
         * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
         */
        connectionPersistenceOnUnhealthyBackends?: string | null;
        /**
         * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
         */
        enableStrongAffinity?: boolean | null;
        /**
         * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
         */
        idleTimeoutSec?: number | null;
        /**
         * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
         */
        trackingMode?: string | null;
    }
    /**
     * Custom Metrics are used for WEIGHTED_ROUND_ROBIN locality_lb_policy.
     */
    export interface Schema$BackendServiceCustomMetric {
        /**
         * If true, the metric data is not used for load balancing.
         */
        dryRun?: boolean | null;
        /**
         * Name of a custom utilization signal. The name must be 1-64 characters long and match the regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all following characters must be a dash, period, underscore, lowercase letter, or digit, except the last character, which cannot be a dash, period, or underscore. For usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED, INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
         */
        name?: string | null;
    }
    /**
     * Defines a dynamic forwarding configuration for the backend service.
     */
    export interface Schema$BackendServiceDynamicForwarding {
        /**
         * IP:PORT based dynamic forwarding configuration.
         */
        ipPortSelection?: Schema$BackendServiceDynamicForwardingIpPortSelection;
    }
    /**
     * Defines a IP:PORT based dynamic forwarding configuration for the backend service. Some ranges are restricted: Restricted ranges.
     */
    export interface Schema$BackendServiceDynamicForwardingIpPortSelection {
        /**
         * A boolean flag enabling IP:PORT based dynamic forwarding.
         */
        enabled?: boolean | null;
    }
    /**
     * For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). On failover or failback, this field indicates whether connection draining will be honored. Google Cloud has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
     */
    export interface Schema$BackendServiceFailoverPolicy {
        /**
         * This can be set to true only if the protocol is TCP. The default is false.
         */
        disableConnectionDrainOnFailover?: boolean | null;
        /**
         * If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.
         */
        dropTrafficIfUnhealthy?: boolean | null;
        /**
         * The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
         */
        failoverRatio?: number | null;
    }
    export interface Schema$BackendServiceGroupHealth {
        /**
         * Metadata defined as annotations on the network endpoint group.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.
         */
        healthStatus?: Schema$HealthStatus[];
        /**
         * [Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.
         */
        kind?: string | null;
    }
    export interface Schema$BackendServiceHAPolicy {
        /**
         * Specifies whether fast IP move is enabled, and if so, the mechanism to achieve it. Supported values are: - DISABLED: Fast IP Move is disabled. You can only use the haPolicy.leader API to update the leader. - \>GARP_RA: Provides a method to very quickly define a new network endpoint as the leader. This method is faster than updating the leader using the haPolicy.leader API. Fast IP move works as follows: The VM hosting the network endpoint that should become the new leader sends either a Gratuitous ARP (GARP) packet (IPv4) or an ICMPv6 Router Advertisement(RA) packet (IPv6). Google Cloud immediately but temporarily associates the forwarding rule IP address with that VM, and both new and in-flight packets are quickly delivered to that VM. Note the important properties of the Fast IP Move functionality: - The GARP/RA-initiated re-routing stays active for approximately 20 minutes. After triggering fast failover, you must also appropriately set the haPolicy.leader. - The new leader instance should continue to send GARP/RA packets periodically every 10 seconds until at least 10 minutes after updating the haPolicy.leader (but stop immediately if it is no longer the leader). - After triggering a fast failover, we recommend that you wait at least 3 seconds before sending another GARP/RA packet from a different VM instance to avoid race conditions. - Don't send GARP/RA packets from different VM instances at the same time. If multiple instances continue to send GARP/RA packets, traffic might be routed to different destinations in an alternating order. This condition ceases when a single instance issues a GARP/RA packet. - The GARP/RA request always takes priority over the leader API. Using the haPolicy.leader API to change the leader to a different instance will have no effect until the GARP/RA request becomes inactive. - The GARP/RA packets should follow the GARP/RA Packet Specifications.. - When multiple forwarding rules refer to a regional backend service, you need only send a GARP or RA packet for a single forwarding rule virtual IP. The virtual IPs for all forwarding rules targeting the same backend service will also be moved to the sender of the GARP or RA packet. The following are the Fast IP Move limitations (that is, when fastIPMove is not DISABLED): - Multiple forwarding rules cannot use the same IP address if one of them refers to a regional backend service with fastIPMove. - The regional backend service must set the network field, and all NEGs must belong to that network. However, individual NEGs can belong to different subnetworks of that network. - The maximum number of network endpoints across all backends of a backend service with fastIPMove is 32. - The maximum number of backend services with fastIPMove that can have the same network endpoint attached to one of its backends is 64. - The maximum number of backend services with fastIPMove in a VPC in a region is 64. - The network endpoints that are attached to a backend of a backend service with fastIPMove cannot resolve to Gen3+ machines for IPv6. - Traffic directed to the leader by a static route next hop will not be redirected to a new leader by fast failover. Such traffic will only be redirected once an haPolicy.leader update has taken effect. Only traffic to the forwarding rule's virtual IP will be redirected to a new leader by fast failover. haPolicy.fastIPMove can be set only at backend service creation time. Once set, it cannot be updated. By default, fastIpMove is set to DISABLED.
         */
        fastIPMove?: string | null;
        /**
         * Selects one of the network endpoints attached to the backend NEGs of this service as the active endpoint (the leader) that receives all traffic. When the leader changes, there is no connection draining to persist existing connections on the old leader. You are responsible for selecting a suitable endpoint as the leader. For example, preferring a healthy endpoint over unhealthy ones. Note that this service does not track backend endpoint health, and selects the configured leader unconditionally.
         */
        leader?: Schema$BackendServiceHAPolicyLeader;
    }
    export interface Schema$BackendServiceHAPolicyLeader {
        /**
         * A fully-qualified URL (starting with https://www.googleapis.com/) of the zonal Network Endpoint Group (NEG) with `GCE_VM_IP` endpoints that the leader is attached to. The leader's backendGroup must already be specified as a backend of this backend service. Removing a backend that is designated as the leader's backendGroup is not permitted.
         */
        backendGroup?: string | null;
        /**
         * The network endpoint within the leader.backendGroup that is designated as the leader. This network endpoint cannot be detached from the NEG specified in the haPolicy.leader.backendGroup until the leader is updated with another network endpoint, or the leader is removed from the haPolicy.
         */
        networkEndpoint?: Schema$BackendServiceHAPolicyLeaderNetworkEndpoint;
    }
    export interface Schema$BackendServiceHAPolicyLeaderNetworkEndpoint {
        /**
         * The name of the VM instance of the leader network endpoint. The instance must already be attached to the NEG specified in the haPolicy.leader.backendGroup. The name must be 1-63 characters long, and comply with RFC1035. Authorization requires the following IAM permission on the specified resource instance: compute.instances.use
         */
        instance?: string | null;
    }
    /**
     * The HTTP cookie used for stateful session affinity.
     */
    export interface Schema$BackendServiceHttpCookie {
        /**
         * Name of the cookie.
         */
        name?: string | null;
        /**
         * Path to set for the cookie.
         */
        path?: string | null;
        /**
         * Lifetime of the cookie.
         */
        ttl?: Schema$Duration;
    }
    /**
     * Identity-Aware Proxy
     */
    export interface Schema$BackendServiceIAP {
        /**
         * Whether the serving infrastructure will authenticate and authorize all incoming requests.
         */
        enabled?: boolean | null;
        /**
         * OAuth2 client ID to use for the authentication flow.
         */
        oauth2ClientId?: string | null;
        /**
         * [Input Only] OAuth client info required to generate client id to be used for IAP.
         */
        oauth2ClientInfo?: Schema$BackendServiceIAPOAuth2ClientInfo;
        /**
         * OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
         */
        oauth2ClientSecret?: string | null;
        /**
         * [Output Only] SHA256 hash value for the field oauth2_client_secret above.
         */
        oauth2ClientSecretSha256?: string | null;
    }
    export interface Schema$BackendServiceIAPOAuth2ClientInfo {
        /**
         * Application name to be used in OAuth consent screen.
         */
        applicationName?: string | null;
        /**
         * Name of the client to be generated. Optional - If not provided, the name will be autogenerated by the backend.
         */
        clientName?: string | null;
        /**
         * Developer's information to be used in OAuth consent screen.
         */
        developerEmailAddress?: string | null;
    }
    /**
     * Contains a list of BackendService resources.
     */
    export interface Schema$BackendServiceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendService resources.
         */
        items?: Schema$BackendService[];
        /**
         * [Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of usable BackendService resources.
     */
    export interface Schema$BackendServiceListUsable {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendService resources.
         */
        items?: Schema$BackendService[];
        /**
         * [Output Only] Type of resource. Always compute#usableBackendServiceList for lists of usable backend services.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Container for either a built-in LB policy supported by gRPC or Envoy or a custom one implemented by the end user.
     */
    export interface Schema$BackendServiceLocalityLoadBalancingPolicyConfig {
        customPolicy?: Schema$BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy;
        policy?: Schema$BackendServiceLocalityLoadBalancingPolicyConfigPolicy;
    }
    /**
     * The configuration for a custom policy implemented by the user and deployed with the client.
     */
    export interface Schema$BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy {
        /**
         * An optional, arbitrary JSON object with configuration data, understood by a locally installed custom policy implementation.
         */
        data?: string | null;
        /**
         * Identifies the custom policy. The value should match the name of a custom implementation registered on the gRPC clients. It should follow protocol buffer message naming conventions and include the full path (for example, myorg.CustomLbPolicy). The maximum length is 256 characters. Do not specify the same custom policy more than once for a backend. If you do, the configuration is rejected. For an example of how to use this field, see Use a custom policy.
         */
        name?: string | null;
    }
    /**
     * The configuration for a built-in load balancing policy.
     */
    export interface Schema$BackendServiceLocalityLoadBalancingPolicyConfigPolicy {
        /**
         * The name of a locality load-balancing policy. Valid values include ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information about these values, see the description of localityLbPolicy. Do not specify the same policy more than once for a backend. If you do, the configuration is rejected.
         */
        name?: string | null;
    }
    /**
     * The available logging options for the load balancer traffic served by this backend service.
     */
    export interface Schema$BackendServiceLogConfig {
        /**
         * Denotes whether to enable logging for the load balancer traffic served by this backend service. The default value is false.
         */
        enable?: boolean | null;
        /**
         * Deprecated in favor of optionalMode. This field can only be specified if logging is enabled for this backend service. Configures whether all, none or a subset of optional fields should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
         */
        optional?: string | null;
        /**
         * This field can only be specified if logging is enabled for this backend service and "logConfig.optionalMode" was set to CUSTOM. Contains a list of optional fields you want to include in the logs. For example: serverInstance, serverGkeDetails.cluster, serverGkeDetails.pod.podNamespace
         */
        optionalFields?: string[] | null;
        /**
         * This field can only be specified if logging is enabled for this backend service. Configures whether all, none or a subset of optional fields should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
         */
        optionalMode?: string | null;
        /**
         * This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
         */
        sampleRate?: number | null;
    }
    export interface Schema$BackendServiceNetworkPassThroughLbTrafficPolicy {
        /**
         * When configured, new connections are load balanced across healthy backend endpoints in the local zone.
         */
        zonalAffinity?: Schema$BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity;
    }
    export interface Schema$BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity {
        /**
         * This field indicates whether zonal affinity is enabled or not. The possible values are: - ZONAL_AFFINITY_DISABLED: Default Value. Zonal Affinity is disabled. The load balancer distributes new connections to all healthy backend endpoints across all zones. - ZONAL_AFFINITY_STAY_WITHIN_ZONE: Zonal Affinity is enabled. The load balancer distributes new connections to all healthy backend endpoints in the local zone only. If there are no healthy backend endpoints in the local zone, the load balancer distributes new connections to all backend endpoints in the local zone. - ZONAL_AFFINITY_SPILL_CROSS_ZONE: Zonal Affinity is enabled. The load balancer distributes new connections to all healthy backend endpoints in the local zone only. If there aren't enough healthy backend endpoints in the local zone, the load balancer distributes new connections to all healthy backend endpoints across all zones.
         */
        spillover?: string | null;
        /**
         * The value of the field must be in [0, 1]. When the ratio of the count of healthy backend endpoints in a zone to the count of backend endpoints in that same zone is equal to or above this threshold, the load balancer distributes new connections to all healthy endpoints in the local zone only. When the ratio of the count of healthy backend endpoints in a zone to the count of backend endpoints in that same zone is below this threshold, the load balancer distributes all new connections to all healthy endpoints across all zones.
         */
        spilloverRatio?: number | null;
    }
    export interface Schema$BackendServiceReference {
        backendService?: string | null;
    }
    export interface Schema$BackendServicesGetEffectiveSecurityPoliciesResponse {
        /**
         * Effective security policies for the backend service.
         */
        securityPolicies?: Schema$SecurityPolicy[];
    }
    export interface Schema$BackendServicesScopedList {
        /**
         * A list of BackendServices contained in this scope.
         */
        backendServices?: Schema$BackendService[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$BackendServiceTlsSettings {
        /**
         * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
         */
        authenticationConfig?: string | null;
        /**
         * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
         */
        sni?: string | null;
        /**
         * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
         */
        subjectAltNames?: Schema$BackendServiceTlsSettingsSubjectAltName[];
    }
    /**
     * A Subject Alternative Name that the load balancer matches against the SAN field in the TLS certificate provided by the backend, specified as either a DNS name or a URI, in accordance with RFC 5280 4.2.1.6
     */
    export interface Schema$BackendServiceTlsSettingsSubjectAltName {
        /**
         * The SAN specified as a DNS Name.
         */
        dnsName?: string | null;
        /**
         * The SAN specified as a URI.
         */
        uniformResourceIdentifier?: string | null;
    }
    export interface Schema$BackendServiceUsedBy {
        /**
         * [Output Only] Server-defined URL for resources referencing given BackendService like UrlMaps, TargetTcpProxies, TargetSslProxies and ForwardingRule.
         */
        reference?: string | null;
    }
    export interface Schema$BfdPacket {
        /**
         * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        authenticationPresent?: boolean | null;
        /**
         * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        controlPlaneIndependent?: boolean | null;
        /**
         * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        demand?: boolean | null;
        /**
         * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
         */
        diagnostic?: string | null;
        /**
         * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        final?: boolean | null;
        /**
         * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
         */
        length?: number | null;
        /**
         * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        minEchoRxIntervalMs?: number | null;
        /**
         * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        minRxIntervalMs?: number | null;
        /**
         * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        minTxIntervalMs?: number | null;
        /**
         * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        multiplier?: number | null;
        /**
         * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        multipoint?: boolean | null;
        /**
         * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        myDiscriminator?: number | null;
        /**
         * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        poll?: boolean | null;
        /**
         * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
         */
        state?: string | null;
        /**
         * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
         */
        version?: number | null;
        /**
         * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        yourDiscriminator?: number | null;
    }
    /**
     * Next free: 15
     */
    export interface Schema$BfdStatus {
        /**
         * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
         */
        bfdSessionInitializationMode?: string | null;
        /**
         * Unix timestamp of the most recent config update.
         */
        configUpdateTimestampMicros?: string | null;
        /**
         * Control packet counts for the current BFD session.
         */
        controlPacketCounts?: Schema$BfdStatusPacketCounts;
        /**
         * Inter-packet time interval statistics for control packets.
         */
        controlPacketIntervals?: Schema$PacketIntervals[];
        /**
         * Echo packet counts for the current BFD session.
         */
        echoPacketCounts?: Schema$BfdStatusPacketCounts;
        /**
         * Inter-packet time interval statistics for echo packets.
         */
        echoPacketIntervals?: Schema$PacketIntervals[];
        /**
         * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
         */
        localDiagnostic?: string | null;
        /**
         * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
         */
        localState?: string | null;
        /**
         * Negotiated transmit interval for control packets.
         */
        negotiatedLocalControlTxIntervalMs?: number | null;
        /**
         * Negotiated transmit interval for echo packets.
         */
        negotiatedLocalEchoTxIntervalMs?: number | null;
        /**
         * The most recent Rx control packet for this BFD session.
         */
        rxPacket?: Schema$BfdPacket;
        /**
         * The most recent Tx control packet for this BFD session.
         */
        txPacket?: Schema$BfdPacket;
        /**
         * Session uptime in milliseconds. Value will be 0 if session is not up.
         */
        uptimeMs?: string | null;
        /**
         * Indicates if echo mode is currently being used.
         */
        usingEchoMode?: boolean | null;
    }
    export interface Schema$BfdStatusPacketCounts {
        /**
         * Number of packets received since the beginning of the current BFD session.
         */
        numRx?: number | null;
        /**
         * Number of packets received that were rejected because of errors since the beginning of the current BFD session.
         */
        numRxRejected?: number | null;
        /**
         * Number of packets received that were successfully processed since the beginning of the current BFD session.
         */
        numRxSuccessful?: number | null;
        /**
         * Number of packets transmitted since the beginning of the current BFD session.
         */
        numTx?: number | null;
    }
    export interface Schema$BgpRoute {
        /**
         * [Output only] AS-PATH for the route
         */
        asPaths?: Schema$BgpRouteAsPath[];
        /**
         * [Output only] BGP communities in human-readable A:B format.
         */
        communities?: string[] | null;
        /**
         * [Output only] Destination IP range for the route, in human-readable CIDR format
         */
        destination?: Schema$BgpRouteNetworkLayerReachabilityInformation;
        /**
         * [Output only] BGP multi-exit discriminator
         */
        med?: number | null;
        /**
         * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
         */
        origin?: string | null;
    }
    export interface Schema$BgpRouteAsPath {
        /**
         * [Output only] ASNs in the path segment. When type is SEQUENCE, these are ordered.
         */
        asns?: number[] | null;
        /**
         * [Output only] Type of AS-PATH segment (SEQUENCE or SET)
         */
        type?: string | null;
    }
    /**
     * Network Layer Reachability Information (NLRI) for a route.
     */
    export interface Schema$BgpRouteNetworkLayerReachabilityInformation {
        /**
         * If the BGP session supports multiple paths (RFC 7911), the path identifier for this route.
         */
        pathId?: number | null;
        /**
         * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16.
         */
        prefix?: string | null;
    }
    /**
     * Associates `members`, or principals, with a `role`.
     */
    export interface Schema$Binding {
        /**
         * The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        condition?: Schema$Expr;
        /**
         * Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid\}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid\}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid\}.svc.id.goog[{namespace\}/{kubernetes-sa\}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid\}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain\}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/subject/{subject_attribute_value\}`: A single identity in a workforce identity pool. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/group/{group_id\}`: All workforce identities in a group. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/attribute.{attribute_name\}/{attribute_value\}`: All workforce identities with a specific attribute value. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/x`: All identities in a workforce identity pool. * `principal://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/subject/{subject_attribute_value\}`: A single identity in a workload identity pool. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/group/{group_id\}`: A workload identity pool group. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/attribute.{attribute_name\}/{attribute_value\}`: All identities in a workload identity pool with a certain attribute. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/x`: All identities in a workload identity pool. * `deleted:user:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid\}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid\}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid\}` and the recovered group retains the role in the binding. * `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/subject/{subject_attribute_value\}`: Deleted single identity in a workforce identity pool. For example, `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value`.
         */
        members?: string[] | null;
        /**
         * Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview of the IAM roles and permissions, see the [IAM documentation](https://cloud.google.com/iam/docs/roles-overview). For a list of the available pre-defined roles, see [here](https://cloud.google.com/iam/docs/understanding-roles).
         */
        role?: string | null;
    }
    /**
     * A transient resource used in compute.disks.bulkInsert and compute.regionDisks.bulkInsert. It is only used to process requests and is not persisted.
     */
    export interface Schema$BulkInsertDiskResource {
        /**
         * The parameters for the instant snapshot group.
         */
        instantSnapshotGroupParameters?: Schema$InstantSnapshotGroupParameters;
        /**
         * The parameters for the snapshot group.
         */
        snapshotGroupParameters?: Schema$SnapshotGroupParameters;
        /**
         * The URL of the DiskConsistencyGroupPolicy for the group of disks to clone. This may be a full or partial URL, such as: - https://www.googleapis.com/compute/v1/projects/project/regions/region /resourcePolicies/resourcePolicy - projects/project/regions/region/resourcePolicies/resourcePolicy - regions/region/resourcePolicies/resourcePolicy
         */
        sourceConsistencyGroupPolicy?: string | null;
    }
    /**
     * A transient resource used in compute.instances.bulkInsert and compute.regionInstances.bulkInsert . This resource is not persisted anywhere, it is used only for processing the requests.
     */
    export interface Schema$BulkInsertInstanceResource {
        /**
         * The maximum number of instances to create.
         */
        count?: string | null;
        /**
         * A flexible specification of machine type of instances to create.
         */
        instanceFlexibilityPolicy?: Schema$InstanceFlexibilityPolicy;
        /**
         * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
         */
        instanceProperties?: Schema$InstanceProperties;
        /**
         * Policy for choosing target zone. For more information, see Create VMs in bulk.
         */
        locationPolicy?: Schema$LocationPolicy;
        /**
         * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
         */
        minCount?: string | null;
        /**
         * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
         */
        namePattern?: string | null;
        /**
         * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
         */
        perInstanceProperties?: {
            [key: string]: Schema$BulkInsertInstanceResourcePerInstanceProperties;
        } | null;
        /**
         * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
         */
        sourceInstanceTemplate?: string | null;
    }
    /**
     * Per-instance properties to be set on individual instances. To be extended in the future.
     */
    export interface Schema$BulkInsertInstanceResourcePerInstanceProperties {
        /**
         * Specifies the hostname of the instance. More details in: https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention
         */
        hostname?: string | null;
        /**
         * This field is only temporary. It will be removed. Do not use it.
         */
        name?: string | null;
    }
    export interface Schema$BulkInsertOperationStatus {
        /**
         * [Output Only] Count of VMs successfully created so far.
         */
        createdVmCount?: number | null;
        /**
         * [Output Only] Count of VMs that got deleted during rollback.
         */
        deletedVmCount?: number | null;
        /**
         * [Output Only] Count of VMs that started creating but encountered an error.
         */
        failedToCreateVmCount?: number | null;
        /**
         * [Output Only] Creation status of BulkInsert operation - information if the flow is rolling forward or rolling back.
         */
        status?: string | null;
        /**
         * [Output Only] Count of VMs originally planned to be created.
         */
        targetVmCount?: number | null;
    }
    export interface Schema$BulkSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You may optionally provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string | null;
        /**
         * The labels to set for this resource.
         */
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$BulkZoneSetLabelsRequest {
        requests?: Schema$BulkSetLabelsRequest[];
    }
    export interface Schema$BundledLocalSsds {
        /**
         * The default disk interface if the interface is not specified.
         */
        defaultInterface?: string | null;
        /**
         * The number of partitions.
         */
        partitionCount?: number | null;
    }
    export interface Schema$CacheInvalidationRule {
        /**
         * A list of cache tags used to identify cached objects. - Cache tags are specified when the response is first cached, by setting the `Cache-Tag` response header at the origin. - Multiple cache tags in the same invalidation request are treated as Boolean `OR` - for example, `tag1 OR tag2 OR tag3`. - If other fields are also specified, these are treated as Boolean `AND` with any tags. Up to 10 tags can be specified in a single invalidation request.
         */
        cacheTags?: string[] | null;
        /**
         * If set, this invalidation rule will only apply to requests with a Host header matching host.
         */
        host?: string | null;
        path?: string | null;
    }
    /**
     * Message containing what to include in the cache key for a request for Cloud CDN.
     */
    export interface Schema$CacheKeyPolicy {
        /**
         * If true, requests to different hosts will be cached separately.
         */
        includeHost?: boolean | null;
        /**
         * Allows HTTP request headers (by name) to be used in the cache key.
         */
        includeHttpHeaders?: string[] | null;
        /**
         * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
         */
        includeNamedCookies?: string[] | null;
        /**
         * If true, http and https requests will be cached separately.
         */
        includeProtocol?: boolean | null;
        /**
         * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
         */
        includeQueryString?: boolean | null;
        /**
         * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
         */
        queryStringBlacklist?: string[] | null;
        /**
         * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
         */
        queryStringWhitelist?: string[] | null;
    }
    /**
     * A request to recommend the best way to consume the specified resources in the future.
     */
    export interface Schema$CalendarModeAdviceRequest {
        /**
         * Specification of resources to create in the future. The key of the map is an arbitrary string specified by the caller. Value of the map is a specification of required resources and their constraints. Currently only one value is allowed in this map.
         */
        futureResourcesSpecs?: {
            [key: string]: Schema$FutureResourcesSpec;
        } | null;
    }
    /**
     * A response containing the recommended way of creating the specified resources in the future. It contains (will contain) multiple recommendations that can be analyzed by the customer and the best one can be picked.
     */
    export interface Schema$CalendarModeAdviceResponse {
        /**
         * Recommendations where, how and when to create the requested resources in order to maximize their obtainability and minimize cost.
         */
        recommendations?: Schema$CalendarModeRecommendation[];
    }
    /**
     * A single recommendation to create requested resources. Contains detailed recommendations for every future resources specification specified in CalendarModeAdviceRequest.
     */
    export interface Schema$CalendarModeRecommendation {
        /**
         * Recommendations for every future resource specification passed in CalendarModeAdviceRequest. Keys of the map correspond to keys specified in the request.
         */
        recommendationsPerSpec?: {
            [key: string]: Schema$FutureResourcesRecommendation;
        } | null;
    }
    /**
     * [Deprecated] gRPC call credentials to access the SDS server. gRPC call credentials to access the SDS server.
     */
    export interface Schema$CallCredentials {
        /**
         * The type of call credentials to use for GRPC requests to the SDS server. This field can be set to one of the following: - GCE_VM: The local GCE VM service account credentials are used to access the SDS server. - FROM_PLUGIN: Custom authenticator credentials are used to access the SDS server.
         */
        callCredentialType?: string | null;
        /**
         * Custom authenticator credentials. Valid if callCredentialType is FROM_PLUGIN.
         */
        fromPlugin?: Schema$MetadataCredentialsFromPlugin;
    }
    /**
     * A request to provide Assistant Scores. These scores determine VM obtainability and preemption likelihood.
     */
    export interface Schema$CapacityAdviceRequest {
        /**
         * Policy specifying the distribution of instances across zones within the requested region.
         */
        distributionPolicy?: Schema$CapacityAdviceRequestDistributionPolicy;
        /**
         * Policy for instance selectors.
         */
        instanceFlexibilityPolicy?: Schema$CapacityAdviceRequestInstanceFlexibilityPolicy;
        /**
         * Instance properties for this request.
         */
        instanceProperties?: Schema$CapacityAdviceRequestInstanceProperties;
    }
    export interface Schema$CapacityAdviceRequestDistributionPolicy {
        /**
         * The distribution shape to which the group converges.
         */
        targetShape?: string | null;
        /**
         * Zones where Capacity Advisor looks for capacity.
         */
        zones?: Schema$CapacityAdviceRequestDistributionPolicyZoneConfiguration[];
    }
    export interface Schema$CapacityAdviceRequestDistributionPolicyZoneConfiguration {
        /**
         * The URL of the zone.
         */
        zone?: string | null;
    }
    /**
     * Specification of alternative, flexible instance subsets.
     */
    export interface Schema$CapacityAdviceRequestInstanceFlexibilityPolicy {
        /**
         * Named instance selections configure properties. The key is an arbitrary, unique RFC1035 string that identifies the instance selection.
         */
        instanceSelections?: {
            [key: string]: Schema$CapacityAdviceRequestInstanceFlexibilityPolicyInstanceSelection;
        } | null;
    }
    /**
     * Machine specification.
     */
    export interface Schema$CapacityAdviceRequestInstanceFlexibilityPolicyInstanceSelection {
        /**
         * Full machine-type names, e.g. "n1-standard-16".
         */
        machineTypes?: string[] | null;
    }
    /**
     * Instance provisining properties.
     */
    export interface Schema$CapacityAdviceRequestInstanceProperties {
        /**
         * Specifies the scheduling options.
         */
        scheduling?: Schema$CapacityAdviceRequestInstancePropertiesScheduling;
    }
    /**
     * Defines the instance scheduling options.
     */
    export interface Schema$CapacityAdviceRequestInstancePropertiesScheduling {
        /**
         * Specifies the provisioning model of the instance.
         */
        provisioningModel?: string | null;
    }
    /**
     * A response contains multiple scoring recommendations.
     */
    export interface Schema$CapacityAdviceResponse {
        /**
         * Initially the API will provide one recommendation which balances the individual scores according to Google's preference.
         */
        recommendations?: Schema$CapacityAdviceResponseRecommendation[];
    }
    export interface Schema$CapacityAdviceResponseRecommendation {
        scores?: Schema$CapacityAdviceResponseRecommendationScores;
        shards?: Schema$CapacityAdviceResponseRecommendationShard[];
    }
    /**
     * The Scores message groups information about a shard of capacity.
     */
    export interface Schema$CapacityAdviceResponseRecommendationScores {
        /**
         * The obtainability score indicates the likelihood of successfully obtaining (provisioning) the requested number of VMs. The score range is 0.0 through 1.0. Higher is better.
         */
        obtainability?: number | null;
        /**
         * The preemption score indicates the likelihood that your Spot VMs is preempted. For more information about the preemption process, see Preemption of Spot VMs. The score range is 0.0 through 1.0. Higher is better.
         */
        spotPreemption?: number | null;
    }
    /**
     * Shards represent blocks of uniform capacity in recommendations. Each shard is for a single zone, single instance selection, and a single machine shape. Each shard defines a size expressed as the number of VMs.
     */
    export interface Schema$CapacityAdviceResponseRecommendationShard {
        instanceCount?: number | null;
        /**
         * The machine type corresponds to the instance selection in the request.
         */
        machineType?: string | null;
        /**
         * Provisioning model of the recommended capacity.
         */
        provisioningModel?: string | null;
        /**
         * The zone name for this shard.
         */
        zone?: string | null;
    }
    /**
     * [Deprecated] gRPC channel credentials to access the SDS server. gRPC channel credentials to access the SDS server.
     */
    export interface Schema$ChannelCredentials {
        /**
         * The call credentials to access the SDS server.
         */
        certificates?: Schema$TlsCertificatePaths;
        /**
         * The channel credentials to access the SDS server. This field can be set to one of the following: CERTIFICATES: Use TLS certificates to access the SDS server. GCE_VM: Use local GCE VM credentials to access the SDS server.
         */
        channelCredentialType?: string | null;
    }
    /**
     * Settings controlling the volume of requests, connections and retries to this backend service.
     */
    export interface Schema$CircuitBreakers {
        /**
         * The timeout for new network connections to hosts.
         */
        connectTimeout?: Schema$Duration;
        /**
         * The maximum number of connections to the backend service. If not specified, there is no limit. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        maxConnections?: number | null;
        /**
         * The maximum number of pending requests allowed to the backend service. If not specified, there is no limit. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        maxPendingRequests?: number | null;
        /**
         * The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
         */
        maxRequests?: number | null;
        /**
         * Maximum requests for a single connection to the backend service. This parameter is respected by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this parameter to 1 will effectively disable keep alive. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        maxRequestsPerConnection?: number | null;
        /**
         * The maximum number of parallel retries allowed to the backend cluster. If not specified, the default is 1. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        maxRetries?: number | null;
    }
    /**
     * [Deprecated] The client side authentication settings for connection originating from the backend service. the backend service.
     */
    export interface Schema$ClientTlsSettings {
        /**
         * Configures the mechanism to obtain client-side security certificates and identity information. This field is only applicable when mode is set to MUTUAL.
         */
        clientTlsContext?: Schema$TlsContext;
        /**
         * Indicates whether connections to this port should be secured using TLS. The value of this field determines how TLS is enforced. This can be set to one of the following values: DISABLE: Do not setup a TLS connection to the backends. SIMPLE: Originate a TLS connection to the backends. MUTUAL: Secure connections to the backends using mutual TLS by presenting client certificates for authentication.
         */
        mode?: string | null;
        /**
         * SNI string to present to the server during TLS handshake. This field is applicable only when mode is SIMPLE or MUTUAL.
         */
        sni?: string | null;
        /**
         * A list of alternate names to verify the subject identity in the certificate.If specified, the proxy will verify that the server certificate's subject alt name matches one of the specified values. This field is applicable only when mode is SIMPLE or MUTUAL.
         */
        subjectAltNames?: string[] | null;
    }
    /**
     * Represents a regional resource-based commitment resource. Creating this commitment resource means that you are purchasing a resource-based committed use contract, with an explicit start and end time. You can purchase resource-based commitments for both hardware and software resources. For more information, read Resource-based committed use discounts
     */
    export interface Schema$Commitment {
        /**
         * Specifies whether to automatically renew the commitment at the end of its current term. The default value is false. If you set the field to true, each time your commitment reaches the end of its term, Compute Engine automatically renews it for another term. You can update this field anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
         */
        autoRenew?: boolean | null;
        /**
         * The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
         */
        category?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Input Only] Optional, specifies the requested commitment end time in RFC3339 text format. Use this option when the desired commitment's end date is later than the start date + term duration.
         */
        customEndTimestamp?: string | null;
        /**
         * An optional description of the commitment. You can provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Commitment end time in RFC3339 text format.
         */
        endTimestamp?: string | null;
        existingReservations?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#commitment for commitments.
         */
        kind?: string | null;
        /**
         * The license specification required as part of a license commitment.
         */
        licenseResource?: Schema$LicenseResourceCommitment;
        /**
         * The list of source commitments that you are merging to create the new merged commitment. For more information, see Merging commitments.
         */
        mergeSourceCommitments?: string[] | null;
        /**
         * Name of the commitment. You must specify a name when you purchase the commitment. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
         */
        plan?: string | null;
        /**
         * [Output Only] URL of the region where the commitment and committed resources are located.
         */
        region?: string | null;
        /**
         * The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
         */
        reservations?: Schema$Reservation[];
        /**
         * The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
         */
        resources?: Schema$ResourceCommitment[];
        /**
         * [Output Only] Status information for Commitment resource.
         */
        resourceStatus?: Schema$CommitmentResourceStatus;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The source commitment from which you are transferring resources to create the new split commitment. For more information, see Split commitments.
         */
        splitSourceCommitment?: string | null;
        /**
         * [Output Only] Commitment start time in RFC3339 text format.
         */
        startTimestamp?: string | null;
        /**
         * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
         */
        status?: string | null;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string | null;
        /**
         * The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
         */
        type?: string | null;
    }
    export interface Schema$CommitmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of CommitmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$CommitmentsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Commitment resources.
     */
    export interface Schema$CommitmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Commitment resources.
         */
        items?: Schema$Commitment[];
        /**
         * [Output Only] Type of resource. Always compute#commitmentList for lists of commitments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * [Output Only] Contains output only fields.
     */
    export interface Schema$CommitmentResourceStatus {
        /**
         * [Output Only] An optional, contains all the needed information of cancellation.
         */
        cancellationInformation?: Schema$CommitmentResourceStatusCancellationInformation;
        /**
         * [Output Only] Indicates the end time of customer's eligibility to send custom term requests in RFC3339 text format. Term extension requests that (not the end time in the request) after this time will be rejected.
         */
        customTermEligibilityEndTimestamp?: string | null;
    }
    export interface Schema$CommitmentResourceStatusCancellationInformation {
        /**
         * [Output Only] An optional amount of CUDs canceled so far in the last 365 days.
         */
        canceledCommitment?: Schema$Money;
        /**
         * [Output Only] An optional last update time of canceled_commitment. RFC3339 text format.
         */
        canceledCommitmentLastUpdatedTimestamp?: string | null;
        /**
         * [Output Only] An optional,the cancellation cap for how much commitments can be canceled in a rolling 365 per billing account.
         */
        cancellationCap?: Schema$Money;
        /**
         * [Output Only] An optional, cancellation fee.
         */
        cancellationFee?: Schema$Money;
        /**
         * [Output Only] An optional, cancellation fee expiration time. RFC3339 text format.
         */
        cancellationFeeExpirationTimestamp?: string | null;
    }
    export interface Schema$CommitmentsScopedList {
        /**
         * [Output Only] The list of commitments contained in this scope.
         */
        commitments?: Schema$Commitment[];
        /**
         * [Output Only] Informational warning which replaces the list of commitments when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a composite health check. A composite health check resource specifies the health source resources and the health destination resource to which the aggregated health result from the health source resources is delivered.
     */
    export interface Schema$CompositeHealthCheck {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a CompositeHealthCheck. An up-to-date fingerprint must be provided in order to patch the CompositeHealthCheck; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the CompositeHealthCheck.
         */
        fingerprint?: string | null;
        /**
         * URL to the destination resource. Must be set. Must be a ForwardingRule. The ForwardingRule must have load balancing scheme INTERNAL or INTERNAL_MANAGED and must be regional and in the same region as the CompositeHealthCheck (cross-region deployment for INTERNAL_MANAGED is not supported). Can be mutated.
         */
        healthDestination?: string | null;
        /**
         * URLs to the HealthSource resources whose results are AND'ed. I.e. he aggregated result is is HEALTHY only if all sources are HEALTHY. Must have at least 1. Must not have more than 10. Must be regional and in the same region as the CompositeHealthCheck. Can be mutated.
         */
        healthSources?: string[] | null;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#compositeHealthCheck for composite health checks.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the composite health check resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Contains a list of CompositeHealthChecksScopedList.
     */
    export interface Schema$CompositeHealthCheckAggregatedList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of CompositeHealthChecksScopedList resources.
         */
        items?: {
            [key: string]: Schema$CompositeHealthChecksScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$CompositeHealthCheckList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of CompositeHealthCheck resources.
         */
        items?: Schema$CompositeHealthCheck[];
        /**
         * [Output Only] Type of the resource. Always compute#compositeHealthCheck for composite health checks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$CompositeHealthChecksScopedList {
        /**
         * A list of CompositeHealthChecks contained in this scope.
         */
        resources?: Schema$CompositeHealthCheck[];
        /**
         * Informational warning which replaces the list of composite health checks when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A set of Confidential Instance options.
     */
    export interface Schema$ConfidentialInstanceConfig {
        /**
         * Defines the type of technology used by the confidential instance.
         */
        confidentialInstanceType?: string | null;
        /**
         * Defines a set of Confidential Paravisor (SVSM) options.
         */
        confidentialParavisorConfig?: Schema$ConfidentialParavisorConfig;
        /**
         * Defines whether the instance should have confidential compute enabled.
         */
        enableConfidentialCompute?: boolean | null;
    }
    /**
     * A set of Confidential Paravisor (SVSM) options.
     */
    export interface Schema$ConfidentialParavisorConfig {
        confidentialTpmType?: string | null;
        sevSnpIrqMode?: string | null;
    }
    /**
     * Message containing connection draining configuration.
     */
    export interface Schema$ConnectionDraining {
        /**
         * Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
         */
        drainingTimeoutSec?: number | null;
    }
    /**
     * This message defines settings for a consistent hash style load balancer.
     */
    export interface Schema$ConsistentHashLoadBalancerSettings {
        /**
         * Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        httpCookie?: Schema$ConsistentHashLoadBalancerSettingsHttpCookie;
        /**
         * The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
         */
        httpHeaderName?: string | null;
        /**
         * The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
         */
        minimumRingSize?: string | null;
    }
    /**
     * The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
     */
    export interface Schema$ConsistentHashLoadBalancerSettingsHttpCookie {
        /**
         * Name of the cookie.
         */
        name?: string | null;
        /**
         * Path to set for the cookie.
         */
        path?: string | null;
        /**
         * Lifetime of the cookie.
         */
        ttl?: Schema$Duration;
    }
    /**
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
     */
    export interface Schema$CorsPolicy {
        /**
         * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
         */
        allowCredentials?: boolean | null;
        /**
         * Specifies the content for the Access-Control-Allow-Headers header.
         */
        allowHeaders?: string[] | null;
        /**
         * Specifies the content for the Access-Control-Allow-Methods header.
         */
        allowMethods?: string[] | null;
        /**
         * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
         */
        allowOriginRegexes?: string[] | null;
        /**
         * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
         */
        allowOrigins?: string[] | null;
        /**
         * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
         */
        disabled?: boolean | null;
        /**
         * Specifies the content for the Access-Control-Expose-Headers header.
         */
        exposeHeaders?: string[] | null;
        /**
         * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
         */
        maxAge?: number | null;
    }
    /**
     * A resource that represents a cross-site network. You can use cross-site networks to connect your on-premises networks to each other through Interconnect connections.
     */
    export interface Schema$CrossSiteNetwork {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of the cross-site network.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#crossSiteNetwork for cross-site networks.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Response to the list request that contains a list of cross-site networks.
     */
    export interface Schema$CrossSiteNetworkList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of CrossSiteNetwork resources.
         */
        items?: Schema$CrossSiteNetwork[];
        /**
         * [Output Only] Type of the resource. Always compute#crossSiteNetwork for cross-site networks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$CustomerEncryptionKey {
        /**
         * The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key The fully-qualifed key name may be returned for resource GET requests. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeyVersions/1
         */
        kmsKeyName?: string | null;
        /**
         * The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/
         */
        kmsKeyServiceAccount?: string | null;
        /**
         * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
         */
        rawKey?: string | null;
        /**
         * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
         */
        rsaEncryptedKey?: string | null;
        /**
         * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
         */
        sha256?: string | null;
    }
    export interface Schema$CustomerEncryptionKeyProtectedDisk {
        /**
         * Decrypts data associated with the disk with a customer-supplied encryption key.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks. For example: "source": "/compute/v1/projects/project_id/zones/zone/disks/ disk_name
         */
        source?: string | null;
    }
    /**
     * Specifies the custom error response policy that must be applied when the backend service or backend bucket responds with an error.
     */
    export interface Schema$CustomErrorResponsePolicy {
        /**
         * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
         */
        errorResponseRules?: Schema$CustomErrorResponsePolicyCustomErrorResponseRule[];
        /**
         * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
         */
        errorService?: string | null;
    }
    /**
     * Specifies the mapping between the response code that will be returned along with the custom error content and the response code returned by the backend service.
     */
    export interface Schema$CustomErrorResponsePolicyCustomErrorResponseRule {
        /**
         * Valid values include: - A number between 400 and 599: For example 401 or 503, in which case the load balancer applies the policy if the error code exactly matches this value. - 5xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 500 to 599. - 4xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 400 to 499. Values must be unique within matchResponseCodes and across all errorResponseRules of CustomErrorResponsePolicy.
         */
        matchResponseCodes?: string[] | null;
        /**
         * The HTTP status code returned with the response containing the custom error content. If overrideResponseCode is not supplied, the same response code returned by the original backend bucket or backend service is returned to the client.
         */
        overrideResponseCode?: number | null;
        /**
         * The full path to a file within backendBucket . For example: /errors/defaultError.html path must start with a leading slash. path cannot have trailing slashes. If the file is not available in backendBucket or the load balancer cannot reach the BackendBucket, a simple Not Found Error is returned to the client. The value must be from 1 to 1024 characters
         */
        path?: string | null;
    }
    /**
     * Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
     */
    export interface Schema$Date {
        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
         */
        day?: number | null;
        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        month?: number | null;
        /**
         * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
         */
        year?: number | null;
    }
    /**
     * Deprecation status for a public resource.
     */
    export interface Schema$DeprecationStatus {
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
         */
        deleted?: string | null;
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
         */
        deprecated?: string | null;
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
         */
        obsolete?: string | null;
        /**
         * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
         */
        replacement?: string | null;
        /**
         * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
         */
        state?: string | null;
        /**
         * The rollout policy for this deprecation. This policy is only enforced by image family views. The rollout policy restricts the zones where the associated resource is considered in a deprecated state. When the rollout policy does not include the user specified zone, or if the zone is rolled out, the associated resource is considered in a deprecated state. The rollout policy for this deprecation is read-only, except for allowlisted users. This field might not be configured. To view the latest non-deprecated image in a specific zone, use the imageFamilyViews.get method.
         */
        stateOverride?: Schema$RolloutPolicy;
    }
    /**
     * Represents a Persistent Disk resource. Google Compute Engine has two Disk resources: * [Zonal](/compute/docs/reference/rest/alpha/disks) * [Regional](/compute/docs/reference/rest/alpha/regionDisks) Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options. The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks. The regionDisks resource represents a regional persistent disk. For more information, read Regional resources.
     */
    export interface Schema$Disk {
        /**
         * The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
         */
        accessMode?: string | null;
        /**
         * The architecture of the disk. Valid values are ARM64 or X86_64.
         */
        architecture?: string | null;
        /**
         * Disk asynchronously replicated into this disk.
         */
        asyncPrimaryDisk?: Schema$DiskAsyncReplication;
        /**
         * [Output Only] A list of disks this disk is asynchronously replicated to.
         */
        asyncSecondaryDisks?: {
            [key: string]: Schema$DiskAsyncReplicationList;
        } | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Whether this disk is using confidential compute mode.
         */
        enableConfidentialCompute?: boolean | null;
        /**
         * Specifies whether the disk restored from a source snapshot should erase Windows specific VSS signature.
         */
        eraseWindowsVssSignature?: boolean | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
         */
        interface?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#disk for disks.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this disk. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Last attach timestamp in RFC3339 text format.
         */
        lastAttachTimestamp?: string | null;
        /**
         * [Output Only] Last detach timestamp in RFC3339 text format.
         */
        lastDetachTimestamp?: string | null;
        /**
         * Integer license codes indicating which licenses are attached to this disk.
         */
        licenseCodes?: string[] | null;
        /**
         * A list of publicly visible licenses. Reserved for Google's use.
         */
        licenses?: string[] | null;
        /**
         * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
         */
        locationHint?: string | null;
        /**
         * [Output Only] The field indicates if the disk is created from a locked source image. Attachment of a disk created from a locked source image will cause the following operations to become irreversibly prohibited: - R/W or R/O disk attachment to any other instance - Disk detachment. And the disk can only be deleted when the instance is deleted - Creation of images or snapshots - Disk cloning Furthermore, the instance with at least one disk with locked flag set to true will be prohibited from performing the operations below: - Further attachment of secondary disks. - Detachment of any disks - Create machine images - Create instance template - Delete the instance with --keep-disk parameter set to true for locked disks - Attach a locked disk with --auto-delete parameter set to false
         */
        locked?: boolean | null;
        /**
         * Indicates whether or not the disk can be read/write attached to more than one instance.
         */
        multiWriter?: boolean | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Internal use only.
         */
        options?: string | null;
        /**
         * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
         */
        params?: Schema$DiskParams;
        /**
         * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
         */
        physicalBlockSizeBytes?: string | null;
        /**
         * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
         */
        provisionedIops?: string | null;
        /**
         * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
         */
        provisionedThroughput?: string | null;
        /**
         * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
         */
        replicaZones?: string[] | null;
        /**
         * Resource policies applied to this disk for automatic snapshot creations.
         */
        resourcePolicies?: string[] | null;
        /**
         * [Output Only] Status information for the disk resource.
         */
        resourceStatus?: Schema$DiskResourceStatus;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
         */
        sizeGb?: string | null;
        /**
         * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
         */
        sourceConsistencyGroupPolicy?: string | null;
        /**
         * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
         */
        sourceConsistencyGroupPolicyId?: string | null;
        /**
         * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
         */
        sourceDisk?: string | null;
        /**
         * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
         */
        sourceDiskId?: string | null;
        /**
         * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
         */
        sourceImage?: string | null;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
         */
        sourceImageId?: string | null;
        /**
         * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
         */
        sourceInstantSnapshot?: string | null;
        /**
         * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
         */
        sourceInstantSnapshotId?: string | null;
        /**
         * The machine image to create the disk from. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/machineImages/machineImage - projects/project/global/machineImages/machineImage - global/machineImages/machineImage
         */
        sourceMachineImage?: string | null;
        /**
         * Input only. The device name of a disk within a given machine image. The source_machine_image must be specified.
         */
        sourceMachineImageDiskDeviceName?: string | null;
        /**
         * The customer-supplied encryption key of the source machine image. Required if the source machine image is protected by a customer-supplied encryption key.
         */
        sourceMachineImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The unique ID of the machine image used to create this disk. This value identifies the exact machine image that was used to create this persistent disk. For example, if you created the persistent disk from a machine image that was later deleted and recreated under the same name, the source machine image ID would identify the exact version of the machine image that was used.
         */
        sourceMachineImageId?: string | null;
        /**
         * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot
         */
        sourceSnapshot?: string | null;
        /**
         * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
         */
        sourceSnapshotId?: string | null;
        /**
         * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
         */
        sourceStorageObject?: string | null;
        /**
         * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
         */
        status?: string | null;
        /**
         * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
         */
        storagePool?: string | null;
        /**
         * [Deprecated] Storage type of the persistent disk.
         */
        storageType?: string | null;
        /**
         * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
         */
        type?: string | null;
        /**
         * A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license: https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch
         */
        userLicenses?: string[] | null;
        /**
         * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
         */
        users?: string[] | null;
        /**
         * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$DiskAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DisksScopedList resources.
         */
        items?: {
            [key: string]: Schema$DisksScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$DiskAsyncReplication {
        /**
         * [Output Only] URL of the DiskConsistencyGroupPolicy if replication was started on the disk as a member of a group.
         */
        consistencyGroupPolicy?: string | null;
        /**
         * [Output Only] ID of the DiskConsistencyGroupPolicy if replication was started on the disk as a member of a group.
         */
        consistencyGroupPolicyId?: string | null;
        /**
         * The other disk asynchronously replicated to or from the current disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk
         */
        disk?: string | null;
        /**
         * [Output Only] The unique ID of the other disk asynchronously replicated to or from the current disk. This value identifies the exact disk that was used to create this replication. For example, if you started replicating the persistent disk from a disk that was later deleted and recreated under the same name, the disk ID would identify the exact version of the disk that was used.
         */
        diskId?: string | null;
    }
    export interface Schema$DiskAsyncReplicationList {
        asyncReplicationDisk?: Schema$DiskAsyncReplication;
    }
    /**
     * A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
     */
    export interface Schema$DiskInstantiationConfig {
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean | null;
        /**
         * The custom source image to be used to restore this disk when instantiating this instance template.
         */
        customImage?: string | null;
        /**
         * Specifies the device name of the disk to which the configurations apply to.
         */
        deviceName?: string | null;
        /**
         * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
         */
        instantiateFrom?: string | null;
    }
    /**
     * A list of Disk resources.
     */
    export interface Schema$DiskList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Disk resources.
         */
        items?: Schema$Disk[];
        /**
         * [Output Only] Type of resource. Always compute#diskList for lists of disks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$DiskMoveRequest {
        /**
         * The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - https://www.googleapis.com/compute/v1/projects/project/zones/zone - projects/project/zones/zone - zones/zone
         */
        destinationZone?: string | null;
        /**
         * The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk
         */
        targetDisk?: string | null;
    }
    export interface Schema$DiskPairReplicationState {
        /**
         * [Output Only] The status of disk creation. - ASYNC_REPLICATION_STATE_INITIALIZING: The device is doing the initial replication after starting the replication. - ASYNC_REPLICATION_STATE_REPLICATING_HEALTHY: The primary disk is healthily replicating to the secondary device i.e. last_replication_time is within RPO. - ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_HIGH_CHURN: The replication is lagging above the SLO limit due to the disk's change rate being above the supported limit. - ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_SYSTEM_LAGGING: The replication is lagging, and the RPO is not being met due to some internal issue. - ASYNC_REPLICATION_STATE_REPLICATION_STUCK: The replication is completely stuck due to some internal error. - ASYNC_REPLICATION_STATE_STOPPING: The replication is under the process of being stopped. This is a transient state. - ASYNC_REPLICATION_STATE_STOPPED: The replication between the disk-pairs have stopped. - ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_CG_HIGH_CHURN: The replication is lagging above the SLO limit for the disk in the consistency group due to disk's change rate being above the supported limit.
         */
        dataReplicationState?: string | null;
        replicationDiskPair?: Schema$ReplicationDiskPair;
    }
    /**
     * Additional disk params.
     */
    export interface Schema$DiskParams {
        /**
         * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id\}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$DiskResourceStatus {
        asyncPrimaryDisk?: Schema$DiskResourceStatusAsyncReplicationStatus;
        /**
         * Key: disk, value: AsyncReplicationStatus message
         */
        asyncSecondaryDisks?: {
            [key: string]: Schema$DiskResourceStatusAsyncReplicationStatus;
        } | null;
        /**
         * [Output Only] Space used by data stored in the disk (in bytes). Note that this field is set only when the disk is in a storage pool.
         */
        usedBytes?: string | null;
    }
    export interface Schema$DiskResourceStatusAsyncReplicationStatus {
        state?: string | null;
    }
    export interface Schema$DisksAddResourcePoliciesRequest {
        /**
         * Full or relative path to the resource policy to be added to this disk. You can only specify one resource policy.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$DiskSettings {
        /**
         * Policy of which locations are allowed to create regional snapshots.
         */
        accessLocation?: Schema$DiskSettingsAccessLocation;
        /**
         * An optional parameter for storing the default resource policies that will be used for the Disks created in the given scope. The Key is a string type, provided by customers to uniquely identify the default Resource Policy entry. The Value is a Default ResourcePolicyDetails Object used to represent the detailed information of the Resource Policy entry.
         */
        defaultResourcePolicies?: {
            [key: string]: Schema$DiskSettingsResourcePolicyDetails;
        } | null;
    }
    /**
     * AccessLocation is only used for regional snapshot. It contains which regions are allowed to create a regional snapshot from disks located in the given region/zone. It includes key-value pairs designed to store the following structure. The keys should match their corresponding values, which must be provided: access_location: { locations { us-central1 { region: "us-central1" \}, asia-west2 { region: "asia-west2" \} \} \}
     */
    export interface Schema$DiskSettingsAccessLocation {
        /**
         * List of regions that can create a regional snapshot from the current region
         */
        locations?: {
            [key: string]: Schema$DiskSettingsAccessLocationAccessLocationPreference;
        } | null;
        /**
         * Policy of which location is allowed to access snapshot.
         */
        policy?: string | null;
    }
    /**
     * A structure for specifying an allowed target region to create snapshot.
     */
    export interface Schema$DiskSettingsAccessLocationAccessLocationPreference {
        /**
         * Accessible region name
         */
        region?: string | null;
    }
    /**
     * This is the object for storing the detail information about the Resource Policy that will be set as default ones for the Disks that is using the DiskSettings. It contains: - one target Resource Policy referenced by its Fully-Qualified URL, - [output only] Disk Types that will be excluded from using this Resource Policy, - Other filtering support (e.g. Label filtering) for Default Resource Policy can be added here as well
     */
    export interface Schema$DiskSettingsResourcePolicyDetails {
        /**
         * [Output Only] A list of Disk Types that will be excluded from applying the Resource Policy referenced here. If absent, Disks created in any DiskType can use the referenced default Resource Policy.
         */
        excludedDiskTypes?: string[] | null;
        /**
         * The target Resource Policies identified by their Fully-Qualified URL.
         */
        resourcePolicy?: string | null;
    }
    export interface Schema$DisksRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this disk.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$DisksResizeRequest {
        /**
         * The new size of the persistent disk, which is specified in GB.
         */
        sizeGb?: string | null;
    }
    export interface Schema$DisksScopedList {
        /**
         * [Output Only] A list of disks contained in this scope.
         */
        disks?: Schema$Disk[];
        /**
         * [Output Only] Informational warning which replaces the list of disks when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$DisksStartAsyncReplicationRequest {
        /**
         * The secondary disk to start asynchronous replication to. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
         */
        asyncSecondaryDisk?: string | null;
    }
    /**
     * A transient resource used in compute.disks.stopGroupAsyncReplication and compute.regionDisks.stopGroupAsyncReplication. It is only used to process requests and is not persisted.
     */
    export interface Schema$DisksStopGroupAsyncReplicationResource {
        /**
         * The URL of the DiskConsistencyGroupPolicy for the group of disks to stop. This may be a full or partial URL, such as: - https://www.googleapis.com/compute/v1/projects/project/regions/region /resourcePolicies/resourcePolicy - projects/project/regions/region/resourcePolicies/resourcePolicy - regions/region/resourcePolicies/resourcePolicy
         */
        resourcePolicy?: string | null;
    }
    /**
     * Represents a Disk Type resource. Google Compute Engine has two Disk Type resources: * [Regional](/compute/docs/reference/rest/alpha/regionDiskTypes) * [Zonal](/compute/docs/reference/rest/alpha/diskTypes) You can choose from a variety of disk types based on your needs. For more information, read Storage options. The diskTypes resource represents disk types for a zonal persistent disk. For more information, read Zonal persistent disks. The regionDiskTypes resource represents disk types for a regional persistent disk. For more information, read Regional persistent disks.
     */
    export interface Schema$DiskType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] Server-defined default disk size in GB.
         */
        defaultDiskSizeGb?: string | null;
        /**
         * [Output Only] The deprecation status associated with this disk type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#diskType for disk types.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] An optional textual description of the valid disk size, such as "10GB-10TB".
         */
        validDiskSize?: string | null;
        /**
         * [Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$DiskTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DiskTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$DiskTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of disk types.
     */
    export interface Schema$DiskTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DiskType resources.
         */
        items?: Schema$DiskType[];
        /**
         * [Output Only] Type of resource. Always compute#diskTypeList for disk types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$DiskTypesScopedList {
        /**
         * [Output Only] A list of disk types contained in this scope.
         */
        diskTypes?: Schema$DiskType[];
        /**
         * [Output Only] Informational warning which replaces the list of disk types when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A set of Display Device options
     */
    export interface Schema$DisplayDevice {
        /**
         * Defines whether the instance has Display enabled.
         */
        enableDisplay?: boolean | null;
    }
    export interface Schema$DistributionPolicy {
        /**
         * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
         */
        targetShape?: string | null;
        /**
         * Zones where the regional managed instance group will create and manage its instances.
         */
        zones?: Schema$DistributionPolicyZoneConfiguration[];
    }
    export interface Schema$DistributionPolicyZoneConfiguration {
        /**
         * The URL of the zone. The zone must exist in the region where the managed instance group is located.
         */
        zone?: string | null;
    }
    /**
     * A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
     */
    export interface Schema$Duration {
        /**
         * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
         */
        nanos?: number | null;
        /**
         * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
         */
        seconds?: string | null;
    }
    /**
     * Describes the cause of the error with structured details. Example of an error when contacting the "pubsub.googleapis.com" API when it is not enabled: { "reason": "API_DISABLED" "domain": "googleapis.com" "metadata": { "resource": "projects/123", "service": "pubsub.googleapis.com" \} \} This response indicates that the pubsub.googleapis.com API is not enabled. Example of an error that is returned when attempting to create a Spanner instance in a region that is out of stock: { "reason": "STOCKOUT" "domain": "spanner.googleapis.com", "metadata": { "availableRegions": "us-central1,us-east2" \} \}
     */
    export interface Schema$ErrorInfo {
        /**
         * The logical grouping to which the "reason" belongs. The error domain is typically the registered service name of the tool or product that generates the error. Example: "pubsub.googleapis.com". If the error is generated by some common infrastructure, the error domain must be a globally unique value that identifies the infrastructure. For Google API infrastructure, the error domain is "googleapis.com".
         */
        domain?: string | null;
        /**
         * Additional structured details about this error. Keys must match a regular expression of `a-z+` but should ideally be lowerCamelCase. Also, they must be limited to 64 characters in length. When identifying the current value of an exceeded limit, the units should be contained in the key, not the value. For example, rather than `{"instanceLimit": "100/request"\}`, should be returned as, `{"instanceLimitPerRequest": "100"\}`, if the client exceeds the number of instances that can be created in a single (batch) request.
         */
        metadatas?: {
            [key: string]: string;
        } | null;
        /**
         * The reason of the error. This is a constant value that identifies the proximate cause of the error. Error reasons are unique within a particular domain of errors. This should be at most 63 characters and match a regular expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
         */
        reason?: string | null;
    }
    export interface Schema$ExchangedPeeringRoute {
        /**
         * The destination range of the route.
         */
        destRange?: string | null;
        /**
         * True if the peering route has been imported from a peer. The actual import happens if the field networkPeering.importCustomRoutes is true for this network, and networkPeering.exportCustomRoutes is true for the peer network, and the import does not result in a route conflict.
         */
        imported?: boolean | null;
        /**
         * The region of peering route next hop, only applies to dynamic routes.
         */
        nextHopRegion?: string | null;
        /**
         * The priority of the peering route.
         */
        priority?: number | null;
        /**
         * The type of the peering route.
         */
        type?: string | null;
    }
    export interface Schema$ExchangedPeeringRoutesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ExchangedPeeringRoute resources.
         */
        items?: Schema$ExchangedPeeringRoute[];
        /**
         * [Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for exchanged peering routes lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
     */
    export interface Schema$Expr {
        /**
         * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string | null;
        /**
         * Textual representation of an expression in Common Expression Language syntax.
         */
        expression?: string | null;
        /**
         * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string | null;
        /**
         * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string | null;
    }
    /**
     * Represents an external VPN gateway. External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway. To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway. For more information about using external VPN gateways, see Creating an HA VPN gateway and tunnel pair to a peer VPN.
     */
    export interface Schema$ExternalVpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
         */
        interfaces?: Schema$ExternalVpnGatewayInterface[];
        /**
         * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Indicates the user-supplied redundancy type of this external VPN gateway.
         */
        redundancyType?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
    }
    /**
     * The interface for the external VPN gateway.
     */
    export interface Schema$ExternalVpnGatewayInterface {
        /**
         * The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
         */
        id?: number | null;
        /**
         * IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
         */
        ipAddress?: string | null;
        /**
         * IPv6 address of the interface in the external VPN gateway. This IPv6 address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine. Must specify an IPv6 address (not IPV4-mapped) using any format described in RFC 4291 (e.g. 2001:db8:0:0:2d9:51:0:0). The output format is RFC 5952 format (e.g. 2001:db8::2d9:51:0:0).
         */
        ipv6Address?: string | null;
    }
    /**
     * Response to the list request, and contains a list of externalVpnGateways.
     */
    export interface Schema$ExternalVpnGatewayList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ExternalVpnGateway resources.
         */
        items?: Schema$ExternalVpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#externalVpnGatewayList for lists of externalVpnGateways.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$FileContentBuffer {
        /**
         * The raw content in the secure keys file.
         */
        content?: string | null;
        /**
         * The file type of source file.
         */
        fileType?: string | null;
    }
    /**
     * Represents a Firewall Rule resource. Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
     */
    export interface Schema$Firewall {
        /**
         * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
         */
        allowed?: Array<{
            IPProtocol?: string;
            ports?: string[];
        }> | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
         */
        denied?: Array<{
            IPProtocol?: string;
            ports?: string[];
        }> | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
         */
        destinationRanges?: string[] | null;
        /**
         * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
         */
        direction?: string | null;
        /**
         * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
         */
        disabled?: boolean | null;
        /**
         * Deprecated in favor of enable in LogConfig. This field denotes whether to enable logging for a particular firewall rule. If logging is enabled, logs will be exported t Cloud Logging.
         */
        enableLogging?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
         */
        kind?: string | null;
        /**
         * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
         */
        logConfig?: Schema$FirewallLogConfig;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
         */
        network?: string | null;
        /**
         * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
         */
        params?: Schema$FirewallParams;
        /**
         * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
         */
        priority?: number | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
         */
        sourceRanges?: string[] | null;
        /**
         * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
         */
        sourceServiceAccounts?: string[] | null;
        /**
         * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
         */
        sourceTags?: string[] | null;
        /**
         * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
         */
        targetServiceAccounts?: string[] | null;
        /**
         * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
         */
        targetTags?: string[] | null;
    }
    /**
     * Contains a list of firewalls.
     */
    export interface Schema$FirewallList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Firewall resources.
         */
        items?: Schema$Firewall[];
        /**
         * [Output Only] Type of resource. Always compute#firewallList for lists of firewalls.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * The available logging options for a firewall rule.
     */
    export interface Schema$FirewallLogConfig {
        /**
         * This field denotes whether to enable logging for a particular firewall rule.
         */
        enable?: boolean | null;
        /**
         * This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
         */
        metadata?: string | null;
    }
    /**
     * Additional firewall parameters.
     */
    export interface Schema$FirewallParams {
        /**
         * Tag keys/values directly bound to this resource. Tag keys and values have the same definition as resource manager tags. The field is allowed for INSERT only. The keys/values to set on the resource should be specified in either ID { : \} or Namespaced format { : \}. For example the following are valid inputs: * {"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"\} * {"123/environment" : "production", "345/abc" : "xyz"\} Note: * Invalid combinations of ID & namespaced format is not supported. For instance: {"123/environment" : "tagValues/444"\} is invalid.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$FirewallPoliciesListAssociationsResponse {
        /**
         * A list of associations.
         */
        associations?: Schema$FirewallPolicyAssociation[];
        /**
         * [Output Only] Type of firewallPolicy associations. Always compute#FirewallPoliciesListAssociations for lists of firewallPolicy associations.
         */
        kind?: string | null;
    }
    export interface Schema$FirewallPoliciesScopedList {
        /**
         * A list of firewall policies contained in this scope.
         */
        firewallPolicies?: Schema$FirewallPolicy[];
        /**
         * Informational warning which replaces the list of firewall policies when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Firewall Policy resource.
     */
    export interface Schema$FirewallPolicy {
        /**
         * A list of associations that belong to this firewall policy.
         */
        associations?: Schema$FirewallPolicyAssociation[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Deprecated, please use short name instead. User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. This field is not applicable to network firewall policies. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        displayName?: string | null;
        /**
         * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the firewall policy.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
         */
        kind?: string | null;
        /**
         * Name of the resource. For Organization Firewall Policies it's a [Output Only] numeric ID allocated by Google Cloud which uniquely identifies the Organization Firewall Policy.
         */
        name?: string | null;
        /**
         * A list of packet mirroring rules that belong to this policy.
         */
        packetMirroringRules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] The parent of the firewall policy. This field is not applicable to network firewall policies.
         */
        parent?: string | null;
        /**
         * The type of the firewall policy. This field can be either VPC_POLICY or RDMA_ROCE_POLICY. Note: if not specified then VPC_POLICY will be used.
         */
        policyType?: string | null;
        /**
         * [Output Only] URL of the region where the regional firewall policy resides. This field is not applicable to global firewall policies. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a default rule with action "allow" will be added.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
         */
        ruleTupleCount?: number | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. This field is not applicable to network firewall policies. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        shortName?: string | null;
        /**
         * The scope of networks allowed to be associated with the firewall policy. This field can be either GLOBAL_VPC_NETWORK or REGIONAL_VPC_NETWORK. A firewall policy with the VPC scope set to GLOBAL_VPC_NETWORK is allowed to be attached only to global networks. When the VPC scope is set to REGIONAL_VPC_NETWORK the firewall policy is allowed to be attached only to regional networks in the same scope as the firewall policy. Note: if not specified then GLOBAL_VPC_NETWORK will be used.
         */
        vpcNetworkScope?: string | null;
    }
    export interface Schema$FirewallPolicyAssociation {
        /**
         * The target that the firewall policy is attached to.
         */
        attachmentTarget?: string | null;
        /**
         * [Output Only] Deprecated, please use short name instead. The display name of the firewall policy of the association.
         */
        displayName?: string | null;
        /**
         * [Output Only] The firewall policy ID of the association.
         */
        firewallPolicyId?: string | null;
        /**
         * The name for an association.
         */
        name?: string | null;
        /**
         * An integer indicating the priority of an association. The priority must be a positive value between 1 and 2147483647. Firewall Policies are evaluated from highest to lowest priority where 1 is the highest priority and 2147483647 is the lowest priority. The default value is `1000`. If two associations have the same priority then lexicographical order on association names is applied.
         */
        priority?: number | null;
        /**
         * [Output Only] The short name of the firewall policy of the association.
         */
        shortName?: string | null;
    }
    export interface Schema$FirewallPolicyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of FirewallPolicy resources.
         */
        items?: Schema$FirewallPolicy[];
        /**
         * [Output Only] Type of resource. Always compute#firewallPolicyList for listsof FirewallPolicies
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
     */
    export interface Schema$FirewallPolicyRule {
        /**
         * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
         */
        action?: string | null;
        /**
         * An optional description for this resource.
         */
        description?: string | null;
        /**
         * The direction in which this rule applies.
         */
        direction?: string | null;
        /**
         * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
         */
        disabled?: boolean | null;
        /**
         * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
         */
        enableLogging?: boolean | null;
        /**
         * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
         */
        kind?: string | null;
        /**
         * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
         */
        match?: Schema$FirewallPolicyRuleMatcher;
        /**
         * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
         */
        priority?: number | null;
        /**
         * An optional name for the rule. This field is not a unique identifier and can be updated.
         */
        ruleName?: string | null;
        /**
         * [Output Only] Calculation of the complexity of a single firewall policy rule.
         */
        ruleTupleCount?: number | null;
        /**
         * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project\}/locations/{location\}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
         */
        securityProfileGroup?: string | null;
        /**
         * A list of forwarding rules to which this rule applies. This field allows you to control which load balancers get this rule. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/forwardingRules/forwardingRule - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - projects/project/global/ forwardingRules/forwardingRule - projects/project/regions/region/forwardingRules/ forwardingRule
         */
        targetForwardingRules?: string[] | null;
        /**
         * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
         */
        targetResources?: string[] | null;
        /**
         * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
         */
        targetSecureTags?: Schema$FirewallPolicyRuleSecureTag[];
        /**
         * A list of service accounts indicating the sets of instances that are applied with this rule.
         */
        targetServiceAccounts?: string[] | null;
        /**
         * Target types of the firewall policy rule. Default value is INSTANCES.
         */
        targetType?: string | null;
        /**
         * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
         */
        tlsInspect?: boolean | null;
    }
    /**
     * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
     */
    export interface Schema$FirewallPolicyRuleMatcher {
        /**
         * Address groups which should be matched against the traffic destination. Maximum number of destination address groups is 10.
         */
        destAddressGroups?: string[] | null;
        /**
         * Fully Qualified Domain Name (FQDN) which should be matched against traffic destination. Maximum number of destination fqdn allowed is 100.
         */
        destFqdns?: string[] | null;
        /**
         * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
         */
        destIpRanges?: string[] | null;
        /**
         * Network scope of the traffic destination.
         */
        destNetworkScope?: string | null;
        /**
         * Network type of the traffic destination. Allowed values are: - UNSPECIFIED - INTERNET - NON_INTERNET
         */
        destNetworkType?: string | null;
        /**
         * Region codes whose IP addresses will be used to match for destination of traffic. Should be specified as 2 letter country code defined as per ISO 3166 alpha-2 country codes. ex."US" Maximum number of dest region codes allowed is 5000.
         */
        destRegionCodes?: string[] | null;
        /**
         * Names of Network Threat Intelligence lists. The IPs in these lists will be matched against traffic destination.
         */
        destThreatIntelligences?: string[] | null;
        /**
         * Pairs of IP protocols and ports that the rule should match.
         */
        layer4Configs?: Schema$FirewallPolicyRuleMatcherLayer4Config[];
        /**
         * Address groups which should be matched against the traffic source. Maximum number of source address groups is 10.
         */
        srcAddressGroups?: string[] | null;
        /**
         * Fully Qualified Domain Name (FQDN) which should be matched against traffic source. Maximum number of source fqdn allowed is 100.
         */
        srcFqdns?: string[] | null;
        /**
         * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
         */
        srcIpRanges?: string[] | null;
        /**
         * Networks of the traffic source. It can be either a full or partial url.
         */
        srcNetworks?: string[] | null;
        /**
         * Network scope of the traffic source.
         */
        srcNetworkScope?: string | null;
        /**
         * Network type of the traffic source. Allowed values are: - UNSPECIFIED - INTERNET - INTRA_VPC - NON_INTERNET - VPC_NETWORKS
         */
        srcNetworkType?: string | null;
        /**
         * Region codes whose IP addresses will be used to match for source of traffic. Should be specified as 2 letter country code defined as per ISO 3166 alpha-2 country codes. ex."US" Maximum number of source region codes allowed is 5000.
         */
        srcRegionCodes?: string[] | null;
        /**
         * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
         */
        srcSecureTags?: Schema$FirewallPolicyRuleSecureTag[];
        /**
         * Names of Network Threat Intelligence lists. The IPs in these lists will be matched against traffic source.
         */
        srcThreatIntelligences?: string[] | null;
    }
    export interface Schema$FirewallPolicyRuleMatcherLayer4Config {
        /**
         * The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
         */
        ipProtocol?: string | null;
        /**
         * An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
         */
        ports?: string[] | null;
    }
    export interface Schema$FirewallPolicyRuleSecureTag {
        /**
         * Name of the secure tag, created with TagManager's TagValue API.
         */
        name?: string | null;
        /**
         * [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
         */
        state?: string | null;
    }
    /**
     * Encapsulates numeric value that can be either absolute or relative.
     */
    export interface Schema$FixedOrPercent {
        /**
         * [Output Only] Absolute value of VM instances calculated based on the specific mode. - If the value is fixed, then the calculated value is equal to the fixed value. - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded.
         */
        calculated?: number | null;
        /**
         * Specifies a fixed number of VM instances. This must be a positive integer.
         */
        fixed?: number | null;
        /**
         * Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
         */
        percent?: number | null;
    }
    /**
     * A flexible specification of a time range that has 3 points of flexibility: (1) a flexible start time, (2) a flexible end time, (3) a flexible duration. It is possible to specify a contradictory time range that cannot be matched by any Interval. This causes a validation error.
     */
    export interface Schema$FlexibleTimeRange {
        endTimeNotEarlierThan?: string | null;
        endTimeNotLaterThan?: string | null;
        maxDuration?: string | null;
        minDuration?: string | null;
        startTimeNotEarlierThan?: string | null;
        startTimeNotLaterThan?: string | null;
    }
    /**
     * Represents a Forwarding Rule resource. Forwarding rule resources in Google Cloud can be either regional or global in scope: * [Global](https://cloud.google.com/compute/docs/reference/rest/alpha/globalForwardingRules) * [Regional](https://cloud.google.com/compute/docs/reference/rest/alpha/forwardingRules) A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway). For more information, read Forwarding rule concepts and Using protocol forwarding.
     */
    export interface Schema$ForwardingRule {
        /**
         * If set to true, clients can access the internal passthrough Network Load Balancers, the regional internal Application Load Balancer, and the regional internal proxy Network Load Balancer from all regions. If false, only allows access from the local region the load balancer is located at. Note that for INTERNAL_MANAGED forwarding rules, this field cannot be changed after the forwarding rule is created.
         */
        allowGlobalAccess?: boolean | null;
        /**
         * This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
         */
        allowPscGlobalAccess?: boolean | null;
        /**
         * This is used in PSC consumer ForwardingRule to control whether the producer is allowed to inject packets into the consumer's network. If set to true, the target service attachment must have tunneling enabled and TunnelingConfig.RoutingMode set to PACKET_INJECTION Non-PSC forwarding rules should not use this field.
         */
        allowPscPacketInjection?: boolean | null;
        /**
         * The ports, portRange, and allPorts fields are mutually exclusive. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The allPorts field has the following limitations: - It requires that the forwarding rule IPProtocol be TCP, UDP, SCTP, or L3_DEFAULT. - It's applicable only to the following products: internal passthrough Network Load Balancers, backend service-based external passthrough Network Load Balancers, and internal and external protocol forwarding. - Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The L3_DEFAULT protocol requires allPorts be set to true.
         */
        allPorts?: boolean | null;
        /**
         * Identifies the backend service to which the forwarding rule sends traffic. Required for internal and external passthrough Network Load Balancers; must be omitted for all other load balancer types.
         */
        backendService?: string | null;
        /**
         * [Output Only] The URL for the corresponding base forwarding rule. By base forwarding rule, we mean the forwarding rule that has the same IP address, protocol, and port settings with the current forwarding rule, but without sourceIPRanges specified. Always empty if the current forwarding rule does not have sourceIPRanges specified.
         */
        baseForwardingRule?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Specifies the canary migration state for the backend buckets attached to this forwarding rule. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic to backend buckets attached to this forwarding rule by percentage using externalManagedBackendBucketMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
         */
        externalManagedBackendBucketMigrationState?: string | null;
        /**
         * Determines the fraction of requests to backend buckets that should be processed by the global external Application Load Balancer. The value of this field must be in the range [0, 100]. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
         */
        externalManagedBackendBucketMigrationTestingPercentage?: number | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
         */
        IPAddress?: string | null;
        /**
         * Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode. Use one of the following formats to specify a sub-PDP when creating an IPv6 NetLB forwarding rule using BYOIP: Full resource URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region /publicDelegatedPrefixes/sub-pdp-name Partial URL, as in: - projects/project_id/regions/region/publicDelegatedPrefixes/sub-pdp-name - regions/region/publicDelegatedPrefixes/sub-pdp-name
         */
        ipCollection?: string | null;
        /**
         * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
         */
        IPProtocol?: string | null;
        /**
         * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
         */
        ipVersion?: string | null;
        /**
         * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
         */
        isMirroringCollector?: boolean | null;
        /**
         * [Output Only] Type of the resource. Always compute#forwardingRule for forwarding rule resources.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
         */
        loadBalancingScheme?: string | null;
        /**
         * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        metadataFilters?: Schema$MetadataFilter[];
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
         */
        name?: string | null;
        /**
         * This field is not used for global external load balancing. For internal passthrough Network Load Balancers, this field identifies the network that the load balanced IP should belong to for this forwarding rule. If the subnetwork is specified, the network of the subnetwork will be used. If neither subnetwork nor this field is specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
         */
        network?: string | null;
        /**
         * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
         */
        networkTier?: string | null;
        /**
         * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field. Once set, this field is not mutable.
         */
        noAutomateDnsZone?: boolean | null;
        /**
         * The ports, portRange, and allPorts fields are mutually exclusive. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The portRange field has the following limitations: - It requires that the forwarding rule IPProtocol be TCP, UDP, or SCTP, and - It's applicable only to the following products: external passthrough Network Load Balancers, internal and external proxy Network Load Balancers, internal and external Application Load Balancers, external protocol forwarding, and Classic VPN. - Some products have restrictions on what ports can be used. See port specifications for details. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. @pattern: \\d+(?:-\\d+)?
         */
        portRange?: string | null;
        /**
         * The ports, portRange, and allPorts fields are mutually exclusive. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports field has the following limitations: - It requires that the forwarding rule IPProtocol be TCP, UDP, or SCTP, and - It's applicable only to the following products: internal passthrough Network Load Balancers, backend service-based external passthrough Network Load Balancers, and internal protocol forwarding. - You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair if they share at least one port number. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair if they share at least one port number. @pattern: \\d+(?:-\\d+)?
         */
        ports?: string[] | null;
        /**
         * [Output Only] The PSC connection id of the PSC forwarding rule.
         */
        pscConnectionId?: string | null;
        pscConnectionStatus?: string | null;
        /**
         * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
         */
        serviceDirectoryRegistrations?: Schema$ForwardingRuleServiceDirectoryRegistration[];
        /**
         * An optional prefix to the service name for this forwarding rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
         */
        serviceLabel?: string | null;
        /**
         * [Output Only] The internal fully qualified service name for this forwarding rule. This field is only used for internal load balancing.
         */
        serviceName?: string | null;
        /**
         * If not empty, this forwarding rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a forwarding rule can only have up to 64 source IP ranges, and this field can only be used with a regional forwarding rule whose scheme is EXTERNAL. Each source_ip_range entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
         */
        sourceIpRanges?: string[] | null;
        /**
         * This field identifies the subnetwork that the load balanced IP should belong to for this forwarding rule, used with internal load balancers and external passthrough Network Load Balancers with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
         */
        subnetwork?: string | null;
        /**
         * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment. The target is not mutable once set as a service attachment.
         */
        target?: string | null;
    }
    export interface Schema$ForwardingRuleAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ForwardingRulesScopedList resources.
         */
        items?: {
            [key: string]: Schema$ForwardingRulesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of ForwardingRule resources.
     */
    export interface Schema$ForwardingRuleList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ForwardingRule resources.
         */
        items?: Schema$ForwardingRule[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ForwardingRuleReference {
        forwardingRule?: string | null;
    }
    /**
     * Describes the auto-registration of the forwarding rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this forwarding rule.
     */
    export interface Schema$ForwardingRuleServiceDirectoryRegistration {
        /**
         * Service Directory namespace to register the forwarding rule under.
         */
        namespace?: string | null;
        /**
         * Service Directory service to register the forwarding rule under.
         */
        service?: string | null;
        /**
         * [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs forwarding rules on the same network should use the same Service Directory region.
         */
        serviceDirectoryRegion?: string | null;
    }
    export interface Schema$ForwardingRulesScopedList {
        /**
         * A list of forwarding rules contained in this scope.
         */
        forwardingRules?: Schema$ForwardingRule[];
        /**
         * Informational warning which replaces the list of forwarding rules when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$FutureReservation {
        /**
         * Aggregate reservation details for the future reservation.
         */
        aggregateReservation?: Schema$AllocationAggregateReservation;
        /**
         * Future timestamp when the FR auto-created reservations will be deleted by Compute Engine. Format of this field must be a valid href="https://www.ietf.org/rfc/rfc3339.txt"\>RFC3339 value.
         */
        autoCreatedReservationsDeleteTime?: string | null;
        /**
         * Specifies the duration of auto-created reservations. It represents relative time to future reservation start_time when auto-created reservations will be automatically deleted by Compute Engine. Duration time unit is represented as a count of seconds and fractions of seconds at nanosecond resolution.
         */
        autoCreatedReservationsDuration?: Schema$Duration;
        /**
         * Setting for enabling or disabling automatic deletion for auto-created reservation. If set to true, auto-created reservations will be deleted at Future Reservation's end time (default) or at user's defined timestamp if any of the [auto_created_reservations_delete_time, auto_created_reservations_duration] values is specified. For keeping auto-created reservation indefinitely, this value should be set to false.
         */
        autoDeleteAutoCreatedReservations?: boolean | null;
        /**
         * If not present, then FR will not deliver a new commitment or update an existing commitment.
         */
        commitmentInfo?: Schema$FutureReservationCommitmentInfo;
        /**
         * [Output Only] The creation timestamp for this future reservation in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Type of the deployment requested as part of future reservation.
         */
        deploymentType?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the future reservation.
         */
        description?: string | null;
        /**
         * Indicates if this group of VMs have emergent maintenance enabled.
         */
        enableEmergentMaintenance?: boolean | null;
        /**
         * [Output Only] A unique identifier for this future reservation. The server defines this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#futureReservation for future reservations.
         */
        kind?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Name prefix for the reservations to be created at the time of delivery. The name prefix must comply with RFC1035. Maximum allowed length for name prefix is 20. Automatically created reservations name format will be -date-####.
         */
        namePrefix?: string | null;
        /**
         * Planning state before being submitted for evaluation
         */
        planningStatus?: string | null;
        /**
         * The reservation mode which determines reservation-termination behavior and expected pricing.
         */
        reservationMode?: string | null;
        /**
         * Name of reservations where the capacity is provisioned at the time of delivery of future reservations. If the reservation with the given name does not exist already, it is created automatically at the time of Approval with INACTIVE state till specified start-time. Either provide the reservation_name or a name_prefix.
         */
        reservationName?: string | null;
        /**
         * Maintenance information for this reservation
         */
        schedulingType?: string | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * List of Projects/Folders to share with.
         */
        shareSettings?: Schema$ShareSettings;
        /**
         * Indicates whether the auto-created reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from the delivered reservation.
         */
        specificReservationRequired?: boolean | null;
        /**
         * Future Reservation configuration to indicate instance properties and total count.
         */
        specificSkuProperties?: Schema$FutureReservationSpecificSKUProperties;
        /**
         * [Output only] Status of the Future Reservation
         */
        status?: Schema$FutureReservationStatus;
        /**
         * Time window for this Future Reservation.
         */
        timeWindow?: Schema$FutureReservationTimeWindow;
        /**
         * [Output Only] URL of the Zone where this future reservation resides.
         */
        zone?: string | null;
    }
    export interface Schema$FutureReservationCommitmentInfo {
        /**
         * name of the commitment where capacity is being delivered to.
         */
        commitmentName?: string | null;
        /**
         * Indicates if a Commitment needs to be created as part of FR delivery. If this field is not present, then no commitment needs to be created.
         */
        commitmentPlan?: string | null;
        /**
         * Only applicable if FR is delivering to the same reservation. If set, all parent commitments will be extended to match the end date of the plan for this commitment.
         */
        previousCommitmentTerms?: string | null;
    }
    /**
     * Contains a list of future reservations.
     */
    export interface Schema$FutureReservationsAggregatedListResponse {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Future reservation resources.
         */
        items?: {
            [key: string]: Schema$FutureReservationsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#futureReservationsAggregatedListResponse for future resevation aggregated list response.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$FutureReservationsListResponse {
        etag?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of future reservation resources.
         */
        items?: Schema$FutureReservation[];
        /**
         * [Output Only] Type of resource.Always compute#FutureReservationsListResponse for lists of reservations
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$FutureReservationSpecificSKUProperties {
        /**
         * Properties of the SKU instances being reserved.
         */
        instanceProperties?: Schema$AllocationSpecificSKUAllocationReservedInstanceProperties;
        /**
         * The instance template that will be used to populate the ReservedInstanceProperties of the future reservation
         */
        sourceInstanceTemplate?: string | null;
        /**
         * Total number of instances for which capacity assurance is requested at a future time period.
         */
        totalCount?: string | null;
    }
    export interface Schema$FutureReservationsScopedList {
        /**
         * A list of future reservations contained in this scope.
         */
        futureReservations?: Schema$FutureReservation[];
        /**
         * Informational warning which replaces the list of future reservations when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * [Output only] Represents status related to the future reservation.
     */
    export interface Schema$FutureReservationStatus {
        /**
         * [Output Only] The current status of the requested amendment.
         */
        amendmentStatus?: string | null;
        /**
         * Fully qualified urls of the automatically created reservations at start_time.
         */
        autoCreatedReservations?: string[] | null;
        /**
         * [Output Only] Represents the existing matching usage for the future reservation.
         */
        existingMatchingUsageInfo?: Schema$FutureReservationStatusExistingMatchingUsageInfo;
        /**
         * This count indicates the fulfilled capacity so far. This is set during "PROVISIONING" state. This count also includes capacity delivered as part of existing matching reservations.
         */
        fulfilledCount?: string | null;
        /**
         * [Output Only] This field represents the future reservation before an amendment was requested. If the amendment is declined, the Future Reservation will be reverted to the last known good state. The last known good state is not set when updating a future reservation whose Procurement Status is DRAFTING.
         */
        lastKnownGoodState?: Schema$FutureReservationStatusLastKnownGoodState;
        /**
         * Time when Future Reservation would become LOCKED, after which no modifications to Future Reservation will be allowed. Applicable only after the Future Reservation is in the APPROVED state. The lock_time is an RFC3339 string. The procurement_status will transition to PROCURING state at this time.
         */
        lockTime?: string | null;
        /**
         * Current state of this Future Reservation
         */
        procurementStatus?: string | null;
        specificSkuProperties?: Schema$FutureReservationStatusSpecificSKUProperties;
    }
    /**
     * [Output Only] Represents the existing matching usage for the future reservation.
     */
    export interface Schema$FutureReservationStatusExistingMatchingUsageInfo {
        /**
         * Count to represent min(FR total_count, matching_reserved_capacity+matching_unreserved_instances)
         */
        count?: string | null;
        /**
         * Timestamp when the matching usage was calculated
         */
        timestamp?: string | null;
    }
    /**
     * The state that the future reservation will be reverted to should the amendment be declined.
     */
    export interface Schema$FutureReservationStatusLastKnownGoodState {
        /**
         * [Output Only] The description of the FutureReservation before an amendment was requested.
         */
        description?: string | null;
        /**
         * [Output Only] Represents the matching usage for the future reservation before an amendment was requested.
         */
        existingMatchingUsageInfo?: Schema$FutureReservationStatusExistingMatchingUsageInfo;
        futureReservationSpecs?: Schema$FutureReservationStatusLastKnownGoodStateFutureReservationSpecs;
        /**
         * [Output Only] The lock time of the FutureReservation before an amendment was requested.
         */
        lockTime?: string | null;
        /**
         * [Output Only] The name prefix of the Future Reservation before an amendment was requested.
         */
        namePrefix?: string | null;
        /**
         * [Output Only] The status of the last known good state for the Future Reservation.
         */
        procurementStatus?: string | null;
    }
    /**
     * The properties of the last known good state for the Future Reservation.
     */
    export interface Schema$FutureReservationStatusLastKnownGoodStateFutureReservationSpecs {
        /**
         * [Output Only] The previous share settings of the Future Reservation.
         */
        shareSettings?: Schema$ShareSettings;
        /**
         * [Output Only] The previous instance related properties of the Future Reservation.
         */
        specificSkuProperties?: Schema$FutureReservationSpecificSKUProperties;
        /**
         * [Output Only] The previous time window of the Future Reservation.
         */
        timeWindow?: Schema$FutureReservationTimeWindow;
    }
    /**
     * Properties to be set for the Future Reservation.
     */
    export interface Schema$FutureReservationStatusSpecificSKUProperties {
        /**
         * ID of the instance template used to populate the Future Reservation properties.
         */
        sourceInstanceTemplateId?: string | null;
    }
    export interface Schema$FutureReservationTimeWindow {
        duration?: Schema$Duration;
        endTime?: string | null;
        /**
         * Start time of the Future Reservation. The start_time is an RFC3339 string.
         */
        startTime?: string | null;
    }
    /**
     * Recommendation for single resources specification, to be created in the future.
     */
    export interface Schema$FutureResourcesRecommendation {
        endTime?: string | null;
        /**
         * The advised location for resource usage. When a zone, in format 'zones/'. If not set, it means that no location is recommended - see other_locations for details.
         */
        location?: string | null;
        /**
         * List of locations in the request scope that were not recommended. Keys of the map are zones, in format 'zones/'. The values are status information indicating the recommendation status.
         */
        otherLocations?: {
            [key: string]: Schema$FutureResourcesRecommendationOtherLocation;
        } | null;
        /**
         * Unique id of the recommendation, a UUID string generated by the API.
         */
        recommendationId?: string | null;
        /**
         * Type of recommendation. Currently only FUTURE_RESERVATION is supported.
         */
        recommendationType?: string | null;
        startTime?: string | null;
    }
    /**
     * Information about recommendation status for locations that were allowed but not used by the response.
     */
    export interface Schema$FutureResourcesRecommendationOtherLocation {
        /**
         * Details (human readable) describing the situation. For example, if status is CONDITION_NOT_MET, then details contain information about the parameters of the time window that did not meet the required conditions.
         */
        details?: string | null;
        /**
         * Status of recommendation in this location.
         */
        status?: string | null;
    }
    /**
     * Specification of resources to be created at some time in the future within an optionally specified set of locations, and within the specified time range.
     */
    export interface Schema$FutureResourcesSpec {
        /**
         * Indicates if the reservation allocation strategy is static (DENSE) or dynamic (STANDARD). Defaults to DENSE.
         */
        deploymentType?: string | null;
        /**
         * Optional location policy allowing to exclude some zone(s) in which the resources must not be created.
         */
        locationPolicy?: Schema$FutureResourcesSpecLocationPolicy;
        /**
         * Specification of the reserved resources.
         */
        targetResources?: Schema$FutureResourcesSpecTargetResources;
        /**
         * Specification of a time range in which the resources may be created. The time range specifies start of resource use and planned end of resource use.
         */
        timeRangeSpec?: Schema$FlexibleTimeRange;
    }
    export interface Schema$FutureResourcesSpecAggregateResources {
        /**
         * Size of the request, in accelerator (chip) count.
         */
        acceleratorCount?: string | null;
        /**
         * The VM family that all instances scheduled against this reservation must belong to. Use for TPU reservations.
         */
        vmFamily?: string | null;
        /**
         * Workload type. Use for TPU reservations.
         */
        workloadType?: string | null;
    }
    export interface Schema$FutureResourcesSpecLocalSsdPartition {
        /**
         * Disk interface. Defaults to SCSI.
         */
        diskInterface?: string | null;
        /**
         * The size of the disk in GB.
         */
        diskSizeGb?: string | null;
    }
    /**
     * Specification of locations to create resources in.
     */
    export interface Schema$FutureResourcesSpecLocationPolicy {
        /**
         * Preferences for specified locations. Keys of the map are locations - zones, in format of 'zones/'. Values are preferences for the zones. If a zone is not specified in this map, it is ALLOWed.
         */
        locations?: {
            [key: string]: Schema$FutureResourcesSpecLocationPolicyLocation;
        } | null;
    }
    /**
     * Preference for a single specified location.
     */
    export interface Schema$FutureResourcesSpecLocationPolicyLocation {
        /**
         * Preference for this location.
         */
        preference?: string | null;
    }
    export interface Schema$FutureResourcesSpecSpecificSKUResources {
        /**
         * Size of the request, in instance count.
         */
        instanceCount?: string | null;
        /**
         * Local SSD partitions. You do not have to include SSD partitions that are built in the machine type.
         */
        localSsdPartitions?: Schema$FutureResourcesSpecLocalSsdPartition[];
        /**
         * The machine type to use for instances that will use the reservation. This field only accepts machine type names. e.g. n2-standard-4 and does not accept machine type full or partial url. e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4. Use for GPU reservations.
         */
        machineType?: string | null;
    }
    /**
     * Specification of reserved resources.
     */
    export interface Schema$FutureResourcesSpecTargetResources {
        aggregateResources?: Schema$FutureResourcesSpecAggregateResources;
        specificSkuResources?: Schema$FutureResourcesSpecSpecificSKUResources;
    }
    export interface Schema$GetAsyncReplicationStatusResponse {
        asyncReplicationStatus?: Schema$AsyncReplicationStatus;
        /**
         * end_interface: MixerGetResponseWithEtagBuilder
         */
        etag?: string | null;
    }
    export interface Schema$GetOwnerInstanceResponse {
        /**
         * Full instance resource URL.
         */
        instance?: string | null;
    }
    export interface Schema$GlobalAddressesMoveRequest {
        /**
         * An optional destination address description if intended to be different from the source.
         */
        description?: string | null;
        /**
         * The URL of the destination address to move to. This can be a full or partial URL. For example, the following are all valid URLs to a address: - https://www.googleapis.com/compute/v1/projects/project /global/addresses/address - projects/project/global/addresses/address Note that destination project must be different from the source project. So /global/addresses/address is not valid partial url.
         */
        destinationAddress?: string | null;
    }
    export interface Schema$GlobalNetworkEndpointGroupsAttachEndpointsRequest {
        /**
         * The list of network endpoints to be attached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$GlobalNetworkEndpointGroupsDetachEndpointsRequest {
        /**
         * The list of network endpoints to be detached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$GlobalOrganizationSetPolicyRequest {
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export interface Schema$GlobalSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string | null;
        /**
         * A list of labels to apply for this resource. Each label must comply with the requirements for labels. For example, "webserver-frontend": "images". A label value can also be empty (e.g. "my-label": "").
         */
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GlobalSetPolicyRequest {
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    /**
     * Maintenance Info for ReservationBlocks.
     */
    export interface Schema$GroupMaintenanceInfo {
        /**
         * Describes number of instances that have ongoing maintenance.
         */
        instanceMaintenanceOngoingCount?: number | null;
        /**
         * Describes number of instances that have pending maintenance.
         */
        instanceMaintenancePendingCount?: number | null;
        /**
         * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
         */
        maintenanceOngoingCount?: number | null;
        /**
         * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
         */
        maintenancePendingCount?: number | null;
        /**
         * The type of maintenance for the reservation.
         */
        schedulingType?: string | null;
        /**
         * Describes number of subblock Infrastructure that has ongoing maintenance. Here, Subblock Infrastructure Maintenance pertains to upstream hardware contained in the Subblock that is necessary for a VM Family(e.g. NVLink Domains). Not all VM Families will support this field.
         */
        subblockInfraMaintenanceOngoingCount?: number | null;
        /**
         * Describes number of subblock Infrastructure that has pending maintenance. Here, Subblock Infrastructure Maintenance pertains to upstream hardware contained in the Subblock that is necessary for a VM Family (e.g. NVLink Domains). Not all VM Families will support this field.
         */
        subblockInfraMaintenancePendingCount?: number | null;
        /**
         * Maintenance information on this group of VMs.
         */
        upcomingGroupMaintenance?: Schema$UpcomingMaintenance;
    }
    export interface Schema$GRPCHealthCheck {
        /**
         * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
         */
        grpcServiceName?: string | null;
        /**
         * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Not supported.
         */
        portName?: string | null;
        /**
         * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
         */
        portSpecification?: string | null;
    }
    /**
     * [Deprecated] gRPC config to access the SDS server. gRPC config to access the SDS server.
     */
    export interface Schema$GrpcServiceConfig {
        /**
         * The call credentials to access the SDS server.
         */
        callCredentials?: Schema$CallCredentials;
        /**
         * The channel credentials to access the SDS server.
         */
        channelCredentials?: Schema$ChannelCredentials;
        /**
         * The target URI of the SDS server.
         */
        targetUri?: string | null;
    }
    export interface Schema$GRPCTLSHealthCheck {
        /**
         * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
         */
        grpcServiceName?: string | null;
        /**
         * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
         */
        portSpecification?: string | null;
    }
    /**
     * A guest attributes entry.
     */
    export interface Schema$GuestAttributes {
        /**
         * [Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.
         */
        kind?: string | null;
        /**
         * The path to be queried. This can be the default namespace ('') or a nested namespace ('\/') or a specified key ('\/\').
         */
        queryPath?: string | null;
        /**
         * [Output Only] The value of the requested queried path.
         */
        queryValue?: Schema$GuestAttributesValue;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * The key to search for.
         */
        variableKey?: string | null;
        /**
         * [Output Only] The value found for the requested key.
         */
        variableValue?: string | null;
    }
    /**
     * A guest attributes namespace/key/value entry.
     */
    export interface Schema$GuestAttributesEntry {
        /**
         * Key for the guest attribute entry.
         */
        key?: string | null;
        /**
         * Namespace for the guest attribute entry.
         */
        namespace?: string | null;
        /**
         * Value for the guest attribute entry.
         */
        value?: string | null;
    }
    /**
     * Array of guest attribute namespace/key/value tuples.
     */
    export interface Schema$GuestAttributesValue {
        items?: Schema$GuestAttributesEntry[];
    }
    /**
     * Guest OS features.
     */
    export interface Schema$GuestOsFeature {
        /**
         * The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE - SEV_LIVE_MIGRATABLE_V2 - SEV_SNP_CAPABLE - TDX_CAPABLE - IDPF - SNP_SVSM_CAPABLE For more information, see Enabling guest operating system features.
         */
        type?: string | null;
    }
    /**
     * Represents a health aggregation policy. A health aggregation policy resource defines a policy to aggregate health. For more information, see Health checks overview.
     */
    export interface Schema$HealthAggregationPolicy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthAggregationPolicy. An up-to-date fingerprint must be provided in order to patch the HealthAggregationPolicy; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthAggregationPolicy.
         */
        fingerprint?: string | null;
        /**
         * Can only be set if the policyType field is BACKEND_SERVICE_POLICY. Specifies the threshold (as a percentage) of healthy endpoints required in order to consider the aggregated health result HEALTHY. Defaults to 60. Must be in range [0, 100]. Not applicable if the policyType field is DNB_PUBLIC_IP_POLICY. Can be mutated. This field is optional, and will be set to the default if unspecified. Note that both this threshold and minHealthyThreshold must be satisfied in order for HEALTHY to be the aggregated result. "Endpoints" refers to network endpoints within a Network Endpoint Group or instances within an Instance Group.
         */
        healthyPercentThreshold?: number | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#healthAggregationPolicy for health aggregation policies.
         */
        kind?: string | null;
        /**
         * Can only be set if the policyType field is BACKEND_SERVICE_POLICY. Specifies the minimum number of healthy endpoints required in order to consider the aggregated health result HEALTHY. Defaults to 1. Must be positive. Not applicable if the policyType field is DNB_PUBLIC_IP_POLICY. Can be mutated. This field is optional, and will be set to the default if unspecified. Note that both this threshold and healthyPercentThreshold must be satisfied in order for HEALTHY to be the aggregated result. "Endpoints" refers to network endpoints within a Network Endpoint Group or instances within an Instance Group.
         */
        minHealthyThreshold?: number | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Specifies the type of the healthAggregationPolicy. The only allowed value for global resources is DNS_PUBLIC_IP_POLICY. The only allowed value for regional resources is BACKEND_SERVICE_POLICY. Must be specified when the healthAggregationPolicy is created, and cannot be mutated.
         */
        policyType?: string | null;
        /**
         * [Output Only] URL of the region where the health aggregation policy resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
    }
    export interface Schema$HealthAggregationPolicyList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthAggregationPolicy resources.
         */
        items?: Schema$HealthAggregationPolicy[];
        /**
         * [Output Only] Type of the resource. Always compute#healthAggregationPolicy for health aggregation policies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a health check resource. Google Compute Engine has two health check resources: * [Regional](/compute/docs/reference/rest/alpha/regionHealthChecks) * [Global](/compute/docs/reference/rest/alpha/healthChecks) These health check resources can be used for load balancing and for autohealing VMs in a managed instance group (MIG). **Load balancing** Health check requirements vary depending on the type of load balancer. For details about the type of health check supported for each load balancer and corresponding backend type, see Health checks overview: Load balancer guide. **Autohealing in MIGs** The health checks that you use for autohealing VMs in a MIG can be either regional or global. For more information, see Set up an application health check and autohealing. For more information, see Health checks overview.
     */
    export interface Schema$HealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number | null;
        /**
         * [Output Only] Creation timestamp in 3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        grpcHealthCheck?: Schema$GRPCHealthCheck;
        grpcTlsHealthCheck?: Schema$GRPCTLSHealthCheck;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number | null;
        http2HealthCheck?: Schema$HTTP2HealthCheck;
        httpHealthCheck?: Schema$HTTPHealthCheck;
        httpsHealthCheck?: Schema$HTTPSHealthCheck;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Type of the resource.
         */
        kind?: string | null;
        /**
         * Configure logging on this health check.
         */
        logConfig?: Schema$HealthCheckLogConfig;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Region where the health check resides. Not applicable to global health checks.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
         */
        sourceRegions?: string[] | null;
        sslHealthCheck?: Schema$SSLHealthCheck;
        tcpHealthCheck?: Schema$TCPHealthCheck;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
         */
        timeoutSec?: number | null;
        /**
         * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
         */
        type?: string | null;
        udpHealthCheck?: Schema$UDPHealthCheck;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number | null;
    }
    /**
     * Contains a list of HealthCheck resources.
     */
    export interface Schema$HealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthCheck resources.
         */
        items?: Schema$HealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
     */
    export interface Schema$HealthCheckLogConfig {
        /**
         * Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
         */
        enable?: boolean | null;
    }
    /**
     * A full or valid partial URL to a health check. For example, the following are valid URLs: - https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check - projects/project-id/global/httpHealthChecks/health-check - global/httpHealthChecks/health-check
     */
    export interface Schema$HealthCheckReference {
        healthCheck?: string | null;
    }
    export interface Schema$HealthChecksAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthChecksScopedList resources.
         */
        items?: {
            [key: string]: Schema$HealthChecksScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Health-Check as a Service resource.
     */
    export interface Schema$HealthCheckService {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthCheckService. An up-to-date fingerprint must be provided in order to patch/update the HealthCheckService; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthCheckService.
         */
        fingerprint?: string | null;
        /**
         * A list of URLs to the HealthCheck resources. Must have at least one HealthCheck, and not more than 10 for regional HealthCheckService, and not more than 1 for global HealthCheckService. HealthCheck resources must have portSpecification=USE_SERVING_PORT or portSpecification=USE_FIXED_PORT. For regional HealthCheckService, the HealthCheck must be regional and in the same region. For global HealthCheckService, HealthCheck must be global. Mix of regional and global HealthChecks is not supported. Multiple regional HealthChecks must belong to the same region. Regional HealthChecks must belong to the same region as zones of NetworkEndpointGroups. For global HealthCheckService using global INTERNET_IP_PORT NetworkEndpointGroups, the global HealthChecks must specify sourceRegions, and HealthChecks that specify sourceRegions can only be used with global INTERNET_IP_PORT NetworkEndpointGroups.
         */
        healthChecks?: string[] | null;
        /**
         * Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. . This is only allowed with regional HealthCheckService.
         */
        healthStatusAggregationPolicy?: string | null;
        /**
         * This field is deprecated. Use health_status_aggregation_policy instead. Policy for how the results from multiple health checks for the same endpoint are aggregated. - NO_AGGREGATION. An EndpointHealth message is returned for each backend in the health check service. - AND. If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY. .
         */
        healthStatusAggregationStrategy?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#healthCheckServicefor health check services.
         */
        kind?: string | null;
        /**
         * Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * A list of URLs to the NetworkEndpointGroup resources. Must not have more than 100. For regional HealthCheckService, NEGs must be in zones in the region of the HealthCheckService. For global HealthCheckServices, the NetworkEndpointGroups must be global INTERNET_IP_PORT.
         */
        networkEndpointGroups?: string[] | null;
        /**
         * A list of URLs to the NotificationEndpoint resources. Must not have more than 10. A list of endpoints for receiving notifications of change in health status. For regional HealthCheckService, NotificationEndpoint must be regional and in the same region. For global HealthCheckService, NotificationEndpoint must be global.
         */
        notificationEndpoints?: string[] | null;
        /**
         * [Output Only] URL of the region where the health check service resides. This field is not applicable to global health check services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Contains a list of HealthCheckServicesScopedList.
     */
    export interface Schema$HealthCheckServiceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthCheckServicesScopedList resources.
         */
        items?: {
            [key: string]: Schema$HealthCheckServicesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A full or valid partial URL to a health check service. For example, the following are valid URLs: - https://www.googleapis.com/compute/beta/projects/project-id/regions/us-west1/healthCheckServices/health-check-service - projects/project-id/regions/us-west1/healthCheckServices/health-check-service - regions/us-west1/healthCheckServices/health-check-service
     */
    export interface Schema$HealthCheckServiceReference {
        healthCheckService?: string | null;
    }
    export interface Schema$HealthCheckServicesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthCheckService resources.
         */
        items?: Schema$HealthCheckService[];
        /**
         * [Output Only] Type of the resource. Always compute#healthCheckServicesList for lists of HealthCheckServices.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthCheckServicesScopedList {
        /**
         * A list of HealthCheckServices contained in this scope.
         */
        resources?: Schema$HealthCheckService[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthChecksScopedList {
        /**
         * A list of HealthChecks contained in this scope.
         */
        healthChecks?: Schema$HealthCheck[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a health source. A health source resource specifies the source resources and the health aggregation policy applied to the source resources to determine the aggregated health status.
     */
    export interface Schema$HealthSource {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthSource. An up-to-date fingerprint must be provided in order to patch the HealthSource; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthSource.
         */
        fingerprint?: string | null;
        /**
         * URL to the HealthAggregationPolicy resource. Must be set. Must be regional and in the same region as the HealthSource. Can be mutated.
         */
        healthAggregationPolicy?: string | null;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#healthSource for health sources.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the health source resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
        /**
         * URLs to the source resources. Must be size 1. Must be a BackendService if the sourceType is BACKEND_SERVICE. The BackendService must have load balancing scheme INTERNAL or INTERNAL_MANAGED and must be regional and in the same region as the HealthSource (cross-region deployment for INTERNAL_MANAGED is not supported). The BackendService may use only IGs, MIGs, or NEGs of type GCE_VM_IP or GCE_VM_IP_PORT. The BackendService may not use haPolicy. Can be mutated.
         */
        sources?: string[] | null;
        /**
         * Specifies the type of the HealthSource. The only allowed value is BACKEND_SERVICE. Must be specified when the HealthSource is created, and cannot be mutated.
         */
        sourceType?: string | null;
    }
    /**
     * Contains a list of HealthSourcesScopedList.
     */
    export interface Schema$HealthSourceAggregatedList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthSourcesScopedList resources.
         */
        items?: {
            [key: string]: Schema$HealthSourcesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthSourceList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthSource resources.
         */
        items?: Schema$HealthSource[];
        /**
         * [Output Only] Type of the resource. Always compute#healthSource for health sources.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthSourcesScopedList {
        /**
         * A list of HealthSources contained in this scope.
         */
        resources?: Schema$HealthSource[];
        /**
         * Informational warning which replaces the list of health sources when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthStatus {
        /**
         * Metadata defined as annotations for network endpoint.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * URL of the forwarding rule associated with the health status of the instance.
         */
        forwardingRule?: string | null;
        /**
         * A forwarding rule IP address assigned to this instance.
         */
        forwardingRuleIp?: string | null;
        /**
         * Health state of the IPv4 address of the instance.
         */
        healthState?: string | null;
        /**
         * URL of the instance resource.
         */
        instance?: string | null;
        /**
         * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
         */
        ipAddress?: string | null;
        ipv6Address?: string | null;
        /**
         * Health state of the IPv6 address of the instance.
         */
        ipv6HealthState?: string | null;
        /**
         * The named port of the instance group, not necessarily the port that is health-checked.
         */
        port?: number | null;
        weight?: string | null;
        weightError?: string | null;
    }
    export interface Schema$HealthStatusForNetworkEndpoint {
        /**
         * URL of the backend service associated with the health state of the network endpoint.
         */
        backendService?: Schema$BackendServiceReference;
        /**
         * URL of the forwarding rule associated with the health state of the network endpoint.
         */
        forwardingRule?: Schema$ForwardingRuleReference;
        /**
         * URL of the health check associated with the health state of the network endpoint.
         */
        healthCheck?: Schema$HealthCheckReference;
        /**
         * URL of the health check service associated with the health state of the network endpoint.
         */
        healthCheckService?: Schema$HealthCheckServiceReference;
        /**
         * Health state of the network endpoint determined based on the health checks configured.
         */
        healthState?: string | null;
        /**
         * Health state of the ipv6 network endpoint determined based on the health checks configured.
         */
        ipv6HealthState?: string | null;
    }
    /**
     * Provides links to documentation or for performing an out of band action. For example, if a quota check failed with an error indicating the calling project hasn't enabled the accessed service, this can contain a URL pointing directly to the right place in the developer console to flip the bit.
     */
    export interface Schema$Help {
        /**
         * URL(s) pointing to additional information on handling the current error.
         */
        links?: Schema$HelpLink[];
    }
    /**
     * Describes a URL link.
     */
    export interface Schema$HelpLink {
        /**
         * Describes what the link offers.
         */
        description?: string | null;
        /**
         * The URL of the link.
         */
        url?: string | null;
    }
    /**
     * UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
     */
    export interface Schema$HostRule {
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character, and if followed by anything, the immediate following character must be either - or .. * based matching is not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
         */
        hosts?: string[] | null;
        /**
         * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
         */
        pathMatcher?: string | null;
    }
    export interface Schema$HTTP2HealthCheck {
        /**
         * The value of the host header in the HTTP/2 health check request. If left empty (default value), the host header is set to the destination IP address to which health check packets are sent. The destination IP address depends on the type of load balancer. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
         */
        host?: string | null;
        /**
         * The TCP port number to which the health check prober sends packets. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Not supported.
         */
        portName?: string | null;
        /**
         * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The request path of the HTTP/2 health check request. The default value is /. Must comply with RFC3986.
         */
        requestPath?: string | null;
        /**
         * Creates a content-based HTTP/2 health check. In addition to the required HTTP 200 (OK) status code, you can configure the health check to pass only when the backend sends this specific ASCII response string within the first 1024 bytes of the HTTP response body. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
         */
        response?: string | null;
        /**
         * Weight report mode. used for weighted Load Balancing.
         */
        weightReportMode?: string | null;
    }
    /**
     * Specification for how requests are aborted as part of fault injection.
     */
    export interface Schema$HttpFaultAbort {
        /**
         * The HTTP status code used to abort the request. The value must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.
         */
        httpStatus?: number | null;
        /**
         * The percentage of traffic for connections, operations, or requests that is aborted as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
         */
        percentage?: number | null;
    }
    /**
     * Specifies the delay introduced by the load balancer before forwarding the request to the backend service as part of fault injection.
     */
    export interface Schema$HttpFaultDelay {
        /**
         * Specifies the value of the fixed delay interval.
         */
        fixedDelay?: Schema$Duration;
        /**
         * The percentage of traffic for connections, operations, or requests for which a delay is introduced as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
         */
        percentage?: number | null;
    }
    /**
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by the load balancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests.
     */
    export interface Schema$HttpFaultInjection {
        /**
         * The specification for how client requests are aborted as part of fault injection.
         */
        abort?: Schema$HttpFaultAbort;
        /**
         * The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
         */
        delay?: Schema$HttpFaultDelay;
    }
    /**
     * HttpFilterConfiguration supplies additional contextual settings for networkservices.HttpFilter resources enabled by Traffic Director.
     */
    export interface Schema$HttpFilterConfig {
        /**
         * The configuration needed to enable the networkservices.HttpFilter resource. The configuration must be YAML formatted and only contain fields defined in the protobuf identified in configTypeUrl
         */
        config?: string | null;
        /**
         * The fully qualified versioned proto3 type url of the protobuf that the filter expects for its contextual settings, for example: type.googleapis.com/google.protobuf.Struct
         */
        configTypeUrl?: string | null;
        /**
         * Name of the networkservices.HttpFilter resource this configuration belongs to. This name must be known to the xDS client. Example: envoy.wasm
         */
        filterName?: string | null;
    }
    /**
     * The request and response header transformations that take effect before the request is passed along to the selected backendService.
     */
    export interface Schema$HttpHeaderAction {
        /**
         * Headers to add to a matching request before forwarding the request to the backendService.
         */
        requestHeadersToAdd?: Schema$HttpHeaderOption[];
        /**
         * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
         */
        requestHeadersToRemove?: string[] | null;
        /**
         * Headers to add the response before sending the response back to the client.
         */
        responseHeadersToAdd?: Schema$HttpHeaderOption[];
        /**
         * A list of header names for headers that need to be removed from the response before sending the response back to the client.
         */
        responseHeadersToRemove?: string[] | null;
    }
    /**
     * matchRule criteria for request header matches.
     */
    export interface Schema$HttpHeaderMatch {
        /**
         * The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        exactMatch?: string | null;
        /**
         * The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
         */
        headerName?: string | null;
        /**
         * If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false.
         */
        invertMatch?: boolean | null;
        /**
         * The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        prefixMatch?: string | null;
        /**
         * A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        presentMatch?: boolean | null;
        /**
         * The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
         */
        rangeMatch?: Schema$Int64RangeMatch;
        /**
         * The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
         */
        regexMatch?: string | null;
        /**
         * The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        suffixMatch?: string | null;
    }
    /**
     * Specification determining how headers are added to requests or responses.
     */
    export interface Schema$HttpHeaderOption {
        /**
         * The name of the header.
         */
        headerName?: string | null;
        /**
         * The value of the header to add.
         */
        headerValue?: string | null;
        /**
         * If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is true, unless a variable is present in headerValue, in which case the default value is false. .
         */
        replace?: boolean | null;
    }
    export interface Schema$HTTPHealthCheck {
        /**
         * The value of the host header in the HTTP health check request. If left empty (default value), the host header is set to the destination IP address to which health check packets are sent. The destination IP address depends on the type of load balancer. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
         */
        host?: string | null;
        /**
         * The TCP port number to which the health check prober sends packets. The default value is 80. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Not supported.
         */
        portName?: string | null;
        /**
         * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Also supported in legacy HTTP health checks for target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The request path of the HTTP health check request. The default value is /. Must comply with RFC3986.
         */
        requestPath?: string | null;
        /**
         * Creates a content-based HTTP health check. In addition to the required HTTP 200 (OK) status code, you can configure the health check to pass only when the backend sends this specific ASCII response string within the first 1024 bytes of the HTTP response body. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
         */
        response?: string | null;
        /**
         * Weight report mode. used for weighted Load Balancing.
         */
        weightReportMode?: string | null;
    }
    /**
     * Represents a legacy HTTP Health Check resource. Legacy HTTP health checks are now only required by target pool-based network load balancers. For all other load balancers, including backend service-based network load balancers, and for managed instance group auto-healing, you must use modern (non-legacy) health checks. For more information, see Health checks overview .
     */
    export interface Schema$HttpHealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number | null;
        /**
         * The value of the host header in the HTTP health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#httpHealthCheck for HTTP health checks.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The TCP port number for the HTTP health check request. The default value is 80.
         */
        port?: number | null;
        /**
         * The request path of the HTTP health check request. The default value is /. This field does not support query parameters. Must comply with RFC3986.
         */
        requestPath?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
         */
        timeoutSec?: number | null;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number | null;
    }
    /**
     * Contains a list of HttpHealthCheck resources.
     */
    export interface Schema$HttpHealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HttpHealthCheck resources.
         */
        items?: Schema$HttpHealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * HttpRouteRuleMatch criteria for a request's query parameter.
     */
    export interface Schema$HttpQueryParameterMatch {
        /**
         * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set.
         */
        exactMatch?: string | null;
        /**
         * The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
         */
        name?: string | null;
        /**
         * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch, or regexMatch must be set.
         */
        presentMatch?: boolean | null;
        /**
         * The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For more information about regular expression syntax, see Syntax. Only one of presentMatch, exactMatch, or regexMatch must be set. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
         */
        regexMatch?: string | null;
    }
    /**
     * Specifies settings for an HTTP redirect.
     */
    export interface Schema$HttpRedirectAction {
        /**
         * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
         */
        hostRedirect?: string | null;
        /**
         * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
         */
        httpsRedirect?: boolean | null;
        /**
         * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
         */
        pathRedirect?: string | null;
        /**
         * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
         */
        prefixRedirect?: string | null;
        /**
         * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
         */
        redirectResponseCode?: string | null;
        /**
         * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
         */
        stripQuery?: boolean | null;
    }
    /**
     * The retry policy associates with HttpRouteRule
     */
    export interface Schema$HttpRetryPolicy {
        /**
         * Specifies the allowed number retries. This number must be \> 0. If not specified, defaults to 1.
         */
        numRetries?: number | null;
        /**
         * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
         */
        perTryTimeout?: Schema$Duration;
        /**
         * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
         */
        retryConditions?: string[] | null;
    }
    export interface Schema$HttpRouteAction {
        /**
         * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
         */
        corsPolicy?: Schema$CorsPolicy;
        /**
         * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
         */
        faultInjectionPolicy?: Schema$HttpFaultInjection;
        /**
         * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        maxStreamDuration?: Schema$Duration;
        /**
         * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
         */
        requestMirrorPolicy?: Schema$RequestMirrorPolicy;
        /**
         * Specifies the retry policy associated with this route.
         */
        retryPolicy?: Schema$HttpRetryPolicy;
        /**
         * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
         */
        timeout?: Schema$Duration;
        /**
         * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
         */
        urlRewrite?: Schema$UrlRewrite;
        /**
         * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
         */
        weightedBackendServices?: Schema$WeightedBackendService[];
    }
    /**
     * The HttpRouteRule setting specifies how to match an HTTP request and the corresponding routing action that load balancing proxies perform.
     */
    export interface Schema$HttpRouteRule {
        /**
         * customErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. If a policy for an error code is not configured for the RouteRule, a policy for the error code configured in pathMatcher.defaultCustomErrorResponsePolicy is applied. If one is not specified in pathMatcher.defaultCustomErrorResponsePolicy, the policy configured in UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the following configuration: - UrlMap.defaultCustomErrorResponsePolicy are configured with policies for 5xx and 4xx errors - A RouteRule for /coming_soon/ is configured for the error code 404. If the request is for www.myotherdomain.com and a 404 is encountered, the policy under UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the request for www.example.com/coming_soon/ encounters a 404, the policy in RouteRule.customErrorResponsePolicy takes effect. If any of the requests in this example encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with routeRules.routeAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the customErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the customErrorResponsePolicy is ignored and the response from the service is returned to the client. customErrorResponsePolicy is supported only for global external Application Load Balancers.
         */
        customErrorResponsePolicy?: Schema$CustomErrorResponsePolicy;
        /**
         * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
         */
        description?: string | null;
        /**
         * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
         */
        headerAction?: Schema$HttpHeaderAction;
        /**
         * Outbound route specific configuration for networkservices.HttpFilter resources enabled by Traffic Director. httpFilterConfigs only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
         */
        httpFilterConfigs?: Schema$HttpFilterConfig[];
        /**
         * Outbound route specific metadata supplied to networkservices.HttpFilter resources enabled by Traffic Director. httpFilterMetadata only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. The only configTypeUrl supported is type.googleapis.com/google.protobuf.Struct Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
         */
        httpFilterMetadata?: Schema$HttpFilterConfig[];
        /**
         * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
         */
        matchRules?: Schema$HttpRouteRuleMatch[];
        /**
         * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
         */
        priority?: number | null;
        /**
         * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of urlRedirect, service or routeAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a route rule's routeAction.
         */
        routeAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of urlRedirect, service or routeAction.weightedBackendService can be set.
         */
        service?: string | null;
        /**
         * When this rule is matched, the request is redirected to a URL specified by urlRedirect. Only one of urlRedirect, service or routeAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
         */
        urlRedirect?: Schema$HttpRedirectAction;
    }
    /**
     * HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
     */
    export interface Schema$HttpRouteRuleMatch {
        /**
         * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
         */
        fullPathMatch?: string | null;
        /**
         * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
         */
        headerMatches?: Schema$HttpHeaderMatch[];
        /**
         * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
         */
        ignoreCase?: boolean | null;
        /**
         * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
         */
        metadataFilters?: Schema$MetadataFilter[];
        /**
         * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
         */
        pathTemplateMatch?: string | null;
        /**
         * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
         */
        prefixMatch?: string | null;
        /**
         * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
         */
        queryParameterMatches?: Schema$HttpQueryParameterMatch[];
        /**
         * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
         */
        regexMatch?: string | null;
    }
    export interface Schema$HTTPSHealthCheck {
        /**
         * The value of the host header in the HTTPS health check request. If left empty (default value), the host header is set to the destination IP address to which health check packets are sent. The destination IP address depends on the type of load balancer. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
         */
        host?: string | null;
        /**
         * The TCP port number to which the health check prober sends packets. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Not supported.
         */
        portName?: string | null;
        /**
         * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The request path of the HTTPS health check request. The default value is /. Must comply with RFC3986.
         */
        requestPath?: string | null;
        /**
         * Creates a content-based HTTPS health check. In addition to the required HTTP 200 (OK) status code, you can configure the health check to pass only when the backend sends this specific ASCII response string within the first 1024 bytes of the HTTP response body. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
         */
        response?: string | null;
        /**
         * Weight report mode. used for weighted Load Balancing.
         */
        weightReportMode?: string | null;
    }
    /**
     * Represents a legacy HTTPS Health Check resource. Legacy HTTPS health checks have been deprecated. If you are using a target pool-based network load balancer, you must use a legacy HTTP (not HTTPS) health check. For all other load balancers, including backend service-based network load balancers, and for managed instance group auto-healing, you must use modern (non-legacy) health checks. For more information, see Health checks overview .
     */
    export interface Schema$HttpsHealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number | null;
        /**
         * The value of the host header in the HTTPS health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Type of the resource.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The TCP port number for the HTTPS health check request. The default value is 443.
         */
        port?: number | null;
        /**
         * The request path of the HTTPS health check request. The default value is "/". Must comply with RFC3986.
         */
        requestPath?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have a greater value than checkIntervalSec.
         */
        timeoutSec?: number | null;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number | null;
    }
    /**
     * Contains a list of HttpsHealthCheck resources.
     */
    export interface Schema$HttpsHealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HttpsHealthCheck resources.
         */
        items?: Schema$HttpsHealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Image resource. You can use images to create boot disks for your VM instances. For more information, read Images.
     */
    export interface Schema$Image {
        /**
         * The architecture of the image. Valid values are ARM64 or X86_64.
         */
        architecture?: string | null;
        /**
         * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
         */
        archiveSizeBytes?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * The deprecation status associated with this image.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Size of the image when restored onto a persistent disk (in GB).
         */
        diskSizeGb?: string | null;
        /**
         * Whether this image is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
         */
        enableConfidentialCompute?: boolean | null;
        /**
         * The name of the image family to which this image belongs. The image family name can be from a publicly managed image family provided by Compute Engine, or from a custom image family you create. For example, centos-stream-9 is a publicly available image family. For more information, see Image family best practices. When creating disks, you can specify an image family instead of a specific image name. The image family always returns its latest image that is not deprecated. The name of the image family must comply with RFC1035.
         */
        family?: string | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. To see a list of available options, see the guestOSfeatures[].type parameter.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Encrypts the image using a customer-supplied encryption key. After you encrypt an image with a customer-supplied key, you must provide the same key if you use the image later (e.g. to create a disk from the image). Customer-supplied encryption keys do not protect access to metadata of the disk. If you do not provide an encryption key when creating the image, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the image later.
         */
        imageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] Type of the resource. Always compute#image for images.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this image, which is essentially a hash of the labels used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an image.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this image. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Integer license codes indicating which licenses are attached to this image.
         */
        licenseCodes?: string[] | null;
        /**
         * Any applicable license URI.
         */
        licenses?: string[] | null;
        /**
         * A flag for marketplace VM disk created from the image, which is designed for marketplace VM disk to prevent the proprietary data on the disk from being accessed unwantedly. The flag will be inherited by the disk created from the image. The disk with locked flag set to true will be prohibited from performing the operations below: - R/W or R/O disk attach - Disk detach, if disk is created via create-on-create - Create images - Create snapshots - Create disk clone (create disk from the current disk) The image with the locked field set to true will be prohibited from performing the operations below: - Create images from the current image - Update the locked field for the current image The instance with at least one disk with locked flag set to true will be prohibited from performing the operations below: - Secondary disk attach - Create instant snapshot - Create machine images - Create instance template - Delete the instance with --keep-disk parameter set to true
         */
        locked?: boolean | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
         */
        params?: Schema$ImageParams;
        /**
         * The parameters of the raw disk image.
         */
        rawDisk?: {
            containerType?: string;
            sha1Checksum?: string;
            source?: string;
        } | null;
        /**
         * A rollout policy to apply to this image. When specified, the rollout policy overrides per-zone references to the image via the associated image family. The rollout policy restricts the zones where this image is accessible when using a zonal image family reference. When the rollout policy does not include the user specified zone, or if the zone is rolled out, this image is accessible. The rollout policy for this image is read-only, except for allowlisted users. This field might not be configured. To view the latest non-deprecated image in a specific zone, use the imageFamilyViews.get method.
         */
        rolloutOverride?: Schema$RolloutPolicy;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Set the secure boot keys of shielded instance.
         */
        shieldedInstanceInitialState?: Schema$InitialStateConfig;
        /**
         * URL of the source disk used to create this image. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
         */
        sourceDisk?: string | null;
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the disk used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string | null;
        /**
         * URL of the source image used to create this image. The following are valid formats for the URL: - https://www.googleapis.com/compute/v1/projects/project_id/global/ images/image_name - projects/project_id/global/images/image_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
         */
        sourceImage?: string | null;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the image used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given image name.
         */
        sourceImageId?: string | null;
        /**
         * URL of the source snapshot used to create this image. The following are valid formats for the URL: - https://www.googleapis.com/compute/v1/projects/project_id/global/ snapshots/snapshot_name - projects/project_id/global/snapshots/snapshot_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL
         */
        sourceSnapshot?: string | null;
        /**
         * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the snapshot used to create this image. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given snapshot name.
         */
        sourceSnapshotId?: string | null;
        /**
         * The type of the image used to create this disk. The default and only valid value is RAW.
         */
        sourceType?: string | null;
        /**
         * [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
         */
        status?: string | null;
        /**
         * Cloud Storage bucket storage location of the image (regional or multi-regional).
         */
        storageLocations?: string[] | null;
        /**
         * A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license: https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch
         */
        userLicenses?: string[] | null;
    }
    export interface Schema$ImageFamilyView {
        /**
         * The latest image that is part of the specified image family in the requested location, and that is not deprecated.
         */
        image?: Schema$Image;
    }
    /**
     * Contains a list of images.
     */
    export interface Schema$ImageList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Image resources.
         */
        items?: Schema$Image[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Additional image params.
     */
    export interface Schema$ImageParams {
        /**
         * Resource manager tags to be bound to the image. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id\}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Initial State for shielded instance, these are public keys which are safe to store in public
     */
    export interface Schema$InitialStateConfig {
        /**
         * The Key Database (db).
         */
        dbs?: Schema$FileContentBuffer[];
        /**
         * The forbidden key database (dbx).
         */
        dbxs?: Schema$FileContentBuffer[];
        /**
         * The Key Exchange Key (KEK).
         */
        keks?: Schema$FileContentBuffer[];
        /**
         * The Platform Key (PK).
         */
        pk?: Schema$FileContentBuffer;
    }
    /**
     * Represents an Instance resource. An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances.
     */
    export interface Schema$Instance {
        /**
         * Controls for advanced machine-related behavior features.
         */
        advancedMachineFeatures?: Schema$AdvancedMachineFeatures;
        /**
         * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
         */
        canIpForward?: boolean | null;
        confidentialInstanceConfig?: Schema$ConfidentialInstanceConfig;
        /**
         * [Output Only] The CPU platform used by this instance.
         */
        cpuPlatform?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Whether the resource should be protected against deletion.
         */
        deletionProtection?: boolean | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
         */
        disks?: Schema$AttachedDisk[];
        /**
         * Enables display device for the instance.
         */
        displayDevice?: Schema$DisplayDevice;
        /**
         * Specifies whether the disks restored from source snapshots or source machine image should erase Windows specific VSS signature.
         */
        eraseWindowsVssSignature?: boolean | null;
        /**
         * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
         */
        fingerprint?: string | null;
        /**
         * A list of the type and count of accelerator cards attached to the instance.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
         */
        hostname?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
         */
        instanceEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
         */
        keyRevocationActionType?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#instance for instances.
         */
        kind?: string | null;
        /**
         * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this instance. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Last start timestamp in RFC3339 text format.
         */
        lastStartTimestamp?: string | null;
        /**
         * [Output Only] Last stop timestamp in RFC3339 text format.
         */
        lastStopTimestamp?: string | null;
        /**
         * [Output Only] Last suspended timestamp in RFC3339 text format.
         */
        lastSuspendedTimestamp?: string | null;
        /**
         * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
         */
        machineType?: string | null;
        /**
         * The metadata key/value pairs assigned to this instance. This includes metadata keys that were explicitly defined for the instance.
         */
        metadata?: Schema$Metadata;
        /**
         * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
         */
        minCpuPlatform?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        networkPerformanceConfig?: Schema$NetworkPerformanceConfig;
        /**
         * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
         */
        params?: Schema$InstanceParams;
        /**
         * Partner Metadata assigned to the instance. A map from a subdomain (namespace) to entries map.
         */
        partnerMetadata?: {
            [key: string]: Schema$StructuredEntries;
        } | null;
        /**
         * PostKeyRevocationActionType of the instance.
         */
        postKeyRevocationActionType?: string | null;
        /**
         * Total amount of preserved state for SUSPENDED instances. Read-only in the api.
         */
        preservedStateSizeGb?: string | null;
        /**
         * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
         */
        privateIpv6GoogleAccess?: string | null;
        /**
         * Specifies the reservations that this instance can consume from.
         */
        reservationAffinity?: Schema$ReservationAffinity;
        /**
         * Resource policies applied to this instance.
         */
        resourcePolicies?: string[] | null;
        /**
         * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
         */
        resourceStatus?: Schema$ResourceStatus;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Sets the scheduling options for this instance.
         */
        scheduling?: Schema$Scheduling;
        /**
         * [Input Only] Secure tags to apply to this instance. These can be later modified by the update method. Maximum number of secure tags allowed is 50.
         */
        secureTags?: string[] | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        /**
         * Mapping of user-defined keys to specifications for service integrations. Currently only a single key-value pair is supported.
         */
        serviceIntegrationSpecs?: {
            [key: string]: Schema$ServiceIntegrationSpec;
        } | null;
        shieldedInstanceConfig?: Schema$ShieldedInstanceConfig;
        shieldedInstanceIntegrityPolicy?: Schema$ShieldedInstanceIntegrityPolicy;
        /**
         * Deprecating, please use shielded_instance_config.
         */
        shieldedVmConfig?: Schema$ShieldedVmConfig;
        /**
         * Deprecating, please use shielded_instance_integrity_policy.
         */
        shieldedVmIntegrityPolicy?: Schema$ShieldedVmIntegrityPolicy;
        /**
         * Source machine image
         */
        sourceMachineImage?: string | null;
        /**
         * Source machine image encryption key when creating an instance from a machine image.
         */
        sourceMachineImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
         */
        startRestricted?: boolean | null;
        /**
         * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
         */
        status?: string | null;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string | null;
        /**
         * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
         */
        tags?: Schema$Tags;
        /**
         * [Output Only] DEPRECATED: Please use resource_status.upcoming_maintenance instead. Specifies upcoming maintenance for the instance.
         */
        upcomingMaintenance?: Schema$UpcomingMaintenance;
        /**
         * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$InstanceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * An object that contains a list of instances scoped by zone.
         */
        items?: {
            [key: string]: Schema$InstancesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#instanceAggregatedList for aggregated lists of Instance resources.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceConsumptionData {
        /**
         * Resources consumed by the instance.
         */
        consumptionInfo?: Schema$InstanceConsumptionInfo;
        /**
         * Server-defined URL for the instance.
         */
        instance?: string | null;
    }
    export interface Schema$InstanceConsumptionInfo {
        /**
         * The number of virtual CPUs that are available to the instance.
         */
        guestCpus?: number | null;
        /**
         * The amount of local SSD storage available to the instance, defined in GiB.
         */
        localSsdGb?: number | null;
        /**
         * The amount of physical memory available to the instance, defined in MiB.
         */
        memoryMb?: number | null;
        /**
         * The minimal guaranteed number of virtual CPUs that are reserved.
         */
        minNodeCpus?: number | null;
    }
    /**
     * A flexible specification of machine types for instances to create.
     */
    export interface Schema$InstanceFlexibilityPolicy {
        /**
         * Specification of alternative, flexible instance subsets. One of them will be selected to create the instances based on various criteria, like: - ranks, - location policy, - current capacity, - available reservations (you can specify affinity in InstanceProperties), - SWAN/GOOSE limitations. Key is an arbitrary, unique RFC1035 string that identifies the instance selection.
         */
        instanceSelections?: {
            [key: string]: Schema$InstanceFlexibilityPolicyInstanceSelection;
        } | null;
    }
    /**
     * Specification of machine type to use. Every position inside this message is an alternative. The count specified in the shape flexibility must not exceed the number of entries in per_instance_properties or the capacity of the name_pattern, if used.
     */
    export interface Schema$InstanceFlexibilityPolicyInstanceSelection {
        /**
         * Alternative machine types to use for instances that are created from these properties. This field only accepts a machine type names, for example `n2-standard-4` and not URLs or partial URLs.
         */
        machineTypes?: string[] | null;
        /**
         * Rank when prioritizing the shape flexibilities. The instance selections with rank are considered first, in the ascending order of the rank. If not set, defaults to 0.
         */
        rank?: string | null;
    }
    /**
     * Represents an Instance Group resource. Instance Groups can be used to configure a target for load balancing. Instance groups can either be managed or unmanaged. To create managed instance groups, use the instanceGroupManager or regionInstanceGroupManager resource instead. Use zonal unmanaged instance groups if you need to apply load balancing to groups of heterogeneous instances or if you need to manage the instances yourself. You cannot create regional unmanaged instance groups. For more information, read Instance groups.
     */
    export interface Schema$InstanceGroup {
        /**
         * [Output Only] The creation timestamp for this instance group in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect conflicts when multiple users change the named ports concurrently.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] A unique identifier for this instance group, generated by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
         */
        kind?: string | null;
        /**
         * The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         *  Optional. Assigns a name to a port number. For example: {name: "http", port: 80\} This allows the system to reference ports by the assigned name instead of a port number. Named ports can also contain multiple ports. For example: [{name: "app1", port: 8080\}, {name: "app1", port: 8081\}, {name: "app2", port: 8082\}] Named ports apply to all instances in this instance group.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The URL of the network to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).
         */
        network?: string | null;
        /**
         * [Output Only] The URL of the region where the instance group is located (for regional resources).
         */
        region?: string | null;
        /**
         * [Output Only] The URL for this instance group. The server generates this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The total number of instances in the instance group.
         */
        size?: number | null;
        /**
         * [Output Only] The URL of the subnetwork to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The URL of the zone where the instance group is located (for zonal resources).
         */
        zone?: string | null;
    }
    export interface Schema$InstanceGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceGroupsScopedList;
        } | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupAggregatedList for aggregated lists of instance groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A list of InstanceGroup resources.
     */
    export interface Schema$InstanceGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroup resources.
         */
        items?: Schema$InstanceGroup[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupList for instance group lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Managed Instance Group resource. An instance group is a collection of VM instances that you can manage as a single entity. For more information, read Instance groups. For zonal Managed Instance Group, use the instanceGroupManagers resource. For regional Managed Instance Group, use the regionInstanceGroupManagers resource.
     */
    export interface Schema$InstanceGroupManager {
        /**
         * Specifies configuration that overrides the instance template configuration for the group.
         */
        allInstancesConfig?: Schema$InstanceGroupManagerAllInstancesConfig;
        /**
         * The autohealing policy for this managed instance group. You can specify only one value.
         */
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
        /**
         * The base instance name is a prefix that you want to attach to the names of all VMs in a MIG. The maximum character length is 58 and the name must comply with RFC1035 format. When a VM is created in the group, the MIG appends a hyphen and a random four-character string to the base instance name. If you want the MIG to assign sequential numbers instead of a random string, then end the base instance name with a hyphen followed by one or more hash symbols. The hash symbols indicate the number of digits. For example, a base instance name of "vm-###" results in "vm-001" as a VM name. @pattern [a-z](([-a-z0-9]{0,57\})|([-a-z0-9]{0,51\}-#{1,10\}(\\[[0-9]{1,10\}\\])?))
         */
        baseInstanceName?: string | null;
        /**
         * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
         */
        currentActions?: Schema$InstanceGroupManagerActionsSummary;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
         */
        distributionPolicy?: Schema$DistributionPolicy;
        /**
         * The action to perform in case of zone failure. Only one value is supported, NO_FAILOVER. The default is NO_FAILOVER.
         */
        failoverAction?: string | null;
        /**
         * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * Instance flexibility allowing MIG to create VMs from multiple types of machines. Instance flexibility configuration on MIG overrides instance template configuration.
         */
        instanceFlexibilityPolicy?: Schema$InstanceGroupManagerInstanceFlexibilityPolicy;
        /**
         * [Output Only] The URL of the Instance Group resource.
         */
        instanceGroup?: string | null;
        /**
         * The repair policy for this managed instance group.
         */
        instanceLifecyclePolicy?: Schema$InstanceGroupManagerInstanceLifecyclePolicy;
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
         */
        instanceTemplate?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
         */
        kind?: string | null;
        /**
         * Pagination behavior of the listManagedInstances API method for this managed instance group.
         */
        listManagedInstancesResults?: string | null;
        /**
         * URL to the multi-MIG that this Managed Instance Group belongs to.
         */
        multiMig?: string | null;
        /**
         * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         * [Output Only] Named ports configured on the Instance Groups complementary to this Instance Group Manager.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * Input only. Additional params passed with the request, but not persisted as part of resource payload.
         */
        params?: Schema$InstanceGroupManagerParams;
        /**
         * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
         */
        region?: string | null;
        /**
         * Resource policies for this managed instance group.
         */
        resourcePolicies?: Schema$InstanceGroupManagerResourcePolicies;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] The URL for this managed instance group. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The service account to be used as credentials for all operations performed by the managed instance group on instances. The service accounts needs all permissions required to create and delete instances. By default, the service account {projectNumber\}@cloudservices.gserviceaccount.com is used.
         */
        serviceAccount?: string | null;
        /**
         * Standby policy for stopped and suspended instances.
         */
        standbyPolicy?: Schema$InstanceGroupManagerStandbyPolicy;
        /**
         * Stateful configuration for this Instanced Group Manager
         */
        statefulPolicy?: Schema$StatefulPolicy;
        /**
         * [Output Only] The status of this managed instance group.
         */
        status?: Schema$InstanceGroupManagerStatus;
        /**
         * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
         */
        targetPools?: string[] | null;
        /**
         * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
         */
        targetSize?: number | null;
        /**
         * The policy that specifies how the MIG creates its VMs to achieve the target size.
         */
        targetSizePolicy?: Schema$InstanceGroupManagerTargetSizePolicy;
        /**
         * The unit of measure for the target size.
         */
        targetSizeUnit?: string | null;
        /**
         * The target number of stopped instances for this managed instance group. This number changes when you: - Stop instance using the stopInstances method or start instances using the startInstances method. - Manually change the targetStoppedSize using the update method.
         */
        targetStoppedSize?: number | null;
        /**
         * The target number of suspended instances for this managed instance group. This number changes when you: - Suspend instance using the suspendInstances method or resume instances using the resumeInstances method. - Manually change the targetSuspendedSize using the update method.
         */
        targetSuspendedSize?: number | null;
        /**
         * The update policy for this managed instance group.
         */
        updatePolicy?: Schema$InstanceGroupManagerUpdatePolicy;
        /**
         * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
         */
        versions?: Schema$InstanceGroupManagerVersion[];
        /**
         * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
         */
        zone?: string | null;
    }
    export interface Schema$InstanceGroupManagerActionsSummary {
        /**
         * [Output Only] The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.
         */
        abandoning?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully. If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.
         */
        creating?: number | null;
        /**
         * [Output Only] The number of instances that the managed instance group will attempt to create atomically, in a batch mode. If the desired count of instances can not be created, entire batch will be deleted and the group will decrease its targetSize value accordingly.
         */
        creatingAtomically?: number | null;
        /**
         * [Output Only] The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group's targetSize value accordingly.
         */
        creatingWithoutRetries?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.
         */
        deleting?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are running and have no scheduled actions.
         */
        none?: number | null;
        /**
         * [Output Only] The number of instances that the managed instance group is currently queuing.
         */
        queuing?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.
         */
        recreating?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.
         */
        refreshing?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.
         */
        restarting?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be resumed or are currently being resumed.
         */
        resuming?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be started or are currently being started.
         */
        starting?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be stopped or are currently being stopped.
         */
        stopping?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be suspended or are currently being suspended.
         */
        suspending?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.
         */
        verifying?: number | null;
    }
    export interface Schema$InstanceGroupManagerAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupManagersScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceGroupManagersScopedList;
        } | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerAggregatedList for an aggregated list of managed instance groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupManagerAllInstancesConfig {
        /**
         * Properties to set on all instances in the group. You can add or modify properties using the instanceGroupManagers.patch or regionInstanceGroupManagers.patch. After setting allInstancesConfig on the group, you must update the group's instances to apply the configuration. To apply the configuration, set the group's updatePolicy.type field to use proactive updates or use the applyUpdatesToInstances method.
         */
        properties?: Schema$InstancePropertiesPatch;
    }
    export interface Schema$InstanceGroupManagerAutoHealingPolicy {
        /**
         * Restricts what triggers autohealing.
         */
        autoHealingTriggers?: Schema$InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers;
        /**
         * The URL for the health check that signals autohealing.
         */
        healthCheck?: string | null;
        /**
         * The initial delay is the number of seconds that a new VM takes to initialize and run its startup script. During a VM's initial delay period, the MIG ignores unsuccessful health checks because the VM might be in the startup process. This prevents the MIG from prematurely recreating a VM. If the health check receives a healthy response during the initial delay, it indicates that the startup process is complete and the VM is ready. The value of initial delay must be between 0 and 3600 seconds. The default value is 0.
         */
        initialDelaySec?: number | null;
        /**
         * Maximum number of instances that can be unavailable when autohealing. When 'percent' is used, the value is rounded if necessary. The instance is considered available if all of the following conditions are satisfied: 1. Instance's status is RUNNING. 2. Instance's currentAction is NONE (in particular its liveness health check result was observed to be HEALTHY at least once as it passed VERIFYING). 3. There is no outgoing action on an instance triggered by IGM. By default, number of concurrently autohealed instances is smaller than the managed instance group target size. However, if a zonal managed instance group has only one instance, or a regional managed instance group has only one instance per zone, autohealing will recreate these instances when they become unhealthy.
         */
        maxUnavailable?: Schema$FixedOrPercent;
    }
    export interface Schema$InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers {
        /**
         * If you have configured an application-based health check for the group, this field controls whether to trigger VM autohealing based on a failed health check. Valid values are: - ON (default): The group recreates running VMs that fail the application-based health check. - OFF: When set to OFF, you can still observe instance health state, but the group does not recreate VMs that fail the application-based health check. This is useful for troubleshooting and setting up your health check configuration.
         */
        onHealthCheck?: string | null;
    }
    export interface Schema$InstanceGroupManagerInstanceFlexibilityPolicy {
        /**
         * Named instance selections configuring properties that the group will use when creating new VMs.
         */
        instanceSelectionLists?: {
            [key: string]: Schema$InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection;
        } | null;
        /**
         * Named instance selections configuring properties that the group will use when creating new VMs.
         */
        instanceSelections?: {
            [key: string]: Schema$InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection;
        } | null;
        /**
         * Provisioning model configuration used by this managed instance group to create instances.
         */
        provisioningModelMix?: Schema$InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix;
    }
    export interface Schema$InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection {
        /**
         * Full machine-type names, e.g. "n1-standard-16".
         */
        machineTypes?: string[] | null;
        /**
         * Preference of this instance selection. Lower number means higher preference. MIG will first try to create a VM based on the machine-type with lowest rank and fallback to next rank based on availability. Machine types and instance selections with the same rank have the same preference.
         */
        rank?: number | null;
    }
    export interface Schema$InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix {
        /**
         * The base capacity that will always use Standard VMs to avoid risk of more preemption than the minimum capacity user needs. MIG will create only Standard VMs until it reaches standard_capacity_base and only then will start using standard_capacity_percent_above_base to mix Spot with Standard VMs.
         */
        standardCapacityBase?: number | null;
        /**
         * The percentage of target capacity that should use Standard VM. The remaining percentage will use Spot VMs. The percentage applies only to the capacity above standard_capacity_base.
         */
        standardCapacityPercentAboveBase?: number | null;
    }
    export interface Schema$InstanceGroupManagerInstanceLifecyclePolicy {
        /**
         * The action that a MIG performs on a failed VM. If the value of the onFailedHealthCheck field is `DEFAULT_ACTION`, then the same action also applies to the VMs on which your application fails a health check. Valid values are - REPAIR (default): MIG automatically repairs a failed VM by recreating it. For more information, see about repairing VMs in a MIG. - DO_NOTHING: MIG does not repair a failed VM.
         */
        defaultActionOnFailure?: string | null;
        /**
         * A bit indicating whether to forcefully apply the group's latest configuration when repairing a VM. Valid options are: - NO (default): If configuration updates are available, they are not forcefully applied during repair. Instead, configuration updates are applied according to the group's update policy. - YES: If configuration updates are available, they are applied during repair.
         */
        forceUpdateOnRepair?: string | null;
        /**
         * The configuration for metadata based readiness signal sent by the instance during initialization when stopping / suspending an instance. The Instance Group Manager will wait for a signal that indicates successful initialization before stopping / suspending an instance. If a successful readiness signal is not sent before timeout, the corresponding instance will not be stopped / suspended. Instead, an error will be visible in the lastAttempt.errors field of the managed instance in the listmanagedinstances method. If metadataBasedReadinessSignal.timeoutSec is unset, the Instance Group Manager will directly proceed to suspend / stop instances, skipping initialization on them.
         */
        metadataBasedReadinessSignal?: Schema$InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal;
        /**
         * The action that a MIG performs on an unhealthy VM. A VM is marked as unhealthy when the application running on that VM fails a health check. Valid values are: - DEFAULT_ACTION (default): MIG uses the same action configured for instanceLifecyclePolicy.defaultActionOnFailure field. - REPAIR: MIG automatically repairs an unhealthy VM by recreating it. - DO_NOTHING: MIG doesn't repair an unhealthy VM. For more information, see About repairing VMs in a MIG.
         */
        onFailedHealthCheck?: string | null;
        /**
         * Configuration for VM repairs in the MIG.
         */
        onRepair?: Schema$InstanceGroupManagerInstanceLifecyclePolicyOnRepair;
    }
    export interface Schema$InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal {
        /**
         * The number of seconds to wait for a readiness signal during initialization before timing out.
         */
        timeoutSec?: number | null;
    }
    /**
     * Configuration for VM repairs in the MIG.
     */
    export interface Schema$InstanceGroupManagerInstanceLifecyclePolicyOnRepair {
        /**
         * Specifies whether the MIG can change a VM's zone during a repair.
         */
        allowChangingZone?: string | null;
    }
    /**
     * [Output Only] A list of managed instance groups.
     */
    export interface Schema$InstanceGroupManagerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupManager resources.
         */
        items?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Input only additional params for instance group manager creation.
     */
    export interface Schema$InstanceGroupManagerParams {
        /**
         * Resource manager tags to bind to the managed instance group. The tags are key-value pairs. Keys must be in the format tagKeys/123 and values in the format tagValues/456. For more information, see Manage tags for resources.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
    }
    /**
     * InstanceGroupManagerResizeRequest represents a request to create a number of VMs: either immediately or by queuing the request for the specified time. This resize request is nested under InstanceGroupManager and the VMs created by this request are added to the owning InstanceGroupManager.
     */
    export interface Schema$InstanceGroupManagerResizeRequest {
        /**
         * This field is deprecated, please use resize_by instead. The count of instances to create as part of this resize request.
         */
        count?: number | null;
        /**
         * [Output Only] The creation timestamp for this resize request in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * The names of instances to be created by this resize request. The number of names specified determines the number of instances to create. The group's target size will be increased by this number. This field cannot be used together with 'resize_by'.
         */
        instances?: Schema$PerInstanceConfig[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerResizeRequest for resize requests.
         */
        kind?: string | null;
        /**
         * The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         * This field is deprecated, ResizeRequests would not be provisioned immediately and would stay in the queue until explicitly cancelled. When set, defines queing parameters for the requested deferred capacity. When unset, the request starts provisioning immediately, or fails if immediate provisioning is not possible.
         */
        queuingPolicy?: Schema$QueuingPolicy;
        /**
         * [Output Only] The URL of a region where the resize request is located. Populated only for regional resize requests.
         */
        region?: string | null;
        /**
         * Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
         */
        requestedRunDuration?: Schema$Duration;
        /**
         * The number of instances to be created by this resize request. The group's target size will be increased by this number. This field cannot be used together with 'instances'.
         */
        resizeBy?: number | null;
        /**
         * [Output Only] The URL for this resize request. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output only] Current state of the request.
         */
        state?: string | null;
        /**
         * [Output only] Status of the request.
         */
        status?: Schema$InstanceGroupManagerResizeRequestStatus;
        /**
         * [Output Only] The URL of a zone where the resize request is located. Populated only for zonal resize requests.
         */
        zone?: string | null;
    }
    /**
     * [Output Only] A list of resize requests.
     */
    export interface Schema$InstanceGroupManagerResizeRequestsListResponse {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of resize request resources.
         */
        items?: Schema$InstanceGroupManagerResizeRequest[];
        /**
         * [Output Only] Type of the resource. Always compute#instanceGroupManagerResizeRequestList for a list of resize requests.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupManagerResizeRequestStatus {
        /**
         * [Output only] Fatal errors encountered during the queueing or provisioning phases of the ResizeRequest that caused the transition to the FAILED state. Contrary to the last_attempt errors, this field is final and errors are never removed from here, as the ResizeRequest is not going to retry.
         */
        error?: {
            errors?: Array<{
                code?: string;
                errorDetails?: Array<{
                    errorInfo?: Schema$ErrorInfo;
                    help?: Schema$Help;
                    localizedMessage?: Schema$LocalizedMessage;
                    quotaInfo?: Schema$QuotaExceededInfo;
                }>;
                location?: string;
                message?: string;
            }>;
        } | null;
        /**
         * [Output only] Information about the last attempt to fulfill the request. The value is temporary since the ResizeRequest can retry, as long as it's still active and the last attempt value can either be cleared or replaced with a different error. Since ResizeRequest retries infrequently, the value may be stale and no longer show an active problem. The value is cleared when ResizeRequest transitions to the final state (becomes inactive). If the final state is FAILED the error describing it will be storred in the "error" field only.
         */
        lastAttempt?: Schema$InstanceGroupManagerResizeRequestStatusLastAttempt;
        /**
         * This field is deprecated, setting queueing policy is no longer supported. Constraints for the time when the instances start provisioning. Always exposed as absolute time.
         */
        queuingPolicy?: Schema$QueuingPolicy;
    }
    export interface Schema$InstanceGroupManagerResizeRequestStatusLastAttempt {
        /**
         * Errors that prevented the ResizeRequest to be fulfilled.
         */
        error?: {
            errors?: Array<{
                code?: string;
                errorDetails?: Array<{
                    errorInfo?: Schema$ErrorInfo;
                    help?: Schema$Help;
                    localizedMessage?: Schema$LocalizedMessage;
                    quotaInfo?: Schema$QuotaExceededInfo;
                }>;
                location?: string;
                message?: string;
            }>;
        } | null;
    }
    export interface Schema$InstanceGroupManagerResourcePolicies {
        /**
         * The URL of the workload policy that is specified for this managed instance group. It can be a full or partial URL. For example, the following are all valid URLs to a workload policy: - https://www.googleapis.com/compute/v1/projects/project/regions/region /resourcePolicies/resourcePolicy - projects/project/regions/region/resourcePolicies/resourcePolicy - regions/region/resourcePolicies/resourcePolicy
         */
        workloadPolicy?: string | null;
    }
    export interface Schema$InstanceGroupManagersAbandonInstancesRequest {
        /**
         * The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * InstanceGroupManagers.applyUpdatesToInstances
     */
    export interface Schema$InstanceGroupManagersApplyUpdatesRequest {
        /**
         * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
         */
        allInstances?: boolean | null;
        /**
         * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
        /**
         * The maximal action that should be performed on the instances. By default REPLACE. This field is deprecated, please use most_disruptive_allowed_action.
         */
        maximalAction?: string | null;
        /**
         * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
         */
        minimalAction?: string | null;
        /**
         * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
         */
        mostDisruptiveAllowedAction?: string | null;
    }
    /**
     * InstanceGroupManagers.createInstances
     */
    export interface Schema$InstanceGroupManagersCreateInstancesRequest {
        /**
         * [Required] List of specifications of per-instance configs.
         */
        instances?: Schema$PerInstanceConfig[];
    }
    export interface Schema$InstanceGroupManagersDeleteInstancesRequest {
        /**
         * The list of instance names to delete. Queued instances do not have URL and can be deleted only by name. You cannot specify both URLs and names in a single request.
         */
        instanceNames?: string[] | null;
        /**
         * The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME]. Queued instances do not have URL and can be deleted only by name. One cannot specify both URLs and names in a single request.
         */
        instances?: string[] | null;
        /**
         * Specifies whether the request should proceed despite the inclusion of instances that are not members of the group or that are already in the process of being deleted or abandoned. If this field is set to `false` and such an instance is specified in the request, the operation fails. The operation always fails if the request contains a malformed instance URL or a reference to an instance that exists in a zone or region other than the group's zone or region.
         */
        skipInstancesOnValidationError?: boolean | null;
    }
    /**
     * InstanceGroupManagers.deletePerInstanceConfigs
     */
    export interface Schema$InstanceGroupManagersDeletePerInstanceConfigsReq {
        /**
         * The list of instance names for which we want to delete per-instance configs on this managed instance group.
         */
        names?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersListErrorsResponse {
        /**
         * [Output Only] The list of errors of the managed instance group.
         */
        items?: Schema$InstanceManagedByIgmError[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$InstanceGroupManagersListManagedInstancesResponse {
        /**
         * [Output Only] The list of instances in the managed instance group.
         */
        managedInstances?: Schema$ManagedInstance[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$InstanceGroupManagersListPerInstanceConfigsResp {
        /**
         * [Output Only] The list of PerInstanceConfig.
         */
        items?: Schema$PerInstanceConfig[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * InstanceGroupManagers.patchPerInstanceConfigs
     */
    export interface Schema$InstanceGroupManagersPatchPerInstanceConfigsReq {
        /**
         * The list of per-instance configurations to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$InstanceGroupManagersRecreateInstancesRequest {
        /**
         * The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersResizeAdvancedRequest {
        /**
         * If this flag is true, the managed instance group attempts to create all instances initiated by this resize request only once. If there is an error during creation, the managed instance group does not retry create this instance, and we will decrease the targetSize of the request instead. If the flag is false, the group attempts to recreate each instance continuously until it succeeds. This flag matters only in the first attempt of creation of an instance. After an instance is successfully created while this flag is enabled, the instance behaves the same way as all the other instances created with a regular resize request. In particular, if a running instance dies unexpectedly at a later time and needs to be recreated, this mode does not affect the recreation behavior in that scenario. This flag is applicable only to the current resize request. It does not influence other resize requests in any way. You can see which instances is being creating in which mode by calling the get or listManagedInstances API.
         */
        noCreationRetries?: boolean | null;
        /**
         * The number of running instances that the managed instance group should maintain at any given time. The group automatically adds or removes instances to maintain the number of instances specified by this parameter.
         */
        targetSize?: number | null;
    }
    export interface Schema$InstanceGroupManagersResumeInstancesRequest {
        /**
         * The URLs of one or more instances to resume. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersScopedList {
        /**
         * [Output Only] The list of managed instance groups that are contained in the specified project and zone.
         */
        instanceGroupManagers?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The warning that replaces the list of managed instance groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupManagersSetAutoHealingRequest {
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
    }
    export interface Schema$InstanceGroupManagersSetInstanceTemplateRequest {
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
         */
        instanceTemplate?: string | null;
    }
    export interface Schema$InstanceGroupManagersSetTargetPoolsRequest {
        /**
         * The fingerprint of the target pools information. Use this optional property to prevent conflicts when multiple users change the target pools settings concurrently. Obtain the fingerprint with the instanceGroupManagers.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
         */
        fingerprint?: string | null;
        /**
         * The list of target pool URLs that instances in this managed instance group belong to. The managed instance group applies these target pools to all of the instances in the group. Existing instances and new instances in the group all receive these target pool settings.
         */
        targetPools?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersStartInstancesRequest {
        /**
         * The URLs of one or more instances to start. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersStopInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to stop the instances, skipping initialization on them.
         */
        forceStop?: boolean | null;
        /**
         * The URLs of one or more instances to stop. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersSuspendInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to suspend the instances, skipping initialization on them.
         */
        forceSuspend?: boolean | null;
        /**
         * The URLs of one or more instances to suspend. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagerStandbyPolicy {
        /**
         * Specifies the number of seconds that the MIG should wait to suspend or stop a VM after that VM was created. The initial delay gives the initialization script the time to prepare your VM for a quick scale out. The value of initial delay must be between 0 and 3600 seconds. The default value is 0.
         */
        initialDelaySec?: number | null;
        /**
         * Defines how a MIG resumes or starts VMs from a standby pool when the group scales out. The default mode is `MANUAL`.
         */
        mode?: string | null;
    }
    export interface Schema$InstanceGroupManagerStatus {
        /**
         * [Output only] Status of all-instances configuration on the group.
         */
        allInstancesConfig?: Schema$InstanceGroupManagerStatusAllInstancesConfig;
        /**
         * [Output Only] The URL of the Autoscaler that targets this instance group manager.
         */
        autoscaler?: string | null;
        /**
         * [Output Only] The status of bulk instance operation.
         */
        bulkInstanceOperation?: Schema$InstanceGroupManagerStatusBulkInstanceOperation;
        /**
         * [Output Only] A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.
         */
        isStable?: boolean | null;
        /**
         * [Output Only] Stateful status of the given Instance Group Manager.
         */
        stateful?: Schema$InstanceGroupManagerStatusStateful;
        /**
         * [Output Only] A status of consistency of Instances' versions with their target version specified by version field on Instance Group Manager.
         */
        versionTarget?: Schema$InstanceGroupManagerStatusVersionTarget;
    }
    export interface Schema$InstanceGroupManagerStatusAllInstancesConfig {
        /**
         * [Output Only] Current all-instances configuration revision. This value is in RFC3339 text format.
         */
        currentRevision?: string | null;
        /**
         * [Output Only] A bit indicating whether this configuration has been applied to all managed instances in the group.
         */
        effective?: boolean | null;
    }
    /**
     * Bulk instance operation is the creation of VMs in a MIG when the targetSizePolicy.mode is set to BULK.
     */
    export interface Schema$InstanceGroupManagerStatusBulkInstanceOperation {
        /**
         * [Output Only] Informs whether bulk instance operation is in progress.
         */
        inProgress?: boolean | null;
        /**
         * [Output Only] Information from the last progress check of bulk instance operation.
         */
        lastProgressCheck?: Schema$InstanceGroupManagerStatusBulkInstanceOperationLastProgressCheck;
    }
    export interface Schema$InstanceGroupManagerStatusBulkInstanceOperationLastProgressCheck {
        /**
         * [Output Only] Errors encountered during bulk instance operation.
         */
        error?: {
            errors?: Array<{
                code?: string;
                errorDetails?: Array<{
                    errorInfo?: Schema$ErrorInfo;
                    help?: Schema$Help;
                    localizedMessage?: Schema$LocalizedMessage;
                    quotaInfo?: Schema$QuotaExceededInfo;
                }>;
                location?: string;
                message?: string;
            }>;
        } | null;
        /**
         * [Output Only] Timestamp of the last progress check of bulk instance operation. Timestamp is in RFC3339 text format.
         */
        timestamp?: string | null;
    }
    export interface Schema$InstanceGroupManagerStatusStateful {
        /**
         * [Output Only] A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful configuration even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions.
         */
        hasStatefulConfig?: boolean | null;
        /**
         * [Output Only] A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful configuration even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions. This field is deprecated in favor of has_stateful_config.
         */
        isStateful?: boolean | null;
        /**
         * [Output Only] Status of per-instance configurations on the instances.
         */
        perInstanceConfigs?: Schema$InstanceGroupManagerStatusStatefulPerInstanceConfigs;
    }
    export interface Schema$InstanceGroupManagerStatusStatefulPerInstanceConfigs {
        /**
         * A bit indicating if all of the group's per-instance configurations (listed in the output of a listPerInstanceConfigs API call) have status EFFECTIVE or there are no per-instance-configs.
         */
        allEffective?: boolean | null;
    }
    export interface Schema$InstanceGroupManagerStatusVersionTarget {
        /**
         * [Output Only] A bit indicating whether version target has been reached in this managed instance group, i.e. all instances are in their target version. Instances' target version are specified by version field on Instance Group Manager.
         */
        isReached?: boolean | null;
    }
    /**
     * InstanceGroupManagers.updatePerInstanceConfigs
     */
    export interface Schema$InstanceGroupManagersUpdatePerInstanceConfigsReq {
        /**
         * The list of per-instance configurations to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$InstanceGroupManagerTargetSizePolicy {
        /**
         * The mode of target size policy based on which the MIG creates its VMs individually or all at once.
         */
        mode?: string | null;
    }
    export interface Schema$InstanceGroupManagerUpdatePolicy {
        /**
         * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
         */
        instanceRedistributionType?: string | null;
        /**
         * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
         */
        maxSurge?: Schema$FixedOrPercent;
        /**
         * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
         */
        maxUnavailable?: Schema$FixedOrPercent;
        /**
         * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
         */
        minimalAction?: string | null;
        /**
         * Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
         */
        minReadySec?: number | null;
        /**
         * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
         */
        mostDisruptiveAllowedAction?: string | null;
        /**
         * What action should be used to replace instances. See minimal_action.REPLACE
         */
        replacementMethod?: string | null;
        /**
         * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
         */
        type?: string | null;
    }
    export interface Schema$InstanceGroupManagerVersion {
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
         */
        instanceTemplate?: string | null;
        /**
         * Name of the version. Unique among all versions in the scope of this managed instance group.
         */
        name?: string | null;
        /**
         * Tag describing the version. Used to trigger rollout of a target version even if instance_template remains unchanged. Deprecated in favor of 'name'.
         */
        tag?: string | null;
        /**
         * Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
         */
        targetSize?: Schema$FixedOrPercent;
    }
    export interface Schema$InstanceGroupsAddInstancesRequest {
        /**
         * The list of instances to add to the instance group.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$InstanceGroupsListInstances {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceWithNamedPorts resources.
         */
        items?: Schema$InstanceWithNamedPorts[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupsListInstances for the list of instances in the specified instance group.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupsListInstancesRequest {
        /**
         * A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
         */
        instanceState?: string | null;
    }
    export interface Schema$InstanceGroupsRemoveInstancesRequest {
        /**
         * The list of instances to remove from the instance group.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$InstanceGroupsScopedList {
        /**
         * [Output Only] The list of instance groups that are contained in this scope.
         */
        instanceGroups?: Schema$InstanceGroup[];
        /**
         * [Output Only] An informational warning that replaces the list of instance groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupsSetNamedPortsRequest {
        /**
         * The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request. A request with an incorrect fingerprint will fail with error 412 conditionNotMet.
         */
        fingerprint?: string | null;
        /**
         * The list of named ports to set for this instance group.
         */
        namedPorts?: Schema$NamedPort[];
    }
    /**
     * Contains a list of instances.
     */
    export interface Schema$InstanceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Instance resources.
         */
        items?: Schema$Instance[];
        /**
         * [Output Only] Type of resource. Always compute#instanceList for lists of Instance resources.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of instance referrers.
     */
    export interface Schema$InstanceListReferrers {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Reference resources.
         */
        items?: Schema$Reference[];
        /**
         * [Output Only] Type of resource. Always compute#instanceListReferrers for lists of Instance referrers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceManagedByIgmError {
        /**
         * [Output Only] Contents of the error.
         */
        error?: Schema$InstanceManagedByIgmErrorManagedInstanceError;
        /**
         * [Output Only] Details of the instance action that triggered this error. May be null, if the error was not caused by an action on an instance. This field is optional.
         */
        instanceActionDetails?: Schema$InstanceManagedByIgmErrorInstanceActionDetails;
        /**
         * [Output Only] The time that this error occurred. This value is in RFC3339 text format.
         */
        timestamp?: string | null;
    }
    export interface Schema$InstanceManagedByIgmErrorInstanceActionDetails {
        /**
         * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
         */
        action?: string | null;
        /**
         * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
         */
        instance?: string | null;
        /**
         * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
         */
        version?: Schema$ManagedInstanceVersion;
    }
    export interface Schema$InstanceManagedByIgmErrorManagedInstanceError {
        /**
         * [Output Only] Error code.
         */
        code?: string | null;
        /**
         * [Output Only] Error message.
         */
        message?: string | null;
    }
    export interface Schema$InstanceMoveRequest {
        /**
         * The URL of the destination zone to move the instance. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - https://www.googleapis.com/compute/v1/projects/project/zones/zone - projects/project/zones/zone - zones/zone
         */
        destinationZone?: string | null;
        /**
         * The URL of the target instance to move. This can be a full or partial URL. For example, the following are all valid URLs to an instance: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance - zones/zone/instances/instance
         */
        targetInstance?: string | null;
    }
    /**
     * Additional instance params.
     */
    export interface Schema$InstanceParams {
        /**
         * Relative deadline for waiting for capacity. Relevant only for Instances.Insert API.
         */
        requestValidForDuration?: Schema$Duration;
        /**
         * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id\}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$InstanceProperties {
        /**
         * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
         */
        advancedMachineFeatures?: Schema$AdvancedMachineFeatures;
        /**
         * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
         */
        canIpForward?: boolean | null;
        /**
         * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
         */
        confidentialInstanceConfig?: Schema$ConfidentialInstanceConfig;
        /**
         * An optional text description for the instances that are created from these properties.
         */
        description?: string | null;
        /**
         * An array of disks that are associated with the instances that are created from these properties.
         */
        disks?: Schema$AttachedDisk[];
        /**
         * Display Device properties to enable support for remote display products like: Teradici, VNC and TeamViewer Note that for MachineImage, this is not supported yet.
         */
        displayDevice?: Schema$DisplayDevice;
        /**
         * A list of guest accelerator cards' type and count to use for instances created from these properties.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
         */
        keyRevocationActionType?: string | null;
        /**
         * Labels to apply to instances that are created from these properties.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The machine type to use for instances that are created from these properties. This field only accepts a machine type name, for example `n2-standard-4`. If you use the machine type full or partial URL, for example `projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4`, the request will result in an `INTERNAL_ERROR`.
         */
        machineType?: string | null;
        /**
         * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
         */
        metadata?: Schema$Metadata;
        /**
         * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
         */
        minCpuPlatform?: string | null;
        /**
         * An array of network access configurations for this interface.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        /**
         * Note that for MachineImage, this is not supported yet.
         */
        networkPerformanceConfig?: Schema$NetworkPerformanceConfig;
        /**
         * Partner Metadata assigned to the instance properties. A map from a subdomain (namespace) to entries map.
         */
        partnerMetadata?: {
            [key: string]: Schema$StructuredEntries;
        } | null;
        /**
         * PostKeyRevocationActionType of the instance.
         */
        postKeyRevocationActionType?: string | null;
        /**
         * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
         */
        privateIpv6GoogleAccess?: string | null;
        /**
         * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
         */
        reservationAffinity?: Schema$ReservationAffinity;
        /**
         * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id\}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
        /**
         * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
         */
        resourcePolicies?: string[] | null;
        /**
         * Specifies the scheduling options for the instances that are created from these properties.
         */
        scheduling?: Schema$Scheduling;
        /**
         * [Input Only] Secure tags to apply to this instance. Maximum number of secure tags allowed is 50. Note that for MachineImage, this is not supported yet.
         */
        secureTags?: string[] | null;
        /**
         * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        /**
         * Mapping of user defined keys to ServiceIntegrationSpec.
         */
        serviceIntegrationSpecs?: {
            [key: string]: Schema$ServiceIntegrationSpec;
        } | null;
        /**
         * Note that for MachineImage, this is not supported yet.
         */
        shieldedInstanceConfig?: Schema$ShieldedInstanceConfig;
        /**
         * Specifies the Shielded VM options for the instances that are created from these properties.
         */
        shieldedVmConfig?: Schema$ShieldedVmConfig;
        /**
         * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
         */
        tags?: Schema$Tags;
    }
    /**
     * Represents the change that you want to make to the instance properties.
     */
    export interface Schema$InstancePropertiesPatch {
        /**
         * The label key-value pairs that you want to patch onto the instance.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The metadata key-value pairs that you want to patch onto the instance. For more information, see Project and instance metadata.
         */
        metadata?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$InstanceReference {
        /**
         * The URL for a specific instance. @required compute.instancegroups.addInstances/removeInstances
         */
        instance?: string | null;
    }
    export interface Schema$InstancesAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this instance.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$InstancesBulkInsertOperationMetadata {
        /**
         * Status information per location (location name is key). Example key: zones/us-central1-a
         */
        perLocationStatus?: {
            [key: string]: Schema$BulkInsertOperationStatus;
        } | null;
    }
    /**
     * Represents a Instance Settings resource. You can use instance settings to configure default settings for Compute Engine VM instances. For example, you can use it to configure default machine type of Compute Engine VM instances.
     */
    export interface Schema$InstanceSettings {
        /**
         * Email address of the service account.
         */
        email?: string | null;
        /**
         * Specifies a fingerprint for instance settings, which is essentially a hash of the instance settings resource's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance settings resource. You must always provide an up-to-date fingerprint hash in order to update or change the resource, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#instance_settings for instance settings.
         */
        kind?: string | null;
        /**
         * The metadata key/value pairs assigned to all the instances in the corresponding scope.
         */
        metadata?: Schema$InstanceSettingsMetadata;
        /**
         * [Output Only] URL of the zone where the resource resides You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$InstanceSettingsMetadata {
        /**
         * A metadata key/value items map. The total size of all keys and values must be less than 512KB.
         */
        items?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Type of the resource. Always compute#metadata for metadata.
         */
        kind?: string | null;
    }
    export interface Schema$InstancesGetEffectiveFirewallsResponse {
        /**
         * [Output Only] Effective firewalls from firewall policies.
         */
        firewallPolicys?: Schema$InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy[];
        /**
         * Effective firewalls on the instance.
         */
        firewalls?: Schema$Firewall[];
        /**
         * Effective firewalls from organization policies.
         */
        organizationFirewalls?: Schema$InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy[];
    }
    export interface Schema$InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy {
        /**
         * [Output Only] Deprecated, please use short name instead. The display name of the firewall policy.
         */
        displayName?: string | null;
        /**
         * [Output Only] The name of the firewall policy.
         */
        name?: string | null;
        /**
         * [Output Only] The packet mirroring rules that apply to the instance.
         */
        packetMirroringRules?: Schema$FirewallPolicyRule[];
        /**
         * [Output only] Priority of firewall policy association. Not applicable for type=HIERARCHY.
         */
        priority?: number | null;
        /**
         * [Output Only] The rules that apply to the instance. Only rules that target the specific VM instance are returned if target service accounts or target secure tags are specified in the rules.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] The short name of the firewall policy.
         */
        shortName?: string | null;
        /**
         * [Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL, SYSTEM_GLOBAL, SYSTEM_REGIONAL.
         */
        type?: string | null;
    }
    /**
     * A pruned SecurityPolicy containing ID and any applicable firewall rules.
     */
    export interface Schema$InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy {
        /**
         * The unique identifier for the security policy. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The rules that apply to the network.
         */
        rules?: Schema$SecurityPolicyRule[];
    }
    export interface Schema$InstancesRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this instance.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$InstancesReportHostAsFaultyRequest {
        /**
         * The action hint to report the host as faulty.
         */
        actionHint?: string | null;
        /**
         * The disruption schedule for the VM. Required field, only allows IMMEDIATE.
         */
        disruptionSchedule?: string | null;
        faultReasons?: Schema$InstancesReportHostAsFaultyRequestFaultReason[];
    }
    export interface Schema$InstancesReportHostAsFaultyRequestFaultReason {
        behavior?: string | null;
        description?: string | null;
    }
    export interface Schema$InstancesResumeRequest {
        /**
         * Array of disks associated with this instance that are protected with a customer-supplied encryption key. In order to resume the instance, the disk url and its corresponding key must be provided. If the disk is not protected with a customer-supplied encryption key it should not be specified.
         */
        disks?: Schema$CustomerEncryptionKeyProtectedDisk[];
        /**
         * Decrypts data associated with an instance that is protected with a customer-supplied encryption key. If the instance you are starting is protected with a customer-supplied encryption key, the correct key must be provided otherwise the instance resume will not succeed.
         */
        instanceEncryptionKey?: Schema$CustomerEncryptionKey;
    }
    export interface Schema$InstancesScopedList {
        /**
         * [Output Only] A list of instances contained in this scope.
         */
        instances?: Schema$Instance[];
        /**
         * [Output Only] Informational warning which replaces the list of instances when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstancesSetLabelsRequest {
        /**
         * Fingerprint of the previous set of labels for this resource, used to prevent conflicts. Provide the latest fingerprint value when making a request to add or change labels.
         */
        labelFingerprint?: string | null;
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$InstancesSetMachineResourcesRequest {
        /**
         * A list of the type and count of accelerator cards attached to the instance.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
    }
    export interface Schema$InstancesSetMachineTypeRequest {
        /**
         * Full or partial URL of the machine type resource. See Machine Types for a full list of machine types. For example: zones/us-central1-f/machineTypes/n1-standard-1
         */
        machineType?: string | null;
    }
    export interface Schema$InstancesSetMinCpuPlatformRequest {
        /**
         * Minimum cpu/platform this instance should be started at.
         */
        minCpuPlatform?: string | null;
    }
    export interface Schema$InstancesSetNameRequest {
        /**
         * The current name of this resource, used to prevent conflicts. Provide the latest name when making a request to change name.
         */
        currentName?: string | null;
        /**
         * The name to be applied to the instance. Needs to be RFC 1035 compliant.
         */
        name?: string | null;
    }
    export interface Schema$InstancesSetSecurityPolicyRequest {
        /**
         * The network interfaces that the security policy will be applied to. Network interfaces use the nicN naming format. You can only set a security policy for network interfaces with an access config.
         */
        networkInterfaces?: string[] | null;
        /**
         * A full or partial URL to a security policy to add to this instance. If this field is set to an empty string it will remove the associated security policy.
         */
        securityPolicy?: string | null;
    }
    export interface Schema$InstancesSetServiceAccountRequest {
        /**
         * Email address of the service account.
         */
        email?: string | null;
        /**
         * The list of scopes to be made available for this service account.
         */
        scopes?: string[] | null;
    }
    export interface Schema$InstancesStartWithEncryptionKeyRequest {
        /**
         * Array of disks associated with this instance that are protected with a customer-supplied encryption key. In order to start the instance, the disk url and its corresponding key must be provided. If the disk is not protected with a customer-supplied encryption key it should not be specified.
         */
        disks?: Schema$CustomerEncryptionKeyProtectedDisk[];
        /**
         * Decrypts data associated with an instance that is protected with a customer-supplied encryption key. If the instance you are starting is protected with a customer-supplied encryption key, the correct key must be provided otherwise the instance start will not succeed.
         */
        instanceEncryptionKey?: Schema$CustomerEncryptionKey;
    }
    /**
     * Represents an Instance Template resource. Google Compute Engine has two Instance Template resources: * [Global](/compute/docs/reference/rest/alpha/instanceTemplates) * [Regional](/compute/docs/reference/rest/alpha/regionInstanceTemplates) You can reuse a global instance template in different regions whereas you can use a regional instance template in a specified region only. If you want to reduce cross-region dependency or achieve data residency, use a regional instance template. To create VMs, managed instance groups, and reservations, you can use either global or regional instance templates. For more information, read Instance Templates.
     */
    export interface Schema$InstanceTemplate {
        /**
         * [Output Only] The creation timestamp for this instance template in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] A unique identifier for this instance template. The server defines this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceTemplate for instance templates.
         */
        kind?: string | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The instance properties for this instance template.
         */
        properties?: Schema$InstanceProperties;
        /**
         * [Output Only] URL of the region where the instance template resides. Only applicable for regional resources.
         */
        region?: string | null;
        /**
         * [Output Only] The URL for this instance template. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The source instance used to create the template. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
         */
        sourceInstance?: string | null;
        /**
         * The source instance params to use to create this instance template.
         */
        sourceInstanceParams?: Schema$SourceInstanceParams;
    }
    /**
     * Contains a list of InstanceTemplatesScopedList.
     */
    export interface Schema$InstanceTemplateAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceTemplatesScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceTemplatesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A list of instance templates.
     */
    export interface Schema$InstanceTemplateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceTemplate resources.
         */
        items?: Schema$InstanceTemplate[];
        /**
         * [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for instance template lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceTemplatesScopedList {
        /**
         * [Output Only] A list of instance templates that are contained within the specified project and zone.
         */
        instanceTemplates?: Schema$InstanceTemplate[];
        /**
         * [Output Only] An informational warning that replaces the list of instance templates when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceWithNamedPorts {
        /**
         * [Output Only] The URL of the instance.
         */
        instance?: string | null;
        /**
         * [Output Only] The named ports that belong to this instance group.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The status of the instance.
         */
        status?: string | null;
    }
    /**
     * Represents a InstantSnapshot resource. You can use instant snapshots to create disk rollback points quickly..
     */
    export interface Schema$InstantSnapshot {
        /**
         * [Output Only] The architecture of the instant snapshot. Valid values are ARM64 or X86_64.
         */
        architecture?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Size of the source disk, specified in GB.
         */
        diskSizeGb?: string | null;
        /**
         * Whether to attempt an application consistent instant snapshot by informing the OS to prepare for the snapshot process.
         */
        guestFlush?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#instantSnapshot for InstantSnapshot resources.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this InstantSnapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a InstantSnapshot.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this InstantSnapshot. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the instant snapshot resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Status information for the instant snapshot resource.
         */
        resourceStatus?: Schema$InstantSnapshotResourceStatus;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * URL of the source disk used to create this instant snapshot. Note that the source disk must be in the same zone/region as the instant snapshot to be created. This can be a full or valid partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
         */
        sourceDisk?: string | null;
        /**
         * [Output Only] The ID value of the disk used to create this InstantSnapshot. This value may be used to determine whether the InstantSnapshot was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string | null;
        /**
         * [Output Only] URL of the source instant snapshot this instant snapshot is part of. Note that the source instant snapshot group must be in the same zone/region as the instant snapshot to be created. This can be a full or valid partial URL.
         */
        sourceInstantSnapshotGroup?: string | null;
        /**
         * [Output Only] The ID value of the source instant snapshot group this InstantSnapshot is part of. This value may be used to determine whether the InstantSnapshot was created as part of an InstantSnapshotGroup creation.
         */
        sourceInstantSnapshotGroupId?: string | null;
        /**
         * [Output Only] The status of the instantSnapshot. This can be CREATING, DELETING, FAILED, or READY.
         */
        status?: string | null;
        /**
         * [Output Only] URL of the zone where the instant snapshot resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$InstantSnapshotAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstantSnapshotsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstantSnapshotsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#instantSnapshotAggregatedList for aggregated lists of instantSnapshots.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an InstantSnapshotGroup resource. An instant snapshot group is a set of instant snapshots that represents a point in time state of a consistency group.
     */
    export interface Schema$InstantSnapshotGroup {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Optional. An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#instantSnapshotGroup for InstantSnapshotGroup resources.
         */
        kind?: string | null;
        /**
         * Identifier. Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the instant snapshot group resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        resourceStatus?: Schema$InstantSnapshotGroupResourceStatus;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        sourceConsistencyGroup?: string | null;
        /**
         * [Output Only]
         */
        status?: string | null;
        /**
         * [Output Only] URL of the zone where the instant snapshot group resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$InstantSnapshotGroupParameters {
        /**
         * The source instant snapshot group used to create disks. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshotGroups/instantSnapshotGroup - projects/project/zones/zone/instantSnapshotGroups/instantSnapshotGroup - zones/zone/instantSnapshotGroups/instantSnapshotGroup
         */
        sourceInstantSnapshotGroup?: string | null;
    }
    export interface Schema$InstantSnapshotGroupResourceStatus {
        /**
         * [Output Only]
         */
        consistencyMembershipResolutionTime?: string | null;
        /**
         * [Output Only]
         */
        sourceInfo?: Schema$InstantSnapshotGroupSourceInfo;
    }
    export interface Schema$InstantSnapshotGroupSourceInfo {
        consistencyGroup?: string | null;
        consistencyGroupId?: string | null;
    }
    /**
     * Contains a list of InstantSnapshot resources.
     */
    export interface Schema$InstantSnapshotList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstantSnapshot resources.
         */
        items?: Schema$InstantSnapshot[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstantSnapshotResourceStatus {
        /**
         * [Output Only] The storage size of this instant snapshot.
         */
        storageSizeBytes?: string | null;
    }
    export interface Schema$InstantSnapshotsScopedList {
        /**
         * [Output Only] A list of instantSnapshots contained in this scope.
         */
        instantSnapshots?: Schema$InstantSnapshot[];
        /**
         * [Output Only] Informational warning which replaces the list of instantSnapshots when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
     */
    export interface Schema$Int64RangeMatch {
        /**
         * The end of the range (exclusive) in signed long integer format.
         */
        rangeEnd?: string | null;
        /**
         * The start of the range (inclusive) in signed long integer format.
         */
        rangeStart?: string | null;
    }
    /**
     * Represents an Interconnect resource. An Interconnect resource is a dedicated connection between the Google Cloud network and your on-premises network. For more information, read the Dedicated Interconnect Overview.
     */
    export interface Schema$Interconnect {
        /**
         * Enable or disable the application awareness feature on this Cloud Interconnect.
         */
        aaiEnabled?: boolean | null;
        /**
         * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
         */
        adminEnabled?: boolean | null;
        /**
         * Configuration information for application awareness on this Cloud Interconnect.
         */
        applicationAwareInterconnect?: Schema$InterconnectApplicationAwareInterconnect;
        /**
         * [Output only] List of features available for this Interconnect connection, which can take one of the following values: - IF_MACSEC If present then the Interconnect connection is provisioned on MACsec capable hardware ports. If not present then the Interconnect connection is provisioned on non-MACsec capable ports and MACsec isn't supported and enabling MACsec fails.
         */
        availableFeatures?: string[] | null;
        /**
         * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
         */
        circuitInfos?: Schema$InterconnectCircuitInfo[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
         */
        customerName?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] A list of outages expected for this Interconnect.
         */
        expectedOutages?: Schema$InterconnectOutageNotification[];
        /**
         * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
         */
        googleIpAddress?: string | null;
        /**
         * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
         */
        googleReferenceId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
         */
        interconnectAttachments?: string[] | null;
        /**
         * [Output Only] URLs of InterconnectGroups that include this Interconnect. Order is arbitrary and items are unique.
         */
        interconnectGroups?: string[] | null;
        /**
         * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
         */
        interconnectType?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this Interconnect, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Interconnect.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
         */
        linkType?: string | null;
        /**
         * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
         */
        location?: string | null;
        /**
         * Configuration that enables Media Access Control security (MACsec) on the Cloud Interconnect connection between Google and your on-premises router.
         */
        macsec?: Schema$InterconnectMacsec;
        /**
         * Enable or disable MACsec on this Interconnect connection. MACsec enablement fails if the MACsec object is not specified.
         */
        macsecEnabled?: boolean | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
         */
        nocContactEmail?: string | null;
        /**
         * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
         */
        operationalStatus?: string | null;
        /**
         * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
         */
        peerIpAddress?: string | null;
        /**
         * [Output Only] Number of links actually provisioned in this interconnect.
         */
        provisionedLinkCount?: number | null;
        /**
         * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
         */
        remoteLocation?: string | null;
        /**
         * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
         */
        requestedFeatures?: string[] | null;
        /**
         * Target number of physical links in the link bundle, as requested by the customer.
         */
        requestedLinkCount?: number | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
         */
        state?: string | null;
        /**
         * [Output Only] A list of the URLs of all CrossSiteNetwork WireGroups configured to use this Interconnect. The Interconnect cannot be deleted if this list is non-empty.
         */
        wireGroups?: string[] | null;
    }
    /**
     * Configuration information for application awareness on this Cloud Interconnect.
     */
    export interface Schema$InterconnectApplicationAwareInterconnect {
        bandwidthPercentagePolicy?: Schema$InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy;
        /**
         * Description for the application awareness profile on this Cloud Interconnect.
         */
        profileDescription?: string | null;
        /**
         * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
         */
        shapeAveragePercentages?: Schema$InterconnectApplicationAwareInterconnectBandwidthPercentage[];
        strictPriorityPolicy?: Schema$InterconnectApplicationAwareInterconnectStrictPriorityPolicy;
    }
    /**
     * Specify bandwidth percentages [1-100] for various traffic classes in BandwidthPercentagePolicy. The sum of all percentages must equal 100. All traffic classes must have a percentage value specified.
     */
    export interface Schema$InterconnectApplicationAwareInterconnectBandwidthPercentage {
        /**
         * Bandwidth percentage for a specific traffic class.
         */
        percentage?: number | null;
        /**
         * TrafficClass whose bandwidth percentage is being specified.
         */
        trafficClass?: string | null;
    }
    export interface Schema$InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy {
        /**
         * Specify bandwidth percentages for various traffic classes for queuing type Bandwidth Percent.
         */
        bandwidthPercentages?: Schema$InterconnectApplicationAwareInterconnectBandwidthPercentage[];
    }
    /**
     * Specify configuration for StrictPriorityPolicy.
     */
    export interface Schema$InterconnectApplicationAwareInterconnectStrictPriorityPolicy {
    }
    /**
     * Represents an Interconnect Attachment (VLAN) resource. You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read Creating VLAN Attachments.
     */
    export interface Schema$InterconnectAttachment {
        /**
         * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
         */
        adminEnabled?: boolean | null;
        /**
         * [Output Only] URL of the AttachmentGroup that includes this Attachment.
         */
        attachmentGroup?: string | null;
        /**
         * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
         */
        bandwidth?: string | null;
        /**
         * Single IPv4 address + prefix length to be configured on the cloud router interface for this interconnect attachment. - Both candidate_cloud_router_ip_address and candidate_customer_router_ip_address fields must be set or both must be unset. - Prefix length of both candidate_cloud_router_ip_address and candidate_customer_router_ip_address must be the same. - Max prefix length is 31.
         */
        candidateCloudRouterIpAddress?: string | null;
        /**
         * Single IPv6 address + prefix length to be configured on the cloud router interface for this interconnect attachment. - Both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address fields must be set or both must be unset. - Prefix length of both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address must be the same. - Max prefix length is 126.
         */
        candidateCloudRouterIpv6Address?: string | null;
        /**
         * Single IPv4 address + prefix length to be configured on the customer router interface for this interconnect attachment.
         */
        candidateCustomerRouterIpAddress?: string | null;
        /**
         * Single IPv6 address + prefix length to be configured on the customer router interface for this interconnect attachment.
         */
        candidateCustomerRouterIpv6Address?: string | null;
        /**
         * This field is not available.
         */
        candidateIpv6Subnets?: string[] | null;
        /**
         * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
         */
        candidateSubnets?: string[] | null;
        /**
         * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
         */
        cloudRouterIpAddress?: string | null;
        /**
         * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
         */
        cloudRouterIpv6Address?: string | null;
        /**
         * This field is not available.
         */
        cloudRouterIpv6InterfaceId?: string | null;
        /**
         * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
         */
        configurationConstraints?: Schema$InterconnectAttachmentConfigurationConstraints;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
         */
        customerRouterIpAddress?: string | null;
        /**
         * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
         */
        customerRouterIpv6Address?: string | null;
        /**
         * This field is not available.
         */
        customerRouterIpv6InterfaceId?: string | null;
        /**
         * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
         */
        dataplaneVersion?: number | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
         */
        edgeAvailabilityDomain?: string | null;
        /**
         * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
         */
        encryption?: string | null;
        /**
         * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
         */
        googleReferenceId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
         */
        interconnect?: string | null;
        /**
         * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
         */
        ipsecInternalAddresses?: string[] | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
         */
        kind?: string | null;
        /**
         * L2 Interconnect Attachment related config. This field is required if the type is L2_DEDICATED. The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad) within L2 packets are mapped to the destination appliances IP addresses. The packet is then encapsulated with the appliance IP address and sent to the edge appliance.
         */
        l2Forwarding?: Schema$InterconnectAttachmentL2Forwarding;
        /**
         * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
         */
        mtu?: number | null;
        /**
         * Whether or not to permit multicast traffic for this attachment. Multicast packets will be dropped if this is not enabled.
         */
        multicastEnabled?: boolean | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
         */
        operationalStatus?: string | null;
        /**
         * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of a PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
         */
        pairingKey?: string | null;
        /**
         * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerAsn?: string | null;
        /**
         * Informational metadata about Partner attachments from Partners to display to customers. Output only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerMetadata?: Schema$InterconnectAttachmentPartnerMetadata;
        /**
         * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
         */
        privateInterconnectInfo?: Schema$InterconnectAttachmentPrivateInfo;
        /**
         * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
         */
        remoteService?: string | null;
        /**
         * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
         */
        router?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
         */
        stackType?: string | null;
        /**
         * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
         */
        state?: string | null;
        /**
         * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
         */
        subnetLength?: number | null;
        /**
         * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
         */
        type?: string | null;
        /**
         * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
         */
        vlanTag8021q?: number | null;
    }
    export interface Schema$InterconnectAttachmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectAttachmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InterconnectAttachmentsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#interconnectAttachmentAggregatedList for aggregated lists of interconnect attachments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InterconnectAttachmentConfigurationConstraints {
        /**
         * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
         */
        bgpMd5?: string | null;
        /**
         * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value\}. For example, [{min: 123, max: 123\}, {min: 64512, max: 65534\}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
         */
        bgpPeerAsnRanges?: Schema$InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange[];
    }
    export interface Schema$InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange {
        max?: number | null;
        min?: number | null;
    }
    /**
     * An interconnect attachment group resource allows customers to create, analyze, and expand highly available deployments.
     */
    export interface Schema$InterconnectAttachmentGroup {
        /**
         * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
         */
        attachments?: {
            [key: string]: Schema$InterconnectAttachmentGroupAttachment;
        } | null;
        configured?: Schema$InterconnectAttachmentGroupConfigured;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
         */
        etag?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        intent?: Schema$InterconnectAttachmentGroupIntent;
        /**
         * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
         */
        interconnectGroup?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
         */
        kind?: string | null;
        logicalStructure?: Schema$InterconnectAttachmentGroupLogicalStructure;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
    }
    /**
     * An Attachment in this AttachmentGroup.
     */
    export interface Schema$InterconnectAttachmentGroupAttachment {
        attachment?: string | null;
    }
    /**
     * [Output Only] The redundancy this group is configured to support. The way a user queries what SLA their Attachment gets is by looking at this field of the Attachment's AttachmentGroup.
     */
    export interface Schema$InterconnectAttachmentGroupConfigured {
        availabilitySla?: Schema$InterconnectAttachmentGroupConfiguredAvailabilitySLA;
    }
    /**
     * [Output Only] Which SLA this group is configured to support, and why this group does or does not meet that SLA's requirements.
     */
    export interface Schema$InterconnectAttachmentGroupConfiguredAvailabilitySLA {
        effectiveSla?: string | null;
        intendedSlaBlockers?: Schema$InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers[];
    }
    /**
     * [Output Only] Reasons why configuration.availabilitySLA.sla differs from intent.availabilitySLA. This list is empty if and only if those are the same.
     */
    export interface Schema$InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers {
        /**
         * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
         */
        attachments?: string[] | null;
        blockerType?: string | null;
        /**
         * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
         */
        documentationLink?: string | null;
        /**
         * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
         */
        explanation?: string | null;
        /**
         * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
         */
        metros?: string[] | null;
        /**
         * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
         */
        regions?: string[] | null;
        /**
         * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
         */
        zones?: string[] | null;
    }
    /**
     * The user's intent for this AttachmentGroup. This is the only required field besides the name that must be specified on group creation.
     */
    export interface Schema$InterconnectAttachmentGroupIntent {
        availabilitySla?: string | null;
    }
    /**
     * [Output Only] An analysis of the logical layout of Attachments in this group. Every Attachment in the group is shown once in this structure.
     */
    export interface Schema$InterconnectAttachmentGroupLogicalStructure {
        regions?: Schema$InterconnectAttachmentGroupLogicalStructureRegion[];
    }
    /**
     * [Output Only] The regions Attachments in this group are in.
     */
    export interface Schema$InterconnectAttachmentGroupLogicalStructureRegion {
        metros?: Schema$InterconnectAttachmentGroupLogicalStructureRegionMetro[];
        /**
         * [Output Only] The name of a region, like "us-central1".
         */
        region?: string | null;
    }
    /**
     * [Output Only] The metros of Attachments in this group in this region.
     */
    export interface Schema$InterconnectAttachmentGroupLogicalStructureRegionMetro {
        facilities?: Schema$InterconnectAttachmentGroupLogicalStructureRegionMetroFacility[];
        /**
         * [Output Only] The name of the metro, as a three-letter lowercase string like "iad". This is the first component of the location of an Interconnect.
         */
        metro?: string | null;
    }
    /**
     * [Output Only] The facilities used for this group's Attachments' Interconnects.
     */
    export interface Schema$InterconnectAttachmentGroupLogicalStructureRegionMetroFacility {
        /**
         * [Output Only] The name of a facility, like "iad-1234".
         */
        facility?: string | null;
        zones?: Schema$InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone[];
    }
    /**
     * [Output Only] The zones that Attachments in this group are present in, in the given facilities. This is inherited from their Interconnects.
     */
    export interface Schema$InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone {
        /**
         * [Output Only] URLs of Attachments in the given zone, to the given region, on Interconnects in the given facility and metro. Every Attachment in the AG has such an entry.
         */
        attachments?: string[] | null;
        /**
         * [Output Only] The name of a zone, either "zone1" or "zone2".
         */
        zone?: string | null;
    }
    export interface Schema$InterconnectAttachmentGroupsCreateMembers {
        /**
         * Parameters for the specific Attachments to create.
         */
        attachments?: Schema$InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput[];
        /**
         * How to behave when configured.availabilitySLA.effectiveSLA would not equal intent.availabilitySLA after this call.
         */
        intentMismatchBehavior?: string | null;
        /**
         * Default parameters for the Attachments to create in this call.
         */
        templateAttachment?: Schema$InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput;
    }
    /**
     * LINT.IfChange Parameters used to create an InterconnectAttachment. This is similar to InterconnectAttachment, but the region field used here is not output only and all other output only fields are excluded.
     */
    export interface Schema$InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput {
        /**
         * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
         */
        adminEnabled?: boolean | null;
        /**
         * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
         */
        bandwidth?: string | null;
        /**
         * Single IPv4 address + prefix length to be configured on the cloud router interface for this interconnect attachment. - Both candidate_cloud_router_ip_address and candidate_customer_router_ip_address fields must be set or both must be unset. - Prefix length of both candidate_cloud_router_ip_address and candidate_customer_router_ip_address must be the same. - Max prefix length is 31.
         */
        candidateCloudRouterIpAddress?: string | null;
        /**
         * Single IPv6 address + prefix length to be configured on the cloud router interface for this interconnect attachment. - Both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address fields must be set or both must be unset. - Prefix length of both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address must be the same. - Max prefix length is 126.
         */
        candidateCloudRouterIpv6Address?: string | null;
        /**
         * Single IPv4 address + prefix length to be configured on the customer router interface for this interconnect attachment.
         */
        candidateCustomerRouterIpAddress?: string | null;
        /**
         * Single IPv6 address + prefix length to be configured on the customer router interface for this interconnect attachment.
         */
        candidateCustomerRouterIpv6Address?: string | null;
        /**
         * This field is not available.
         */
        candidateIpv6Subnets?: string[] | null;
        /**
         * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
         */
        candidateSubnets?: string[] | null;
        /**
         * This field is not available.
         */
        cloudRouterIpv6InterfaceId?: string | null;
        /**
         * This field is not available.
         */
        customerRouterIpv6InterfaceId?: string | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
         */
        edgeAvailabilityDomain?: string | null;
        /**
         * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - alpha - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
         */
        encryption?: string | null;
        /**
         * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
         */
        interconnect?: string | null;
        /**
         * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
         */
        ipsecInternalAddresses?: string[] | null;
        /**
         * L2 Interconnect Attachment related config. This field is required if the type is L2_DEDICATED. The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad) within L2 packets are mapped to the destination appliances IP addresses. The packet is then encapsulated with the appliance IP address and sent to the edge appliance.
         */
        l2Forwarding?: Schema$InterconnectAttachmentL2Forwarding;
        /**
         * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Valid values are 1440, 1460, 1500, or 8896. If not specified, the value will default to 1440.
         */
        mtu?: number | null;
        /**
         * Whether or not to permit multicast traffic for this attachment. Multicast packets will be dropped if this is not enabled.
         */
        multicastEnabled?: boolean | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. Must be set on either the template_attachment or on each specific attachment. If set, the name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of a PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
         */
        pairingKey?: string | null;
        /**
         * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerAsn?: string | null;
        /**
         * Informational metadata about Partner attachments from Partners to display to customers. Output only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerMetadata?: Schema$InterconnectAttachmentPartnerMetadata;
        /**
         * The region that the Attachment is in.
         */
        region?: string | null;
        /**
         * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
         */
        router?: string | null;
        /**
         * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
         */
        stackType?: string | null;
        /**
         * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
         */
        subnetLength?: number | null;
        /**
         * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
         */
        type?: string | null;
        /**
         * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
         */
        vlanTag8021q?: number | null;
    }
    export interface Schema$InterconnectAttachmentGroupsCreateMembersRequest {
        request?: Schema$InterconnectAttachmentGroupsCreateMembers;
    }
    /**
     * Response for the InterconnectAttachmentGroupsGetOperationalStatusResponse.
     */
    export interface Schema$InterconnectAttachmentGroupsGetOperationalStatusResponse {
        etag?: string | null;
        result?: Schema$InterconnectAttachmentGroupsOperationalStatus;
    }
    export interface Schema$InterconnectAttachmentGroupsListResponse {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectAttachmentGroup resources.
         */
        items?: Schema$InterconnectAttachmentGroup[];
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InterconnectAttachmentGroupsOperationalStatus {
        attachmentStatuses?: Schema$InterconnectAttachmentGroupsOperationalStatusAttachmentStatus[];
        configured?: Schema$InterconnectAttachmentGroupConfigured;
        /**
         * Summarizes the status of the group.
         */
        groupStatus?: string | null;
        intent?: Schema$InterconnectAttachmentGroupIntent;
        /**
         * The operational state of the group, including only active Attachments.
         */
        operational?: Schema$InterconnectAttachmentGroupConfigured;
    }
    /**
     * The status of one Attachment in the group. List order is arbitrary.
     */
    export interface Schema$InterconnectAttachmentGroupsOperationalStatusAttachmentStatus {
        /**
         * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
         */
        adminEnabled?: boolean | null;
        /**
         * The URL of the Attachment being described.
         */
        attachment?: string | null;
        /**
         * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
         */
        isActive?: string | null;
        /**
         * Whether this Attachment is active, and if so, whether BGP is up. This is based on the statuses available in the Pantheon UI here: http://google3/java/com/google/cloud/boq/clientapi/gce/hybrid/api/interconnect_models.proto
         */
        status?: string | null;
    }
    /**
     * L2 Interconnect Attachment related configuration.
     */
    export interface Schema$InterconnectAttachmentL2Forwarding {
        /**
         * Optional. A map of VLAN tags to appliances and optional inner mapping rules. If VLANs are not explicitly mapped to any appliance, the defaultApplianceIpAddress is used. Each VLAN tag can be a single number or a range of numbers in the range of 1 to 4094, e.g., "1" or "4001-4094". Non-empty and non-overlapping VLAN tag ranges are enforced, and violating operations will be rejected. The VLAN tags in the Ethernet header must use an ethertype value of 0x88A8 or 0x8100.
         */
        applianceMappings?: {
            [key: string]: Schema$InterconnectAttachmentL2ForwardingApplianceMapping;
        } | null;
        /**
         * Optional. A single IPv4 or IPv6 address used as the default destination IP when there is no VLAN mapping result found. Unset field (null-value) indicates the unmatched packet should be dropped.
         */
        defaultApplianceIpAddress?: string | null;
        /**
         * Optional. It represents the structure of a Geneve (Generic Network Virtualization Encapsulation) header, as defined in RFC8926. It encapsulates packets from various protocols (e.g., Ethernet, IPv4, IPv6) for use in network virtualization environments.
         */
        geneveHeader?: Schema$InterconnectAttachmentL2ForwardingGeneveHeader;
        /**
         * Required. Resource URL of the network to which this attachment belongs.
         */
        network?: string | null;
        /**
         * Required. A single IPv4 or IPv6 address. This address will be used as the source IP address for packets sent to the appliances, and must be used as the destination IP address for packets that should be sent out through this attachment.
         */
        tunnelEndpointIpAddress?: string | null;
    }
    /**
     * Two-level VLAN-to-Appliance mapping rule.
     */
    export interface Schema$InterconnectAttachmentL2ForwardingApplianceMapping {
        /**
         * Optional. A single IPv4 or IPv6 address used as the destination IP address for ingress packets that match on a VLAN tag, but do not match a more specific inner VLAN tag. Unset field (null-value) indicates both VLAN tags are required to be mapped. Otherwise, defaultApplianceIpAddress is used.
         */
        applianceIpAddress?: string | null;
        /**
         * Optional. Used to match against the inner VLAN when the packet contains two VLAN tags. A list of mapping rules from inner VLAN tags to IP addresses. If the inner VLAN is not explicitly mapped to an IP address range, the applianceIpAddress is used.
         */
        innerVlanToApplianceMappings?: Schema$InterconnectAttachmentL2ForwardingApplianceMappingInnerVlanToApplianceMapping[];
        /**
         * Optional. The name of this appliance mapping rule.
         */
        name?: string | null;
    }
    /**
     * The inner VLAN-to-Appliance mapping.
     */
    export interface Schema$InterconnectAttachmentL2ForwardingApplianceMappingInnerVlanToApplianceMapping {
        /**
         * Required in this object. A single IPv4 or IPv6 address used as the destination IP address for ingress packets that match on both VLAN tags.
         */
        innerApplianceIpAddress?: string | null;
        /**
         * Required in this object. Used to match the inner VLAN tag on the packet. Each entry can be a single number or a range of numbers in the range of 1 to 4094, e.g., ["1", "4001-4094"] is valid. Non-empty and Non-overlapping VLAN tag ranges are enforced, and violating operations will be rejected. The inner VLAN tags must have an ethertype value of 0x8100.
         */
        innerVlanTags?: string[] | null;
    }
    /**
     * GeneveHeader related configurations.
     */
    export interface Schema$InterconnectAttachmentL2ForwardingGeneveHeader {
        /**
         * Optional. VNI is a 24-bit unique virtual network identifier, from 0 to 16,777,215.
         */
        vni?: number | null;
    }
    /**
     * Response to the list request, and contains a list of interconnect attachments.
     */
    export interface Schema$InterconnectAttachmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectAttachment resources.
         */
        items?: Schema$InterconnectAttachment[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectAttachmentList for lists of interconnect attachments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
     */
    export interface Schema$InterconnectAttachmentPartnerMetadata {
        /**
         * Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
         */
        interconnectName?: string | null;
        /**
         * Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
         */
        partnerName?: string | null;
        /**
         * URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
         */
        portalUrl?: string | null;
    }
    /**
     * Information for an interconnect attachment when this belongs to an interconnect of type DEDICATED.
     */
    export interface Schema$InterconnectAttachmentPrivateInfo {
        /**
         * [Output Only] 802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.
         */
        tag8021q?: number | null;
    }
    export interface Schema$InterconnectAttachmentsScopedList {
        /**
         * A list of interconnect attachments contained in this scope.
         */
        interconnectAttachments?: Schema$InterconnectAttachment[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Describes a single physical circuit between the Customer and Google. CircuitInfo objects are created by Google, so all fields are output only.
     */
    export interface Schema$InterconnectCircuitInfo {
        /**
         * Customer-side demarc ID for this circuit.
         */
        customerDemarcId?: string | null;
        /**
         * Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
         */
        googleCircuitId?: string | null;
        /**
         * Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.
         */
        googleDemarcId?: string | null;
    }
    /**
     * Diagnostics information about the Interconnect connection, which contains detailed and current technical information about Google's side of the connection.
     */
    export interface Schema$InterconnectDiagnostics {
        /**
         * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
         */
        arpCaches?: Schema$InterconnectDiagnosticsARPEntry[];
        /**
         * The aggregation type of the bundle interface.
         */
        bundleAggregationType?: string | null;
        /**
         * The operational status of the bundle interface.
         */
        bundleOperationalStatus?: string | null;
        /**
         * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
         */
        links?: Schema$InterconnectDiagnosticsLinkStatus[];
        /**
         * The MAC address of the Interconnect's bundle interface.
         */
        macAddress?: string | null;
    }
    /**
     * Describing the ARP neighbor entries seen on this link
     */
    export interface Schema$InterconnectDiagnosticsARPEntry {
        /**
         * The IP address of this ARP neighbor.
         */
        ipAddress?: string | null;
        /**
         * The MAC address of this ARP neighbor.
         */
        macAddress?: string | null;
    }
    export interface Schema$InterconnectDiagnosticsLinkLACPStatus {
        /**
         * System ID of the port on Google's side of the LACP exchange.
         */
        googleSystemId?: string | null;
        /**
         * System ID of the port on the neighbor's side of the LACP exchange.
         */
        neighborSystemId?: string | null;
        /**
         * The state of a LACP link, which can take one of the following values: - ACTIVE: The link is configured and active within the bundle. - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
         */
        state?: string | null;
    }
    export interface Schema$InterconnectDiagnosticsLinkOpticalPower {
        /**
         * The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning threshold. - LOW_WARNING: The value has crossed below the low warning threshold. - HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high alarm threshold.
         */
        state?: string | null;
        /**
         * Value of the current receiving or transmitting optical power, read in dBm. Take a known good optical value, give it a 10% margin and trigger warnings relative to that value. In general, a -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
         */
        value?: number | null;
    }
    export interface Schema$InterconnectDiagnosticsLinkStatus {
        /**
         * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
         */
        arpCaches?: Schema$InterconnectDiagnosticsARPEntry[];
        /**
         * The unique ID for this link assigned during turn up by Google.
         */
        circuitId?: string | null;
        /**
         * The Demarc address assigned by Google and provided in the LoA.
         */
        googleDemarc?: string | null;
        lacpStatus?: Schema$InterconnectDiagnosticsLinkLACPStatus;
        /**
         * Describes the status of MACsec encryption on this link.
         */
        macsec?: Schema$InterconnectDiagnosticsMacsecStatus;
        /**
         * The operational status of the link.
         */
        operationalStatus?: string | null;
        /**
         * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
         */
        receivingOpticalPower?: Schema$InterconnectDiagnosticsLinkOpticalPower;
        /**
         * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
         */
        transmittingOpticalPower?: Schema$InterconnectDiagnosticsLinkOpticalPower;
    }
    /**
     * Describes the status of MACsec encryption on the link.
     */
    export interface Schema$InterconnectDiagnosticsMacsecStatus {
        /**
         * Indicates the Connectivity Association Key Name (CKN) currently being used if MACsec is operational.
         */
        ckn?: string | null;
        /**
         * Indicates whether or not MACsec is operational on this link.
         */
        operational?: boolean | null;
    }
    /**
     * An interconnect group resource allows customers to create, analyze, and expand their redundant connections.
     */
    export interface Schema$InterconnectGroup {
        configured?: Schema$InterconnectGroupConfigured;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
         */
        etag?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        intent?: Schema$InterconnectGroupIntent;
        /**
         * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
         */
        interconnects?: {
            [key: string]: Schema$InterconnectGroupInterconnect;
        } | null;
        /**
         * [Output Only] Type of the resource. Always compute#InterconnectGroup
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        physicalStructure?: Schema$InterconnectGroupPhysicalStructure;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
    }
    /**
     * [Output Only] The status of the group as configured. This has the same structure as the operational field reported by the OperationalStatus method, but does not take into account the operational status of each resource.
     */
    export interface Schema$InterconnectGroupConfigured {
        topologyCapability?: Schema$InterconnectGroupConfiguredTopologyCapability;
    }
    /**
     * [Output Only] How reliable this topology is configured to be, and why this group does or does not meet the requirements for the intended capability.
     */
    export interface Schema$InterconnectGroupConfiguredTopologyCapability {
        intendedCapabilityBlockers?: Schema$InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers[];
        supportedSla?: string | null;
    }
    /**
     * [Output Only] Reasons why configuration.topologyCapability.sla differs from intent.topologyCapability. This list is empty if and only if those are the same.
     */
    export interface Schema$InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers {
        blockerType?: string | null;
        /**
         * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
         */
        documentationLink?: string | null;
        /**
         * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
         */
        explanation?: string | null;
        /**
         * [Output Only] Facilities used to explain this blocker in more detail. Like physicalStructure.metros.facilities.facility, this is a numeric string like "5467".
         */
        facilities?: string[] | null;
        /**
         * [Output Only] Interconnects used to explain this blocker in more detail.
         */
        interconnects?: string[] | null;
        /**
         * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". A blocker like INCOMPATIBLE_METROS will specify the problematic metros in this field.
         */
        metros?: string[] | null;
        /**
         * [Output Only] Zones used to explain this blocker in more detail. Zone names are "zone1" and/or "zone2".
         */
        zones?: string[] | null;
    }
    /**
     * The user's intent for this group. This is the only required field besides the name that must be specified on group creation.
     */
    export interface Schema$InterconnectGroupIntent {
        topologyCapability?: string | null;
    }
    /**
     * An Interconnect in this InterconnectGroup.
     */
    export interface Schema$InterconnectGroupInterconnect {
        /**
         * The URL of an Interconnect in this group. All Interconnects in the group are unique.
         */
        interconnect?: string | null;
    }
    /**
     * [Output Only] An analysis of the physical layout of Interconnects in this group. Every Interconnect in the group is shown once in this structure.
     */
    export interface Schema$InterconnectGroupPhysicalStructure {
        metros?: Schema$InterconnectGroupPhysicalStructureMetros[];
    }
    /**
     * [Output Only] The metros Interconnects in this group are in.
     */
    export interface Schema$InterconnectGroupPhysicalStructureMetros {
        facilities?: Schema$InterconnectGroupPhysicalStructureMetrosFacilities[];
        /**
         * [Output Only] The name of the metro, as a three-letter lowercase string like "iad". This is the first component of the location of Interconnects underneath this.
         */
        metro?: string | null;
    }
    /**
     * [Output Only] The facilities Interconnects in this metro are present in.
     */
    export interface Schema$InterconnectGroupPhysicalStructureMetrosFacilities {
        /**
         * [Output Only] The ID of this facility, as a numeric string like "5467". This is the third component of the location of Interconnects in this facility.
         */
        facility?: string | null;
        zones?: Schema$InterconnectGroupPhysicalStructureMetrosFacilitiesZones[];
    }
    /**
     * [Output Only] The zones that Interconnects in this facility are present in.
     */
    export interface Schema$InterconnectGroupPhysicalStructureMetrosFacilitiesZones {
        /**
         * [Output Only] URLs of Interconnects in this redundancy group in the given metro, facility, and zone.
         */
        interconnects?: string[] | null;
        /**
         * [Output Only] The name of the zone, either "zone1" or "zone2". This is the second component of the location of Interconnects in this facility.
         */
        zone?: string | null;
    }
    export interface Schema$InterconnectGroupsCreateMembers {
        /**
         * How to behave when configured.topologyCapability.supportedSLA would not equal intent.topologyCapability after this call.
         */
        intentMismatchBehavior?: string | null;
        interconnects?: Schema$InterconnectGroupsCreateMembersInterconnectInput[];
        /**
         * Parameters for the Interconnects to create.
         */
        templateInterconnect?: Schema$InterconnectGroupsCreateMembersInterconnectInput;
    }
    /**
     * LINT.IfChange
     */
    export interface Schema$InterconnectGroupsCreateMembersInterconnectInput {
        /**
         * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
         */
        adminEnabled?: boolean | null;
        /**
         * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
         */
        customerName?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
         */
        facility?: string | null;
        /**
         * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
         */
        interconnectType?: string | null;
        /**
         * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
         */
        linkType?: string | null;
        /**
         * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
         */
        nocContactEmail?: string | null;
        /**
         * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
         */
        remoteLocation?: string | null;
        /**
         * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
         */
        requestedFeatures?: string[] | null;
        /**
         * Target number of physical links in the link bundle, as requested by the customer.
         */
        requestedLinkCount?: number | null;
    }
    export interface Schema$InterconnectGroupsCreateMembersRequest {
        request?: Schema$InterconnectGroupsCreateMembers;
    }
    /**
     * Response for the InterconnectGroupsGetOperationalStatusResponse.
     */
    export interface Schema$InterconnectGroupsGetOperationalStatusResponse {
        etag?: string | null;
        result?: Schema$InterconnectGroupsOperationalStatus;
    }
    export interface Schema$InterconnectGroupsListResponse {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectGroup resources.
         */
        items?: Schema$InterconnectGroup[];
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Request to get the status of the interconnect group with extra detail.
     */
    export interface Schema$InterconnectGroupsOperationalStatus {
        /**
         * The configuration analysis, as returned by Get.
         */
        configured?: Schema$InterconnectGroupConfigured;
        /**
         * Summarizes the status of the group.
         */
        groupStatus?: string | null;
        /**
         * The intent of the resource, as returned by Get.
         */
        intent?: Schema$InterconnectGroupIntent;
        interconnectStatuses?: Schema$InterconnectGroupsOperationalStatusInterconnectStatus[];
        /**
         * The operational state of the group, including only active Interconnects.
         */
        operational?: Schema$InterconnectGroupConfigured;
    }
    /**
     * The status of one Interconnect in the group. The order is arbitrary.
     */
    export interface Schema$InterconnectGroupsOperationalStatusInterconnectStatus {
        /**
         * Whether the Interconnect is enabled.
         */
        adminEnabled?: boolean | null;
        /**
         * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
         */
        diagnostics?: Schema$InterconnectDiagnostics;
        /**
         * The URL of the Interconnect being described.
         */
        interconnect?: string | null;
        /**
         * Whether this interconnect is participating in the redundant configuration.
         */
        isActive?: string | null;
    }
    /**
     * Response to the list request, and contains a list of interconnects.
     */
    export interface Schema$InterconnectList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Interconnect resources.
         */
        items?: Schema$Interconnect[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectList for lists of interconnects.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Interconnect Attachment (VLAN) Location resource. You can use this resource to find location details about an Interconnect attachment (VLAN). For more information about interconnect attachments, read Creating VLAN Attachments.
     */
    export interface Schema$InterconnectLocation {
        /**
         * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
         */
        address?: string | null;
        /**
         * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
         */
        availabilityZone?: string | null;
        /**
         * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - IF_MACSEC
         */
        availableFeatures?: string[] | null;
        /**
         * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR - LINK_TYPE_ETHERNET_400G_LR4
         */
        availableLinkTypes?: string[] | null;
        /**
         * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
         */
        city?: string | null;
        /**
         * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
         */
        continent?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] A list of InterconnectLocation.CrossSiteInterconnectInfo objects, that describe where Cross-Site Interconnect wires may connect to from this location and associated connection parameters. Cross-Site Interconnect isn't allowed to locations which are not listed.
         */
        crossSiteInterconnectInfos?: Schema$InterconnectLocationCrossSiteInterconnectInfo[];
        /**
         * [Output Only] An optional description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
         */
        facilityProvider?: string | null;
        /**
         * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
         */
        facilityProviderFacilityId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
         */
        peeringdbFacilityId?: string | null;
        /**
         * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
         */
        regionInfos?: Schema$InterconnectLocationRegionInfo[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
         */
        status?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        supportsPzs?: boolean | null;
    }
    /**
     * Information about Cross-Site Interconnect wires which may be created between the containing location and another remote location.
     */
    export interface Schema$InterconnectLocationCrossSiteInterconnectInfo {
        /**
         * The remote location for Cross-Site Interconnect wires. This specifies an InterconnectLocation city (metropolitan area designator), which itself may match multiple InterconnectLocations.
         */
        city?: string | null;
        /**
         * The maximum gbps for a single flow to this metro. This limits the total bandwidth which may be configured per wire.
         */
        maxSingleFlowGbps?: number | null;
    }
    /**
     * Response to the list request, and contains a list of interconnect locations.
     */
    export interface Schema$InterconnectLocationList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectLocation resources.
         */
        items?: Schema$InterconnectLocation[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectLocationList for lists of interconnect locations.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Information about any potential InterconnectAttachments between an Interconnect at a specific InterconnectLocation, and a specific Cloud Region.
     */
    export interface Schema$InterconnectLocationRegionInfo {
        /**
         * Expected round-trip time in milliseconds, from this InterconnectLocation to a VM in this region.
         */
        expectedRttMs?: string | null;
        /**
         * Identifies whether L2 Interconnect Attachments can be created in this region for interconnects that are in this location.
         */
        l2ForwardingEnabled?: boolean | null;
        /**
         * Identifies the network presence of this location.
         */
        locationPresence?: string | null;
        /**
         * URL for the region of this location.
         */
        region?: string | null;
    }
    /**
     * Configuration information for enabling Media Access Control security (MACsec) on this Cloud Interconnect connection between Google and your on-premises router.
     */
    export interface Schema$InterconnectMacsec {
        /**
         * If set to true, the Interconnect connection is configured with a should-secure MACsec security policy, that allows the Google router to fallback to cleartext traffic if the MKA session cannot be established. By default, the Interconnect connection is configured with a must-secure security policy that drops all traffic if the MKA session cannot be established with your router.
         */
        failOpen?: boolean | null;
        /**
         * Required. A keychain placeholder describing a set of named key objects along with their start times. A MACsec CKN/CAK is generated for each key in the key chain. Google router automatically picks the key with the most recent startTime when establishing or re-establishing a MACsec secure link.
         */
        preSharedKeys?: Schema$InterconnectMacsecPreSharedKey[];
    }
    /**
     * MACsec configuration information for the Interconnect connection. Contains the generated Connectivity Association Key Name (CKN) and the key (CAK) for this Interconnect connection.
     */
    export interface Schema$InterconnectMacsecConfig {
        /**
         * A keychain placeholder describing a set of named key objects along with their start times. A MACsec CKN/CAK is generated for each key in the key chain. Google router automatically picks the key with the most recent startTime when establishing or re-establishing a MACsec secure link.
         */
        preSharedKeys?: Schema$InterconnectMacsecConfigPreSharedKey[];
    }
    /**
     * Describes a pre-shared key used to setup MACsec in static connectivity association key (CAK) mode.
     */
    export interface Schema$InterconnectMacsecConfigPreSharedKey {
        /**
         * An auto-generated Connectivity Association Key (CAK) for this key.
         */
        cak?: string | null;
        /**
         * An auto-generated Connectivity Association Key Name (CKN) for this key.
         */
        ckn?: string | null;
        /**
         * User provided name for this pre-shared key.
         */
        name?: string | null;
        /**
         * User provided timestamp on or after which this key is valid.
         */
        startTime?: string | null;
    }
    /**
     * Describes a pre-shared key used to setup MACsec in static connectivity association key (CAK) mode.
     */
    export interface Schema$InterconnectMacsecPreSharedKey {
        /**
         * Required. A name for this pre-shared key. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * A RFC3339 timestamp on or after which the key is valid. startTime can be in the future. If the keychain has a single key, startTime can be omitted. If the keychain has multiple keys, startTime is mandatory for each key. The start times of keys must be in increasing order. The start times of two consecutive keys must be at least 6 hours apart.
         */
        startTime?: string | null;
    }
    /**
     * Description of a planned outage on this Interconnect.
     */
    export interface Schema$InterconnectOutageNotification {
        /**
         * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
         */
        affectedCircuits?: string[] | null;
        /**
         * A description about the purpose of the outage.
         */
        description?: string | null;
        /**
         * Scheduled end time for the outage (milliseconds since Unix epoch).
         */
        endTime?: string | null;
        /**
         * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
         */
        issueType?: string | null;
        /**
         * Unique identifier for this outage notification.
         */
        name?: string | null;
        /**
         * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
         */
        source?: string | null;
        /**
         * Scheduled start time for the outage (milliseconds since Unix epoch).
         */
        startTime?: string | null;
        /**
         * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
         */
        state?: string | null;
    }
    /**
     * Represents a Cross-Cloud Interconnect Remote Location resource. You can use this resource to find remote location details about an Interconnect attachment (VLAN).
     */
    export interface Schema$InterconnectRemoteLocation {
        /**
         * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
         */
        address?: string | null;
        /**
         * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
         */
        attachmentConfigurationConstraints?: Schema$InterconnectAttachmentConfigurationConstraints;
        /**
         * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
         */
        city?: string | null;
        /**
         * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
         */
        constraints?: Schema$InterconnectRemoteLocationConstraints;
        /**
         * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
         */
        continent?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] An optional description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
         */
        facilityProvider?: string | null;
        /**
         * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
         */
        facilityProviderFacilityId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
         */
        kind?: string | null;
        /**
         * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
         */
        lacp?: string | null;
        /**
         * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
         */
        maxLagSize100Gbps?: number | null;
        /**
         * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
         */
        maxLagSize10Gbps?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
         */
        peeringdbFacilityId?: string | null;
        /**
         * [Output Only] Permitted connections.
         */
        permittedConnections?: Schema$InterconnectRemoteLocationPermittedConnections[];
        /**
         * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
         */
        remoteService?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
         */
        status?: string | null;
    }
    export interface Schema$InterconnectRemoteLocationConstraints {
        /**
         * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. Google Cloud API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
         */
        portPairRemoteLocation?: string | null;
        /**
         * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
         */
        portPairVlan?: string | null;
        /**
         * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30\} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30\}.
         */
        subnetLengthRange?: Schema$InterconnectRemoteLocationConstraintsSubnetLengthRange;
    }
    export interface Schema$InterconnectRemoteLocationConstraintsSubnetLengthRange {
        max?: number | null;
        min?: number | null;
    }
    /**
     * Response to the list request, and contains a list of interconnect remote locations.
     */
    export interface Schema$InterconnectRemoteLocationList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectRemoteLocation resources.
         */
        items?: Schema$InterconnectRemoteLocation[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectRemoteLocationList for lists of interconnect remote locations.
         */
        kind?: string | null;
        /**
         * [Output Only] This token lets you get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InterconnectRemoteLocationPermittedConnections {
        /**
         * [Output Only] URL of an Interconnect location that is permitted to connect to this Interconnect remote location.
         */
        interconnectLocation?: string | null;
    }
    /**
     * Response for the InterconnectsGetDiagnosticsRequest.
     */
    export interface Schema$InterconnectsGetDiagnosticsResponse {
        result?: Schema$InterconnectDiagnostics;
    }
    /**
     * Response for the InterconnectsGetMacsecConfigRequest.
     */
    export interface Schema$InterconnectsGetMacsecConfigResponse {
        /**
         * end_interface: MixerGetResponseWithEtagBuilder
         */
        etag?: string | null;
        result?: Schema$InterconnectMacsecConfig;
    }
    export interface Schema$InternalIpAddress {
        /**
         * IP CIDR address or range.
         */
        cidr?: string | null;
        /**
         * The owner of the internal IP address.
         */
        owner?: string | null;
        /**
         * The purpose of the internal IP address if applicable.
         */
        purpose?: string | null;
        /**
         * The region of the internal IP address if applicable.
         */
        region?: string | null;
        /**
         * The type of the internal IP address.
         */
        type?: string | null;
    }
    export interface Schema$InternalIpOwner {
        /**
         * IP CIDR range being owned.
         */
        ipCidrRange?: string | null;
        /**
         * URLs of the IP owners of the IP CIDR range.
         */
        owners?: string[] | null;
        /**
         * Whether this IP CIDR range is reserved for system use.
         */
        systemOwned?: boolean | null;
    }
    export interface Schema$IpAddressesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InternalIpAddress resources.
         */
        items?: Schema$InternalIpAddress[];
        /**
         * [Output Only] Type of resource. Always compute#ipAddressesList for IP addresses lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of IP owners.
     */
    export interface Schema$IpOwnerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InternalIpOwner resources.
         */
        items?: Schema$InternalIpOwner[];
        /**
         * [Output Only] Type of resource. Always compute#ipOwnerList for lists of IP owners.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * [Deprecated] JWT configuration for origin authentication. JWT configuration for origin authentication.
     */
    export interface Schema$Jwt {
        /**
         * A JWT containing any of these audiences will be accepted. The service name will be accepted if audiences is empty. Examples: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
         */
        audiences?: string[] | null;
        /**
         * Identifies the issuer that issued the JWT, which is usually a URL or an email address. Examples: https://securetoken.google.com, 1234567-compute@developer.gserviceaccount.com
         */
        issuer?: string | null;
        /**
         * The provider's public key set to validate the signature of the JWT.
         */
        jwksPublicKeys?: string | null;
        /**
         * jwt_headers and jwt_params define where to extract the JWT from an HTTP request. If no explicit location is specified, the following default locations are tried in order: 1. The Authorization header using the Bearer schema. See `here `_. Example: Authorization: Bearer . 2. `access_token` query parameter. See `this `_ Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations its issuer specified or from the default locations. This field is set if JWT is sent in a request header. This field specifies the header name. For example, if `header=x-goog-iap-jwt-assertion`, the header format will be x-goog-iap-jwt-assertion: .
         */
        jwtHeaders?: Schema$JwtHeader[];
        /**
         * This field is set if JWT is sent in a query parameter. This field specifies the query parameter name. For example, if jwt_params[0] is jwt_token, the JWT format in the query parameter is /path?jwt_token=.
         */
        jwtParams?: string[] | null;
    }
    /**
     * [Deprecated] This message specifies a header location to extract JWT token. This message specifies a header location to extract JWT token.
     */
    export interface Schema$JwtHeader {
        /**
         * The HTTP header name.
         */
        name?: string | null;
        /**
         * The value prefix. The value format is "value_prefix" For example, for "Authorization: Bearer ", value_prefix="Bearer " with a space at the end.
         */
        valuePrefix?: string | null;
    }
    /**
     * Represents a License resource. A License represents billing and aggregate usage data for public and marketplace images. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
     */
    export interface Schema$License {
        /**
         * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
         */
        allowedReplacementLicenses?: string[] | null;
        /**
         * If true, this license can be appended to an existing disk's set of licenses.
         */
        appendableToDisk?: boolean | null;
        /**
         * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
         */
        chargesUseFee?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional textual description of the resource; provided by the client when the resource is created.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
         */
        incompatibleLicenses?: string[] | null;
        /**
         * [Output Only] Type of resource. Always compute#license for licenses.
         */
        kind?: string | null;
        /**
         * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
         */
        licenseCode?: string | null;
        /**
         * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
         */
        minimumRetention?: Schema$Duration;
        /**
         * If true, this license can only be used on VMs on multi tenant nodes.
         */
        multiTenantOnly?: boolean | null;
        /**
         * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
         */
        name?: string | null;
        /**
         * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
         */
        osLicense?: boolean | null;
        /**
         * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
         */
        removableFromDisk?: boolean | null;
        /**
         * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
         */
        requiredCoattachedLicenses?: string[] | null;
        /**
         * [Input Only] Deprecated.
         */
        resourceRequirements?: Schema$LicenseResourceRequirements;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * If true, this license can only be used on VMs on sole tenant nodes.
         */
        soleTenantOnly?: boolean | null;
        /**
         * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
         */
        transferable?: boolean | null;
        /**
         * [Output Only] Last update timestamp in RFC3339 text format.
         */
        updateTimestamp?: string | null;
    }
    /**
     * Represents a License Code resource. A License Code is a unique identifier used to represent a license resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
     */
    export interface Schema$LicenseCode {
        /**
         * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
         */
        allowedReplacementLicenses?: string[] | null;
        /**
         * If true, this license can be appended to an existing disk's set of licenses.
         */
        appendableToDisk?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] Description of this License Code.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
         */
        incompatibleLicenses?: string[] | null;
        /**
         * [Output Only] Type of resource. Always compute#licenseCode for licenses.
         */
        kind?: string | null;
        /**
         * [Output Only] URL and description aliases of Licenses with the same License Code.
         */
        licenseAlias?: Schema$LicenseCodeLicenseAlias[];
        /**
         * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
         */
        minimumRetention?: Schema$Duration;
        /**
         * If true, this license can only be used on VMs on multi tenant nodes.
         */
        multiTenantOnly?: boolean | null;
        /**
         * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit integer.
         */
        name?: string | null;
        /**
         * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
         */
        osLicense?: boolean | null;
        /**
         * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
         */
        removableFromDisk?: boolean | null;
        /**
         * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
         */
        requiredCoattachedLicenses?: string[] | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * If true, this license can only be used on VMs on sole tenant nodes.
         */
        soleTenantOnly?: boolean | null;
        /**
         * [Output Only] Current state of this License Code.
         */
        state?: string | null;
        /**
         * [Output Only] If true, the license will remain attached when creating images or snapshots from disks. Otherwise, the license is not transferred.
         */
        transferable?: boolean | null;
        /**
         * [Output Only] Last update timestamp in RFC3339 text format.
         */
        updateTimestamp?: string | null;
    }
    export interface Schema$LicenseCodeLicenseAlias {
        /**
         * [Output Only] Description of this License Code.
         */
        description?: string | null;
        /**
         * [Output Only] URL of license corresponding to this License Code.
         */
        selfLink?: string | null;
    }
    /**
     * Commitment for a particular license resource.
     */
    export interface Schema$LicenseResourceCommitment {
        /**
         * The number of licenses you plan to purchase.
         */
        amount?: string | null;
        /**
         * The number of cores per license.
         */
        coresPerLicense?: string | null;
        /**
         * The applicable license URI.
         */
        license?: string | null;
    }
    export interface Schema$LicenseResourceRequirements {
        /**
         * [Input Only] Deprecated. This field no longer reflects the minimum number of guest cpus required to use the Instance.
         */
        minGuestCpuCount?: number | null;
        /**
         * [Input Only] Deprecated. This field no longer reflects the minimum memory required to use the Instance.
         */
        minMemoryMb?: number | null;
    }
    export interface Schema$LicensesListResponse {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of License resources.
         */
        items?: Schema$License[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of InstantSnapshotGroup resources.
     */
    export interface Schema$ListInstantSnapshotGroups {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstantSnapshotGroup resources.
         */
        items?: Schema$InstantSnapshotGroup[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of SnapshotGroup resources.
     */
    export interface Schema$ListSnapshotGroups {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of SnapshotGroup resources.
         */
        items?: Schema$SnapshotGroup[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$LocalDisk {
        /**
         * Specifies the number of such disks.
         */
        diskCount?: number | null;
        /**
         * Specifies the size of the disk in base-2 GB.
         */
        diskSizeGb?: number | null;
        /**
         * Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.
         */
        diskType?: string | null;
    }
    /**
     * Provides a localized error message that is safe to return to the user which can be attached to an RPC error.
     */
    export interface Schema$LocalizedMessage {
        /**
         * The locale used following the specification defined at https://www.rfc-editor.org/rfc/bcp/bcp47.txt. Examples are: "en-US", "fr-CH", "es-MX"
         */
        locale?: string | null;
        /**
         * The localized error message in the above locale.
         */
        message?: string | null;
    }
    /**
     * Configuration for location policy among multiple possible locations (e.g. preferences for zone selection among zones in a single region).
     */
    export interface Schema$LocationPolicy {
        /**
         * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
         */
        locations?: {
            [key: string]: Schema$LocationPolicyLocation;
        } | null;
        /**
         * Strategy for distributing VMs across zones in a region.
         */
        targetShape?: string | null;
    }
    export interface Schema$LocationPolicyLocation {
        /**
         * Constraints that the caller requires on the result distribution in this zone.
         */
        constraints?: Schema$LocationPolicyLocationConstraints;
        /**
         * Names of resources to be put in the location. Must contain unique, correct resource names. If used, targetShape must be left unset.
         */
        names?: string[] | null;
        /**
         * Preference for a given location. Set to either ALLOW or DENY.
         */
        preference?: string | null;
    }
    /**
     * Per-zone constraints on location policy for this zone.
     */
    export interface Schema$LocationPolicyLocationConstraints {
        /**
         * Maximum number of items that are allowed to be placed in this zone. The value must be non-negative.
         */
        maxCount?: number | null;
    }
    /**
     * Represents a machine image resource. A machine image is a Compute Engine resource that stores all the configuration, metadata, permissions, and data from one or more disks required to create a Virtual machine (VM) instance. For more information, see Machine images.
     */
    export interface Schema$MachineImage {
        /**
         * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
         */
        guestFlush?: boolean | null;
        /**
         * [Output Only] A unique identifier for this machine image. The server defines this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Properties of source instance
         */
        instanceProperties?: Schema$InstanceProperties;
        /**
         * [Output Only] The resource type, which is always compute#machineImage for machine image.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this machine image. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
         */
        machineImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Input only. [Input Only] Additional parameters that are passed in the request, but are not persisted in the resource.
         */
        params?: Schema$MachineImageParams;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * An array of Machine Image specific properties for disks attached to the source instance
         */
        savedDisks?: Schema$SavedDisk[];
        /**
         * [Output Only] The URL for this machine image. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKeys?: Schema$SourceDiskEncryptionKey[];
        /**
         * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
         */
        sourceInstance?: string | null;
        /**
         * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
         */
        sourceInstanceProperties?: Schema$SourceInstanceProperties;
        /**
         * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
         */
        status?: string | null;
        /**
         * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
         */
        storageLocations?: string[] | null;
        /**
         * [Output Only] Total size of the storage used by the machine image.
         */
        totalStorageBytes?: string | null;
    }
    /**
     * A list of machine images.
     */
    export interface Schema$MachineImageList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of MachineImage resources.
         */
        items?: Schema$MachineImage[];
        /**
         * [Output Only] The resource type, which is always compute#machineImagesListResponse for machine image lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Machine Image parameters
     */
    export interface Schema$MachineImageParams {
        /**
         * Input only. [Input Only] Specifies the list of disk device names that must be excluded from the new machine image.
         */
        excludedDisks?: string[] | null;
        /**
         * Input only. [Input Only] Specifies the list of disk device names that must be included with the new machine image.
         */
        includedDisks?: string[] | null;
    }
    /**
     * Represents a Machine Type resource. You can use specific machine types for your VM instances based on performance and pricing requirements. For more information, read Machine Types.
     */
    export interface Schema$MachineType {
        /**
         * [Output Only] A list of accelerator configurations assigned to this machine type.
         */
        accelerators?: Array<{
            guestAcceleratorCount?: number;
            guestAcceleratorType?: string;
        }> | null;
        /**
         * [Output Only] The architecture of the machine type.
         */
        architecture?: string | null;
        /**
         * [Output Only] The configuration of bundled local SSD for the machine type.
         */
        bundledLocalSsds?: Schema$BundledLocalSsds;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The number of virtual CPUs that are available to the instance.
         */
        guestCpus?: number | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
         */
        isSharedCpu?: boolean | null;
        /**
         * [Output Only] The type of the resource. Always compute#machineType for machine types.
         */
        kind?: string | null;
        /**
         * [Output Only] Maximum persistent disks allowed.
         */
        maximumPersistentDisks?: number | null;
        /**
         * [Output Only] Maximum total persistent disks size (GB) allowed.
         */
        maximumPersistentDisksSizeGb?: string | null;
        /**
         * [Output Only] The amount of physical memory available to the instance, defined in MB.
         */
        memoryMb?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
         */
        zone?: string | null;
    }
    export interface Schema$MachineTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of MachineTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$MachineTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#machineTypeAggregatedList for aggregated lists of machine types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of machine types.
     */
    export interface Schema$MachineTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of MachineType resources.
         */
        items?: Schema$MachineType[];
        /**
         * [Output Only] Type of resource. Always compute#machineTypeList for lists of machine types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$MachineTypesScopedList {
        /**
         * [Output Only] A list of machine types contained in this scope.
         */
        machineTypes?: Schema$MachineType[];
        /**
         * [Output Only] An informational warning that appears when the machine types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A Managed Instance resource.
     */
    export interface Schema$ManagedInstance {
        /**
         * [Output Only] Current all-instances configuration revision applied to this instance.
         */
        allInstancesConfig?: Schema$ManagedInstanceAllInstancesConfig;
        /**
         * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
         */
        currentAction?: string | null;
        currentActionDetails?: Schema$ManagedInstanceCurrentActionDetails;
        /**
         * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
         */
        id?: string | null;
        /**
         * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
         */
        instance?: string | null;
        /**
         * [Output Only] The overrides to instance properties resulting from InstanceFlexibilityPolicy.
         */
        instanceFlexibilityOverride?: Schema$ManagedInstanceInstanceFlexibilityOverride;
        /**
         * [Output Only] Health state of the instance per health-check.
         */
        instanceHealth?: Schema$ManagedInstanceInstanceHealth[];
        /**
         * [Output Only] The status of the instance. This field is empty when the instance does not exist.
         */
        instanceStatus?: string | null;
        /**
         * [Output Only] The intended template of the instance. This field is empty when current_action is one of { DELETING, ABANDONING \}.
         */
        instanceTemplate?: string | null;
        /**
         * [Output Only] Information about the last attempt to create or delete the instance.
         */
        lastAttempt?: Schema$ManagedInstanceLastAttempt;
        /**
         * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
         */
        name?: string | null;
        /**
         * [Output Only] Preserved state applied from per-instance config for this instance.
         */
        preservedStateFromConfig?: Schema$PreservedState;
        /**
         * [Output Only] Preserved state generated based on stateful policy for this instance.
         */
        preservedStateFromPolicy?: Schema$PreservedState;
        /**
         * [Output Only] Instance properties selected for this instance resulting from InstanceFlexibilityPolicy.
         */
        propertiesFromFlexibilityPolicy?: Schema$ManagedInstancePropertiesFromFlexibilityPolicy;
        /**
         * [Output Only] Information about the termination timestamp of the instance, if applicable.
         */
        scheduling?: Schema$ManagedInstanceScheduling;
        /**
         * [Output only] The size of the VM represented by this Managed Instance. This is how much this Managed Instance contributes to the size of the group.
         */
        sizeInUnit?: number | null;
        /**
         * [Output Only] Tag describing the version.
         */
        tag?: string | null;
        /**
         * [Output Only] The eventual status of the instance. The instance group manager will not be identified as stable till each managed instance reaches its targetStatus.
         */
        targetStatus?: string | null;
        /**
         * [Output Only] Intended version of this instance.
         */
        version?: Schema$ManagedInstanceVersion;
    }
    export interface Schema$ManagedInstanceAllInstancesConfig {
        /**
         * [Output Only] Current all-instances configuration revision. This value is in RFC3339 text format.
         */
        revision?: string | null;
    }
    export interface Schema$ManagedInstanceCurrentActionDetails {
        methodName?: string | null;
        /**
         * [Output Only] Details of the current action that the managed instance group has scheduled for the instance. Contains trigger for the current action, and methodName in case it was triggered by API call. Possible values for trigger: - API Any API call. - PROACTIVE_UPDATE Proactive updater scheduled an update on this managed instance. - AUTOSCALING Instance being deleted/created after a decision from the Autoscaler. - REDISTRIBUTION The regional managed instance group is moving instances between zones to restore balance. - STANDBY_REFILL The managed instance group is refilling the Standby Pool (stopped/suspended virtual machines) after scale up. - MAINTENANCE Manual maintenance. - FAILED_CREATION The managed instance group is handling failed instance creation. - INSTANCE_FAILURE The managed instance group is handling instance failure, according to the Instance Lifecycle Policy. - FAILED_HEALTH_CHECK The managed instance group is handling failed health check, according to the Instance Lifecycle Policy. - TERMINATION_TIMESTAMP Instance reached termination time, thus managed instance group stops/deletes it.
         */
        trigger?: string | null;
    }
    export interface Schema$ManagedInstanceInstanceFlexibilityOverride {
        /**
         * The machine type to be used for this instance.
         */
        machineType?: string | null;
        /**
         * The provisioning model to be used for this instance.
         */
        provisioningModel?: string | null;
    }
    export interface Schema$ManagedInstanceInstanceHealth {
        /**
         * [Output Only] The current detailed instance health state.
         */
        detailedHealthState?: string | null;
        /**
         * [Output Only] The URL for the health check that verifies whether the instance is healthy.
         */
        healthCheck?: string | null;
        /**
         * [Output Only] The current instance health state. This field will not get promoted to beta/GA and might be removed from alpha APIs after 01/12/2019. Please use detailed_health_state field instead.
         */
        healthState?: string | null;
    }
    export interface Schema$ManagedInstanceLastAttempt {
        /**
         * [Output Only] Encountered errors during the last attempt to create or delete the instance.
         */
        errors?: {
            errors?: Array<{
                code?: string;
                errorDetails?: Array<{
                    errorInfo?: Schema$ErrorInfo;
                    help?: Schema$Help;
                    localizedMessage?: Schema$LocalizedMessage;
                    quotaInfo?: Schema$QuotaExceededInfo;
                }>;
                location?: string;
                message?: string;
            }>;
        } | null;
    }
    export interface Schema$ManagedInstancePropertiesFromFlexibilityPolicy {
        /**
         * The machine type to be used for this instance.
         */
        machineType?: string | null;
        /**
         * The provisioning model to be used for this instance.
         */
        provisioningModel?: string | null;
    }
    export interface Schema$ManagedInstanceScheduling {
        /**
         * [Output Only] The timestamp at which the managed instance will be terminated. This is in RFC3339 text format.
         */
        terminationTimestamp?: string | null;
    }
    export interface Schema$ManagedInstanceVersion {
        /**
         * [Output Only] The intended template of the instance. This field is empty when current_action is one of { DELETING, ABANDONING \}.
         */
        instanceTemplate?: string | null;
        /**
         * [Output Only] Name of the version.
         */
        name?: string | null;
    }
    /**
     * A metadata key/value entry.
     */
    export interface Schema$Metadata {
        /**
         * Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
         */
        fingerprint?: string | null;
        /**
         * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
         */
        items?: Array<{
            key?: string;
            value?: string;
        }> | null;
        /**
         * [Output Only] Type of the resource. Always compute#metadata for metadata.
         */
        kind?: string | null;
    }
    /**
     * [Deprecated] Custom authenticator credentials. Custom authenticator credentials.
     */
    export interface Schema$MetadataCredentialsFromPlugin {
        /**
         * Plugin name.
         */
        name?: string | null;
        /**
         * A text proto that conforms to a Struct type definition interpreted by the plugin.
         */
        structConfig?: string | null;
    }
    /**
     * Opaque filter criteria used by load balancers to restrict routing configuration to a limited set of load balancing proxies. Proxies and sidecars involved in load balancing would typically present metadata to the load balancers that need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. An example for using metadataFilters would be: if load balancing involves Envoys, they receive routing configuration when values in metadataFilters match values supplied in of their XDS requests to loadbalancers.
     */
    export interface Schema$MetadataFilter {
        /**
         * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
         */
        filterLabels?: Schema$MetadataFilterLabelMatch[];
        /**
         * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
         */
        filterMatchCriteria?: string | null;
    }
    /**
     * MetadataFilter label name value pairs that are expected to match corresponding labels presented as metadata to the load balancer.
     */
    export interface Schema$MetadataFilterLabelMatch {
        /**
         * Name of metadata label. The name can have a maximum length of 1024 characters and must be at least 1 character long.
         */
        name?: string | null;
        /**
         * The value of the label must match the specified value. value can have a maximum length of 1024 characters.
         */
        value?: string | null;
    }
    /**
     * Represents an amount of money with its currency type.
     */
    export interface Schema$Money {
        /**
         * The three-letter currency code defined in ISO 4217.
         */
        currencyCode?: string | null;
        /**
         * Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
         */
        nanos?: number | null;
        /**
         * The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
         */
        units?: string | null;
    }
    /**
     * Multi-MIG represents a group of managed instance groups.
     */
    export interface Schema$MultiMig {
        /**
         * [Output only] The creation timestamp of this multi-MIG in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output only] The unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#multiMig for multi-MIGs.
         */
        kind?: string | null;
        /**
         * The name of the multi-MIG. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output only] The URL of the region where the resource resides. You must specify this field as part of the HTTP request URL. You cannot set the region as a field in the request body.
         */
        region?: string | null;
        /**
         * Resource policies for this multi-MIG.
         */
        resourcePolicies?: Schema$MultiMigResourcePolicies;
        /**
         * [Output only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        status?: Schema$MultiMigStatus;
    }
    /**
     * Represents a Multi-MIG member resource.
     */
    export interface Schema$MultiMigMember {
        /**
         * [Output Only] Creation timestamp of this multi-MIG member in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output only] The unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * Type of the resource. Always compute#multiMigMember for a list of multi-MIG members.
         */
        kind?: string | null;
        /**
         * [Output Only] The name of this multi-MIG member generated by Google Compute Engine.
         */
        name?: string | null;
        /**
         * [Output Only] The URL of the region where the multi-MIG resides.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of this multi-MIG member
         */
        status?: Schema$MultiMigMemberStatus;
    }
    export interface Schema$MultiMigMemberList {
        /**
         * Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of multi-MIG member resources.
         */
        items?: Schema$MultiMigMember[];
        /**
         * Type of the resource. Always compute#multiMigMember for a list of multi-MIG members.
         */
        kind?: string | null;
        /**
         * This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$MultiMigMemberStatus {
        /**
         * [Output Only] URL of member instance group manager
         */
        instanceGroupManager?: string | null;
    }
    /**
     * Resource policies message for a multi-MIG. Specifies the workload policy configuration of the multi-MIG.
     */
    export interface Schema$MultiMigResourcePolicies {
        /**
         * The URL of the workload policy for this multi-MIG. It can be a full or partial URL. For example, the following are all valid URLs to a workload policy: - https://www.googleapis.com/compute/v1/projects/project/regions/region /resourcePolicies/resourcePolicy - projects/project/regions/region/resourcePolicies/resourcePolicy - regions/region/resourcePolicies/resourcePolicy
         */
        workloadPolicy?: string | null;
    }
    export interface Schema$MultiMigsList {
        etag?: string | null;
        /**
         * Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of multi-MIGs in the specified project and region.
         */
        items?: Schema$MultiMig[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * This token allows you to get the next page of results for maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$MultiMigStatus {
        memberInstanceGroupManagers?: string[] | null;
        /**
         * [Output Only] The number of instance group manager members in this multi-MIG.
         */
        membersCount?: number | null;
    }
    /**
     * [Deprecated] Configuration for the mutual Tls mode for peer authentication. Configuration for the mutual Tls mode for peer authentication.
     */
    export interface Schema$MutualTls {
        /**
         * Specifies if the server TLS is configured to be strict or permissive. This field can be set to one of the following: STRICT: Client certificate must be presented, connection is in TLS. PERMISSIVE: Client certificate can be omitted, connection can be either plaintext or TLS.
         */
        mode?: string | null;
    }
    /**
     * The named port. For example: <"http", 80\>.
     */
    export interface Schema$NamedPort {
        /**
         * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         * The port number, which can be a value between 1 and 65535.
         */
        port?: number | null;
    }
    export interface Schema$NamedSet {
        /**
         * CEL expressions that are comparable to constructs of this set's type (see Policy Language).
         */
        elements?: Schema$Expr[];
        /**
         * A fingerprint for the Named Set being applied to this Router, which is essentially a hash of the Named Set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the Named Set. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make a getNamedSet() request to retrieve a Named Set.
         */
        fingerprint?: string | null;
        /**
         * This set's name, which must be a resource ID segment and unique within all named sets owned by the Router. Name should conform to RFC1035.
         */
        name?: string | null;
        /**
         * This named set's type
         */
        type?: string | null;
    }
    /**
     * Contains NAT IP information of a NAT config (i.e. usage status, mode).
     */
    export interface Schema$NatIpInfo {
        /**
         * A list of all NAT IPs assigned to this NAT config.
         */
        natIpInfoMappings?: Schema$NatIpInfoNatIpInfoMapping[];
        /**
         * Name of the NAT config which the NAT IP belongs to.
         */
        natName?: string | null;
    }
    /**
     * Contains information of a NAT IP.
     */
    export interface Schema$NatIpInfoNatIpInfoMapping {
        /**
         * Specifies whether NAT IP is auto or manual.
         */
        mode?: string | null;
        /**
         * NAT IP address. For example: 203.0.113.11.
         */
        natIp?: string | null;
        /**
         * Specifies whether NAT IP is currently serving at least one endpoint or not.
         */
        usage?: string | null;
    }
    export interface Schema$NatIpInfoResponse {
        /**
         * [Output Only] A list of NAT IP information.
         */
        result?: Schema$NatIpInfo[];
    }
    /**
     * Represents a VPC Network resource. Networks connect resources to each other and to the internet. For more information, read Virtual Private Cloud (VPC) Network.
     */
    export interface Schema$Network {
        /**
         * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
         */
        autoCreateSubnetworks?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
         */
        enableUlaInternalIpv6?: boolean | null;
        /**
         * [Output Only] URL of the firewall policy the network is associated with.
         */
        firewallPolicy?: string | null;
        /**
         * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
         */
        gatewayIPv4?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
         */
        internalIpv6Range?: string | null;
        /**
         * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
         */
        IPv4Range?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#network for networks.
         */
        kind?: string | null;
        /**
         * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
         */
        mtu?: number | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
         */
        networkFirewallPolicyEnforcementOrder?: string | null;
        /**
         * A full or partial URL of the network profile to apply to this network. This field can be set only at resource creation time. For example, the following are valid URLs: - https://www.googleapis.com/compute/{api_version\}/projects/{project_id\}/global/networkProfiles/{network_profile_name\} - projects/{project_id\}/global/networkProfiles/{network_profile_name\}
         */
        networkProfile?: string | null;
        /**
         * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
         */
        params?: Schema$NetworkParams;
        /**
         * [Output Only] A list of network peerings for the resource.
         */
        peerings?: Schema$NetworkPeering[];
        /**
         * [Output Only] URL of the region where the regional network resides. This field is not applicable to global network. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
         */
        routingConfig?: Schema$NetworkRoutingConfig;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
         */
        subnetworks?: string[] | null;
    }
    /**
     * NetworkAttachments A network attachment resource ...
     */
    export interface Schema$NetworkAttachment {
        /**
         * [Output Only] An array of connections for all the producers connected to this network attachment.
         */
        connectionEndpoints?: Schema$NetworkAttachmentConnectedEndpoint[];
        connectionPreference?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. An up-to-date fingerprint must be provided in order to patch.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] The URL of the network which the Network Attachment belongs to. Practically it is inferred by fetching the network of the first subnetwork associated. Because it is required that all the subnetworks must be from the same network, it is assured that the Network Attachment belongs to the same network as all the subnetworks.
         */
        network?: string | null;
        /**
         * Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
         */
        producerAcceptLists?: string[] | null;
        /**
         * Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
         */
        producerRejectLists?: string[] | null;
        /**
         * [Output Only] URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
         */
        subnetworks?: string[] | null;
    }
    /**
     * Contains a list of NetworkAttachmentsScopedList.
     */
    export interface Schema$NetworkAttachmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkAttachmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NetworkAttachmentsScopedList;
        } | null;
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * [Output Only] A connection connected to this network attachment.
     */
    export interface Schema$NetworkAttachmentConnectedEndpoint {
        /**
         * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
         */
        ipAddress?: string | null;
        /**
         * The IPv6 address assigned to the producer instance network interface. This is only assigned when the stack types of both the instance network interface and the consumer subnet are IPv4_IPv6.
         */
        ipv6Address?: string | null;
        /**
         * The project id or number of the interface to which the IP was assigned.
         */
        projectIdOrNum?: string | null;
        /**
         * Alias IP ranges from the same subnetwork.
         */
        secondaryIpCidrRanges?: string[] | null;
        /**
         * The status of a connected endpoint to this network attachment.
         */
        status?: string | null;
        /**
         * The subnetwork used to assign the IP to the producer instance network interface.
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The CIDR range of the subnet from which the IPv4 internal IP was allocated from.
         */
        subnetworkCidrRange?: string | null;
    }
    export interface Schema$NetworkAttachmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkAttachment resources.
         */
        items?: Schema$NetworkAttachment[];
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkAttachmentsScopedList {
        /**
         * A list of NetworkAttachments contained in this scope.
         */
        networkAttachments?: Schema$NetworkAttachment[];
        /**
         * Informational warning which replaces the list of network attachments when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Google Cloud Armor network edge security service resource.
     */
    export interface Schema$NetworkEdgeSecurityService {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a NetworkEdgeSecurityService. An up-to-date fingerprint must be provided in order to update the NetworkEdgeSecurityService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a NetworkEdgeSecurityService.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#networkEdgeSecurityService for NetworkEdgeSecurityServices
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the resource resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * The resource URL for the network edge security service associated with this network edge security service.
         */
        securityPolicy?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    export interface Schema$NetworkEdgeSecurityServiceAggregatedList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEdgeSecurityServicesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NetworkEdgeSecurityServicesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#networkEdgeSecurityServiceAggregatedList for lists of Network Edge Security Services.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkEdgeSecurityServicesScopedList {
        /**
         * A list of NetworkEdgeSecurityServices contained in this scope.
         */
        networkEdgeSecurityServices?: Schema$NetworkEdgeSecurityService[];
        /**
         * Informational warning which replaces the list of security policies when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * The network endpoint.
     */
    export interface Schema$NetworkEndpoint {
        /**
         * Optional metadata defined as annotations on the network endpoint.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * Represents the port number to which PSC consumer sends packets. Optional. Only valid for network endpoint groups created with GCE_VM_IP_PORTMAP endpoint type.
         */
        clientDestinationPort?: number | null;
        /**
         * Optional fully qualified domain name of network endpoint. This can only be specified when NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.
         */
        fqdn?: string | null;
        /**
         * The name or a URL of VM instance of this network endpoint. Optional, the field presence depends on the network endpoint type. The field is required for network endpoints of type GCE_VM_IP and GCE_VM_IP_PORT. The instance must be in the same zone of network endpoint group (for zonal NEGs) or in the zone within the region of the NEG (for regional NEGs). If the ipAddress is specified, it must belongs to the VM instance. The name must be 1-63 characters long, and comply with RFC1035 or be a valid URL pointing to an existing instance.
         */
        instance?: string | null;
        /**
         * Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine (either the primary IP or as part of an aliased IP range). If the IP address is not specified, then the primary IP address for the VM instance in the network that the network endpoint group belongs to will be used. This field is redundant and need not be set for network endpoints of type GCE_VM_IP. If set, it must be set to the primary internal IP address of the attached VM instance that matches the subnetwork of the NEG. The primary internal IP address from any NIC of a multi-NIC VM instance can be added to a NEG as long as it matches the NEG subnetwork.
         */
        ipAddress?: string | null;
        /**
         * Optional IPv6 address of network endpoint.
         */
        ipv6Address?: string | null;
        /**
         * Optional port number of network endpoint. If not specified, the defaultPort for the network endpoint group will be used. This field can not be set for network endpoints of type GCE_VM_IP.
         */
        port?: number | null;
    }
    /**
     * Represents a collection of network endpoints. A network endpoint group (NEG) defines how a set of endpoints should be reached, whether they are reachable, and where they are located. For more information about using NEGs for different use cases, see Network endpoint groups overview.
     */
    export interface Schema$NetworkEndpointGroup {
        /**
         * Optional. Metadata defined as annotations on the network endpoint group.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
         */
        appEngine?: Schema$NetworkEndpointGroupAppEngine;
        /**
         * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
         */
        cloudFunction?: Schema$NetworkEndpointGroupCloudFunction;
        /**
         * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
         */
        cloudRun?: Schema$NetworkEndpointGroupCloudRun;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
         */
        defaultPort?: number | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
         */
        kind?: string | null;
        /**
         * This field is only valid when the network endpoint group is used for load balancing. [Deprecated] This field is deprecated.
         */
        loadBalancer?: Schema$NetworkEndpointGroupLbNetworkEndpointGroup;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
         */
        network?: string | null;
        /**
         * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
         */
        networkEndpointType?: string | null;
        /**
         * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
         */
        pscData?: Schema$NetworkEndpointGroupPscData;
        /**
         * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
         */
        pscTargetService?: string | null;
        /**
         * [Output Only] The URL of the region where the network endpoint group is located.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
         */
        serverlessDeployment?: Schema$NetworkEndpointGroupServerlessDeployment;
        /**
         * [Output only] Number of network endpoints in the network endpoint group.
         */
        size?: number | null;
        /**
         * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
         */
        subnetwork?: string | null;
        /**
         * Specify the type of this network endpoint group. Only LOAD_BALANCING is valid for now.
         */
        type?: string | null;
        /**
         * [Output Only] The URL of the zone where the network endpoint group is located.
         */
        zone?: string | null;
    }
    export interface Schema$NetworkEndpointGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEndpointGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NetworkEndpointGroupsScopedList;
        } | null;
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupAggregatedList for aggregated lists of network endpoint groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Configuration for an App Engine network endpoint group (NEG). The service is optional, may be provided explicitly or in the URL mask. The version is optional and can only be provided explicitly or in the URL mask when service is present. Note: App Engine service must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupAppEngine {
        /**
         * Optional serving service. The service name is case-sensitive and must be 1-63 characters long. Example value: default, my-service.
         */
        service?: string | null;
        /**
         * An URL mask is one of the main components of the Cloud Function. A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services. For example, the request URLs foo1-dot-appname.appspot.com/v1 and foo1-dot-appname.appspot.com/v2 can be backed by the same Serverless NEG with URL mask <service\>-dot-appname.appspot.com/<version\>. The URL mask will parse them to { service = "foo1", version = "v1" \} and { service = "foo1", version = "v2" \} respectively.
         */
        urlMask?: string | null;
        /**
         * Optional serving version. The version name is case-sensitive and must be 1-100 characters long. Example value: v1, v2.
         */
        version?: string | null;
    }
    /**
     * Configuration for a Cloud Function network endpoint group (NEG). The function must be provided explicitly or in the URL mask. Note: Cloud Function must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupCloudFunction {
        /**
         * A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: func1.
         */
        function?: string | null;
        /**
         * An URL mask is one of the main components of the Cloud Function. A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services. For example, request URLs mydomain.com/function1 and mydomain.com/function2 can be backed by the same Serverless NEG with URL mask /<function\>. The URL mask will parse them to { function = "function1" \} and { function = "function2" \} respectively.
         */
        urlMask?: string | null;
    }
    /**
     * Configuration for a Cloud Run network endpoint group (NEG). The service must be provided explicitly or in the URL mask. The tag is optional, may be provided explicitly or in the URL mask. Note: Cloud Run service must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupCloudRun {
        /**
         * Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long, and comply with RFC1035. Example value: "run-service".
         */
        service?: string | null;
        /**
         * Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035. Example value: "revision-0010".
         */
        tag?: string | null;
        /**
         * An URL mask is one of the main components of the Cloud Function. A template to parse <service\> and <tag\> fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services. For example, request URLs foo1.domain.com/bar1 and foo1.domain.com/bar2 can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask <tag\>.domain.com/<service\>. The URL mask will parse them to { service="bar1", tag="foo1" \} and { service="bar2", tag="foo2" \} respectively.
         */
        urlMask?: string | null;
    }
    /**
     * Load balancing specific fields for network endpoint group.
     */
    export interface Schema$NetworkEndpointGroupLbNetworkEndpointGroup {
        /**
         * The default port used if the port number is not specified in the network endpoint. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified. [Deprecated] This field is deprecated.
         */
        defaultPort?: number | null;
        /**
         * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified. [Deprecated] This field is deprecated.
         */
        network?: string | null;
        /**
         * Optional URL of the subnetwork to which all network endpoints in the NEG belong. [Deprecated] This field is deprecated.
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The URL of the zone where the network endpoint group is located. [Deprecated] This field is deprecated.
         */
        zone?: string | null;
    }
    export interface Schema$NetworkEndpointGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEndpointGroup resources.
         */
        items?: Schema$NetworkEndpointGroup[];
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupList for network endpoint group lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * All data that is specifically relevant to only network endpoint groups of type PRIVATE_SERVICE_CONNECT.
     */
    export interface Schema$NetworkEndpointGroupPscData {
        /**
         * [Output Only] Address allocated from given subnetwork for PSC. This IP address acts as a VIP for a PSC NEG, allowing it to act as an endpoint in L7 PSC-XLB.
         */
        consumerPscAddress?: string | null;
        /**
         * The psc producer port is used to connect PSC NEG with specific port on the PSC Producer side; should only be used for the PRIVATE_SERVICE_CONNECT NEG type
         */
        producerPort?: number | null;
        /**
         * [Output Only] The PSC connection id of the PSC Network Endpoint Group Consumer.
         */
        pscConnectionId?: string | null;
        /**
         * [Output Only] The connection status of the PSC Forwarding Rule.
         */
        pscConnectionStatus?: string | null;
    }
    export interface Schema$NetworkEndpointGroupsAttachEndpointsRequest {
        /**
         * The list of network endpoints to be attached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$NetworkEndpointGroupsDetachEndpointsRequest {
        /**
         * The list of network endpoints to be detached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    /**
     * Configuration for a serverless network endpoint group (NEG). The platform must be provided. Note: The target backend service must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupServerlessDeployment {
        /**
         * The platform of the backend target(s) of this NEG. The only supported value is API Gateway: apigateway.googleapis.com.
         */
        platform?: string | null;
        /**
         * The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask. The resource identified by this value is platform-specific and is as follows: 1. API Gateway: The gateway ID 2. App Engine: The service name 3. Cloud Functions: The function name 4. Cloud Run: The service name
         */
        resource?: string | null;
        /**
         * An URL mask is one of the main components of the Cloud Function. A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple resources on the same serverless platform without having to create multiple Network Endpoint Groups and backend resources. The fields parsed by this template are platform-specific and are as follows: 1. API Gateway: The gateway ID 2. App Engine: The service and version 3. Cloud Functions: The function name 4. Cloud Run: The service and tag
         */
        urlMask?: string | null;
        /**
         * The optional resource version. The version identified by this value is platform-specific and is follows: 1. API Gateway: Unused 2. App Engine: The service version 3. Cloud Functions: Unused 4. Cloud Run: The service tag
         */
        version?: string | null;
    }
    export interface Schema$NetworkEndpointGroupsListEndpointsRequest {
        /**
         * Optional list of endpoints to query. This is a more efficient but also limited version of filter parameter. Endpoints in the filter must have ip_address and port fields populated, other fields are not supported.
         */
        endpointFilters?: Schema$NetworkEndpointGroupsListEndpointsRequestNetworkEndpointFilter[];
        /**
         * Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don't specify this parameter, the health status of network endpoints will not be provided.
         */
        healthStatus?: string | null;
    }
    export interface Schema$NetworkEndpointGroupsListEndpointsRequestNetworkEndpointFilter {
        networkEndpoint?: Schema$NetworkEndpoint;
    }
    export interface Schema$NetworkEndpointGroupsListNetworkEndpoints {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEndpointWithHealthStatus resources.
         */
        items?: Schema$NetworkEndpointWithHealthStatus[];
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupsListNetworkEndpoints for the list of network endpoints in the specified network endpoint group.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkEndpointGroupsScopedList {
        /**
         * [Output Only] The list of network endpoint groups that are contained in this scope.
         */
        networkEndpointGroups?: Schema$NetworkEndpointGroup[];
        /**
         * [Output Only] An informational warning that replaces the list of network endpoint groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkEndpointWithHealthStatus {
        /**
         * [Output only] The health status of network endpoint. Optional. Displayed only if the network endpoint has centralized health checking configured.
         */
        healths?: Schema$HealthStatusForNetworkEndpoint[];
        /**
         * [Output only] The network endpoint.
         */
        networkEndpoint?: Schema$NetworkEndpoint;
    }
    export interface Schema$NetworkFirewallPolicyAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of FirewallPoliciesScopedList resources.
         */
        items?: {
            [key: string]: Schema$FirewallPoliciesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#networkFirewallPoliciesAggregatedList for lists of network firewall policies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A network interface resource attached to an instance.
     */
    export interface Schema$NetworkInterface {
        /**
         * An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
         */
        accessConfigs?: Schema$AccessConfig[];
        /**
         * An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
         */
        aliasIpRanges?: Schema$AliasIpRange[];
        /**
         * Fingerprint hash of contents stored in this network interface. This field will be ignored when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided in order to update the NetworkInterface. The request will fail with error 400 Bad Request if the fingerprint is not provided, or 412 Precondition Failed if the fingerprint is out of date.
         */
        fingerprint?: string | null;
        /**
         * Indicate whether igmp query is enabled on the network interface or not. If enabled, also indicates the version of IGMP supported.
         */
        igmpQuery?: string | null;
        /**
         * The prefix length of the primary internal IPv6 range.
         */
        internalIpv6PrefixLength?: number | null;
        /**
         * An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.
         */
        ipv6AccessConfigs?: Schema$AccessConfig[];
        /**
         * [Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork. Valid only if stackType is IPV4_IPV6.
         */
        ipv6AccessType?: string | null;
        /**
         * An IPv6 internal network address for this network interface. To use a static internal IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an internal IPv6 address from the instance's subnetwork.
         */
        ipv6Address?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#networkInterface for network interfaces.
         */
        kind?: string | null;
        /**
         * [Output Only] The name of the network interface, which is generated by the server. For a VM, the network interface uses the nicN naming format. Where N is a value between 0 and 7. The default interface value is nic0.
         */
        name?: string | null;
        /**
         * URL of the VPC network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used. If the selected project doesn't have the default network, you must specify a network or subnet. If the network is not specified but the subnetwork is specified, the network is inferred. If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/global/networks/ network - projects/project/global/networks/network - global/networks/default
         */
        network?: string | null;
        /**
         * The URL of the network attachment that this interface should connect to in the following format: projects/{project_number\}/regions/{region_name\}/networkAttachments/{network_attachment_name\}.
         */
        networkAttachment?: string | null;
        /**
         * An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
         */
        networkIP?: string | null;
        /**
         * The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
         */
        nicType?: string | null;
        /**
         * Name of the parent network interface of a dynamic network interface.
         */
        parentNicName?: string | null;
        /**
         * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.
         */
        queueCount?: number | null;
        /**
         * The stack type for this network interface. To assign only IPv4 addresses, use IPV4_ONLY. To assign both IPv4 and IPv6 addresses, use IPV4_IPV6. If not specified, IPV4_ONLY is used. This field can be both set at instance creation and update network interface operations.
         */
        stackType?: string | null;
        /**
         * SubInterfaces help enable L2 communication for the instance over subnetworks that support L2. Every network interface will get a default untagged (vlan not specified) subinterface. Users can specify additional tagged subinterfaces which are sub-fields to the Network Interface.
         */
        subinterfaces?: Schema$NetworkInterfaceSubInterface[];
        /**
         * The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork
         */
        subnetwork?: string | null;
        /**
         * VLAN tag of a dynamic network interface, must be an integer in the range from 2 to 255 inclusively.
         */
        vlan?: number | null;
    }
    export interface Schema$NetworkInterfaceSubInterface {
        /**
         * An IPv4 internal IP address to assign to the instance for this subinterface. If specified, ip_allocation_mode should be set to ALLOCATE_IP.
         */
        ipAddress?: string | null;
        ipAllocationMode?: string | null;
        /**
         * If specified, this subnetwork must belong to the same network as that of the network interface. If not specified the subnet of network interface will be used. If you specify this property, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork
         */
        subnetwork?: string | null;
        /**
         * VLAN tag. Should match the VLAN(s) supported by the subnetwork to which this subinterface is connecting.
         */
        vlan?: number | null;
    }
    /**
     * Contains a list of networks.
     */
    export interface Schema$NetworkList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Network resources.
         */
        items?: Schema$Network[];
        /**
         * [Output Only] Type of resource. Always compute#networkList for lists of networks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Additional network parameters.
     */
    export interface Schema$NetworkParams {
        /**
         * Tag keys/values directly bound to this resource. Tag keys and values have the same definition as resource manager tags. The field is allowed for INSERT only. The keys/values to set on the resource should be specified in either ID { : \} or Namespaced format { : \}. For example the following are valid inputs: * {"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"\} * {"123/environment" : "production", "345/abc" : "xyz"\} Note: * Invalid combinations of ID & namespaced format is not supported. For instance: {"123/environment" : "tagValues/444"\} is invalid.
         */
        resourceManagerTags?: {
            [key: string]: string;
        } | null;
    }
    /**
     * A network peering attached to a network resource. The message includes the peering name, peer network, peering state, and a flag indicating whether Google Compute Engine should automatically create routes for the peering.
     */
    export interface Schema$NetworkPeering {
        /**
         * Whether Cloud Routers in this network can automatically advertise subnets from the peer network.
         */
        advertisePeerSubnetsViaRouters?: boolean | null;
        /**
         * This field will be deprecated soon. Use the exchange_subnet_routes field instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        autoCreateRoutes?: boolean | null;
        /**
         * [Output Only] The effective state of the peering connection as a whole.
         */
        connectionStatus?: Schema$NetworkPeeringConnectionStatus;
        /**
         * Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        exchangeSubnetRoutes?: boolean | null;
        /**
         * Whether to export the custom routes to peer network. The default value is false.
         */
        exportCustomRoutes?: boolean | null;
        /**
         * Whether subnet routes with public IP range are exported. The default value is true, all subnet routes are exported. IPv4 special-use ranges are always exported to peers and are not controlled by this field.
         */
        exportSubnetRoutesWithPublicIp?: boolean | null;
        /**
         * Whether to import the custom routes from peer network. The default value is false.
         */
        importCustomRoutes?: boolean | null;
        /**
         * Whether subnet routes with public IP range are imported. The default value is false. IPv4 special-use ranges are always imported from peers and are not controlled by this field.
         */
        importSubnetRoutesWithPublicIp?: boolean | null;
        /**
         * Name of this peering. Provided by the client when the peering is created. The name must comply with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all the following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
         */
        network?: string | null;
        /**
         * [Output Only] Maximum Transmission Unit in bytes of the peer network.
         */
        peerMtu?: number | null;
        /**
         * Which IP version(s) of traffic and routes are allowed to be imported or exported between peer networks. The default value is IPV4_ONLY.
         */
        stackType?: string | null;
        /**
         * [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
         */
        state?: string | null;
        /**
         * [Output Only] Details about the current state of the peering.
         */
        stateDetails?: string | null;
        /**
         * The update strategy determines the semantics for updates and deletes to the peering connection configuration.
         */
        updateStrategy?: string | null;
    }
    /**
     * [Output Only] Describes the state of a peering connection, not just the local peering. This field provides information about the effective settings for the connection as a whole, including pending delete/update requests for CONSENSUS peerings.
     */
    export interface Schema$NetworkPeeringConnectionStatus {
        /**
         * The consensus state contains information about the status of update and delete for a consensus peering connection.
         */
        consensusState?: Schema$NetworkPeeringConnectionStatusConsensusState;
        /**
         * The active connectivity settings for the peering connection based on the settings of the network peerings.
         */
        trafficConfiguration?: Schema$NetworkPeeringConnectionStatusTrafficConfiguration;
        /**
         * The update strategy determines the update/delete semantics for this peering connection.
         */
        updateStrategy?: string | null;
    }
    /**
     * The status of update/delete for a consensus peering connection. Only set when connection_status.update_strategy is CONSENSUS or a network peering is proposing to update the strategy to CONSENSUS.
     */
    export interface Schema$NetworkPeeringConnectionStatusConsensusState {
        /**
         * The status of the delete request.
         */
        deleteStatus?: string | null;
        /**
         * The status of the update request.
         */
        updateStatus?: string | null;
    }
    export interface Schema$NetworkPeeringConnectionStatusTrafficConfiguration {
        /**
         * Whether custom routes are being exported to the peer network.
         */
        exportCustomRoutesToPeer?: boolean | null;
        /**
         * Whether subnet routes with public IP ranges are being exported to the peer network.
         */
        exportSubnetRoutesWithPublicIpToPeer?: boolean | null;
        /**
         * Whether custom routes are being imported from the peer network.
         */
        importCustomRoutesFromPeer?: boolean | null;
        /**
         * Whether subnet routes with public IP ranges are being imported from the peer network.
         */
        importSubnetRoutesWithPublicIpFromPeer?: boolean | null;
        /**
         * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
         */
        stackType?: string | null;
    }
    export interface Schema$NetworkPerformanceConfig {
        externalIpEgressBandwidthTier?: string | null;
        totalEgressBandwidthTier?: string | null;
    }
    /**
     * NetworkProfile represents a Google managed network profile resource.
     */
    export interface Schema$NetworkProfile {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output Only] Features supported by the network.
         */
        features?: Schema$NetworkProfileNetworkFeatures;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#networkProfile for network profiles.
         */
        kind?: string | null;
        /**
         * [Output Only] Location to which the network is restricted.
         */
        location?: Schema$NetworkProfileLocation;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Type of the network profile.
         */
        profileType?: Schema$NetworkProfileProfileType;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    export interface Schema$NetworkProfileLocation {
        name?: string | null;
        scope?: string | null;
    }
    export interface Schema$NetworkProfileNetworkFeatures {
        /**
         * Specifies what address purposes are supported. If empty, all address purposes are supported.
         */
        addressPurposes?: string[] | null;
        /**
         * Specifies whether alias IP ranges (and secondary address ranges) are allowed.
         */
        allowAliasIpRanges?: string | null;
        /**
         * Specifies whether auto mode subnet creation is allowed.
         */
        allowAutoModeSubnet?: string | null;
        /**
         * Specifies whether firewalls for Class D address ranges are supported.
         */
        allowClassDFirewalls?: string | null;
        /**
         * Specifies whether cloud NAT creation is allowed.
         */
        allowCloudNat?: string | null;
        /**
         * Specifies whether cloud router creation is allowed.
         */
        allowCloudRouter?: string | null;
        /**
         * Specifies whether default NIC attachment is allowed.
         */
        allowDefaultNicAttachment?: string | null;
        /**
         * Specifies whether VMs are allowed to have external IP access on network interfaces connected to this VPC.
         */
        allowExternalIpAccess?: string | null;
        /**
         * Specifies whether Cloud Interconnect creation is allowed.
         */
        allowInterconnect?: string | null;
        /**
         * Specifies whether IP forwarding is allowed.
         */
        allowIpForwarding?: string | null;
        /**
         * Specifies whether cloud load balancing is allowed.
         */
        allowLoadBalancing?: string | null;
        /**
         * Specifies whether multi-nic in the same network is allowed.
         */
        allowMultiNicInSameNetwork?: string | null;
        /**
         * Specifies whether NCC is allowed.
         */
        allowNcc?: string | null;
        /**
         * Specifies whether VM network migration is allowed.
         */
        allowNetworkMigration?: string | null;
        /**
         * Specifies whether Packet Mirroring 1.0 is supported.
         */
        allowPacketMirroring?: string | null;
        /**
         * Specifies whether private Google access is allowed.
         */
        allowPrivateGoogleAccess?: string | null;
        /**
         * Specifies whether PSC creation is allowed.
         */
        allowPsc?: string | null;
        /**
         * Specifies whether unicast within the same network is allowed.
         */
        allowSameNetworkUnicast?: string | null;
        /**
         * Specifies whether static route creation is allowed.
         */
        allowStaticRoutes?: string | null;
        /**
         * Specifies whether sub interfaces are allowed.
         */
        allowSubInterfaces?: string | null;
        /**
         * Specifies whether VPC peering is allowed.
         */
        allowVpcPeering?: string | null;
        /**
         * Specifies whether VPN creation is allowed.
         */
        allowVpn?: string | null;
        /**
         * If set, limits the interface types that the network supports. If empty, all interface types are supported.
         */
        interfaceTypes?: string[] | null;
        /**
         * Specifies which subnetwork purposes are supported.
         */
        subnetPurposes?: string[] | null;
        /**
         * Specifies which subnetwork stack types are supported.
         */
        subnetStackTypes?: string[] | null;
        /**
         * Specifies which subnetwork purposes are supported.
         */
        subnetworkPurposes?: string[] | null;
        /**
         * Specifies which subnetwork stack types are supported.
         */
        subnetworkStackTypes?: string[] | null;
        /**
         * Specifies which type of unicast is supported.
         */
        unicast?: string | null;
    }
    export interface Schema$NetworkProfileProfileType {
        networkType?: string | null;
        rdmaSubtype?: string | null;
        ullSubtype?: string | null;
        vpcSubtype?: string | null;
    }
    /**
     * Contains a list of network profiles.
     */
    export interface Schema$NetworkProfilesListResponse {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkProfile resources.
         */
        items?: Schema$NetworkProfile[];
        /**
         * [Output Only] Type of resource. Always compute#networkProfileList for network profiles.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
     */
    export interface Schema$NetworkRoutingConfig {
        /**
         * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
         */
        bgpAlwaysCompareMed?: boolean | null;
        /**
         * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
         */
        bgpBestPathSelectionMode?: string | null;
        /**
         * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
         */
        bgpInterRegionCost?: string | null;
        /**
         * [Output Only] Effective value of the bgp_always_compare_med field.
         */
        effectiveBgpAlwaysCompareMed?: boolean | null;
        /**
         * [Output Only] Effective value of the bgp_inter_region_cost field.
         */
        effectiveBgpInterRegionCost?: string | null;
        /**
         * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
         */
        routingMode?: string | null;
    }
    export interface Schema$NetworksAddPeeringRequest {
        /**
         * This field will be deprecated soon. Use exchange_subnet_routes in network_peering instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        autoCreateRoutes?: boolean | null;
        /**
         * This field will be deprecated soon. Use export_custom_routes in network_peering instead. Whether to export the custom routes to peer network.
         */
        exportCustomRoutes?: boolean | null;
        /**
         * This field will be deprecated soon. Use import_custom_routes in network_peering instead. Whether to import the custom routes from peer network.
         */
        importCustomRoutes?: boolean | null;
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string | null;
        /**
         * Network peering parameters. In order to specify route policies for peering using import and export custom routes, you must specify all peering related parameters (name, peer network, exchange_subnet_routes) in the network_peering field. The corresponding fields in NetworksAddPeeringRequest will be deprecated soon.
         */
        networkPeering?: Schema$NetworkPeering;
        /**
         * URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
         */
        peerNetwork?: string | null;
    }
    export interface Schema$NetworksGetEffectiveFirewallsResponse {
        /**
         * [Output Only] Effective firewalls from firewall policy. It returns Global Network Firewall Policies and Hierarchical Firewall Policies. Use regionNetworkFirewallPolicies.getEffectiveFirewalls to get Regional Network Firewall Policies as well.
         */
        firewallPolicys?: Schema$NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy[];
        /**
         * Effective firewalls on the network.
         */
        firewalls?: Schema$Firewall[];
        /**
         * Effective firewalls from organization policies.
         */
        organizationFirewalls?: Schema$NetworksGetEffectiveFirewallsResponseOrganizationFirewallPolicy[];
    }
    export interface Schema$NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy {
        /**
         * [Output Only] Deprecated, please use short name instead. The display name of the firewall policy.
         */
        displayName?: string | null;
        /**
         * [Output Only] The name of the firewall policy.
         */
        name?: string | null;
        /**
         * [Output Only] The packet mirroring rules that apply to the network.
         */
        packetMirroringRules?: Schema$FirewallPolicyRule[];
        /**
         * [Output only] Priority of firewall policy association. Not applicable for type=HIERARCHY.
         */
        priority?: number | null;
        /**
         * [Output Only] The rules that apply to the network.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] The short name of the firewall policy.
         */
        shortName?: string | null;
        /**
         * [Output Only] The type of the firewall policy.
         */
        type?: string | null;
    }
    /**
     * A pruned SecurityPolicy containing ID and any applicable firewall rules.
     */
    export interface Schema$NetworksGetEffectiveFirewallsResponseOrganizationFirewallPolicy {
        /**
         * [Output Only] The unique identifier for the security policy. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The rules that apply to the network.
         */
        rules?: Schema$SecurityPolicyRule[];
    }
    export interface Schema$NetworksRemovePeeringRequest {
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string | null;
    }
    export interface Schema$NetworksRequestRemovePeeringRequest {
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string | null;
    }
    export interface Schema$NetworksUpdatePeeringRequest {
        networkPeering?: Schema$NetworkPeering;
    }
    /**
     * Represents a sole-tenant Node Group resource. A sole-tenant node is a physical server that is dedicated to hosting VM instances only for your specific project. Use sole-tenant nodes to keep your instances physically separated from instances in other projects, or to group your instances together on the same host hardware. For more information, read Sole-tenant nodes.
     */
    export interface Schema$NodeGroup {
        /**
         * Specifies how autoscaling should behave.
         */
        autoscalingPolicy?: Schema$NodeGroupAutoscalingPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
         */
        kind?: string | null;
        /**
         * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
         */
        locationHint?: string | null;
        /**
         * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
         */
        maintenanceInterval?: string | null;
        /**
         * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
         */
        maintenancePolicy?: string | null;
        maintenanceWindow?: Schema$NodeGroupMaintenanceWindow;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * URL of the node template to create the node group from.
         */
        nodeTemplate?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Share-settings for the node group
         */
        shareSettings?: Schema$ShareSettings;
        /**
         * [Output Only] The total number of nodes in the node group.
         */
        size?: number | null;
        status?: string | null;
        /**
         * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
         */
        zone?: string | null;
    }
    export interface Schema$NodeGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeGroupsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource.Always compute#nodeGroupAggregatedList for aggregated lists of node groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeGroupAutoscalingPolicy {
        /**
         * The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.
         */
        maxNodes?: number | null;
        /**
         * The minimum number of nodes that the group should have.
         */
        minNodes?: number | null;
        /**
         * The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
         */
        mode?: string | null;
    }
    /**
     * Contains a list of nodeGroups.
     */
    export interface Schema$NodeGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeGroup resources.
         */
        items?: Schema$NodeGroup[];
        /**
         * [Output Only] Type of resource.Always compute#nodeGroupList for lists of node groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Time window specified for daily maintenance operations. GCE's internal maintenance will be performed within this window.
     */
    export interface Schema$NodeGroupMaintenanceWindow {
        /**
         * [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
         */
        duration?: string | null;
        /**
         * [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
         */
        maintenanceDuration?: Schema$Duration;
        /**
         * Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
         */
        startTime?: string | null;
    }
    export interface Schema$NodeGroupNode {
        /**
         * Accelerators for this node.
         */
        accelerators?: Schema$AcceleratorConfig[];
        /**
         * Node resources that are reserved by all instances.
         */
        consumedResources?: Schema$InstanceConsumptionInfo;
        /**
         * CPU overcommit.
         */
        cpuOvercommitType?: string | null;
        /**
         * Local disk configurations.
         */
        disks?: Schema$LocalDisk[];
        /**
         * Instance data that shows consumed resources on the node.
         */
        instanceConsumptionData?: Schema$InstanceConsumptionData[];
        /**
         * Instances scheduled on this node.
         */
        instances?: string[] | null;
        /**
         * The name of the node.
         */
        name?: string | null;
        /**
         * The type of this node.
         */
        nodeType?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Binding properties for the physical server.
         */
        serverBinding?: Schema$ServerBinding;
        /**
         * Server ID associated with this node.
         */
        serverId?: string | null;
        status?: string | null;
        /**
         * Total amount of available resources on the node.
         */
        totalResources?: Schema$InstanceConsumptionInfo;
        /**
         * [Output Only] The information about an upcoming maintenance event.
         */
        upcomingMaintenance?: Schema$UpcomingMaintenance;
    }
    export interface Schema$NodeGroupsAddNodesRequest {
        /**
         * Count of additional nodes to be added to the node group.
         */
        additionalNodeCount?: number | null;
    }
    export interface Schema$NodeGroupsDeleteNodesRequest {
        /**
         * Names of the nodes to delete.
         */
        nodes?: string[] | null;
    }
    export interface Schema$NodeGroupsListNodes {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Node resources.
         */
        items?: Schema$NodeGroupNode[];
        /**
         * [Output Only] The resource type, which is always compute.nodeGroupsListNodes for the list of nodes in the specified node group.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeGroupsPerformMaintenanceRequest {
        /**
         * [Required] List of nodes affected by the call.
         */
        nodes?: string[] | null;
        /**
         * The start time of the schedule. The timestamp is an RFC3339 string.
         */
        startTime?: string | null;
    }
    export interface Schema$NodeGroupsScopedList {
        /**
         * [Output Only] A list of node groups contained in this scope.
         */
        nodeGroups?: Schema$NodeGroup[];
        /**
         * [Output Only] An informational warning that appears when the nodeGroup list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeGroupsSetNodeTemplateRequest {
        /**
         * Full or partial URL of the node template resource to be updated for this node group.
         */
        nodeTemplate?: string | null;
    }
    export interface Schema$NodeGroupsSimulateMaintenanceEventRequest {
        /**
         * Names of the nodes to go under maintenance simulation.
         */
        nodes?: string[] | null;
    }
    /**
     * Represent a sole-tenant Node Template resource. You can use a template to define properties for nodes in a node group. For more information, read Creating node groups and instances.
     */
    export interface Schema$NodeTemplate {
        accelerators?: Schema$AcceleratorConfig[];
        /**
         * CPU overcommit.
         */
        cpuOvercommitType?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        disks?: Schema$LocalDisk[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
         */
        kind?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Labels to use for node affinity, which will be used in instance scheduling.
         */
        nodeAffinityLabels?: {
            [key: string]: string;
        } | null;
        /**
         * The node type to use for nodes group that are created from this template.
         */
        nodeType?: string | null;
        /**
         * Do not use. Instead, use the node_type property.
         */
        nodeTypeFlexibility?: Schema$NodeTemplateNodeTypeFlexibility;
        /**
         * [Output Only] The name of the region where the node template resides, such as us-central1.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
         */
        serverBinding?: Schema$ServerBinding;
        /**
         * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
         */
        status?: string | null;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string | null;
    }
    export interface Schema$NodeTemplateAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeTemplatesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeTemplatesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource.Always compute#nodeTemplateAggregatedList for aggregated lists of node templates.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of node templates.
     */
    export interface Schema$NodeTemplateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeTemplate resources.
         */
        items?: Schema$NodeTemplate[];
        /**
         * [Output Only] Type of resource.Always compute#nodeTemplateList for lists of node templates.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeTemplateNodeTypeFlexibility {
        cpus?: string | null;
        localSsd?: string | null;
        memory?: string | null;
    }
    export interface Schema$NodeTemplatesScopedList {
        /**
         * [Output Only] A list of node templates contained in this scope.
         */
        nodeTemplates?: Schema$NodeTemplate[];
        /**
         * [Output Only] An informational warning that appears when the node templates list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represent a sole-tenant Node Type resource. Each node within a node group must have a node type. A node type specifies the total amount of cores and memory for that node. Currently, the only available node type is n1-node-96-624 node type that has 96 vCPUs and 624 GB of memory, available in multiple zones. For more information read Node types.
     */
    export interface Schema$NodeType {
        /**
         * [Output Only] The CPU platform used by this node type.
         */
        cpuPlatform?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this node type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The number of virtual CPUs that are available to the node type.
         */
        guestCpus?: number | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#nodeType for node types.
         */
        kind?: string | null;
        /**
         * [Output Only] Local SSD available to the node type, defined in GB.
         */
        localSsdGb?: number | null;
        /**
         * [Output Only] Maximum number of VMs that can be created for this node type.
         */
        maxVms?: number | null;
        /**
         * [Output Only] The amount of physical memory available to the node type, defined in MB.
         */
        memoryMb?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The name of the zone where the node type resides, such as us-central1-a.
         */
        zone?: string | null;
    }
    export interface Schema$NodeTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource.Always compute#nodeTypeAggregatedList for aggregated lists of node types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of node types.
     */
    export interface Schema$NodeTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeType resources.
         */
        items?: Schema$NodeType[];
        /**
         * [Output Only] Type of resource.Always compute#nodeTypeList for lists of node types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeTypesScopedList {
        /**
         * [Output Only] A list of node types contained in this scope.
         */
        nodeTypes?: Schema$NodeType[];
        /**
         * [Output Only] An informational warning that appears when the node types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a notification endpoint. A notification endpoint resource defines an endpoint to receive notifications when there are status changes detected by the associated health check service. For more information, see Health checks overview.
     */
    export interface Schema$NotificationEndpoint {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Settings of the gRPC notification endpoint including the endpoint URL and the retry duration.
         */
        grpcSettings?: Schema$NotificationEndpointGrpcSettings;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#notificationEndpoint for notification endpoints.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the notification endpoint resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
    }
    /**
     * Contains a list of NotificationEndpointsScopedList.
     */
    export interface Schema$NotificationEndpointAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NotificationEndpointsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NotificationEndpointsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
     */
    export interface Schema$NotificationEndpointGrpcSettings {
        /**
         * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
         */
        authority?: string | null;
        /**
         * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
         */
        endpoint?: string | null;
        /**
         * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
         */
        payloadName?: string | null;
        /**
         * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
         */
        resendInterval?: Schema$Duration;
        /**
         * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
         */
        retryDurationSec?: number | null;
    }
    export interface Schema$NotificationEndpointList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NotificationEndpoint resources.
         */
        items?: Schema$NotificationEndpoint[];
        /**
         * [Output Only] Type of the resource. Always compute#notificationEndpoint for notification endpoints.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NotificationEndpointsScopedList {
        /**
         * A list of NotificationEndpoints contained in this scope.
         */
        resources?: Schema$NotificationEndpoint[];
        /**
         * Informational warning which replaces the list of notification endpoints when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Operation resource. Google Compute Engine has three Operation resources: * [Global](/compute/docs/reference/rest/alpha/globalOperations) * [Regional](/compute/docs/reference/rest/alpha/regionOperations) * [Zonal](/compute/docs/reference/rest/alpha/zoneOperations) You can use an operation resource to manage asynchronous API requests. For more information, read Handling API responses. Operations can be global, regional or zonal. - For global operations, use the `globalOperations` resource. - For regional operations, use the `regionOperations` resource. - For zonal operations, use the `zoneOperations` resource. For more information, read Global, Regional, and Zonal Resources. Note that completed Operation resources have a limited retention period.
     */
    export interface Schema$Operation {
        /**
         * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
         */
        clientOperationId?: string | null;
        /**
         * [Deprecated] This field is deprecated.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] A textual description of the operation, which is set when the operation is created.
         */
        description?: string | null;
        /**
         * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
         */
        endTime?: string | null;
        /**
         * [Output Only] If errors are generated during processing of the operation, this field will be populated.
         */
        error?: {
            errors?: Array<{
                code?: string;
                errorDetails?: Array<{
                    errorInfo?: Schema$ErrorInfo;
                    help?: Schema$Help;
                    localizedMessage?: Schema$LocalizedMessage;
                    quotaInfo?: Schema$QuotaExceededInfo;
                }>;
                location?: string;
                message?: string;
            }>;
        } | null;
        /**
         * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
         */
        httpErrorMessage?: string | null;
        /**
         * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
         */
        httpErrorStatusCode?: number | null;
        /**
         * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
         */
        insertTime?: string | null;
        instancesBulkInsertOperationMetadata?: Schema$InstancesBulkInsertOperationMetadata;
        /**
         * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the operation.
         */
        name?: string | null;
        /**
         * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
         */
        operationGroupId?: string | null;
        /**
         * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
         */
        operationType?: string | null;
        /**
         * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
         */
        progress?: number | null;
        /**
         * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] If the operation is for projects.setCommonInstanceMetadata, this field will contain information on all underlying zonal actions and their state.
         */
        setCommonInstanceMetadataOperationMetadata?: Schema$SetCommonInstanceMetadataOperationMetadata;
        /**
         * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
         */
        startTime?: string | null;
        /**
         * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
         */
        status?: string | null;
        /**
         * [Output Only] An optional textual description of the current status of the operation.
         */
        statusMessage?: string | null;
        /**
         * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
         */
        targetId?: string | null;
        /**
         * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the disk that the snapshot was created from.
         */
        targetLink?: string | null;
        /**
         * [Output Only] User who requested the operation, for example: `user@example.com` or `alice_smith_identifier (global/workforcePools/example-com-us-employees)`.
         */
        user?: string | null;
        /**
         * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }> | null;
        /**
         * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
         */
        zone?: string | null;
    }
    export interface Schema$OperationAggregatedList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A map of scoped operation lists.
         */
        items?: {
            [key: string]: Schema$OperationsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always `compute#operationAggregatedList` for aggregated lists of operations.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than `maxResults`, use the `nextPageToken` as a value for the query parameter `pageToken` in the next list request. Subsequent list requests will have their own `nextPageToken` to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Operation resources.
     */
    export interface Schema$OperationList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of Operation resources.
         */
        items?: Schema$Operation[];
        /**
         * [Output Only] Type of resource. Always `compute#operations` for Operations resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than `maxResults`, use the `nextPageToken` as a value for the query parameter `pageToken` in the next list request. Subsequent list requests will have their own `nextPageToken` to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$OperationsScopedList {
        /**
         * [Output Only] A list of operations contained in this scope.
         */
        operations?: Schema$Operation[];
        /**
         * [Output Only] Informational warning which replaces the list of operations when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$OrganizationSecurityPoliciesListAssociationsResponse {
        /**
         * A list of associations.
         */
        associations?: Schema$SecurityPolicyAssociation[];
        /**
         * [Output Only] Type of securityPolicy associations. Always compute#organizationSecurityPoliciesListAssociations for lists of securityPolicy associations.
         */
        kind?: string | null;
    }
    /**
     * [Deprecated] Configuration for the origin authentication method. Configuration for the origin authentication method.
     */
    export interface Schema$OriginAuthenticationMethod {
        jwt?: Schema$Jwt;
    }
    /**
     * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
     */
    export interface Schema$OutlierDetection {
        /**
         * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
         */
        baseEjectionTime?: Schema$Duration;
        /**
         * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
         */
        consecutiveErrors?: number | null;
        /**
         * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
         */
        consecutiveGatewayFailure?: number | null;
        /**
         * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
         */
        enforcingConsecutiveErrors?: number | null;
        /**
         * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
         */
        enforcingConsecutiveGatewayFailure?: number | null;
        /**
         * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
         */
        enforcingSuccessRate?: number | null;
        /**
         * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
         */
        interval?: Schema$Duration;
        /**
         * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
         */
        maxEjectionPercent?: number | null;
        /**
         * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
         */
        successRateMinimumHosts?: number | null;
        /**
         * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
         */
        successRateRequestVolume?: number | null;
        /**
         * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
         */
        successRateStdevFactor?: number | null;
    }
    /**
     * Next free: 7
     */
    export interface Schema$PacketIntervals {
        /**
         * Average observed inter-packet interval in milliseconds.
         */
        avgMs?: string | null;
        /**
         * From how long ago in the past these intervals were observed.
         */
        duration?: string | null;
        /**
         * Maximum observed inter-packet interval in milliseconds.
         */
        maxMs?: string | null;
        /**
         * Minimum observed inter-packet interval in milliseconds.
         */
        minMs?: string | null;
        /**
         * Number of inter-packet intervals from which these statistics were derived.
         */
        numIntervals?: string | null;
        /**
         * The type of packets for which inter-packet intervals were computed.
         */
        type?: string | null;
    }
    /**
     * Represents a Packet Mirroring resource. Packet Mirroring clones the traffic of specified instances in your Virtual Private Cloud (VPC) network and forwards it to a collector destination, such as an instance group of an internal TCP/UDP load balancer, for analysis or examination. For more information about setting up Packet Mirroring, see Using Packet Mirroring.
     */
    export interface Schema$PacketMirroring {
        /**
         * The Forwarding Rule resource of type loadBalancingScheme=INTERNAL that will be used as collector for mirrored traffic. The specified forwarding rule must have isMirroringCollector set to true.
         */
        collectorIlb?: Schema$PacketMirroringForwardingRuleInfo;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet mirroring policy will not be enforced on the network. The default is TRUE.
         */
        enable?: string | null;
        /**
         * Filter for mirrored traffic. If unspecified, all IPv4 traffic is mirrored.
         */
        filter?: Schema$PacketMirroringFilter;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#packetMirroring for packet mirrorings.
         */
        kind?: string | null;
        /**
         * PacketMirroring mirroredResourceInfos. MirroredResourceInfo specifies a set of mirrored VM instances, subnetworks and/or tags for which traffic from/to all VM instances will be mirrored.
         */
        mirroredResources?: Schema$PacketMirroringMirroredResourceInfo;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Specifies the mirrored VPC network. Only packets in this network will be mirrored. All mirrored VMs should have a NIC in the given network. All mirrored subnetworks should belong to the given network.
         */
        network?: Schema$PacketMirroringNetworkInfo;
        /**
         * The priority of applying this configuration. Priority is used to break ties in cases where there is more than one matching rule. In the case of two rules that apply for a given Instance, the one with the lowest-numbered priority value wins. Default value is 1000. Valid range is 0 through 65535.
         */
        priority?: number | null;
        /**
         * [Output Only] URI of the region where the packetMirroring resides.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Contains a list of packetMirrorings.
     */
    export interface Schema$PacketMirroringAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PacketMirroring resources.
         */
        items?: {
            [key: string]: Schema$PacketMirroringsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PacketMirroringFilter {
        /**
         * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
         */
        cidrRanges?: string[] | null;
        /**
         * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
         */
        direction?: string | null;
        /**
         * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
         */
        IPProtocols?: string[] | null;
    }
    export interface Schema$PacketMirroringForwardingRuleInfo {
        /**
         * [Output Only] Unique identifier for the forwarding rule; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.
         */
        url?: string | null;
    }
    /**
     * Contains a list of PacketMirroring resources.
     */
    export interface Schema$PacketMirroringList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PacketMirroring resources.
         */
        items?: Schema$PacketMirroring[];
        /**
         * [Output Only] Type of resource. Always compute#packetMirroring for packetMirrorings.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PacketMirroringMirroredResourceInfo {
        /**
         * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
         */
        instances?: Schema$PacketMirroringMirroredResourceInfoInstanceInfo[];
        /**
         * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
         */
        subnetworks?: Schema$PacketMirroringMirroredResourceInfoSubnetInfo[];
        /**
         * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
         */
        tags?: string[] | null;
    }
    export interface Schema$PacketMirroringMirroredResourceInfoInstanceInfo {
        /**
         * [Output Only] Unique identifier for the instance; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * Resource URL to the virtual machine instance which is being mirrored.
         */
        url?: string | null;
    }
    export interface Schema$PacketMirroringMirroredResourceInfoSubnetInfo {
        /**
         * [Output Only] Unique identifier for the subnetwork; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.
         */
        url?: string | null;
    }
    export interface Schema$PacketMirroringNetworkInfo {
        /**
         * [Output Only] Unique identifier for the network; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * URL of the network resource.
         */
        url?: string | null;
    }
    export interface Schema$PacketMirroringsScopedList {
        /**
         * A list of packetMirrorings contained in this scope.
         */
        packetMirrorings?: Schema$PacketMirroring[];
        /**
         * Informational warning which replaces the list of packetMirrorings when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Model definition of partner_metadata field. To be used in dedicated Partner Metadata methods and to be inlined in the Instance and InstanceTemplate resources.
     */
    export interface Schema$PartnerMetadata {
        /**
         * Instance-level hash to be used for optimistic locking.
         */
        fingerprint?: string | null;
        /**
         * Partner Metadata assigned to the instance. A map from a subdomain to entries map. Subdomain name must be compliant with RFC1035 definition. The total size of all keys and values must be less than 2MB. Subdomain 'metadata.compute.googleapis.com' is reserverd for instance's metadata.
         */
        partnerMetadata?: {
            [key: string]: Schema$StructuredEntries;
        } | null;
    }
    /**
     * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service is used.
     */
    export interface Schema$PathMatcher {
        /**
         * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the PathMatcher level and applies only when no policy has been defined for the error code at lower levels like RouteRule and PathRule within this PathMatcher. If an error code does not have a policy defined in defaultCustomErrorResponsePolicy, then a policy defined for the error code in UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the following configuration: - UrlMap.defaultCustomErrorResponsePolicy is configured with policies for 5xx and 4xx errors - A RouteRule for /coming_soon/ is configured for the error code 404. If the request is for www.myotherdomain.com and a 404 is encountered, the policy under UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the request for www.example.com/coming_soon/ encounters a 404, the policy in RouteRule.customErrorResponsePolicy takes effect. If any of the requests in this example encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with pathMatcher.defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
         */
        defaultCustomErrorResponsePolicy?: Schema$CustomErrorResponsePolicy;
        /**
         * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
         */
        defaultRouteAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
         */
        defaultService?: string | null;
        /**
         * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
         */
        defaultUrlRedirect?: Schema$HttpRedirectAction;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
         */
        headerAction?: Schema$HttpHeaderAction;
        /**
         * The name to which this PathMatcher is referred by the HostRule.
         */
        name?: string | null;
        /**
         * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/x will match before /a/b/x irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
         */
        pathRules?: Schema$PathRule[];
        /**
         * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
         */
        routeRules?: Schema$HttpRouteRule[];
    }
    /**
     * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
     */
    export interface Schema$PathRule {
        /**
         * customErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. If a policy for an error code is not configured for the PathRule, a policy for the error code configured in pathMatcher.defaultCustomErrorResponsePolicy is applied. If one is not specified in pathMatcher.defaultCustomErrorResponsePolicy, the policy configured in UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the following configuration: - UrlMap.defaultCustomErrorResponsePolicy are configured with policies for 5xx and 4xx errors - A PathRule for /coming_soon/ is configured for the error code 404. If the request is for www.myotherdomain.com and a 404 is encountered, the policy under UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the request for www.example.com/coming_soon/ encounters a 404, the policy in PathRule.customErrorResponsePolicy takes effect. If any of the requests in this example encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect. customErrorResponsePolicy is supported only for global external Application Load Balancers.
         */
        customErrorResponsePolicy?: Schema$CustomErrorResponsePolicy;
        /**
         * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
         */
        paths?: string[] | null;
        /**
         * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of urlRedirect, service or routeAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
         */
        routeAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of urlRedirect, service or routeAction.weightedBackendService can be set.
         */
        service?: string | null;
        /**
         * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. Only one of urlRedirect, service or routeAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
         */
        urlRedirect?: Schema$HttpRedirectAction;
    }
    /**
     * [Deprecated] Configuration for the peer authentication method. Configuration for the peer authentication method.
     */
    export interface Schema$PeerAuthenticationMethod {
        /**
         * Set if mTLS is used for peer authentication.
         */
        mtls?: Schema$MutualTls;
    }
    export interface Schema$PerInstanceConfig {
        /**
         * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
         */
        fingerprint?: string | null;
        /**
         * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configuration for a VM instance that either doesn't exist or is not part of the group will result in an error.
         */
        name?: string | null;
        /**
         * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
         */
        preservedState?: Schema$PreservedState;
        /**
         * The status of applying this per-instance configuration on the corresponding managed instance.
         */
        status?: string | null;
    }
    /**
     * [Deprecated] All fields defined in a permission are ANDed.
     */
    export interface Schema$Permission {
        /**
         * Extra custom constraints. The constraints are ANDed together.
         */
        constraints?: Schema$PermissionConstraint[];
        /**
         * Used in Ingress or Egress Gateway cases to specify hosts that the policy applies to. Exact match, prefix match, and suffix match are supported.
         */
        hosts?: string[] | null;
        /**
         * HTTP method.
         */
        methods?: string[] | null;
        /**
         * Negate of hosts. Specifies exclusions.
         */
        notHosts?: string[] | null;
        /**
         * Negate of methods. Specifies exclusions.
         */
        notMethods?: string[] | null;
        /**
         * Negate of paths. Specifies exclusions.
         */
        notPaths?: string[] | null;
        /**
         * Negate of ports. Specifies exclusions.
         */
        notPorts?: string[] | null;
        /**
         * HTTP request paths or gRPC methods. Exact match, prefix match, and suffix match are supported.
         */
        paths?: string[] | null;
        /**
         * Port names or numbers.
         */
        ports?: string[] | null;
    }
    /**
     * Custom constraint that specifies a key and a list of allowed values for Istio attributes.
     */
    export interface Schema$PermissionConstraint {
        /**
         * Key of the constraint.
         */
        key?: string | null;
        /**
         * A list of allowed values.
         */
        values?: string[] | null;
    }
    /**
     * An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** ``` { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] \}, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", \} \} ], "etag": "BwWWja0YfJA=", "version": 3 \} ``` **YAML example:** ``` bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
     */
    export interface Schema$Policy {
        /**
         * Specifies cloud audit logging configuration for this policy.
         */
        auditConfigs?: Schema$AuditConfig[];
        /**
         * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
         */
        bindings?: Schema$Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
         */
        etag?: string | null;
        /**
         * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        version?: number | null;
    }
    export interface Schema$PreconfiguredWafSet {
        /**
         * List of entities that are currently supported for WAF rules.
         */
        expressionSets?: Schema$WafExpressionSet[];
    }
    /**
     * Preserved state for a given instance.
     */
    export interface Schema$PreservedState {
        /**
         * Preserved disks defined for this instance. This map is keyed with the device names of the disks.
         */
        disks?: {
            [key: string]: Schema$PreservedStatePreservedDisk;
        } | null;
        /**
         * Preserved external IPs defined for this instance. This map is keyed with the name of the network interface.
         */
        externalIPs?: {
            [key: string]: Schema$PreservedStatePreservedNetworkIp;
        } | null;
        /**
         * Preserved internal IPs defined for this instance. This map is keyed with the name of the network interface.
         */
        internalIPs?: {
            [key: string]: Schema$PreservedStatePreservedNetworkIp;
        } | null;
        /**
         * Preserved metadata defined for this instance.
         */
        metadata?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$PreservedStatePreservedDisk {
        /**
         * These stateful disks will never be deleted during autohealing, update, instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole MIG is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
         */
        autoDelete?: string | null;
        /**
         * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
         */
        mode?: string | null;
        /**
         * The URL of the disk resource that is stateful and should be attached to the VM instance.
         */
        source?: string | null;
    }
    export interface Schema$PreservedStatePreservedNetworkIp {
        /**
         * These stateful IPs will never be released during autohealing, update or VM instance recreate operations. This flag is used to configure if the IP reservation should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted.
         */
        autoDelete?: string | null;
        /**
         * Ip address representation
         */
        ipAddress?: Schema$PreservedStatePreservedNetworkIpIpAddress;
    }
    export interface Schema$PreservedStatePreservedNetworkIpIpAddress {
        /**
         * The URL of the reservation for this IP address.
         */
        address?: string | null;
        /**
         * An IPv4 internal network address to assign to the instance for this network interface.
         */
        literal?: string | null;
    }
    /**
     * Represents a single Google Compute Engine preview feature.
     */
    export interface Schema$PreviewFeature {
        /**
         * Specifies whether the feature is enabled or disabled.
         */
        activationStatus?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] Description of the feature.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] The type of the feature. Always "compute#previewFeature" for preview features.
         */
        kind?: string | null;
        /**
         * Name of the feature.
         */
        name?: string | null;
        /**
         * Rollout operation of the feature.
         */
        rolloutOperation?: Schema$PreviewFeatureRolloutOperation;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output only] Status of the feature.
         */
        status?: Schema$PreviewFeatureStatus;
    }
    export interface Schema$PreviewFeatureList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PreviewFeature resources.
         */
        items?: Schema$PreviewFeature[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents the rollout operation
     */
    export interface Schema$PreviewFeatureRolloutOperation {
        rolloutInput?: Schema$PreviewFeatureRolloutOperationRolloutInput;
        rolloutStatus?: Schema$PreviewFeatureRolloutOperationRolloutStatus;
    }
    export interface Schema$PreviewFeatureRolloutOperationRolloutInput {
        /**
         * The name of the rollout plan Ex. organizations//locations/global/rolloutPlans/ Ex. folders//locations/global/rolloutPlans/ Ex. projects//locations/global/rolloutPlans/.
         */
        name?: string | null;
        /**
         * Predefined rollout plan.
         */
        predefinedRolloutPlan?: string | null;
        /**
         * The UUID of the retry action. Only needed if this is a retry for an existing rollout. This can be used after the user canceled a rollout and want to retry it with no changes.
         */
        retryUuid?: string | null;
    }
    export interface Schema$PreviewFeatureRolloutOperationRolloutStatus {
        /**
         * Output only. The ongoing rollout resources. There can be multiple ongoing rollouts for a resource.
         */
        ongoingRollouts?: Schema$PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata[];
        /**
         * Output only. The last completed rollout resource. This field will not be populated until the first rollout is completed.
         */
        previousRollout?: Schema$PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata;
    }
    export interface Schema$PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata {
        /**
         * The name of the rollout Ex. organizations//locations/global/rollouts/ Ex. folders//locations/global/rollouts/ Ex. projects//locations/global/rollouts/.
         */
        rollout?: string | null;
        /**
         * The name of the rollout plan Ex. organizations//locations/global/rolloutPlans/ Ex. folders//locations/global/rolloutPlans/ Ex. projects//locations/global/rolloutPlans/.
         */
        rolloutPlan?: string | null;
        /**
         * The status of the rollout.
         */
        status?: Schema$PreviewFeatureStatus;
    }
    /**
     * [Output Only] The status of the feature.
     */
    export interface Schema$PreviewFeatureStatus {
        /**
         * [Output Only] The description of the feature.
         */
        description?: string | null;
        /**
         * [Output Only] Link to the public documentation for the feature.
         */
        helpLink?: string | null;
        releaseStatus?: Schema$PreviewFeatureStatusReleaseStatus;
    }
    export interface Schema$PreviewFeatureStatusReleaseStatus {
        /**
         * [Output Only] The stage of the feature.
         */
        stage?: string | null;
        /**
         * Output only. The last date when a feature transitioned between ReleaseStatuses.
         */
        updateDate?: Schema$Date;
    }
    /**
     * [Deprecated] All fields defined in a principal are ANDed.
     */
    export interface Schema$Principal {
        /**
         * An expression to specify custom condition.
         */
        condition?: string | null;
        /**
         * The groups the principal belongs to. Exact match, prefix match, and suffix match are supported.
         */
        groups?: string[] | null;
        /**
         * IPv4 or IPv6 address or range (In CIDR format)
         */
        ips?: string[] | null;
        /**
         * The namespaces. Exact match, prefix match, and suffix match are supported.
         */
        namespaces?: string[] | null;
        /**
         * Negate of groups. Specifies exclusions.
         */
        notGroups?: string[] | null;
        /**
         * Negate of IPs. Specifies exclusions.
         */
        notIps?: string[] | null;
        /**
         * Negate of namespaces. Specifies exclusions.
         */
        notNamespaces?: string[] | null;
        /**
         * Negate of users. Specifies exclusions.
         */
        notUsers?: string[] | null;
        /**
         * A map of Istio attribute to expected values. Exact match, prefix match, and suffix match are supported for values. For example, `request.headers[version]: "v1"`. The properties are ANDed together.
         */
        properties?: {
            [key: string]: string;
        } | null;
        /**
         * The user names/IDs or service accounts. Exact match, prefix match, and suffix match are supported.
         */
        users?: string[] | null;
    }
    /**
     * Represents a Project resource. A project is used to organize resources in a Google Cloud Platform environment. For more information, read about the Resource Hierarchy.
     */
    export interface Schema$Project {
        /**
         * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
         */
        cloudArmorTier?: string | null;
        /**
         * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
         */
        commonInstanceMetadata?: Schema$Metadata;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
         */
        defaultNetworkTier?: string | null;
        /**
         * [Output Only] Default service account used by VMs running in this project.
         */
        defaultServiceAccount?: string | null;
        /**
         * An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * An optional list of restricted features enabled for use on this project.
         */
        enabledFeatures?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#project for projects.
         */
        kind?: string | null;
        /**
         * [Output Only] The Cloud Armor Managed Protection (CAMP) tier for this project. It can be one of the following values: CA_STANDARD, CAMP_PLUS_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
         */
        managedProtectionTier?: string | null;
        /**
         * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
         */
        name?: string | null;
        /**
         * [Output Only] Quotas assigned to this project.
         */
        quotas?: Schema$Quota[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
         */
        usageExportLocation?: Schema$UsageExportLocation;
        /**
         * [Output Only] Default internal DNS setting used by VMs running in this project.
         */
        vmDnsSetting?: string | null;
        /**
         * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
         */
        xpnProjectStatus?: string | null;
    }
    export interface Schema$ProjectsDisableXpnResourceRequest {
        /**
         * Service resource (a.k.a service project) ID.
         */
        xpnResource?: Schema$XpnResourceId;
    }
    export interface Schema$ProjectsEnableXpnResourceRequest {
        /**
         * Service resource (a.k.a service project) ID.
         */
        xpnResource?: Schema$XpnResourceId;
    }
    export interface Schema$ProjectsGetXpnResources {
        /**
         * [Output Only] Type of resource. Always compute#projectsGetXpnResources for lists of service resources (a.k.a service projects)
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * Service resources (a.k.a service projects) attached to this project as their shared VPC host.
         */
        resources?: Schema$XpnResourceId[];
    }
    export interface Schema$ProjectsListXpnHostsRequest {
        /**
         * Optional organization ID managed by Cloud Resource Manager, for which to list shared VPC host projects. If not specified, the organization will be inferred from the project.
         */
        organization?: string | null;
        /**
         * Opt-in for partial page behavior which provides a partial filled page (number of items on which may be smaller than maxResults) within the API deadline. If opt-in, then the user should rely on if nextPageToken is empty in the response to determine if there is a next page. Empty page is also valid and possible. The default value is false.
         */
        returnPartialPage?: boolean | null;
    }
    export interface Schema$ProjectsSetCloudArmorTierRequest {
        /**
         * Managed protection tier to be set.
         */
        cloudArmorTier?: string | null;
    }
    export interface Schema$ProjectsSetDefaultNetworkTierRequest {
        /**
         * Default network tier to be set.
         */
        networkTier?: string | null;
    }
    export interface Schema$ProjectsSetDefaultServiceAccountRequest {
        /**
         * Email address of the service account.
         */
        email?: string | null;
    }
    export interface Schema$ProjectsSetManagedProtectionTierRequest {
        /**
         * Managed protection tier to be set.
         */
        managedProtectionTier?: string | null;
    }
    /**
     * A public advertised prefix represents an aggregated IP prefix or netblock which customers bring to cloud. The IP prefix is a single unit of route advertisement and is announced globally to the internet.
     */
    export interface Schema$PublicAdvertisedPrefix {
        /**
         * [Output Only] The version of BYOIP API.
         */
        byoipApiVersion?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The address to be used for reverse DNS verification.
         */
        dnsVerificationIp?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * The address range, in CIDR format, represented by this public advertised prefix.
         */
        ipCidrRange?: string | null;
        /**
         * The internet access type for IPv6 Public Advertised Prefixes.
         */
        ipv6AccessType?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
         */
        pdpScope?: string | null;
        /**
         * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
         */
        publicDelegatedPrefixs?: Schema$PublicAdvertisedPrefixPublicDelegatedPrefix[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The shared secret to be used for reverse DNS verification.
         */
        sharedSecret?: string | null;
        /**
         * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
         */
        status?: string | null;
    }
    export interface Schema$PublicAdvertisedPrefixList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PublicAdvertisedPrefix resources.
         */
        items?: Schema$PublicAdvertisedPrefix[];
        /**
         * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a CIDR range which can be used to assign addresses.
     */
    export interface Schema$PublicAdvertisedPrefixPublicDelegatedPrefix {
        /**
         * The IP address range of the public delegated prefix
         */
        ipRange?: string | null;
        /**
         * The name of the public delegated prefix
         */
        name?: string | null;
        /**
         * The project number of the public delegated prefix
         */
        project?: string | null;
        /**
         * The region of the public delegated prefix if it is regional. If absent, the prefix is global.
         */
        region?: string | null;
        /**
         * The status of the public delegated prefix. Possible values are: INITIALIZING: The public delegated prefix is being initialized and addresses cannot be created yet. ANNOUNCED: The public delegated prefix is active.
         */
        status?: string | null;
    }
    /**
     * A PublicDelegatedPrefix resource represents an IP block within a PublicAdvertisedPrefix that is configured within a single cloud scope (global or region). IPs in the block can be allocated to resources within that scope. Public delegated prefixes may be further broken up into smaller IP blocks in the same scope as the parent block.
     */
    export interface Schema$PublicDelegatedPrefix {
        /**
         * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
         */
        allocatablePrefixLength?: number | null;
        /**
         * [Output Only] The version of BYOIP API.
         */
        byoipApiVersion?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * The IP address range, in CIDR format, represented by this public delegated prefix.
         */
        ipCidrRange?: string | null;
        /**
         * [Output Only] The internet access type for IPv6 Public Delegated Prefixes. Inherited from parent prefix.
         */
        ipv6AccessType?: string | null;
        /**
         * If true, the prefix will be live migrated.
         */
        isLiveMigration?: boolean | null;
        /**
         * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
         */
        kind?: string | null;
        /**
         * The public delegated prefix mode for IPv6 only.
         */
        mode?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
         */
        parentPrefix?: string | null;
        /**
         * The list of sub public delegated prefixes that exist for this public delegated prefix.
         */
        publicDelegatedSubPrefixs?: Schema$PublicDelegatedPrefixPublicDelegatedSubPrefix[];
        /**
         * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is announced and ready to use. - `DELETING` The public delegated prefix is being deprovsioned.
         */
        status?: string | null;
    }
    export interface Schema$PublicDelegatedPrefixAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PublicDelegatedPrefixesScopedList resources.
         */
        items?: {
            [key: string]: Schema$PublicDelegatedPrefixesScopedList;
        } | null;
        /**
         * [Output Only] Type of the resource. Always compute#publicDelegatedPrefixAggregatedList for aggregated lists of public delegated prefixes.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PublicDelegatedPrefixesScopedList {
        /**
         * [Output Only] A list of PublicDelegatedPrefixes contained in this scope.
         */
        publicDelegatedPrefixes?: Schema$PublicDelegatedPrefix[];
        /**
         * [Output Only] Informational warning which replaces the list of public delegated prefixes when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PublicDelegatedPrefixList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PublicDelegatedPrefix resources.
         */
        items?: Schema$PublicDelegatedPrefix[];
        /**
         * [Output Only] Type of the resource. Always compute#publicDelegatedPrefixList for public delegated prefixes.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a sub PublicDelegatedPrefix.
     */
    export interface Schema$PublicDelegatedPrefixPublicDelegatedSubPrefix {
        /**
         * The allocatable prefix length supported by this PublicDelegatedSubPrefix.
         */
        allocatablePrefixLength?: number | null;
        /**
         * Name of the project scoping this PublicDelegatedSubPrefix.
         */
        delegateeProject?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The IP address range, in CIDR format, represented by this sub public delegated prefix.
         */
        ipCidrRange?: string | null;
        /**
         * [Output Only] The internet access type for IPv6 Public Delegated Sub Prefixes. Inherited from parent prefix.
         */
        ipv6AccessType?: string | null;
        /**
         * Whether the sub prefix is delegated to create Address resources in the delegatee project.
         */
        isAddress?: boolean | null;
        /**
         * The PublicDelegatedSubPrefix mode for IPv6 only.
         */
        mode?: string | null;
        /**
         * The name of the sub public delegated prefix.
         */
        name?: string | null;
        /**
         * [Output Only] The region of the sub public delegated prefix if it is regional. If absent, the sub prefix is global.
         */
        region?: string | null;
        /**
         * [Output Only] The status of the sub public delegated prefix.
         */
        status?: string | null;
    }
    /**
     * QueuedResource represents a request for future capacity. The capacity is delivered in the form of other GCE resources, either Instances or Reservations.
     */
    export interface Schema$QueuedResource {
        /**
         * Specification of VM instances to create.
         */
        bulkInsertInstanceResource?: Schema$BulkInsertInstanceResource;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#queuedResource for QueuedResources.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Queuing parameters for the requested capacity.
         */
        queuingPolicy?: Schema$QueuingPolicy;
        /**
         * [Output only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output only] High-level status of the request.
         */
        state?: string | null;
        /**
         * [Output only] Result of queuing and provisioning based on deferred capacity.
         */
        status?: Schema$QueuedResourceStatus;
        /**
         * [Output Only] URL of the zone where the resource resides. Only applicable for zonal resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$QueuedResourceList {
        /**
         * Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of QueuedResource resources.
         */
        items?: Schema$QueuedResource[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * This token allows you to get the next page of results for maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$QueuedResourcesAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of QueuedResourcesScopedList resources.
         */
        items?: {
            [key: string]: Schema$QueuedResourcesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#queuedResourcesAggregatedList for lists of QueuedResource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$QueuedResourcesScopedList {
        /**
         * List of QueuedResources contained in this scope.
         */
        queuedResources?: Schema$QueuedResource[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$QueuedResourceStatus {
        failedData?: Schema$QueuedResourceStatusFailedData;
        provisioningOperations?: string[] | null;
        queuingPolicy?: Schema$QueuingPolicy;
    }
    export interface Schema$QueuedResourceStatusFailedData {
        error?: {
            errors?: Array<{
                code?: string;
                errorDetails?: Array<{
                    errorInfo?: Schema$ErrorInfo;
                    help?: Schema$Help;
                    localizedMessage?: Schema$LocalizedMessage;
                    quotaInfo?: Schema$QuotaExceededInfo;
                }>;
                location?: string;
                message?: string;
            }>;
        } | null;
    }
    /**
     * Queuing parameters for the requested deferred capacity.
     */
    export interface Schema$QueuingPolicy {
        /**
         * Relative deadline for waiting for capacity.
         */
        validUntilDuration?: Schema$Duration;
        /**
         * Absolute deadline for waiting for capacity in RFC3339 text format.
         */
        validUntilTime?: string | null;
    }
    /**
     * A quotas entry.
     */
    export interface Schema$Quota {
        /**
         * [Output Only] Quota limit for this metric.
         */
        limit?: number | null;
        /**
         * [Output Only] Name of the quota metric.
         */
        metric?: string | null;
        /**
         * [Output Only] Owning resource. This is the resource on which this quota is applied.
         */
        owner?: string | null;
        /**
         * [Output Only] Current usage of this metric.
         */
        usage?: number | null;
    }
    /**
     * Additional details for quota exceeded error for resource quota.
     */
    export interface Schema$QuotaExceededInfo {
        /**
         * The map holding related quota dimensions.
         */
        dimensions?: {
            [key: string]: string;
        } | null;
        /**
         * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
         */
        futureLimit?: number | null;
        /**
         * Current effective quota limit. The limit's unit depends on the quota type or metric.
         */
        limit?: number | null;
        /**
         * The name of the quota limit.
         */
        limitName?: string | null;
        /**
         * The Compute Engine quota metric name.
         */
        metricName?: string | null;
        /**
         * Rollout status of the future quota limit.
         */
        rolloutStatus?: string | null;
    }
    export interface Schema$RbacPolicy {
        /**
         * Name of the RbacPolicy.
         */
        name?: string | null;
        /**
         * The list of permissions.
         */
        permissions?: Schema$Permission[];
        /**
         * The list of principals.
         */
        principals?: Schema$Principal[];
    }
    /**
     * Represents a RecoverableSnapshot resource. A RecoverableSnapshot represents a snapshot in recycle bin.
     */
    export interface Schema$RecoverableSnapshot {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Optional. An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#recoverableSnapshot for RecoverableSnapshot resources.
         */
        kind?: string | null;
        /**
         * Identifier. Name of the recoverable snapshot generated on the deletion of the snapshot. The name will be 1-63 characters long, and comply with RFC1035. Specifically, the name will be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character will be a lowercase letter, and all following characters can be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Output Only] The original snapshot resource.
         */
        originalResource?: Schema$RecoverableSnapshotOriginalSnapshot;
        /**
         * [Output Only] Purge timestamp of recoverable snapshot in RFC3339 text format.
         */
        purgeTimestamp?: string | null;
        /**
         * Output only. [Output Only] Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Status of the recoverable snapshot.
         */
        status?: string | null;
    }
    export interface Schema$RecoverableSnapshotAggregatedList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of RecoverableSnapshotsScopedList resources.
         */
        items?: {
            [key: string]: Schema$RecoverableSnapshotsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#recoverableSnapshotAggregatedList for aggregated lists of recoverablesnapshots.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RecoverableSnapshotList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of RecoverableSnapshots resources.
         */
        items?: Schema$RecoverableSnapshot[];
        /**
         * [Output Only] Type of resource. Always compute#recoverableSnapshotList for lists of recoverablesnapshots.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RecoverableSnapshotOriginalSnapshot {
        /**
         * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
         */
        architecture?: string | null;
        /**
         * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
         */
        autoCreated?: boolean | null;
        /**
         * ResourceKey of the resource policy or flow which created this auto snapshot
         */
        autoCreatedBy?: string | null;
        /**
         * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
         */
        chainName?: string | null;
        /**
         * [Output Only] Size in bytes of the snapshot at creation time.
         */
        creationSizeBytes?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] Purge timestamp of recoverable snapshot in RFC3339 text format.
         */
        deletionTimestamp?: string | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output Only] Size of the source disk, specified in GB.
         */
        diskSizeGb?: string | null;
        /**
         * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
         */
        downloadBytes?: string | null;
        /**
         * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
         */
        enableConfidentialCompute?: boolean | null;
        /**
         * Indicates the created snapshot is a full snapshot.
         */
        full?: boolean | null;
        /**
         * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the original snapshot. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
         */
        licenseCodes?: string[] | null;
        /**
         * [Output Only] A list of public visible licenses that apply to this snapshot.
         */
        licenses?: string[] | null;
        /**
         * Number of days the snapshot should be retained before being deleted automatically.
         */
        maxRetentionDays?: number | null;
        /**
         * Name of the original snapshot provided by the client. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the snapshot resides. Only applicable for regional snapshots.
         */
        region?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
         */
        snapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The unique ID of the snapshot group that this snapshot belongs to.
         */
        snapshotGroupId?: string | null;
        /**
         * [Output only] The snapshot group that this snapshot belongs to.
         */
        snapshotGroupName?: string | null;
        /**
         * Indicates the type of the snapshot.
         */
        snapshotType?: string | null;
        /**
         * The source disk used to create this snapshot.
         */
        sourceDisk?: string | null;
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The source disk whose recovery checkpoint will be used to create this snapshot.
         */
        sourceDiskForRecoveryCheckpoint?: string | null;
        /**
         * [Output Only] The ID value of the disk used to create this snapshot
         */
        sourceDiskId?: string | null;
        /**
         * The source instant snapshot used to create this snapshot.
         */
        sourceInstantSnapshot?: string | null;
        /**
         * Customer provided encryption key when creating Snapshot from Instant Snapshot.
         */
        sourceInstantSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
         */
        sourceInstantSnapshotId?: string | null;
        /**
         * [Output Only] URL of the resource policy which created this scheduled snapshot.
         */
        sourceSnapshotSchedulePolicy?: string | null;
        /**
         * [Output Only] ID of the resource policy which created this scheduled snapshot.
         */
        sourceSnapshotSchedulePolicyId?: string | null;
        /**
         * [Output Only] A size of the storage used by the snapshot.
         */
        storageBytes?: string | null;
        /**
         * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
         */
        storageBytesStatus?: string | null;
        /**
         * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
         */
        storageLocations?: string[] | null;
        /**
         * [Output Only] A list of user provided licenses represented by a list of URLs to the license resource.
         */
        userLicenses?: string[] | null;
    }
    export interface Schema$RecoverableSnapshotsScopedList {
        /**
         * [Output Only] A list of recoverablesnapshots contained in this scope.
         */
        recoverablesnapshots?: Schema$RecoverableSnapshot[];
        /**
         * [Output Only] Informational warning which replaces the list of recoverablesnapshots when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a reference to a resource.
     */
    export interface Schema$Reference {
        /**
         * [Output Only] Type of the resource. Always compute#reference for references.
         */
        kind?: string | null;
        /**
         * A description of the reference type with no implied semantics. Possible values include: 1. MEMBER_OF
         */
        referenceType?: string | null;
        /**
         * URL of the resource which refers to the target.
         */
        referrer?: string | null;
        /**
         * URL of the resource to which this reference points.
         */
        target?: string | null;
    }
    /**
     * Represents a Region resource. A region is a geographical area where a resource is located. For more information, read Regions and Zones.
     */
    export interface Schema$Region {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this region.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] Textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#region for regions.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Quotas assigned to this region.
         */
        quotas?: Schema$Quota[];
        /**
         * [Output Only] Warning of fetching the `quotas` field for this region. This field is populated only if fetching of the `quotas` field fails.
         */
        quotaStatusWarning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Status of the region, either UP or DOWN.
         */
        status?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        supportsPzs?: boolean | null;
        /**
         * [Output Only] A list of zones available in this region, in the form of resource URLs.
         */
        zones?: string[] | null;
    }
    export interface Schema$RegionAddressesMoveRequest {
        /**
         * An optional destination address description if intended to be different from the source.
         */
        description?: string | null;
        /**
         * The URL of the destination address to move to. This can be a full or partial URL. For example, the following are all valid URLs to a address: - https://www.googleapis.com/compute/v1/projects/project/regions/region /addresses/address - projects/project/regions/region/addresses/address Note that destination project must be different from the source project. So /regions/region/addresses/address is not valid partial url.
         */
        destinationAddress?: string | null;
    }
    /**
     * Contains a list of autoscalers.
     */
    export interface Schema$RegionAutoscalerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Autoscaler resources.
         */
        items?: Schema$Autoscaler[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionCommitmentsUpdateReservationsRequest {
        /**
         * A list of two reservations to transfer GPUs and Local SSD disks between.
         */
        reservations?: Schema$Reservation[];
    }
    export interface Schema$RegionDisksAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this disk.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$RegionDisksRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this disk.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$RegionDisksResizeRequest {
        /**
         * The new size of the regional persistent disk, which is specified in GB.
         */
        sizeGb?: string | null;
    }
    export interface Schema$RegionDisksStartAsyncReplicationRequest {
        /**
         * The secondary disk to start asynchronous replication to. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
         */
        asyncSecondaryDisk?: string | null;
    }
    export interface Schema$RegionDiskTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DiskType resources.
         */
        items?: Schema$DiskType[];
        /**
         * [Output Only] Type of resource. Always compute#regionDiskTypeList for region disk types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of InstanceGroup resources.
     */
    export interface Schema$RegionInstanceGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroup resources.
         */
        items?: Schema$InstanceGroup[];
        /**
         * The resource type.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * RegionInstanceGroupManagers.deletePerInstanceConfigs
     */
    export interface Schema$RegionInstanceGroupManagerDeleteInstanceConfigReq {
        /**
         * The list of instance names for which we want to delete per-instance configs on this managed instance group.
         */
        names?: string[] | null;
    }
    /**
     * Contains a list of managed instance groups.
     */
    export interface Schema$RegionInstanceGroupManagerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupManager resources.
         */
        items?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups that exist in th regional scope.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * RegionInstanceGroupManagers.patchPerInstanceConfigs
     */
    export interface Schema$RegionInstanceGroupManagerPatchInstanceConfigReq {
        /**
         * The list of per-instance configurations to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$RegionInstanceGroupManagerResizeRequestsListResponse {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Resize Request resources.
         */
        items?: Schema$InstanceGroupManagerResizeRequest[];
        /**
         * [Output Only] Type of the resource. Always compute#regionInstanceGroupManagerResizeRequestList for a list of Resize Requests.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionInstanceGroupManagersAbandonInstancesRequest {
        /**
         * The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * RegionInstanceGroupManagers.applyUpdatesToInstances
     */
    export interface Schema$RegionInstanceGroupManagersApplyUpdatesRequest {
        /**
         * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
         */
        allInstances?: boolean | null;
        /**
         * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
        /**
         * The maximal action that should be performed on the instances. By default REPLACE. This field is deprecated, please use most_disruptive_allowed_action.
         */
        maximalAction?: string | null;
        /**
         * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
         */
        minimalAction?: string | null;
        /**
         * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
         */
        mostDisruptiveAllowedAction?: string | null;
    }
    /**
     * RegionInstanceGroupManagers.createInstances
     */
    export interface Schema$RegionInstanceGroupManagersCreateInstancesRequest {
        /**
         * [Required] List of specifications of per-instance configs.
         */
        instances?: Schema$PerInstanceConfig[];
    }
    export interface Schema$RegionInstanceGroupManagersDeleteInstancesRequest {
        /**
         * The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
        /**
         * Specifies whether the request should proceed despite the inclusion of instances that are not members of the group or that are already in the process of being deleted or abandoned. If this field is set to `false` and such an instance is specified in the request, the operation fails. The operation always fails if the request contains a malformed instance URL or a reference to an instance that exists in a zone or region other than the group's zone or region.
         */
        skipInstancesOnValidationError?: boolean | null;
    }
    export interface Schema$RegionInstanceGroupManagersListErrorsResponse {
        /**
         * [Output Only] The list of errors of the managed instance group.
         */
        items?: Schema$InstanceManagedByIgmError[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$RegionInstanceGroupManagersListInstanceConfigsResp {
        /**
         * [Output Only] The list of PerInstanceConfig.
         */
        items?: Schema$PerInstanceConfig[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionInstanceGroupManagersListInstancesResponse {
        /**
         * A list of managed instances.
         */
        managedInstances?: Schema$ManagedInstance[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$RegionInstanceGroupManagersRecreateRequest {
        /**
         * The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersResizeAdvancedRequest {
        /**
         * If this flag is true, the managed instance group attempts to create all instances initiated by this resize request only once. If there is an error during creation, the managed instance group does not retry create this instance, and we will decrease the targetSize of the request instead. If the flag is false, the group attempts to recreate each instance continuously until it succeeds. This flag matters only in the first attempt of creation of an instance. After an instance is successfully created while this flag is enabled, the instance behaves the same way as all the other instances created with a regular resize request. In particular, if a running instance dies unexpectedly at a later time and needs to be recreated, this mode does not affect the recreation behavior in that scenario. This flag is applicable only to the current resize request. It does not influence other resize requests in any way. You can see which instances ar being created in which mode by calling the get or listManagedInstances API.
         */
        noCreationRetries?: boolean | null;
        /**
         * The number of running instances that the managed instance group should maintain at any given time. The group automatically adds or removes instances to maintain the number of instances specified by this parameter.
         */
        targetSize?: number | null;
    }
    export interface Schema$RegionInstanceGroupManagersResumeInstancesRequest {
        /**
         * The URLs of one or more instances to resume. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersSetAutoHealingRequest {
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
    }
    export interface Schema$RegionInstanceGroupManagersSetTargetPoolsRequest {
        /**
         * Fingerprint of the target pools information, which is a hash of the contents. This field is used for optimistic locking when you update the target pool entries. This field is optional.
         */
        fingerprint?: string | null;
        /**
         * The URL of all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
         */
        targetPools?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersSetTemplateRequest {
        /**
         * URL of the InstanceTemplate resource from which all new instances will be created.
         */
        instanceTemplate?: string | null;
    }
    export interface Schema$RegionInstanceGroupManagersStartInstancesRequest {
        /**
         * The URLs of one or more instances to start. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersStopInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to stop the instances, skipping initialization on them.
         */
        forceStop?: boolean | null;
        /**
         * The URLs of one or more instances to stop. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersSuspendInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to suspend the instances, skipping initialization on them.
         */
        forceSuspend?: boolean | null;
        /**
         * The URLs of one or more instances to suspend. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * RegionInstanceGroupManagers.updatePerInstanceConfigs
     */
    export interface Schema$RegionInstanceGroupManagerUpdateInstanceConfigReq {
        /**
         * The list of per-instance configurations to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$RegionInstanceGroupsListInstances {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceWithNamedPorts resources.
         */
        items?: Schema$InstanceWithNamedPorts[];
        /**
         * The resource type.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionInstanceGroupsListInstancesRequest {
        /**
         * Instances in which state should be returned. Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.
         */
        instanceState?: string | null;
        /**
         * Name of port user is interested in. It is optional. If it is set, only information about this ports will be returned. If it is not set, all the named ports will be returned. Always lists all instances.
         */
        portName?: string | null;
    }
    export interface Schema$RegionInstanceGroupsSetNamedPortsRequest {
        /**
         * The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
         */
        fingerprint?: string | null;
        /**
         * The list of named ports to set for this instance group.
         */
        namedPorts?: Schema$NamedPort[];
    }
    /**
     * Contains a list of region resources.
     */
    export interface Schema$RegionList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Region resources.
         */
        items?: Schema$Region[];
        /**
         * [Output Only] Type of resource. Always compute#regionList for lists of regions.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionNetworkEndpointGroupsAttachEndpointsRequest {
        /**
         * The list of network endpoints to be attached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$RegionNetworkEndpointGroupsDetachEndpointsRequest {
        /**
         * The list of network endpoints to be detached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse {
        /**
         * [Output only] Effective firewalls from firewall policy. It applies to Regional Network Firewall Policies in the specified region, Global Network Firewall Policies and Hierachial Firewall Policies which are associated with the network.
         */
        firewallPolicys?: Schema$RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy[];
        /**
         * Effective firewalls on the network.
         */
        firewalls?: Schema$Firewall[];
    }
    export interface Schema$RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy {
        /**
         * [Output Only] The display name of the firewall policy.
         */
        displayName?: string | null;
        /**
         * [Output Only] The name of the firewall policy.
         */
        name?: string | null;
        /**
         * [Output only] The packet mirroring rules that apply to the network.
         */
        packetMirroringRules?: Schema$FirewallPolicyRule[];
        /**
         * [Output only] Priority of firewall policy association. Not applicable for type=HIERARCHY.
         */
        priority?: number | null;
        /**
         * [Output only] The rules that apply to the network.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL, SYSTEM_GLOBAL, SYSTEM_REGIONAL.
         */
        type?: string | null;
    }
    export interface Schema$RegionSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string | null;
        /**
         * The labels to set for this resource.
         */
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$RegionSetPolicyRequest {
        /**
         * Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export interface Schema$RegionTargetHttpsProxiesSetSslCertificatesRequest {
        /**
         * New set of SslCertificate resources to associate with this TargetHttpsProxy resource.
         */
        sslCertificates?: string[] | null;
    }
    export interface Schema$RegionUrlMapsValidateRequest {
        /**
         * Content of the UrlMap to be validated.
         */
        resource?: Schema$UrlMap;
    }
    export interface Schema$RegionWaitForReplicationCatchUpRequest {
        maxWaitDuration?: string | null;
    }
    /**
     * Represents a ReliabilityRisk resource.
     */
    export interface Schema$ReliabilityRisk {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional textual description of the resource; provided when the resource is created.
         */
        description?: string | null;
        /**
         * [Output Only] Details of the reliability risk resource
         */
        details?: Schema$RiskDetails;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#reliabilityRisk for reliability risks.
         */
        kind?: string | null;
        /**
         * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
         */
        name?: string | null;
        /**
         * The recommendations to mitigate the risk.
         */
        recommendation?: Schema$RiskRecommendation;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    export interface Schema$ReliabilityRisksListResponse {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ReliabilityRisk resources.
         */
        items?: Schema$ReliabilityRisk[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ReplicationDetails {
        /**
         * The last sync time of the device pair.
         */
        lastReplicationTime?: string | null;
        /**
         * Replication lag in seconds. This will only be populated if device is in replicating state. Note that the value is calculated sometime during request processing and at the instant the client receives the response, the current replication_lag may have changed.
         */
        secondsSinceLastReplication?: string | null;
    }
    export interface Schema$ReplicationDiskPair {
        /**
         * URL of the primary disk.
         */
        primaryDisk?: string | null;
        /**
         * URL of the secondary disk.
         */
        secondaryDisk?: string | null;
    }
    /**
     * A policy that specifies how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer doesn't wait for responses from the shadow service. Before sending traffic to the shadow service, the host or authority header is suffixed with -shadow.
     */
    export interface Schema$RequestMirrorPolicy {
        /**
         * The full or partial URL to the BackendService resource being mirrored to. The backend service configured for a mirroring policy must reference backends that are of the same type as the original backend service matched in the URL map. Serverless NEG backends are not currently supported as a mirrored backend service.
         */
        backendService?: string | null;
        /**
         * The percentage of requests to be mirrored to `backend_service`.
         */
        mirrorPercent?: number | null;
    }
    /**
     * Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read Reserving zonal resources.
     */
    export interface Schema$Reservation {
        /**
         * Reservation for aggregated resources, providing shape flexibility.
         */
        aggregateReservation?: Schema$AllocationAggregateReservation;
        /**
         * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
         */
        commitment?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Duration time relative to reservation creation when Compute Engine will automatically delete this resource.
         */
        deleteAfterDuration?: Schema$Duration;
        /**
         * Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
         */
        deleteAtTime?: string | null;
        /**
         * Specifies the deployment strategy for this reservation.
         */
        deploymentType?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Indicates whether Compute Engine allows unplanned maintenance for your VMs; for example, to fix hardware errors.
         */
        enableEmergentMaintenance?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#reservations for reservations.
         */
        kind?: string | null;
        /**
         * [Output Only] Full or partial URL to parent commitments. This field displays for reservations that are tied to multiple commitments.
         */
        linkedCommitments?: string[] | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Protection tier for the workload which specifies the workload expectations in the event of infrastructure failures at data center (e.g. power and/or cooling failures).
         */
        protectionTier?: string | null;
        /**
         * [Output only] Indicates the reservation mode of the reservation.
         */
        reservationMode?: string | null;
        /**
         * Specify the reservation sharing policy. If unspecified, the reservation will not be shared with Google Cloud managed services.
         */
        reservationSharingPolicy?: Schema$AllocationReservationSharingPolicy;
        /**
         * Resource policies to be added to this reservation. The key is defined by user, and the value is resource policy url. This is to define placement policy with reservation.
         */
        resourcePolicies?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Status information for Reservation resource.
         */
        resourceStatus?: Schema$AllocationResourceStatus;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * The type of maintenance for the reservation.
         */
        schedulingType?: string | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Specify share-settings to create a shared reservation. This property is optional. For more information about the syntax and options for this field and its subfields, see the guide for creating a shared reservation.
         */
        shareSettings?: Schema$ShareSettings;
        /**
         * Reservation for instances with specific machine shapes.
         */
        specificReservation?: Schema$AllocationSpecificSKUReservation;
        /**
         * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
         */
        specificReservationRequired?: boolean | null;
        /**
         * [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
         */
        status?: string | null;
        /**
         * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
         */
        zone?: string | null;
    }
    /**
     * Specifies the reservations that this instance can consume from.
     */
    export interface Schema$ReservationAffinity {
        /**
         * Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
         */
        consumeReservationType?: string | null;
        /**
         * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
         */
        key?: string | null;
        /**
         * Corresponds to the label values of a reservation resource. This can be either a name to a reservation in the same project or "projects/different-project/reservations/some-reservation-name" to target a shared reservation in the same zone but in a different project.
         */
        values?: string[] | null;
    }
    /**
     * Contains a list of reservations.
     */
    export interface Schema$ReservationAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Allocation resources.
         */
        items?: {
            [key: string]: Schema$ReservationsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a reservation block resource.
     */
    export interface Schema$ReservationBlock {
        /**
         * [Output Only] The number of resources that are allocated in this reservation block.
         */
        count?: number | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The number of instances that are currently in use on this reservation block.
         */
        inUseCount?: number | null;
        /**
         * [Output Only] Type of the resource. Always compute#reservationBlock for reservation blocks.
         */
        kind?: string | null;
        /**
         * [Output Only] Obfuscated location where this reservation block physically resides in format /CCCC/GGGG. This matches the tripod specified in the VM topology information. Example: /USEAB1/0101/ is the location prefix in /USEAB1/0101/031/003
         */
        locationPrefix?: string | null;
        /**
         * [Output Only] The name of this reservation block generated by Google Compute Engine. The name must be 1-63 characters long, and comply with RFC1035 @pattern [a-z](?:[-a-z0-9]{0,61\}[a-z0-9])?
         */
        name?: string | null;
        /**
         * [Output Only] The physical topology of the reservation block.
         */
        physicalTopology?: Schema$ReservationBlockPhysicalTopology;
        /**
         * [Output Only] Maintenance information for this reservation block.
         */
        reservationMaintenance?: Schema$GroupMaintenanceInfo;
        /**
         * [Output Only] The number of reservation subBlocks associated with this reservation block.
         */
        reservationSubBlockCount?: number | null;
        /**
         * [Output Only] The number of in-use reservation subBlocks associated with this reservation block. If at least one VM is running on a subBlock, it is considered in-use.
         */
        reservationSubBlockInUseCount?: number | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Status of the reservation block.
         */
        status?: string | null;
        /**
         * [Output Only] Zone in which the reservation block resides.
         */
        zone?: string | null;
    }
    export interface Schema$ReservationBlockPhysicalTopology {
        /**
         * The hash of the capacity block within the cluster.
         */
        block?: string | null;
        /**
         * The cluster name of the reservation block.
         */
        cluster?: string | null;
    }
    export interface Schema$ReservationBlocksGetResponse {
        resource?: Schema$ReservationBlock;
    }
    /**
     * A list of reservation blocks under a single reservation.
     */
    export interface Schema$ReservationBlocksListResponse {
        /**
         * Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of reservation block resources.
         */
        items?: Schema$ReservationBlock[];
        /**
         * Type of the resource. Always compute#reservationBlock for a list of reservation blocks.
         */
        kind?: string | null;
        /**
         * This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
 