import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace workspaceevents_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Google Workspace Events API
     *
     * The Google Workspace Events API lets you subscribe to events and manage change notifications across Google Workspace applications.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const workspaceevents = google.workspaceevents('v1');
     * ```
     */
    export class Workspaceevents {
        context: APIRequestContext;
        operations: Resource$Operations;
        subscriptions: Resource$Subscriptions;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * The response message for SubscriptionsService.ListSubscriptions.
     */
    export interface Schema$ListSubscriptionsResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * List of subscriptions.
         */
        subscriptions?: Schema$Subscription[];
    }
    /**
     * The endpoint where the subscription delivers events.
     */
    export interface Schema$NotificationEndpoint {
        /**
         * Immutable. The Pub/Sub topic that receives events for the subscription. Format: `projects/{project\}/topics/{topic\}` You must create the topic in the same Google Cloud project where you create this subscription. Note: The Workspace Events API uses [ordering keys](https://cloud.google.com/pubsub/docs/ordering) for the benefit of sequential events. If the Cloud Pub/Sub topic has a [message storage policy](https://cloud.google.com/pubsub/docs/resource-location-restriction#exceptions) configured to exclude the nearest Google Cloud region, publishing events with ordering keys will fail. When the topic receives events, the events are encoded as Pub/Sub messages. For details, see the [Google Cloud Pub/Sub Protocol Binding for CloudEvents](https://github.com/googleapis/google-cloudevents/blob/main/docs/spec/pubsub.md).
         */
        pubsubTopic?: string | null;
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$Operation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean | null;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$Status;
        /**
         * Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id\}`.
         */
        name?: string | null;
        /**
         * The normal, successful response of the operation. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Options about what data to include in the event payload. Only supported for Google Chat events.
     */
    export interface Schema$PayloadOptions {
        /**
         * Optional. If `include_resource` is set to `true`, the list of fields to include in the event payload. Separate fields with a comma. For example, to include a Google Chat message's sender and create time, enter `message.sender,message.createTime`. If omitted, the payload includes all fields for the resource. If you specify a field that doesn't exist for the resource, the system ignores the field.
         */
        fieldMask?: string | null;
        /**
         * Optional. Whether the event payload includes data about the resource that changed. For example, for an event where a Google Chat message was created, whether the payload contains data about the [`Message`](https://developers.google.com/chat/api/reference/rest/v1/spaces.messages) resource. If false, the event payload only includes the name of the changed resource.
         */
        includeResource?: boolean | null;
    }
    /**
     * The request message for SubscriptionsService.ReactivateSubscription.
     */
    export interface Schema$ReactivateSubscriptionRequest {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$Status {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number | null;
        /**
         * A list of messages that carry the error details. There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string | null;
    }
    /**
     * A subscription to receive events about a Google Workspace resource. To learn more about subscriptions, see the [Google Workspace Events API overview](https://developers.google.com/workspace/events).
     */
    export interface Schema$Subscription {
        /**
         * Output only. The user who authorized the creation of the subscription. Format: `users/{user\}` For Google Workspace users, the `{user\}` value is the [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids) field from the Directory API.
         */
        authority?: string | null;
        /**
         * Output only. The time when the subscription is created.
         */
        createTime?: string | null;
        /**
         * Optional. This checksum is computed by the server based on the value of other fields, and might be sent on update requests to ensure the client has an up-to-date value before proceeding.
         */
        etag?: string | null;
        /**
         * Required. Unordered list. Input for creating a subscription. Otherwise, output only. One or more types of events to receive about the target resource. Formatted according to the CloudEvents specification. The supported event types depend on the target resource of your subscription. For details, see [Supported Google Workspace events](https://developers.google.com/workspace/events/guides#supported-events). By default, you also receive events about the [lifecycle of your subscription](https://developers.google.com/workspace/events/guides/events-lifecycle). You don't need to specify lifecycle events for this field. If you specify an event type that doesn't exist for the target resource, the request returns an HTTP `400 Bad Request` status code.
         */
        eventTypes?: string[] | null;
        /**
         * Non-empty default. The timestamp in UTC when the subscription expires. Always displayed on output, regardless of what was used on input.
         */
        expireTime?: string | null;
        /**
         * Identifier. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         */
        name?: string | null;
        /**
         * Required. Immutable. The endpoint where the subscription delivers events, such as a Pub/Sub topic.
         */
        notificationEndpoint?: Schema$NotificationEndpoint;
        /**
         * Optional. Options about what data to include in the event payload. Only supported for Google Chat events.
         */
        payloadOptions?: Schema$PayloadOptions;
        /**
         * Output only. If `true`, the subscription is in the process of being updated.
         */
        reconciling?: boolean | null;
        /**
         * Output only. The state of the subscription. Determines whether the subscription can receive events and deliver them to the notification endpoint.
         */
        state?: string | null;
        /**
         * Output only. The error that suspended the subscription. To reactivate the subscription, resolve the error and call the `ReactivateSubscription` method.
         */
        suspensionReason?: string | null;
        /**
         * Required. Immutable. The Google Workspace resource that's monitored for events, formatted as the [full resource name](https://google.aip.dev/122#full-resource-names). To learn about target resources and the events that they support, see [Supported Google Workspace events](https://developers.google.com/workspace/events#supported-events). A user can only authorize your app to create one subscription for a given target resource. If your app tries to create another subscription with the same user credentials, the request returns an `ALREADY_EXISTS` error.
         */
        targetResource?: string | null;
        /**
         * Input only. The time-to-live (TTL) or duration for the subscription. If unspecified or set to `0`, uses the maximum possible duration.
         */
        ttl?: string | null;
        /**
         * Output only. System-assigned unique identifier for the subscription.
         */
        uid?: string | null;
        /**
         * Output only. The last time that the subscription is updated.
         */
        updateTime?: string | null;
    }
    export class Resource$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.bot',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.operations.get({
         *     // The name of the operation resource.
         *     name: 'operations/.*',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$Operation>>;
        get(params: Params$Resource$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        get(params: Params$Resource$Operations$Get, callback: BodyResponseCallback<Schema$Operation>): void;
        get(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export class Resource$Subscriptions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a Google Workspace subscription. To learn how to use this method, see [Create a Google Workspace subscription](https://developers.google.com/workspace/events/guides/create-subscription).
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.app.memberships',
         *       'https://www.googleapis.com/auth/chat.app.spaces',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.subscriptions.create({
         *     // Optional. If set to `true`, validates and previews the request, but doesn't create the subscription.
         *     validateOnly: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "authority": "my_authority",
         *       //   "createTime": "my_createTime",
         *       //   "etag": "my_etag",
         *       //   "eventTypes": [],
         *       //   "expireTime": "my_expireTime",
         *       //   "name": "my_name",
         *       //   "notificationEndpoint": {},
         *       //   "payloadOptions": {},
         *       //   "reconciling": false,
         *       //   "state": "my_state",
         *       //   "suspensionReason": "my_suspensionReason",
         *       //   "targetResource": "my_targetResource",
         *       //   "ttl": "my_ttl",
         *       //   "uid": "my_uid",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Subscriptions$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Subscriptions$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$Operation>>;
        create(params: Params$Resource$Subscriptions$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Subscriptions$Create, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        create(params: Params$Resource$Subscriptions$Create, callback: BodyResponseCallback<Schema$Operation>): void;
        create(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Deletes a Google Workspace subscription. To learn how to use this method, see [Delete a Google Workspace subscription](https://developers.google.com/workspace/events/guides/delete-subscription).
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.bot',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.subscriptions.delete({
         *     // Optional. If set to `true` and the subscription isn't found, the request succeeds but doesn't delete the subscription.
         *     allowMissing: 'placeholder-value',
         *     // Optional. Etag of the subscription. If present, it must match with the server's etag. Otherwise, request fails with the status `ABORTED`.
         *     etag: 'placeholder-value',
         *     // Required. Resource name of the subscription to delete. Format: `subscriptions/{subscription\}`
         *     name: 'subscriptions/my-subscription',
         *     // Optional. If set to `true`, validates and previews the request, but doesn't delete the subscription.
         *     validateOnly: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Subscriptions$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Subscriptions$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$Operation>>;
        delete(params: Params$Resource$Subscriptions$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Subscriptions$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Subscriptions$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Gets details about a Google Workspace subscription. To learn how to use this method, see [Get details about a Google Workspace subscription](https://developers.google.com/workspace/events/guides/get-subscription).
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.bot',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.subscriptions.get({
         *     // Required. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         *     name: 'subscriptions/my-subscription',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "authority": "my_authority",
         *   //   "createTime": "my_createTime",
         *   //   "etag": "my_etag",
         *   //   "eventTypes": [],
         *   //   "expireTime": "my_expireTime",
         *   //   "name": "my_name",
         *   //   "notificationEndpoint": {},
         *   //   "payloadOptions": {},
         *   //   "reconciling": false,
         *   //   "state": "my_state",
         *   //   "suspensionReason": "my_suspensionReason",
         *   //   "targetResource": "my_targetResource",
         *   //   "ttl": "my_ttl",
         *   //   "uid": "my_uid",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Subscriptions$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Subscriptions$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$Subscription>>;
        get(params: Params$Resource$Subscriptions$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Subscriptions$Get, options: MethodOptions | BodyResponseCallback<Schema$Subscription>, callback: BodyResponseCallback<Schema$Subscription>): void;
        get(params: Params$Resource$Subscriptions$Get, callback: BodyResponseCallback<Schema$Subscription>): void;
        get(callback: BodyResponseCallback<Schema$Subscription>): void;
        /**
         * Lists Google Workspace subscriptions. To learn how to use this method, see [List Google Workspace subscriptions](https://developers.google.com/workspace/events/guides/list-subscriptions).
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.bot',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.subscriptions.list({
         *     // Required. A query filter. You can filter subscriptions by event type (`event_types`) and target resource (`target_resource`). You must specify at least one event type in your query. To filter for multiple event types, use the `OR` operator. To filter by both event type and target resource, use the `AND` operator and specify the full resource name, such as `//chat.googleapis.com/spaces/{space\}`. For example, the following queries are valid: ``` event_types:"google.workspace.chat.membership.v1.updated" OR event_types:"google.workspace.chat.message.v1.created" event_types:"google.workspace.chat.message.v1.created" AND target_resource="//chat.googleapis.com/spaces/{space\}" ( event_types:"google.workspace.chat.membership.v1.updated" OR event_types:"google.workspace.chat.message.v1.created" ) AND target_resource="//chat.googleapis.com/spaces/{space\}" ``` The server rejects invalid queries with an `INVALID_ARGUMENT` error.
         *     filter: 'placeholder-value',
         *     // Optional. The maximum number of subscriptions to return. The service might return fewer than this value. If unspecified or set to `0`, up to 50 subscriptions are returned. The maximum value is 100. If you specify a value more than 100, the system only returns 100 subscriptions.
         *     pageSize: 'placeholder-value',
         *     // Optional. A page token, received from a previous list subscriptions call. Provide this parameter to retrieve the subsequent page. When paginating, the filter value should match the call that provided the page token. Passing a different value might lead to unexpected results.
         *     pageToken: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "subscriptions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Subscriptions$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Subscriptions$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$ListSubscriptionsResponse>>;
        list(params: Params$Resource$Subscriptions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Subscriptions$List, options: MethodOptions | BodyResponseCallback<Schema$ListSubscriptionsResponse>, callback: BodyResponseCallback<Schema$ListSubscriptionsResponse>): void;
        list(params: Params$Resource$Subscriptions$List, callback: BodyResponseCallback<Schema$ListSubscriptionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListSubscriptionsResponse>): void;
        /**
         * Updates or renews a Google Workspace subscription. To learn how to use this method, see [Update or renew a Google Workspace subscription](https://developers.google.com/workspace/events/guides/update-subscription).
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.app.memberships',
         *       'https://www.googleapis.com/auth/chat.app.spaces',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.subscriptions.patch({
         *     // Identifier. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         *     name: 'subscriptions/my-subscription',
         *     // Optional. The field to update. If omitted, updates any fields included in the request. You can update one of the following fields in a subscription: * `expire_time`: The timestamp when the subscription expires. * `ttl`: The time-to-live (TTL) or duration of the subscription. * `event_types`: The list of event types to receive about the target resource. When using the `*` wildcard (equivalent to `PUT`), omitted fields are set to empty values and rejected if they're invalid.
         *     updateMask: 'placeholder-value',
         *     // Optional. If set to `true`, validates and previews the request, but doesn't update the subscription.
         *     validateOnly: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "authority": "my_authority",
         *       //   "createTime": "my_createTime",
         *       //   "etag": "my_etag",
         *       //   "eventTypes": [],
         *       //   "expireTime": "my_expireTime",
         *       //   "name": "my_name",
         *       //   "notificationEndpoint": {},
         *       //   "payloadOptions": {},
         *       //   "reconciling": false,
         *       //   "state": "my_state",
         *       //   "suspensionReason": "my_suspensionReason",
         *       //   "targetResource": "my_targetResource",
         *       //   "ttl": "my_ttl",
         *       //   "uid": "my_uid",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Subscriptions$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Subscriptions$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$Operation>>;
        patch(params: Params$Resource$Subscriptions$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Subscriptions$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Subscriptions$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Reactivates a suspended Google Workspace subscription. This method resets your subscription's `State` field to `ACTIVE`. Before you use this method, you must fix the error that suspended the subscription. This method will ignore or reject any subscription that isn't currently in a suspended state. To learn how to use this method, see [Reactivate a Google Workspace subscription](https://developers.google.com/workspace/events/guides/reactivate-subscription).
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/workspaceevents.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const workspaceevents = google.workspaceevents('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chat.app.memberships',
         *       'https://www.googleapis.com/auth/chat.app.spaces',
         *       'https://www.googleapis.com/auth/chat.memberships',
         *       'https://www.googleapis.com/auth/chat.memberships.readonly',
         *       'https://www.googleapis.com/auth/chat.messages',
         *       'https://www.googleapis.com/auth/chat.messages.reactions',
         *       'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
         *       'https://www.googleapis.com/auth/chat.messages.readonly',
         *       'https://www.googleapis.com/auth/chat.spaces',
         *       'https://www.googleapis.com/auth/chat.spaces.readonly',
         *       'https://www.googleapis.com/auth/drive',
         *       'https://www.googleapis.com/auth/drive.file',
         *       'https://www.googleapis.com/auth/drive.metadata',
         *       'https://www.googleapis.com/auth/drive.metadata.readonly',
         *       'https://www.googleapis.com/auth/drive.readonly',
         *       'https://www.googleapis.com/auth/meetings.space.created',
         *       'https://www.googleapis.com/auth/meetings.space.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await workspaceevents.subscriptions.reactivate({
         *     // Required. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         *     name: 'subscriptions/my-subscription',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        reactivate(params: Params$Resource$Subscriptions$Reactivate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        reactivate(params?: Params$Resource$Subscriptions$Reactivate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$Operation>>;
        reactivate(params: Params$Resource$Subscriptions$Reactivate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        reactivate(params: Params$Resource$Subscriptions$Reactivate, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        reactivate(params: Params$Resource$Subscriptions$Reactivate, callback: BodyResponseCallback<Schema$Operation>): void;
        reactivate(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Subscriptions$Create extends StandardParameters {
        /**
         * Optional. If set to `true`, validates and previews the request, but doesn't create the subscription.
         */
        validateOnly?: boolean;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Subscription;
    }
    export interface Params$Resource$Subscriptions$Delete extends StandardParameters {
        /**
         * Optional. If set to `true` and the subscription isn't found, the request succeeds but doesn't delete the subscription.
         */
        allowMissing?: boolean;
        /**
         * Optional. Etag of the subscription. If present, it must match with the server's etag. Otherwise, request fails with the status `ABORTED`.
         */
        etag?: string;
        /**
         * Required. Resource name of the subscription to delete. Format: `subscriptions/{subscription\}`
         */
        name?: string;
        /**
         * Optional. If set to `true`, validates and previews the request, but doesn't delete the subscription.
         */
        validateOnly?: boolean;
    }
    export interface Params$Resource$Subscriptions$Get extends StandardParameters {
        /**
         * Required. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         */
        name?: string;
    }
    export interface Params$Resource$Subscriptions$List extends StandardParameters {
        /**
         * Required. A query filter. You can filter subscriptions by event type (`event_types`) and target resource (`target_resource`). You must specify at least one event type in your query. To filter for multiple event types, use the `OR` operator. To filter by both event type and target resource, use the `AND` operator and specify the full resource name, such as `//chat.googleapis.com/spaces/{space\}`. For example, the following queries are valid: ``` event_types:"google.workspace.chat.membership.v1.updated" OR event_types:"google.workspace.chat.message.v1.created" event_types:"google.workspace.chat.message.v1.created" AND target_resource="//chat.googleapis.com/spaces/{space\}" ( event_types:"google.workspace.chat.membership.v1.updated" OR event_types:"google.workspace.chat.message.v1.created" ) AND target_resource="//chat.googleapis.com/spaces/{space\}" ``` The server rejects invalid queries with an `INVALID_ARGUMENT` error.
         */
        filter?: string;
        /**
         * Optional. The maximum number of subscriptions to return. The service might return fewer than this value. If unspecified or set to `0`, up to 50 subscriptions are returned. The maximum value is 100. If you specify a value more than 100, the system only returns 100 subscriptions.
         */
        pageSize?: number;
        /**
         * Optional. A page token, received from a previous list subscriptions call. Provide this parameter to retrieve the subsequent page. When paginating, the filter value should match the call that provided the page token. Passing a different value might lead to unexpected results.
         */
        pageToken?: string;
    }
    export interface Params$Resource$Subscriptions$Patch extends StandardParameters {
        /**
         * Identifier. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         */
        name?: string;
        /**
         * Optional. The field to update. If omitted, updates any fields included in the request. You can update one of the following fields in a subscription: * `expire_time`: The timestamp when the subscription expires. * `ttl`: The time-to-live (TTL) or duration of the subscription. * `event_types`: The list of event types to receive about the target resource. When using the `*` wildcard (equivalent to `PUT`), omitted fields are set to empty values and rejected if they're invalid.
         */
        updateMask?: string;
        /**
         * Optional. If set to `true`, validates and previews the request, but doesn't update the subscription.
         */
        validateOnly?: boolean;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Subscription;
    }
    export interface Params$Resource$Subscriptions$Reactivate extends StandardParameters {
        /**
         * Required. Resource name of the subscription. Format: `subscriptions/{subscription\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ReactivateSubscriptionRequest;
    }
    export {};
}
