"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPropByString = exports.getSize = exports.getError = exports.getField = void 0;
function getField(validations, key) {
    if (/\[[0-9]+\]$/.test(key)) {
        return;
    }
    let validation = validations.find(e => e.startsWith('field:'));
    if (!validation) {
        return;
    }
    return validation.slice('field:'.length);
}
exports.getField = getField;
function getError(validations) {
    let validation = validations.find(e => e.startsWith('error:'));
    if (!validation) {
        return;
    }
    return validation.slice('error:'.length);
}
exports.getError = getError;
function getSize(validations) {
    let validation = validations.find(e => e.startsWith('size:'));
    if (!validation) {
        return 1;
    }
    return +validation.slice('size:'.length);
}
exports.getSize = getSize;
function getPropByString(obj, propString) {
    if (!propString)
        return obj;
    let prop, props = propString.split('.');
    let i = 0;
    for (let iLen = props.length - 1; i < iLen; i++) {
        prop = props[i];
        let candidate = obj[prop];
        if (candidate !== undefined) {
            obj = candidate;
        }
        else {
            break;
        }
    }
    return obj[props[i]];
}
exports.getPropByString = getPropByString;
//# sourceMappingURL=helpers.js.map