"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlexUserListInstance = exports.FlexUserInstance = exports.FlexUserContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class FlexUserContextImpl {
    constructor(_version, instanceSid, flexUserSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(instanceSid)) {
            throw new Error("Parameter 'instanceSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(flexUserSid)) {
            throw new Error("Parameter 'flexUserSid' is not valid.");
        }
        this._solution = { instanceSid, flexUserSid };
        this._uri = `/Instances/${instanceSid}/Users/${flexUserSid}`;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new FlexUserInstance(operationVersion, payload, instance._solution.instanceSid, instance._solution.flexUserSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["email"] !== undefined)
            data["Email"] = params["email"];
        if (params["userSid"] !== undefined)
            data["UserSid"] = params["userSid"];
        if (params["locale"] !== undefined)
            data["Locale"] = params["locale"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new FlexUserInstance(operationVersion, payload, instance._solution.instanceSid, instance._solution.flexUserSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FlexUserContextImpl = FlexUserContextImpl;
class FlexUserInstance {
    constructor(_version, payload, instanceSid, flexUserSid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.instanceSid = payload.instance_sid;
        this.userSid = payload.user_sid;
        this.flexUserSid = payload.flex_user_sid;
        this.workerSid = payload.worker_sid;
        this.workspaceSid = payload.workspace_sid;
        this.flexTeamSid = payload.flex_team_sid;
        this.username = payload.username;
        this.email = payload.email;
        this.locale = payload.locale;
        this.roles = payload.roles;
        this.createdDate = deserialize.iso8601DateTime(payload.created_date);
        this.updatedDate = deserialize.iso8601DateTime(payload.updated_date);
        this.version = deserialize.integer(payload.version);
        this.url = payload.url;
        this._solution = {
            instanceSid: instanceSid || this.instanceSid,
            flexUserSid: flexUserSid || this.flexUserSid,
        };
    }
    get _proxy() {
        this._context =
            this._context ||
                new FlexUserContextImpl(this._version, this._solution.instanceSid, this._solution.flexUserSid);
        return this._context;
    }
    /**
     * Fetch a FlexUserInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed FlexUserInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            instanceSid: this.instanceSid,
            userSid: this.userSid,
            flexUserSid: this.flexUserSid,
            workerSid: this.workerSid,
            workspaceSid: this.workspaceSid,
            flexTeamSid: this.flexTeamSid,
            username: this.username,
            email: this.email,
            locale: this.locale,
            roles: this.roles,
            createdDate: this.createdDate,
            updatedDate: this.updatedDate,
            version: this.version,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FlexUserInstance = FlexUserInstance;
function FlexUserListInstance(version) {
    const instance = ((instanceSid, flexUserSid) => instance.get(instanceSid, flexUserSid));
    instance.get = function get(instanceSid, flexUserSid) {
        return new FlexUserContextImpl(version, instanceSid, flexUserSid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.FlexUserListInstance = FlexUserListInstance;
