"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketListInstance = exports.BucketInstance = exports.BucketContextImpl = exports.RateLimitRequest = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
/**
 * Rate limit request schema
 */
class RateLimitRequest {
}
exports.RateLimitRequest = RateLimitRequest;
class BucketContextImpl {
    constructor(_version, field, bucket) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(field)) {
            throw new Error("Parameter 'field' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(bucket)) {
            throw new Error("Parameter 'bucket' is not valid.");
        }
        this._solution = { field, bucket };
        this._uri = `/RateLimits/Fields/${field}/Bucket/${bucket}`;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new BucketInstance(operationVersion, payload, instance._solution.field, instance._solution.bucket));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, headers, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "put",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new BucketInstance(operationVersion, payload, instance._solution.field, instance._solution.bucket));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.BucketContextImpl = BucketContextImpl;
class BucketInstance {
    constructor(_version, payload, field, bucket) {
        this._version = _version;
        this.code = payload.code;
        this.message = payload.message;
        this.moreInfo = payload.more_info;
        this.status = payload.status;
        this.field = payload.field;
        this.limit = payload.limit;
        this.bucket = payload.bucket;
        this.owner = payload.owner;
        this.ttl = payload.ttl;
        this._solution = {
            field: field || this.field,
            bucket: bucket || this.bucket,
        };
    }
    get _proxy() {
        this._context =
            this._context ||
                new BucketContextImpl(this._version, this._solution.field, this._solution.bucket);
        return this._context;
    }
    /**
     * Remove a BucketInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a BucketInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed BucketInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            code: this.code,
            message: this.message,
            moreInfo: this.moreInfo,
            status: this.status,
            field: this.field,
            limit: this.limit,
            bucket: this.bucket,
            owner: this.owner,
            ttl: this.ttl,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.BucketInstance = BucketInstance;
function BucketListInstance(version) {
    const instance = ((field, bucket) => instance.get(field, bucket));
    instance.get = function get(field, bucket) {
        return new BucketContextImpl(version, field, bucket);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.BucketListInstance = BucketListInstance;
