"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.LookupOverrideListInstance = exports.LookupOverrideInstance = exports.LookupOverrideContextImpl = exports.OverridesRequest = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class OverridesRequest {
}
exports.OverridesRequest = OverridesRequest;
class LookupOverrideContextImpl {
    constructor(_version, field, phoneNumber) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(field)) {
            throw new Error("Parameter 'field' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(phoneNumber)) {
            throw new Error("Parameter 'phoneNumber' is not valid.");
        }
        this._solution = { field, phoneNumber };
        this._uri = `/PhoneNumbers/${phoneNumber}/Overrides/${field}`;
    }
    create(params, headers, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new LookupOverrideInstance(operationVersion, payload, instance._solution.field, instance._solution.phoneNumber));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new LookupOverrideInstance(operationVersion, payload, instance._solution.field, instance._solution.phoneNumber));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, headers, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "put",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new LookupOverrideInstance(operationVersion, payload, instance._solution.field, instance._solution.phoneNumber));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.LookupOverrideContextImpl = LookupOverrideContextImpl;
class LookupOverrideInstance {
    constructor(_version, payload, field, phoneNumber) {
        this._version = _version;
        this.phoneNumber = payload.phone_number;
        this.originalLineType = payload.original_line_type;
        this.overriddenLineType = payload.overridden_line_type;
        this.overrideReason = payload.override_reason;
        this.overrideTimestamp = deserialize.iso8601DateTime(payload.override_timestamp);
        this.overriddenByAccountSid = payload.overridden_by_account_sid;
        this.code = payload.code;
        this.message = payload.message;
        this.moreInfo = payload.more_info;
        this.status = payload.status;
        this.field = payload.field;
        this.limit = payload.limit;
        this.bucket = payload.bucket;
        this.owner = payload.owner;
        this.ttl = payload.ttl;
        this._solution = {
            field: field || this.field,
            phoneNumber: phoneNumber || this.phoneNumber,
        };
    }
    get _proxy() {
        this._context =
            this._context ||
                new LookupOverrideContextImpl(this._version, this._solution.field, this._solution.phoneNumber);
        return this._context;
    }
    create(params, callback) {
        return this._proxy.create(params, callback);
    }
    /**
     * Remove a LookupOverrideInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a LookupOverrideInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed LookupOverrideInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            phoneNumber: this.phoneNumber,
            originalLineType: this.originalLineType,
            overriddenLineType: this.overriddenLineType,
            overrideReason: this.overrideReason,
            overrideTimestamp: this.overrideTimestamp,
            overriddenByAccountSid: this.overriddenByAccountSid,
            code: this.code,
            message: this.message,
            moreInfo: this.moreInfo,
            status: this.status,
            field: this.field,
            limit: this.limit,
            bucket: this.bucket,
            owner: this.owner,
            ttl: this.ttl,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.LookupOverrideInstance = LookupOverrideInstance;
function LookupOverrideListInstance(version) {
    const instance = ((field, phoneNumber) => instance.get(field, phoneNumber));
    instance.get = function get(field, phoneNumber) {
        return new LookupOverrideContextImpl(version, field, phoneNumber);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.LookupOverrideListInstance = LookupOverrideListInstance;
